/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.sighting.edits.ChosenUsers;
import com.scythebill.birdlist.model.sighting.edits.RecentEdits;
import com.scythebill.birdlist.model.sighting.edits.SingleLocationEdit;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.user.Users;
import com.scythebill.birdlist.model.util.Dirty;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.app.NavigablePanel;
import com.scythebill.birdlist.ui.app.ReportSetSaver;
import com.scythebill.birdlist.ui.events.DefaultUserStore;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.DataEntryPreferences;
import com.scythebill.birdlist.ui.panels.SingleLocationNewLocationPanel;
import com.scythebill.birdlist.ui.panels.SingleLocationSpeciesListPanel;
import com.scythebill.birdlist.ui.panels.SingleLocationTripInfoPanel;
import com.scythebill.birdlist.ui.panels.SingleLocationVisitInfoPanel;
import com.scythebill.birdlist.ui.panels.SingleLocationWhenAndWherePanel;
import com.scythebill.birdlist.ui.panels.WizardPanelBase;
import com.scythebill.birdlist.ui.panels.reports.EBirdDirectExporter;
import com.scythebill.birdlist.ui.prefs.ReportSetPreference;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.VisibilityDetector;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.joda.time.Chronology;
import org.joda.time.LocalDate;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GJChronology;

public class SingleLocationEditPanel
extends WizardPanelBase<SingleLocationEdit>
implements FontManager.FontsUpdatedListener,
NavigablePanel {
    private static ReadablePartial defaultDate = new LocalDate((Object)new Date(), (Chronology)GJChronology.getInstance());
    private static String defaultLocation = null;
    private final SingleLocationEdit edit;
    private final ReportSet reportSet;
    private final ReportSetSaver reportSetSaver;
    private final TaxonomyStore taxonomyStore;
    private final SingleLocationWhenAndWherePanel whenAndWhere;
    private final Alerts alerts;
    private final ReportSetPreference<RecentEdits> recentEdits;
    private final ReportSetPreference<ChosenUsers> chosenUsers;
    private final DataEntryPreferences dataEntryPreferences;
    private final JCheckBox exportToEBird;
    private final EBirdDirectExporter eBirdDirectExporter;
    private JCheckBox andSave;
    private static final int PAGE_WHEN_AND_WHERE = 0;
    private static final int PAGE_NEW_LOCATION = 1;
    private static final int PAGE_VISIT_INFO = 2;
    private static final int PAGE_TRIP_INFO = 3;
    private static final int PAGE_SPECIES_LIST = 4;

    @Inject
    public SingleLocationEditPanel(NavigableFrame navigableFrame, VisibilityDetector visibilityDetector, SingleLocationWhenAndWherePanel whenAndWhere, SingleLocationNewLocationPanel newLocation, SingleLocationVisitInfoPanel visitInfo, SingleLocationTripInfoPanel tripInfo, SingleLocationSpeciesListPanel speciesList, DefaultUserStore defaultUserStore, TaxonomyStore taxonomyStore, ReportSet reportSet, FontManager fontManager, Alerts alerts, ReportSetPreference<RecentEdits> recentEdits, ReportSetPreference<ChosenUsers> chosenUsers, DataEntryPreferences dataEntryPreferences, EBirdDirectExporter eBirdDirectExporter, final ReportSetSaver reportSetSaver) {
        super(navigableFrame, visibilityDetector);
        Location initialLocation;
        this.whenAndWhere = whenAndWhere;
        this.taxonomyStore = taxonomyStore;
        this.recentEdits = recentEdits;
        this.chosenUsers = chosenUsers;
        this.dataEntryPreferences = dataEntryPreferences;
        this.eBirdDirectExporter = eBirdDirectExporter;
        this.reportSetSaver = reportSetSaver;
        ImmutableSet.Builder users = ImmutableSet.builder();
        users.addAll(chosenUsers.get().getUsers(reportSet.getUserSet()));
        if (defaultUserStore.getUser() != null) {
            users.add(defaultUserStore.getUser());
        }
        this.edit = new SingleLocationEdit(defaultDate, users.build());
        if (dataEntryPreferences.useTrips) {
            this.edit.setTrip(true);
            this.edit.setEndDate(defaultDate);
        }
        if (defaultLocation != null && (initialLocation = reportSet.getLocations().getLocation(defaultLocation)) != null) {
            this.edit.setLocation(initialLocation);
        }
        this.reportSet = reportSet;
        this.alerts = alerts;
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                reportSetSaver.releaseEditor();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                reportSetSaver.attachEditor(new SingleLocationEditEditor());
            }
        });
        this.exportToEBird = new JCheckBox(Messages.getMessage(Messages.Name.AND_EXPORT_TO_EBIRD));
        this.exportToEBird.setSelected(dataEntryPreferences.immediateExportToEBird);
        this.andSave = new JCheckBox(Messages.getMessage(Messages.Name.AND_SAVE));
        this.andSave.setSelected(dataEntryPreferences.immediateSave);
        this.addPage(whenAndWhere);
        this.addPage(newLocation);
        this.addPage(visitInfo);
        this.addPage(tripInfo);
        this.addPage(speciesList);
        this.fontsUpdated(fontManager);
    }

    @Override
    protected boolean save() {
        defaultDate = this.edit.getDate() != null ? new Partial(this.edit.getDate()) : null;
        defaultLocation = this.edit.getLocation() != null ? this.edit.getLocation().getId() : null;
        this.edit.apply(this.reportSet, this.taxonomyStore.getTaxonomy());
        Location location = this.edit.getLocation();
        if (location != null && this.edit.getDate() != null) {
            if (this.edit.isTrip()) {
                this.recentEdits.get().add(location.getId(), this.edit.getDate(), this.edit.getTime(), this.edit.getEndDate(), this.edit.getEndTime());
            } else {
                this.recentEdits.get().add(location.getId(), this.edit.getDate(), this.edit.getTime());
            }
            this.recentEdits.save(true);
        }
        this.chosenUsers.get().setUsers(this.edit.getUsers());
        this.chosenUsers.save(true);
        VisitInfo visitInfo = this.edit.getVisitInfo();
        if (visitInfo != null && visitInfo.hasData()) {
            this.dataEntryPreferences.observationType = visitInfo.observationType();
        }
        this.dataEntryPreferences.useTrips = this.edit.isTrip();
        this.dataEntryPreferences.immediateExportToEBird = this.exportToEBird.isSelected();
        if (this.exportToEBird.isSelected() && location != null && this.edit.getDate() != null) {
            this.eBirdDirectExporter.doExport(this, location, this.edit.getDate(), this.edit.getTime(), this.edit.isTrip() ? this.edit.getEndDate() : null);
        }
        this.dataEntryPreferences.immediateSave = this.andSave.isSelected();
        if (this.andSave.isSelected()) {
            try {
                this.reportSetSaver.save();
            }
            catch (IOException e) {
                FileDialogs.showFileSaveError(this.alerts, e, this.reportSetSaver.file());
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getWizardTitle() {
        return Messages.getMessage(Messages.Name.ENTER_SIGHTINGS);
    }

    @Override
    protected int getPreviousIndex() {
        int index = super.getPreviousIndex();
        if (index == 3 && !this.wizardValue().isTrip()) {
            index = 2;
        }
        if (index == 2 && (!this.whenAndWhere.hasWhen() || this.wizardValue().isTrip())) {
            index = 1;
        }
        if (index == 1 && this.whenAndWhere.hasWhere()) {
            index = 0;
        }
        return index;
    }

    @Override
    protected int getNextIndex() {
        int index = super.getNextIndex();
        if (index == 1 && this.whenAndWhere.hasWhere()) {
            index = 2;
        }
        if (index == 2) {
            if (this.wizardValue().isTrip()) {
                index = 3;
            } else if (!this.whenAndWhere.hasWhen()) {
                index = 4;
                this.wizardValue().setVisitInfo(null);
            }
        }
        if (index == 3 && !this.wizardValue().isTrip()) {
            index = 4;
        }
        return index;
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        super.fontsUpdated(fontManager);
        this.setPreferredSize(fontManager.scale(new Dimension(1000, 640)));
    }

    @Override
    protected SingleLocationEdit wizardValue() {
        return this.edit;
    }

    @Override
    protected void addExtraContentAfterDone(GroupLayout.SequentialGroup horizontalButtonGroup) {
        horizontalButtonGroup.addComponent(this.andSave);
        horizontalButtonGroup.addComponent(this.exportToEBird);
    }

    @Override
    protected void addExtraContentAfterDone(GroupLayout.ParallelGroup verticalButtonGroup) {
        verticalButtonGroup.addComponent(this.andSave);
        verticalButtonGroup.addComponent(this.exportToEBird);
    }

    @Override
    public void navigateTo(Object args) {
        ImmutableSet<User> users;
        if (args instanceof VisitInfoKey) {
            VisitInfoKey visitInfoKey = (VisitInfoKey)args;
            this.wizardValue().setTrip(false);
            this.wizardValue().setDate(visitInfoKey.date());
            Location location = this.reportSet.getLocations().getLocation(visitInfoKey.locationId());
            this.wizardValue().setLocation(location);
            this.wizardValue().setTime(visitInfoKey.startTime().orNull());
            users = Users.usersForVisitInfoKey(this.reportSet, visitInfoKey);
            this.whenAndWhere.setVisitInfoKeyAndUsers(visitInfoKey, users);
        } else if (args instanceof Trip) {
            Trip trip = (Trip)args;
            this.wizardValue().setTrip(true);
            this.wizardValue().setDate(trip.startDate());
            this.wizardValue().setTime(trip.startTime());
            this.wizardValue().setEndDate(trip.endDate());
            this.wizardValue().setEndTime(trip.endTime());
            this.wizardValue().setLocation(this.reportSet.getLocations().getLocation(trip.locationId()));
            this.wizardValue().setTripName(trip.name());
            this.wizardValue().setTripNotes(trip.notes());
            users = Users.usersForTrip(this.reportSet, trip);
            this.whenAndWhere.setTripAndUsers(trip, users);
        } else {
            return;
        }
        this.wizardValue().setUsers(users);
        this.wizardValue().setUsersOnSpeciesList(users);
        this.showPage(this.getPageCount() - 1);
    }

    class SingleLocationEditEditor
    implements ReportSetSaver.Editor {
        SingleLocationEditEditor() {
        }

        @Override
        public Dirty getDirty() {
            return SingleLocationEditPanel.this.edit.getDirty();
        }

        @Override
        public void beforeSave() {
            SingleLocationEditPanel.this.getCurrentPage().leaving(false);
            if (SingleLocationEditPanel.this.edit.getLocation() != null) {
                SingleLocationEditPanel.this.edit.apply(SingleLocationEditPanel.this.reportSet, SingleLocationEditPanel.this.taxonomyStore.getTaxonomy());
            }
        }

        @Override
        public boolean beforeNavigation() {
            if (SingleLocationEditPanel.this.edit.getDirty().isDirty()) {
                return SingleLocationEditPanel.this.alerts.showOkCancel((Object)this, Messages.Name.ARE_YOU_SURE, Messages.Name.LOSE_ALL_THE_SIGHTINGS, new Object[0]) == 0;
            }
            return true;
        }
    }
}

