/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.TransposedChecklist;
import com.scythebill.birdlist.model.checklist.TransposedChecklists;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import com.scythebill.birdlist.ui.util.GoogleGeocharts;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;

public class ShowSpeciesMap {
    private final LocationSet locations;
    private final GoogleGeocharts googleGeocharts;
    private static final ImmutableMap<Checklist.Status, Integer> STATUS_INDICES = ImmutableMap.builder().put(Checklist.Status.ENDEMIC, 1).put(Checklist.Status.NATIVE, 2).put(Checklist.Status.INTRODUCED, 4).put(Checklist.Status.RARITY, 3).put(Checklist.Status.RARITY_FROM_INTRODUCED, 5).put(Checklist.Status.ESCAPED, 6).put(Checklist.Status.EXTINCT, 7).build();

    @Inject
    public ShowSpeciesMap(PredefinedLocations predefinedLocations, ReportSet reportSet) {
        this.locations = reportSet.getLocations();
        this.googleGeocharts = new GoogleGeocharts(this.locations, predefinedLocations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showRange(ReportSet reportSet, Taxonomy taxonomy, String id) throws IOException {
        Species taxon = (Species)taxonomy.getTaxon(id);
        File file = File.createTempFile("range", ".html");
        try (FileWriter writer = new FileWriter(file);){
            this.writeRange(reportSet, taxon, writer);
        }
        DesktopUtils.openHtmlFileInBrowser(file);
    }

    public void writeRange(ReportSet reportSet, Species taxon, Writer writer) throws IOException {
        TransposedChecklist transposedChecklist = TransposedChecklists.instance().getTransposedChecklist(reportSet, taxon.getTaxonomy());
        String startTemplate = Resources.toString(Resources.getResource(this.getClass(), "speciesmap.start.html.template"), StandardCharsets.UTF_8);
        String endTemplate = Resources.toString(Resources.getResource(this.getClass(), "speciesmap.end.html.template"), StandardCharsets.UTF_8);
        writer.write(String.format(startTemplate, taxon.getCommonName()));
        HashSet<String> alreadyRecorded = Sets.newHashSet();
        ArrayList<String> usStateEntries = Lists.newArrayList();
        ArrayList<String> caStateEntries = Lists.newArrayList();
        ArrayList<String> auStateEntries = Lists.newArrayList();
        for (Checklist.Status status : STATUS_INDICES.keySet()) {
            Integer statusInt = Preconditions.checkNotNull(STATUS_INDICES.get((Object)status), (Object)status);
            Iterable<String> statesAndCountries = transposedChecklist.locationsWithStatuses(taxon, ImmutableSet.of(status));
            Set<String> countries = this.normalizeCountries(statesAndCountries = Iterables.transform(statesAndCountries, id -> GoogleGeocharts.EBIRD_LOCATIONS_NOT_IN_GOOGLE.getOrDefault(id, (String)id)));
            if (countries.contains("US")) {
                for (String state : this.findStates(statesAndCountries, "US")) {
                    usStateEntries.add(this.dataFormat(status, statusInt, state, this.googleGeocharts.getNameForGoogle(state)));
                }
            }
            if (countries.contains("CA")) {
                for (String state : this.findStates(statesAndCountries, "CA")) {
                    caStateEntries.add(this.dataFormat(status, statusInt, state, this.googleGeocharts.getNameForGoogle(state)));
                }
            }
            if (countries.contains("AU")) {
                for (String state : this.findStates(statesAndCountries, "AU")) {
                    auStateEntries.add(this.dataFormat(status, statusInt, state, this.googleGeocharts.getNameForGoogle(state)));
                }
            }
            countries.removeAll(alreadyRecorded);
            alreadyRecorded.addAll(countries);
            for (String country : countries) {
                String countryName = this.googleGeocharts.getNameForGoogle(country);
                writer.write(this.dataFormat(status, statusInt, country, countryName));
            }
        }
        String region = null;
        ImmutableSet<GoogleGeocharts.Subcontinent> subcontinents = this.googleGeocharts.subcontinents(alreadyRecorded);
        ImmutableSet<GoogleGeocharts.Continent> continents = this.googleGeocharts.continents(subcontinents);
        if (subcontinents.size() == 1) {
            region = alreadyRecorded.size() == 1 && ImmutableSet.of("US", "CA", "AU").contains(Iterables.getOnlyElement(alreadyRecorded)) ? Iterables.getOnlyElement(alreadyRecorded) : Iterables.getOnlyElement(subcontinents).id();
        } else if (continents.size() == 1) {
            region = Iterables.getOnlyElement(continents).id();
        }
        Object regionJs = region == null ? "null" : "\"" + region + "\"";
        String extraText = "";
        ArrayList<String> optionsList = Lists.newArrayList();
        if (continents.size() > 1) {
            optionsList.add("<option value=\"\">Zoom to world, or...</option>");
        }
        Object usStates = "null";
        if (!usStateEntries.isEmpty()) {
            usStates = "[" + Joiner.on("").join(usStateEntries) + "]";
        }
        Object caStates = "null";
        if (!caStateEntries.isEmpty()) {
            caStates = "[" + Joiner.on("").join(caStateEntries) + "]";
        }
        Object auStates = "null";
        if (!auStateEntries.isEmpty()) {
            auStates = "[" + Joiner.on("").join(auStateEntries) + "]";
        }
        for (GoogleGeocharts.Continent continent : continents) {
            if (subcontinents.size() > 1) {
                optionsList.add(continent.asOption());
            }
            for (GoogleGeocharts.Subcontinent subcontinent : continent.subcontinents()) {
                if (!subcontinents.contains(subcontinent)) continue;
                optionsList.add(subcontinent.asOption());
                if (subcontinent.contains("US") && alreadyRecorded.contains("US")) {
                    optionsList.add("<option value=\"?US\">&nbsp;&nbsp;&nbsp;&nbsp;United States</option>");
                }
                if (subcontinent.contains("CA") && alreadyRecorded.contains("CA")) {
                    optionsList.add("<option value=\"?CA\">&nbsp;&nbsp;&nbsp;&nbsp;Canada</option>");
                }
                if (!subcontinent.contains("AU") || !alreadyRecorded.contains("AU")) continue;
                optionsList.add("<option value=\"?AU\">&nbsp;&nbsp;&nbsp;&nbsp;Australia</option>");
            }
        }
        writer.write(String.format(endTemplate, regionJs, usStates, caStates, auStates, Joiner.on('\n').join(optionsList), taxon.getCommonName(), TaxonUtils.getRange(taxon), extraText));
    }

    private Iterable<String> findStates(Iterable<String> statesAndCountries, String prefix) {
        final String prefixPlusHyphen = prefix + "-";
        return FluentIterable.from(statesAndCountries).filter(new Predicate<String>(){

            @Override
            public boolean apply(String string) {
                return string.startsWith(prefixPlusHyphen);
            }
        });
    }

    private String dataFormat(Checklist.Status status, Integer statusInt, String country, String countryName) {
        return String.format("[{v:\"%s\",f:\"%s\"}, {v:%d, f:\"%s\"}],", country, StringEscapeUtils.escapeJson(countryName), statusInt, StringEscapeUtils.escapeJson(this.statusText(status)));
    }

    private String statusText(Checklist.Status status) {
        String statusText = Messages.getText(status);
        return statusText;
    }

    private Set<String> normalizeCountries(Iterable<String> statesAndCountries) {
        HashSet<String> set = Sets.newHashSet();
        for (String value : statesAndCountries) {
            int indexOf;
            if (GoogleGeocharts.EBIRD_TO_GOOGLE_COUNTRIES.containsKey(value)) {
                value = (String)GoogleGeocharts.EBIRD_TO_GOOGLE_COUNTRIES.get(value);
            }
            if ((indexOf = value.indexOf(45)) < 0) {
                set.add(value);
                continue;
            }
            set.add(value.substring(0, indexOf));
        }
        return set;
    }
}

