/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.scythebill.birdlist.ui.guice.Scythebill;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;

@Singleton
public class PrivacyPolicyFrame {
    private static final int FRAME_WIDTH = 400;
    private static final int FRAME_HEIGHT = 350;
    private JFrame privacyPolicyFrame;
    private final Icon applicationIcon;
    private JScrollPane policyScrollPane;

    @Inject
    public PrivacyPolicyFrame(@Scythebill Icon applicationIcon) {
        this.applicationIcon = applicationIcon;
    }

    public void show() {
        this.privacyPolicyFrame = this.createPrivacyPolicyFrame();
        this.privacyPolicyFrame.setVisible(true);
        this.privacyPolicyFrame.toFront();
    }

    private JFrame createPrivacyPolicyFrame() {
        JFrame frame = new JFrame();
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        Rectangle screenBounds = frame.getGraphicsConfiguration().getBounds();
        frame.setLocation(screenBounds.x + (screenBounds.width - 400) / 2, screenBounds.y + (screenBounds.height - 300) / 2);
        Container contentPane = frame.getRootPane().getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        JPanel centerBox = new JPanel();
        centerBox.setBorder(new EmptyBorder(4, 4, 4, 4));
        contentPane.add(centerBox);
        GroupLayout layout = new GroupLayout(centerBox);
        centerBox.setLayout(layout);
        JLabel image = new JLabel(this.applicationIcon);
        JTextPane textPane = new JTextPane();
        textPane.setContentType("text/html");
        try {
            textPane.setText(Resources.toString(Resources.getResource(this.getClass(), "privacy_policy.html"), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        textPane.setCaretPosition(0);
        textPane.setEditable(false);
        this.policyScrollPane = new JScrollPane(textPane);
        this.policyScrollPane.setPreferredSize(new Dimension(400, 350));
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(image).addComponent(this.policyScrollPane, -2, -2, -2);
        layout.setHorizontalGroup(horizontalGroup);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addComponent(image).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.policyScrollPane);
        layout.setVerticalGroup(verticalGroup);
        frame.pack();
        return frame;
    }
}

