/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.edits.ChosenUsers;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.user.UserSet;
import com.scythebill.birdlist.model.util.LocalePreferences;
import com.scythebill.birdlist.ui.actions.ReturnAction;
import com.scythebill.birdlist.ui.actions.locationapi.LocationApiPreferences;
import com.scythebill.birdlist.ui.app.ReportSetSaver;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.backup.BackupFrequency;
import com.scythebill.birdlist.ui.backup.BackupPreferences;
import com.scythebill.birdlist.ui.backup.BackupSaver;
import com.scythebill.birdlist.ui.components.TextLink;
import com.scythebill.birdlist.ui.events.DefaultUserStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.imports.ImportPreferences;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.BrowsePreferences;
import com.scythebill.birdlist.ui.panels.UIMode;
import com.scythebill.birdlist.ui.panels.UIPreferences;
import com.scythebill.birdlist.ui.panels.UserDialog;
import com.scythebill.birdlist.ui.panels.UserSetPanel;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.prefs.ReportSetPreference;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class PreferencesPanel
extends JPanel
implements FontManager.FontsUpdatedListener,
Titled {
    private final NamesPreferences namePreferences;
    private final QueryPreferences queryPreferences;
    private final BackupPreferences backupPreferences;
    private final LocationApiPreferences locationApiPreferences;
    private final ReportSetPreference<ChosenUsers> chosenUserPreferences;
    private final BackupSaver backupSaver;
    private final UIPreferences uiPreferences;
    private final Alerts alerts;
    private JComboBox<NamesPreferences.AvailableIocLocale> iocLocalesComboBox;
    private JComboBox<NamesPreferences.AvailableClementsLocale> clementsLocalesComboBox;
    private JComboBox<AvailableUiLocales> uiLocalesComboBox;
    private JButton returnButton;
    private JLabel iocLocalesLabel;
    private JLabel clementsLocalesLabel;
    private JLabel uiLocalesLabel;
    private JComboBox<String> sciOrCommonComboBox;
    private JLabel countability;
    private JCheckBox countIntroduced;
    private JCheckBox countHeardOnly;
    private JCheckBox countUndescribed;
    private JCheckBox countRestrained;
    private JCheckBox showExtinct;
    private JLabel backups;
    private JLabel backupFrequency;
    private JComboBox<BackupFrequency> backupFrequencyCombo;
    private TextLink backupLocation;
    private JButton backupLocationButton;
    private JButton backupNowButton;
    private boolean backupOptionsChanged;
    private final File reportSetFile;
    private final ReportSetSaver reportSetSaver;
    private final ReportSet reportSet;
    private JLabel users;
    private JButton toggleMultipleUsers;
    private final UserSetPanel userSetPanel;
    private final UserDialog userDialog;
    private final DefaultUserStore defaultUserStore;
    private BrowsePreferences browsePreferences;
    private JLabel uiModeLabel;
    private JComboBox<UIMode> uiModeComboBox;
    private JLabel privacy;
    private JCheckBox useGoogleLocationApis;
    private JCheckBox useEBirdLocationApis;
    private JLabel mapProviderLabel;
    private JComboBox<String> mapProvider;
    private ImportPreferences importPreferences;
    private JCheckBox excelCompatibleCsvs;
    private JLabel exportPreferences;

    @Inject
    PreferencesPanel(NamesPreferences namePreferences, QueryPreferences queryPreferences, BackupPreferences backupPreferences, ReportSetPreference<ChosenUsers> chosenUserPreferences, LocationApiPreferences locationApiPreferences, BrowsePreferences browsePreferences, ImportPreferences importPreferences, UIPreferences uiPreferences, BackupSaver backupSaver, ReportSet reportSet, ReportSetSaver reportSetSaver, UserSetPanel userSetPanel, UserDialog userDialog, DefaultUserStore defaultUserStore, FileDialogs fileDialogs, Alerts alerts, File reportSetFile, ReturnAction returnAction, FontManager fontManager) {
        this.namePreferences = namePreferences;
        this.queryPreferences = queryPreferences;
        this.backupPreferences = backupPreferences;
        this.chosenUserPreferences = chosenUserPreferences;
        this.locationApiPreferences = locationApiPreferences;
        this.browsePreferences = browsePreferences;
        this.importPreferences = importPreferences;
        this.uiPreferences = uiPreferences;
        this.backupSaver = backupSaver;
        this.reportSet = reportSet;
        this.reportSetSaver = reportSetSaver;
        this.userSetPanel = userSetPanel;
        this.userDialog = userDialog;
        this.defaultUserStore = defaultUserStore;
        this.alerts = alerts;
        this.reportSetFile = reportSetFile;
        this.initComponents(returnAction);
        fontManager.applyTo(this);
    }

    private void initComponents(ReturnAction returnAction) {
        File backupDirectory;
        this.clementsLocalesComboBox = new JComboBox<NamesPreferences.AvailableClementsLocale>(NamesPreferences.AvailableClementsLocale.values());
        this.clementsLocalesComboBox.setMaximumRowCount(this.clementsLocalesComboBox.getItemCount());
        for (NamesPreferences.AvailableClementsLocale availableClementsLocale : NamesPreferences.AvailableClementsLocale.values()) {
            if (!availableClementsLocale.code().equals(this.namePreferences.clementsLocale)) continue;
            this.clementsLocalesComboBox.setSelectedItem(availableClementsLocale);
            break;
        }
        this.clementsLocalesComboBox.addActionListener(e -> {
            this.namePreferences.clementsLocale = ((NamesPreferences.AvailableClementsLocale)this.clementsLocalesComboBox.getSelectedItem()).code();
        });
        this.clementsLocalesLabel = new JLabel(Messages.getMessage(Messages.Name.SPECIES_NAME_EBIRD_CLEMENTS));
        this.iocLocalesComboBox = new JComboBox<NamesPreferences.AvailableIocLocale>(NamesPreferences.AvailableIocLocale.values());
        this.iocLocalesComboBox.setMaximumRowCount(this.iocLocalesComboBox.getItemCount());
        for (Enum enum_ : NamesPreferences.AvailableIocLocale.values()) {
            if (!((NamesPreferences.AvailableIocLocale)enum_).code().equals(this.namePreferences.locale)) continue;
            this.iocLocalesComboBox.setSelectedItem(enum_);
            break;
        }
        this.iocLocalesComboBox.addActionListener(e -> {
            this.namePreferences.locale = ((NamesPreferences.AvailableIocLocale)this.iocLocalesComboBox.getSelectedItem()).code();
        });
        this.iocLocalesLabel = new JLabel(Messages.getMessage(Messages.Name.SPECIES_NAME_IOC));
        this.uiLocalesLabel = new JLabel(Messages.getMessage(Messages.Name.LANGUAGE_PREFERENCES_NEEDS_RESTART));
        this.uiLocalesComboBox = new JComboBox<AvailableUiLocales>(AvailableUiLocales.values());
        if (LocalePreferences.instance().isDefault()) {
            this.uiLocalesComboBox.setSelectedItem((Object)AvailableUiLocales.DEFAULT);
        } else {
            this.uiLocalesComboBox.setSelectedItem((Object)AvailableUiLocales.forLocale(LocalePreferences.instance().getSavedLocale()));
        }
        this.uiLocalesComboBox.addActionListener(e -> {
            AvailableUiLocales uiLocale = (AvailableUiLocales)((Object)((Object)((Object)this.uiLocalesComboBox.getSelectedItem())));
            LocalePreferences.instance().saveLocale(uiLocale.locale);
        });
        this.uiModeLabel = new JLabel(Messages.getMessage(Messages.Name.UI_MODE_QUERY));
        this.uiModeComboBox = new JComboBox<UIMode>(UIMode.modesForOperatingSystem());
        this.uiModeComboBox.setSelectedItem((Object)this.uiPreferences.uiMode);
        this.uiModeComboBox.addActionListener(e -> {
            UIMode uiMode = (UIMode)((Object)((Object)((Object)this.uiModeComboBox.getSelectedItem())));
            uiMode.apply();
            this.uiPreferences.uiMode = uiMode;
        });
        this.exportPreferences = new JLabel(Messages.getMessage(Messages.Name.EXPORT_PREFERENCES));
        this.excelCompatibleCsvs = new JCheckBox(Messages.getMessage(Messages.Name.EXCEL_COMPATIBLE_CSVS));
        this.excelCompatibleCsvs.setSelected(this.importPreferences.excelCompatibleCsv);
        this.excelCompatibleCsvs.addActionListener(e -> {
            this.importPreferences.excelCompatibleCsv = this.excelCompatibleCsvs.isSelected();
        });
        ImmutableBiMap<NamesPreferences.ScientificOrCommon, String> sciOrCommonMap = ImmutableBiMap.of(NamesPreferences.ScientificOrCommon.COMMON_FIRST, Messages.getMessage(Messages.Name.COMMON_THEN_SCIENTIFIC), NamesPreferences.ScientificOrCommon.SCIENTIFIC_FIRST, Messages.getMessage(Messages.Name.SCIENTIFIC_THEN_COMMON), NamesPreferences.ScientificOrCommon.SCIENTIFIC_ONLY, Messages.getMessage(Messages.Name.SCIENTIFIC_ONLY), NamesPreferences.ScientificOrCommon.COMMON_ONLY, Messages.getMessage(Messages.Name.COMMON_ONLY));
        this.sciOrCommonComboBox = new JComboBox<String>(sciOrCommonMap.values().toArray(new String[4]));
        this.sciOrCommonComboBox.setSelectedItem(sciOrCommonMap.get((Object)this.namePreferences.scientificOrCommon));
        this.sciOrCommonComboBox.addActionListener(e -> {
            this.namePreferences.scientificOrCommon = (NamesPreferences.ScientificOrCommon)((Object)((Object)((Object)((ImmutableMap)((Object)sciOrCommonMap.inverse())).get(this.sciOrCommonComboBox.getSelectedItem()))));
        });
        this.countability = new JLabel(Messages.getMessage(Messages.Name.COUNTABILITY_PREFERENCES));
        this.countIntroduced = new JCheckBox(Messages.getMessage(Messages.Name.COUNT_INTRODUCED_SPECIES));
        this.countIntroduced.setSelected(this.queryPreferences.countIntroduced);
        this.countIntroduced.addActionListener(e -> {
            this.queryPreferences.countIntroduced = this.countIntroduced.isSelected();
        });
        this.countHeardOnly = new JCheckBox(Messages.getMessage(Messages.Name.COUNT_HEARD_ONLY_SIGHTINGS));
        this.countHeardOnly.setSelected(this.queryPreferences.countHeardOnly);
        this.countHeardOnly.addActionListener(e -> {
            this.queryPreferences.countHeardOnly = this.countHeardOnly.isSelected();
        });
        this.countUndescribed = new JCheckBox(Messages.getMessage(Messages.Name.COUNT_UNDESCRIBED_SPECIES));
        this.countUndescribed.setSelected(this.queryPreferences.countUndescribed);
        this.countUndescribed.addActionListener(e -> {
            this.queryPreferences.countUndescribed = this.countUndescribed.isSelected();
        });
        this.countRestrained = new JCheckBox(Messages.getMessage(Messages.Name.COUNT_RESTRAINED_INDIVIDUALS));
        this.countRestrained.setSelected(this.queryPreferences.countRestrained);
        this.countRestrained.addActionListener(e -> {
            this.queryPreferences.countRestrained = this.countRestrained.isSelected();
        });
        this.showExtinct = new JCheckBox(Messages.getMessage(Messages.Name.SHOW_EXTINCT_TAXA));
        this.showExtinct.setSelected(this.browsePreferences.showExtinctTaxa);
        this.showExtinct.addActionListener(e -> {
            this.browsePreferences.showExtinctTaxa = this.showExtinct.isSelected();
        });
        this.privacy = new JLabel(Messages.getMessage(Messages.Name.PRIVACY_PREFERENCES));
        this.useGoogleLocationApis = new JCheckBox(Messages.getMessage(Messages.Name.USE_GOOGLE_LOCATION_APIS));
        this.useGoogleLocationApis.setSelected(this.locationApiPreferences.enableGoogleApis);
        this.useGoogleLocationApis.addActionListener(e -> {
            this.locationApiPreferences.enableGoogleApis = this.useGoogleLocationApis.isSelected();
        });
        this.useEBirdLocationApis = new JCheckBox(Messages.getMessage(Messages.Name.USE_EBIRD_LOCATION_APIS));
        this.useEBirdLocationApis.setSelected(this.locationApiPreferences.enableEBirdApis);
        this.useEBirdLocationApis.addActionListener(e -> {
            this.locationApiPreferences.enableEBirdApis = this.useEBirdLocationApis.isSelected();
        });
        this.mapProviderLabel = new JLabel(Messages.getMessage(Messages.Name.MAP_PROVIDER));
        this.mapProvider = new JComboBox<String>(new String[]{"Google", "OpenStreetMap", Messages.getMessage(Messages.Name.MAP_PROVIDER_NONE)});
        switch (this.locationApiPreferences.mapProvider) {
            case GOOGLE: {
                this.mapProvider.setSelectedIndex(0);
                break;
            }
            case OPEN_STREET_MAP: {
                this.mapProvider.setSelectedIndex(1);
                break;
            }
            case NONE: {
                this.mapProvider.setSelectedIndex(2);
            }
        }
        this.mapProvider.addActionListener(e -> {
            if (this.mapProvider.getSelectedIndex() >= 0) {
                this.locationApiPreferences.mapProvider = LocationApiPreferences.MapProvider.values()[this.mapProvider.getSelectedIndex()];
            }
        });
        this.backups = new JLabel(Messages.getMessage(Messages.Name.BACKUP_PREFERENCES));
        this.backupFrequency = new JLabel(Messages.getMessage(Messages.Name.HOW_OFTEN));
        this.backupFrequencyCombo = new JComboBox<BackupFrequency>(new BackupFrequency[]{BackupFrequency.NEVER, BackupFrequency.WEEKLY, BackupFrequency.MONTHLY});
        this.backupFrequencyCombo.setSelectedItem((Object)this.backupPreferences.frequency);
        this.backupFrequencyCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesPanel.this.backupPreferences.frequency = (BackupFrequency)((Object)PreferencesPanel.this.backupFrequencyCombo.getSelectedItem());
                PreferencesPanel.this.backupOptionsChanged = true;
            }
        });
        this.backupNowButton = new JButton(Messages.getMessage(Messages.Name.BACKUP_NOW));
        this.backupNowButton.setVisible(false);
        this.backupNowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PreferencesPanel.this.reportSetSaver.getDirty().isDirty()) {
                    int option = PreferencesPanel.this.alerts.showConfirm((Object)PreferencesPanel.this, Messages.Name.YOU_HAVE_UNSAVED_CHANGES, Messages.Name.SAVE_BEFORE_BACKING_UP, new Object[0]);
                    if (option == 2) {
                        return;
                    }
                    if (option == 0) {
                        try {
                            PreferencesPanel.this.reportSetSaver.save();
                        }
                        catch (IOException ioe) {
                            FileDialogs.showFileSaveError(PreferencesPanel.this.alerts, ioe, PreferencesPanel.this.reportSetSaver.file());
                            return;
                        }
                    }
                }
                PreferencesPanel.this.backupSaver.definitelySaveAll();
            }
        });
        this.backupLocationButton = new JButton(Messages.getMessage(Messages.Name.CHOOSE_A_DIRECTORY));
        this.backupLocation = new TextLink(Messages.getMessage(Messages.Name.NONE_IN_BRACKETS));
        if (this.backupPreferences.backupDirectory != null && (backupDirectory = new File(this.backupPreferences.backupDirectory)).exists() && backupDirectory.isDirectory()) {
            this.updateBackupDirectoryText(backupDirectory);
        }
        this.backupLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File backupDirectory;
                if (PreferencesPanel.this.backupPreferences.backupDirectory != null && (backupDirectory = new File(PreferencesPanel.this.backupPreferences.backupDirectory)).exists() && backupDirectory.isDirectory() && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                    try {
                        Desktop.getDesktop().open(backupDirectory);
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                PreferencesPanel.this.chooseBackupDirectory();
            }
        });
        this.backupLocationButton.addActionListener(e -> this.chooseBackupDirectory());
        this.users = new JLabel(Messages.getMessage(Messages.Name.OBSERVER_PREFERENCES));
        this.toggleMultipleUsers = new JButton(Messages.getMessage(this.reportSet.getUserSet() == null ? Messages.Name.ENABLE_MULTIPLE_OBSERVERS : Messages.Name.DISABLE_MULTIPLE_OBSERVERS));
        this.toggleMultipleUsers.addActionListener(e -> this.toggleMultipleUsers());
        this.userSetPanel.setVisible(this.reportSet.getUserSet() != null);
        if (this.reportSet.getUserSet() != null) {
            this.userSetPanel.setUserSet(this.reportSet.getUserSet());
        }
        this.returnButton = new JButton(returnAction);
        this.returnButton.addActionListener(e -> {
            if (this.backupOptionsChanged) {
                this.backupSaver.maybeSaveAll();
            }
        });
    }

    private void toggleMultipleUsers() {
        if (this.reportSet.getUserSet() == null) {
            this.enableMultipleUsers();
        } else {
            this.disableMultipleUsers();
        }
    }

    private void enableMultipleUsers() {
        UserSet userSet = new UserSet();
        this.userDialog.showUserDialog(this, Messages.getMessage(Messages.Name.CREATE_A_FIRST_OBSERVER), userSet, null, u -> {
            this.reportSet.setUserSet(userSet);
            User addedUser = userSet.addUser(u);
            this.userSetPanel.setUserSet(userSet);
            this.toggleMultipleUsers.setText(Messages.getMessage(Messages.Name.DISABLE_MULTIPLE_OBSERVERS));
            this.userSetPanel.setVisible(true);
            this.defaultUserStore.setUser(addedUser);
            SwingUtilities.getWindowAncestor(this).pack();
            if (!this.reportSet.getSightings().isEmpty()) {
                if (this.alerts.showYesNo((Object)this, Messages.Name.ADD_TO_ALL_SIGHTINGS, Messages.Name.ADD_OBSERVER_TO_ALL_SIGHTING_NOW, new Object[0]) == 0) {
                    ImmutableSet<User> users = ImmutableSet.of(addedUser);
                    for (Sighting sighting : this.reportSet.getSightings()) {
                        sighting.getSightingInfo().setUsers(users);
                    }
                    this.chosenUserPreferences.get().setUsers(users);
                    this.chosenUserPreferences.save(true);
                }
            } else {
                this.chosenUserPreferences.get().setUsers(ImmutableSet.of(addedUser));
                this.chosenUserPreferences.save(true);
            }
        });
    }

    private void disableMultipleUsers() {
        if (this.alerts.showOkCancel((Object)this, Messages.Name.DISABLE_OBSERVERS_TITLE, Messages.Name.DISABLE_OBSERVERS_MESSAGE, new Object[0]) == 0) {
            this.chosenUserPreferences.get().setUsers(ImmutableSet.of());
            this.reportSet.clearUserSet();
            this.defaultUserStore.setUser(null);
            this.toggleMultipleUsers.setText(Messages.getMessage(Messages.Name.ENABLE_MULTIPLE_OBSERVERS));
            this.userSetPanel.setVisible(false);
        }
    }

    private void updateBackupDirectoryText(File backupDirectory) {
        Object path = backupDirectory.getAbsolutePath();
        if (((String)path).length() > 40) {
            path = "\u2026" + ((String)path).substring(((String)path).length() - 40, ((String)path).length());
        }
        this.backupLocation.setText((String)path);
        this.backupNowButton.setVisible(true);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.backupLocation.putClientProperty("birdlist.plainLabel", true);
        this.backupFrequency.putClientProperty("birdlist.plainLabel", true);
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.clementsLocalesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clementsLocalesComboBox, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.iocLocalesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.iocLocalesComboBox, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sciOrCommonComboBox, -2, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.countability).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countIntroduced).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countHeardOnly).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countUndescribed).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countRestrained).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showExtinct))).addGap(fontManager.scale(20)).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.uiModeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.uiModeComboBox, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.uiLocalesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.uiLocalesComboBox, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exportPreferences).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.excelCompatibleCsvs)).addGroup(layout.createSequentialGroup().addComponent(this.privacy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useGoogleLocationApis).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useEBirdLocationApis).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mapProviderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mapProvider, -2, -2, -2))).addGap(fontManager.scale(20)).addComponent(this.backups).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.backupFrequency).addComponent(this.backupFrequencyCombo, -2, -2, -2).addComponent(this.backupLocationButton, -2, -2, -2).addComponent(this.backupNowButton, -2, -2, -2).addComponent(this.backupLocation)).addGap(fontManager.scale(20)).addComponent(this.users).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toggleMultipleUsers, -2, -2, -2).addComponent(this.userSetPanel, -2, -2, -2).addGap(0, fontManager.scale(20), Short.MAX_VALUE).addComponent(this.returnButton));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.clementsLocalesLabel).addComponent(this.clementsLocalesComboBox, fontManager.scale(180), -2, -2).addComponent(this.iocLocalesLabel).addComponent(this.iocLocalesComboBox, fontManager.scale(180), -2, -2).addComponent(this.sciOrCommonComboBox, fontManager.scale(180), -2, -2).addComponent(this.uiModeLabel).addComponent(this.uiModeComboBox, -2, -2, -2).addComponent(this.uiLocalesLabel).addComponent(this.uiLocalesComboBox, -2, -2, -2).addComponent(this.exportPreferences).addComponent(this.excelCompatibleCsvs)).addGap(fontManager.scale(80)).addGroup(layout.createParallelGroup().addComponent(this.countability).addComponent(this.countIntroduced).addComponent(this.countHeardOnly).addComponent(this.countUndescribed).addComponent(this.countRestrained).addComponent(this.showExtinct).addComponent(this.privacy).addComponent(this.useGoogleLocationApis).addComponent(this.useEBirdLocationApis).addComponent(this.mapProviderLabel).addComponent(this.mapProvider, -2, -2, -2))).addComponent(this.backups).addGroup(layout.createSequentialGroup().addComponent(this.backupFrequency).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backupFrequencyCombo, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backupLocationButton).addComponent(this.backupLocation, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backupNowButton, -2, -2, -2)).addComponent(this.users).addComponent(this.toggleMultipleUsers).addComponent(this.userSetPanel, -2, -2, fontManager.scale(400)).addGroup(layout.createSequentialGroup().addGap(0, fontManager.scale(75), Short.MAX_VALUE).addComponent(this.returnButton)));
        this.setPreferredSize(fontManager.scale(new Dimension(800, this.reportSet.getUserSet() == null ? 600 : 800)));
    }

    private void chooseBackupDirectory() {
        if (this.backupSaver.chooseBackupDirectory(this, this.reportSetFile)) {
            this.updateBackupDirectoryText(new File(this.backupPreferences.backupDirectory));
            this.backupFrequencyCombo.setSelectedItem((Object)this.backupPreferences.frequency);
            this.backupOptionsChanged = true;
        }
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.PREFERENCES);
    }

    public static enum AvailableUiLocales {
        DEFAULT(null),
        ENGLISH(new Locale("en")),
        GERMAN(new Locale("de")),
        SPANISH(new Locale("es"));

        private final Locale locale;

        private AvailableUiLocales(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String toString() {
            if (this.locale == null) {
                return Messages.getMessage(Messages.Name.USE_SYSTEM_LANGUAGE);
            }
            return this.locale.getDisplayName(this.locale);
        }

        static AvailableUiLocales forLocale(Locale locale) {
            for (AvailableUiLocales uiLocale : AvailableUiLocales.values()) {
                if (uiLocale == DEFAULT || !uiLocale.getLocale().equals(locale)) continue;
                return uiLocale;
            }
            return DEFAULT;
        }
    }
}

