/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.backup.BackupPreferences;
import com.scythebill.birdlist.ui.components.VisitInfoPreferences;
import com.scythebill.birdlist.ui.imports.ImportMenuPanel;
import com.scythebill.birdlist.ui.panels.BrowsePreferences;
import com.scythebill.birdlist.ui.panels.DataEntryPreferences;
import com.scythebill.birdlist.ui.panels.MainBrowsePanel;
import com.scythebill.birdlist.ui.panels.MainFrame;
import com.scythebill.birdlist.ui.panels.MainMenuPanel;
import com.scythebill.birdlist.ui.panels.PreferencesPanel;
import com.scythebill.birdlist.ui.panels.SingleLocationEditPanel;
import com.scythebill.birdlist.ui.panels.ToolbarManager;
import com.scythebill.birdlist.ui.panels.location.ChecklistPrintPreferences;
import com.scythebill.birdlist.ui.panels.location.ChecklistSpreadsheetPreferences;
import com.scythebill.birdlist.ui.panels.location.LocationBrowsePanel;
import com.scythebill.birdlist.ui.panels.reports.BigDayPanel;
import com.scythebill.birdlist.ui.panels.reports.ExtendedReportMenuPanel;
import com.scythebill.birdlist.ui.panels.reports.FamilyReportPreferences;
import com.scythebill.birdlist.ui.panels.reports.QueryPanelFactory;
import com.scythebill.birdlist.ui.panels.reports.ReportPrintPreferences;
import com.scythebill.birdlist.ui.panels.reports.ReportSpreadsheetPreferences;
import com.scythebill.birdlist.ui.panels.reports.ReportsPanel;
import com.scythebill.birdlist.ui.panels.reports.ResolveTaxaPanel;
import com.scythebill.birdlist.ui.panels.reports.SplitsAndLumpsPanel;
import com.scythebill.birdlist.ui.panels.reports.StoredQueries;
import com.scythebill.birdlist.ui.panels.reports.StoredQueriesPreferences;
import com.scythebill.birdlist.ui.panels.reports.TotalTicksPanel;
import com.scythebill.birdlist.ui.panels.reports.TripReportPreferences;
import com.scythebill.birdlist.ui.panels.reports.YearComparisonPanel;
import com.scythebill.birdlist.ui.panels.trips.TripsBrowsePanel;
import com.scythebill.birdlist.ui.prefs.PreferencesManager;
import com.scythebill.birdlist.ui.taxonomy.TaxonomyManagementPanel;
import java.lang.annotation.Annotation;
import javax.swing.JPanel;

public class PanelsModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bindPanel(MainMenuPanel.class, "main");
        this.bindPanel(ReportsPanel.class, "reports");
        this.bindPanel(ResolveTaxaPanel.class, "resolveTaxa");
        this.bindPanel(SingleLocationEditPanel.class, "sightings");
        this.bindPanel(MainBrowsePanel.class, "browse");
        this.bindPanel(LocationBrowsePanel.class, "browseLocations");
        this.bindPanel(TripsBrowsePanel.class, "browseTrips");
        this.bindPanel(ImportMenuPanel.class, "importMenu");
        this.bindPanel(TaxonomyManagementPanel.class, "manageTaxonomies");
        this.bindPanel(PreferencesPanel.class, "preferences");
        this.bindPanel(ExtendedReportMenuPanel.class, "extendedReportsMenu");
        this.bindPanel(BigDayPanel.class, "bigDay");
        this.bindPanel(TotalTicksPanel.class, "totalTicks");
        this.bindPanel(SplitsAndLumpsPanel.class, "splitsAndLumps");
        this.bindPanel(YearComparisonPanel.class, "yearComparison");
        this.bind(MainFrame.class).in(Singleton.class);
        this.bind(Key.get(NavigableFrame.class)).to(MainFrame.class);
        this.bind(QueryPanelFactory.class).in(Singleton.class);
    }

    @Provides
    public BrowsePreferences provideBrowsePreferences(PreferencesManager manager) {
        return manager.getPreference(BrowsePreferences.class);
    }

    @Provides
    public DataEntryPreferences provideDataEntryPreferences(PreferencesManager manager) {
        return manager.getPreference(DataEntryPreferences.class);
    }

    @Provides
    public VisitInfoPreferences provideVisitInfoPreferences(PreferencesManager manager) {
        return manager.getPreference(VisitInfoPreferences.class);
    }

    @Provides
    public ReportSpreadsheetPreferences provideReportSpreadsheetPreferences(PreferencesManager manager) {
        return manager.getPreference(ReportSpreadsheetPreferences.class);
    }

    @Provides
    public TripReportPreferences provideTripReportPreferences(PreferencesManager manager) {
        return manager.getPreference(TripReportPreferences.class);
    }

    @Provides
    public FamilyReportPreferences provideFamilyReportPreferences(PreferencesManager manager) {
        return manager.getPreference(FamilyReportPreferences.class);
    }

    @Provides
    public BackupPreferences provideBackupPreferences(PreferencesManager manager) {
        return manager.getPreference(BackupPreferences.class);
    }

    @Provides
    public ReportPrintPreferences provideReportPrintPreferences(PreferencesManager manager) {
        return manager.getPreference(ReportPrintPreferences.class);
    }

    @Provides
    public ChecklistPrintPreferences provideChecklistPrintPreferences(PreferencesManager manager) {
        return manager.getPreference(ChecklistPrintPreferences.class);
    }

    @Provides
    public ChecklistSpreadsheetPreferences provideChecklistSpreadsheetPreferences(PreferencesManager manager) {
        return manager.getPreference(ChecklistSpreadsheetPreferences.class);
    }

    @Provides
    public StoredQueriesPreferences provideStoredQueriesPreferences(PreferencesManager manager) {
        return manager.getPreference(StoredQueriesPreferences.class);
    }

    @Provides
    public ToolbarManager provideToolbarManager(MainFrame mainFrame) {
        return mainFrame.getToolbarManager();
    }

    @Provides
    @Singleton
    public StoredQueries provideStoredQueries(QueryPanelFactory queryPanelFactory) {
        return queryPanelFactory.getStoredQueries();
    }

    private void bindPanel(Class<? extends JPanel> panelClass, String name) {
        this.bind(Key.get(JPanel.class, (Annotation)Names.named(name))).to(panelClass);
    }
}

