/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.scythebill.birdlist.ui.actions.ImportChecklistsAction;
import com.scythebill.birdlist.ui.actions.ReturnAction;
import com.scythebill.birdlist.ui.app.OtherFileLoaderRegistry;
import com.scythebill.birdlist.ui.imports.ImportMenuPanel;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.taxonomy.ExtendedTaxonomyAdder;
import com.scythebill.birdlist.ui.taxonomy.ExtendedTaxonomyXmlImporter;
import com.scythebill.birdlist.ui.taxonomy.TaxonomyWithChecklists;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.xml.sax.SAXException;

class OtherFileLoader {
    private final OtherFileLoaderRegistry registry;
    private final ImportChecklistsAction importChecklistsAction;
    private final Provider<ImportMenuPanel> menuPanelProvider;
    private final ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            List<File> files = OtherFileLoader.this.registry.getAndClear();
            if (!files.isEmpty()) {
                OtherFileLoader.this.loadArbitraryCsvFiles(files);
            }
        }
    };
    private final Action returnAction;
    private final ExtendedTaxonomyAdder extendedTaxonomyAdder;
    private final Alerts alerts;

    @Inject
    OtherFileLoader(OtherFileLoaderRegistry registry, ImportChecklistsAction importChecklistsAction, ReturnAction returnAction, ExtendedTaxonomyAdder extendedTaxonomyAdder, Alerts alerts, Provider<ImportMenuPanel> menuPanelProvider) {
        this.registry = registry;
        this.importChecklistsAction = importChecklistsAction;
        this.returnAction = returnAction;
        this.extendedTaxonomyAdder = extendedTaxonomyAdder;
        this.alerts = alerts;
        this.menuPanelProvider = menuPanelProvider;
    }

    public void register() {
        this.registry.addActionListener(this.listener);
        this.listener.actionPerformed(null);
    }

    public void unregister() {
        this.registry.removeActionListener(this.listener);
    }

    private void loadArbitraryCsvFiles(List<File> files) {
        ArrayList<File> checklists = Lists.newArrayList();
        ArrayList<File> notChecklists = Lists.newArrayList();
        ArrayList<File> taxonomyFiles = Lists.newArrayList();
        for (File file : files) {
            if (file.getName().endsWith(".btxm")) {
                taxonomyFiles.add(file);
                continue;
            }
            if (this.importChecklistsAction.isClementsChecklist(file)) {
                checklists.add(file);
                continue;
            }
            notChecklists.add(file);
        }
        if (!checklists.isEmpty()) {
            this.importChecklistsAction.importFiles(checklists.toArray(new File[0]));
        }
        for (File taxonomyFile : taxonomyFiles) {
            try {
                BufferedReader in = Files.newReader(taxonomyFile, StandardCharsets.UTF_8);
                try {
                    TaxonomyWithChecklists taxonomy = new ExtendedTaxonomyXmlImporter().readExtendedTaxonomy(in);
                    this.extendedTaxonomyAdder.addTaxonomy(null, taxonomy);
                }
                finally {
                    if (in == null) continue;
                    ((Reader)in).close();
                }
            }
            catch (IOException | SAXException e) {
                this.alerts.showError(null, Messages.Name.IMPORT_FAILED, Messages.Name.IMPORTING_TAXONOMY_FAILED_FORMAT, e.getMessage());
            }
        }
        if (!notChecklists.isEmpty()) {
            new ImportOneEBirdFileAction(notChecklists).actionPerformed(null);
        }
    }

    private class ImportOneEBirdFileAction
    extends AbstractAction {
        private Iterable<File> ebirdFiles;

        public ImportOneEBirdFileAction(Iterable<File> ebirdFiles) {
            this.ebirdFiles = ebirdFiles;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File next = this.ebirdFiles.iterator().next();
            Iterable<File> remaining = Iterables.skip(this.ebirdFiles, 1);
            Action continuation = Iterables.isEmpty(remaining) ? OtherFileLoader.this.returnAction : new ImportOneEBirdFileAction(remaining);
            ImportMenuPanel importMenuPanel = OtherFileLoader.this.menuPanelProvider.get();
            importMenuPanel.importEBirdFile(next, continuation);
        }
    }
}

