/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.inject.Inject;
import com.scythebill.birdlist.ui.actions.NewReportSetAction;
import com.scythebill.birdlist.ui.actions.OpenAction;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.imports.ImportAction;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;

public class OpenOrNewListPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private final FontManager fontManager;
    private JTextPane text;
    private JPanel centerBox;
    private JButton openListButton;
    private JButton newListButton;
    private JButton importButton;
    private JLabel openListLabel;
    private JLabel newListLabel;
    private JLabel importListLabel;

    @Inject
    public OpenOrNewListPanel(FontManager fontManager, OpenAction openAction, NewReportSetAction newAction, ImportAction importAction) {
        this.fontManager = fontManager;
        this.initGUI(openAction, newAction, importAction);
    }

    private void initGUI(Action openAction, Action newAction, Action importAction) {
        this.setLayout(new BoxLayout(this, 3));
        this.text = new JTextPane();
        this.text.setContentType("text/html");
        this.text.setText("<html><b>" + Messages.getMessage(Messages.Name.WELCOME_TO_SCYTHEBILL) + "</b><br><br>" + Messages.getMessage(Messages.Name.WELCOME_MESSAGE));
        this.text.putClientProperty("birdlist.textSize", (Object)FontManager.TextSize.LARGE);
        this.text.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.text.setOpaque(false);
        this.text.setEditable(false);
        this.add(this.text);
        this.centerBox = new JPanel();
        this.add(this.centerBox);
        this.openListButton = new JButton();
        this.openListButton.setAction(openAction);
        this.openListButton.setText(Messages.getMessage(Messages.Name.OPEN_FILE));
        this.openListButton.putClientProperty("Quaqua.Button.style", "bevel");
        this.newListButton = new JButton();
        this.newListButton.setAction(newAction);
        this.newListButton.setText(Messages.getMessage(Messages.Name.NEW_FILE));
        this.newListButton.putClientProperty("Quaqua.Button.style", "bevel");
        this.importButton = new JButton();
        this.importButton.setAction(importAction);
        this.importButton.setText(Messages.getMessage(Messages.Name.IMPORT_SIGHTINGS_MENU));
        this.importButton.putClientProperty("Quaqua.Button.style", "bevel");
        this.openListLabel = new JLabel(Messages.getMessage(Messages.Name.OPEN_FILE_EXPLANATION));
        this.openListLabel.putClientProperty("birdlist.plainLabel", true);
        this.newListLabel = new JLabel(Messages.getMessage(Messages.Name.NEW_FILE_EXPLANATION));
        this.newListLabel.putClientProperty("birdlist.plainLabel", true);
        this.importListLabel = new JLabel(Messages.getMessage(Messages.Name.IMPORT_RECORDS_EXPLANATION));
        this.importListLabel.putClientProperty("birdlist.plainLabel", true);
        this.fontManager.applyTo(this);
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.setBorder(new EmptyBorder(fontManager.scale(20), fontManager.scale(40), fontManager.scale(20), fontManager.scale(40)));
        this.centerBox.setBorder(new EmptyBorder(fontManager.scale(10), 0, 0, 0));
        this.text.setPreferredSize(new Dimension(fontManager.scale(300), fontManager.scale(100)));
        GroupLayout thisLayout = new GroupLayout(this.centerBox);
        this.centerBox.setLayout(thisLayout);
        thisLayout.setHorizontalGroup(thisLayout.createSequentialGroup().addContainerGap().addGroup(thisLayout.createParallelGroup().addComponent(this.openListButton, GroupLayout.Alignment.LEADING, -2, 154, -2).addComponent(this.newListButton, GroupLayout.Alignment.LEADING, -2, 154, -2).addComponent(this.importButton, GroupLayout.Alignment.LEADING, -2, 154, -2)).addGap(fontManager.scale(63)).addGroup(thisLayout.createParallelGroup().addComponent(this.openListLabel, -2, -2, -2).addComponent(this.newListLabel, -2, -2, -2).addComponent(this.importListLabel, -2, -2, -2)).addContainerGap(fontManager.scale(67), fontManager.scale(67)));
        thisLayout.setVerticalGroup(thisLayout.createSequentialGroup().addContainerGap().addGroup(thisLayout.createBaselineGroup(false, false).addComponent(this.openListButton, -2, fontManager.scale(64), -2).addComponent(this.openListLabel, -2, -2, -2)).addGap(fontManager.scale(14)).addGroup(thisLayout.createBaselineGroup(false, false).addComponent(this.newListButton, -2, fontManager.scale(64), -2).addComponent(this.newListLabel, -2, -2, -2)).addGap(fontManager.scale(14)).addGroup(thisLayout.createBaselineGroup(false, false).addComponent(this.importButton, -2, fontManager.scale(64), -2).addComponent(this.importListLabel, -2, -2, -2)).addContainerGap(fontManager.scale(82), fontManager.scale(82)));
        thisLayout.linkSize(this.openListButton, this.newListButton, this.importButton);
    }
}

