/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.ui.actions.MenuConfiguration;
import com.scythebill.birdlist.ui.actions.NewReportSetAction;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.guice.Scythebill;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.lang.annotation.Annotation;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class OpenOrNewListFrame
extends JFrame
implements NavigableFrame {
    private final Injector injector;
    private final FontManager fontManager;
    private final FontManager.FontsUpdatedListener fontsUpdatedListener = new FontManager.FontsUpdatedListener(){

        @Override
        public void fontsUpdated(FontManager fontManager) {
            fontManager.applyTo(OpenOrNewListFrame.this);
            OpenOrNewListFrame.this.pack();
            UIUtils.keepWindowOnScreen(OpenOrNewListFrame.this);
        }
    };

    @Inject
    public OpenOrNewListFrame(MenuConfiguration menuConfiguration, Injector injector, NewReportSetAction newReportSetAction, ReportSet reportSet, FontManager fontManager, @Scythebill Image image) {
        JMenu helpMenu;
        this.injector = injector;
        this.fontManager = fontManager;
        this.setTitle("Scythebill");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menuConfiguration.getFileMenu());
        JMenu viewMenu = menuConfiguration.getViewMenu();
        if (viewMenu != null) {
            menuBar.add(viewMenu);
        }
        if ((helpMenu = menuConfiguration.getHelpMenu()) != null) {
            menuBar.add(helpMenu);
        }
        this.setJMenuBar(menuBar);
        fontManager.addListener(this.fontsUpdatedListener);
        this.setIconImage(image);
    }

    public void start() {
        this.navigateTo("main");
        this.setLocationByPlatform(true);
        this.setVisible(true);
    }

    @Override
    public JPanel navigateTo(String target) {
        JPanel panel = this.injector.getInstance(Key.get(JPanel.class, (Annotation)Names.named(target)));
        this.navigateTo(panel);
        return panel;
    }

    @Override
    public JPanel navigateToAndPush(String target, Action onCompletion) {
        throw new UnsupportedOperationException("Not yet implemented for OpenOrNew");
    }

    @Override
    public void complete(ActionEvent evt) {
        this.navigateTo("main");
    }

    @Override
    public boolean navigateTo(JPanel panel) {
        Component firstComponent;
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
        FocusTraversalPolicy traversalPolicy = this.getFocusTraversalPolicy();
        if (traversalPolicy != null && (firstComponent = traversalPolicy.getFirstComponent(panel)) != null) {
            firstComponent.requestFocusInWindow();
        }
        return true;
    }

    @Override
    public void updateTitle() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fontManager.removeListener(this.fontsUpdatedListener);
    }
}

