/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.inject.Inject;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.guice.SidebarImage;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.ShrinkToFit;
import com.scythebill.birdlist.ui.panels.reports.StoredQueriesPanel;
import com.scythebill.birdlist.ui.util.VisibilityDetector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.OptionalDouble;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class MainMenuPanel
extends JPanel
implements FontManager.FontsUpdatedListener,
ShrinkToFit {
    private JButton enterSightings;
    private JButton reportButton;
    private JButton browseButton;
    private JButton browseLocationsButton;
    private JButton browseTripsButton;
    private JButton extendedReportsButton;
    private final NavigableFrame navigableFrame;
    private final FontManager fontManager;
    private JPanel centerBox;
    private JLabel sightingsLabel;
    private JLabel reportsLabel;
    private JLabel browseLabel;
    private JLabel browseLocationsLabel;
    private JLabel browseTripsLabel;
    private JLabel extendedReportsLabel;
    private StoredQueriesPanel storedQueriesPanel;
    private MenuButton preferencesButton;
    private JLabel preferencesLabel;
    private JLabel scythebillImageLabel;
    private final BufferedImage scythebillImage;
    private MenuButton manageTaxonomiesButton;
    private JLabel manageTaxonomiesLabel;

    @Inject
    public MainMenuPanel(NavigableFrame navigableFrame, FontManager fontManager, StoredQueriesPanel storedQueriesPanel, VisibilityDetector visibilityDetector, @SidebarImage BufferedImage sidebarImage) {
        this.navigableFrame = navigableFrame;
        this.fontManager = fontManager;
        this.storedQueriesPanel = storedQueriesPanel;
        this.scythebillImage = null;
        this.initGUI();
        visibilityDetector.install(this.preferencesButton);
        if (this.scythebillImage != null) {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    MainMenuPanel.this.updateScythebillImage(OptionalDouble.empty());
                }
            });
        }
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.centerBox = new JPanel();
        this.centerBox.setBorder(new EmptyBorder(20, 60, 20, 60));
        if (!this.storedQueriesPanel.isEmpty()) {
            this.add(this.storedQueriesPanel);
            this.storedQueriesPanel.setBorder(new EmptyBorder(20, 60, 20, 60));
            this.storedQueriesPanel.setAlignmentX(0.5f);
        }
        this.add(this.centerBox);
        this.centerBox.setAlignmentX(0.5f);
        if (this.scythebillImage != null) {
            this.scythebillImageLabel = new JLabel();
            this.scythebillImageLabel.setAlignmentY(1.0f);
            JPanel boxPanel = new JPanel();
            boxPanel.setLayout(new BoxLayout(boxPanel, 0));
            boxPanel.add(Box.createVerticalGlue());
            boxPanel.add(this.scythebillImageLabel);
            this.updateScythebillImage(OptionalDouble.of(0.55f));
            boxPanel.setOpaque(true);
            this.add(boxPanel);
        }
        this.enterSightings = new MenuButton();
        this.enterSightings.setAction(this.getNavigationAction("sightings"));
        this.enterSightings.setText(Messages.getMessage(Messages.Name.ENTER_SIGHTINGS));
        this.reportButton = new MenuButton();
        this.reportButton.setAction(this.getNavigationAction("reports"));
        this.reportButton.setText(Messages.getMessage(Messages.Name.SHOW_REPORTS));
        this.browseButton = new MenuButton();
        this.browseButton.setAction(this.getNavigationAction("browse"));
        this.browseButton.setText(Messages.getMessage(Messages.Name.BROWSE_BY_SPECIES));
        this.browseLocationsButton = new MenuButton();
        this.browseLocationsButton.setAction(this.getNavigationAction("browseLocations"));
        this.browseLocationsButton.setText(Messages.getMessage(Messages.Name.BROWSE_BY_LOCATION));
        this.browseTripsButton = new MenuButton();
        this.browseTripsButton.setAction(this.getNavigationAction("browseTrips"));
        this.browseTripsButton.setText(Messages.getMessage(Messages.Name.BROWSE_BY_TRIPS));
        this.extendedReportsButton = new MenuButton();
        this.extendedReportsButton.setAction(this.getNavigationAction("extendedReportsMenu"));
        this.extendedReportsButton.setText(Messages.getMessage(Messages.Name.SPECIAL_REPORTS));
        this.manageTaxonomiesButton = new MenuButton();
        this.manageTaxonomiesButton.setAction(this.getNavigationAction("manageTaxonomies"));
        this.manageTaxonomiesButton.setText(Messages.getMessage(Messages.Name.MANAGE_TAXONOMIES));
        this.preferencesButton = new MenuButton();
        this.preferencesButton.setAction(this.getNavigationAction("preferences"));
        this.preferencesButton.setText(Messages.getMessage(Messages.Name.PREFERENCES));
        this.sightingsLabel = new JLabel(Messages.getMessage(Messages.Name.ENTER_SIGHTINGS_EXPLANATION));
        this.sightingsLabel.putClientProperty("birdlist.plainLabel", true);
        this.reportsLabel = new JLabel(Messages.getMessage(Messages.Name.SHOW_REPORTS_EXPLANATION));
        this.reportsLabel.putClientProperty("birdlist.plainLabel", true);
        this.browseLabel = new JLabel(Messages.getMessage(Messages.Name.BROWSE_BY_SPECIES_EXPLANATION));
        this.browseLabel.putClientProperty("birdlist.plainLabel", true);
        this.browseLocationsLabel = new JLabel(Messages.getMessage(Messages.Name.BROWSE_BY_LOCATION_EXPLANATION));
        this.browseLocationsLabel.putClientProperty("birdlist.plainLabel", true);
        this.browseTripsLabel = new JLabel(Messages.getMessage(Messages.Name.BROWSE_BY_TRIPS_EXPLANATION));
        this.browseTripsLabel.putClientProperty("birdlist.plainLabel", true);
        this.extendedReportsLabel = new JLabel(Messages.getMessage(Messages.Name.SPECIAL_REPORTS_EXPLANATION));
        this.extendedReportsLabel.putClientProperty("birdlist.plainLabel", true);
        this.manageTaxonomiesLabel = new JLabel(Messages.getMessage(Messages.Name.MANAGE_TAXONOMIES_EXPLANATION));
        this.manageTaxonomiesLabel.putClientProperty("birdlist.plainLabel", true);
        this.preferencesLabel = new JLabel(Messages.getMessage(Messages.Name.PREFERENCES_EXPLANATION));
        this.preferencesLabel.putClientProperty("birdlist.plainLabel", true);
        this.fontManager.applyTo(this);
    }

    private Action getNavigationAction(final String navigateTarget) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenuPanel.this.navigableFrame.navigateTo(navigateTarget);
            }
        };
    }

    private void updateScythebillImage(OptionalDouble optionalRatio) {
        int w = this.scythebillImage.getWidth();
        int h = this.scythebillImage.getHeight();
        double ratio = optionalRatio.orElseGet(() -> (double)this.getWidth() / (double)w);
        int newW = (int)((double)w * ratio);
        int newH = (int)((double)h * ratio);
        if (newW <= 0 || newH <= 0) {
            return;
        }
        BufferedImage after = new BufferedImage(newW, newH, 2);
        AffineTransform at = AffineTransform.getScaleInstance(ratio, ratio);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        Color background = this.getBackground();
        Graphics2D g2 = (Graphics2D)after.getGraphics();
        g2.drawImage(this.scythebillImage, scaleOp, 0, 0);
        LinearGradientPaint paint = new LinearGradientPaint(new Point2D.Float(0.0f, 0.0f), new Point2D.Float(0.0f, h), new float[]{0.0f, 0.05f, 0.1f, 1.0f}, new Color[]{new Color(background.getRed(), background.getGreen(), background.getBlue(), 255), new Color(background.getRed(), background.getGreen(), background.getBlue(), 96), new Color(background.getRed(), background.getGreen(), background.getBlue(), 64), new Color(background.getRed(), background.getGreen(), background.getBlue(), 64)});
        g2.setPaint(paint);
        g2.fillRect(0, 0, newW, newH);
        g2.dispose();
        this.scythebillImageLabel.setIcon(new ImageIcon(after));
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        GroupLayout layout = new GroupLayout(this.centerBox);
        this.centerBox.setLayout(layout);
        int buttonWidth = fontManager.scale(194);
        int buttonHeight = fontManager.scale(60);
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addComponent(this.enterSightings, GroupLayout.Alignment.CENTER, -2, buttonWidth, -2).addComponent(this.browseButton, GroupLayout.Alignment.CENTER, -2, buttonWidth, -2).addComponent(this.browseLocationsButton, GroupLayout.Alignment.CENTER, -2, buttonWidth, -2).addComponent(this.browseTripsButton, GroupLayout.Alignment.CENTER, -2, buttonWidth, -2).addComponent(this.sightingsLabel, GroupLayout.Alignment.CENTER).addComponent(this.browseLabel, GroupLayout.Alignment.CENTER).addComponent(this.browseLocationsLabel, GroupLayout.Alignment.CENTER).addComponent(this.browseTripsLabel, GroupLayout.Alignment.CENTER)).addGap(63).addGroup(layout.createParallelGroup().addComponent(this.reportButton, GroupLayout.Alignment.CENTER, -2, buttonWidth, -2).addComponent(this.extendedReportsButton, GroupLayout.Alignment.CENTER, -2, buttonWidth, -2).addComponent(this.manageTaxonomiesButton, GroupLayout.Alignment.CENTER, -2, buttonWidth, -2).addComponent(this.preferencesButton, GroupLayout.Alignment.CENTER, -2, buttonWidth, -2).addComponent(this.reportsLabel, GroupLayout.Alignment.CENTER).addComponent(this.extendedReportsLabel, GroupLayout.Alignment.CENTER).addComponent(this.manageTaxonomiesLabel, GroupLayout.Alignment.CENTER).addComponent(this.preferencesLabel, GroupLayout.Alignment.CENTER)).addContainerGap(67, 67));
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createBaselineGroup(false, false).addComponent(this.enterSightings, GroupLayout.Alignment.BASELINE, -2, buttonHeight, -2).addComponent(this.reportButton, GroupLayout.Alignment.BASELINE, -2, buttonHeight, -2)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.sightingsLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.reportsLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(14).addGroup(layout.createBaselineGroup(false, false).addComponent(this.browseButton, GroupLayout.Alignment.BASELINE, -2, buttonHeight, -2).addComponent(this.extendedReportsButton, GroupLayout.Alignment.BASELINE, -2, buttonHeight, -2)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.browseLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.extendedReportsLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(14).addGroup(layout.createBaselineGroup(false, false).addComponent(this.browseLocationsButton, GroupLayout.Alignment.BASELINE, -2, buttonHeight, -2).addComponent(this.manageTaxonomiesButton, GroupLayout.Alignment.BASELINE, -2, buttonHeight, -2)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.browseLocationsLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.manageTaxonomiesLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(14).addGroup(layout.createBaselineGroup(false, false).addComponent(this.browseTripsButton, GroupLayout.Alignment.BASELINE, -2, buttonHeight, -2).addComponent(this.preferencesButton, GroupLayout.Alignment.BASELINE, -2, buttonHeight, -2)).addGroup(layout.createBaselineGroup(false, false).addComponent(this.browseTripsLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.preferencesLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addContainerGap(67, 67));
        layout.linkSize(0, this.enterSightings, this.reportButton, this.extendedReportsButton, this.browseButton, this.browseLocationsButton, this.browseTripsButton, this.preferencesButton, this.manageTaxonomiesButton);
        layout.linkSize(1, this.enterSightings, this.reportButton, this.extendedReportsButton, this.browseButton, this.browseLocationsButton, this.browseTripsButton, this.preferencesButton, this.manageTaxonomiesButton);
        this.centerBox.setMinimumSize(this.centerBox.getPreferredSize());
    }

    static class MenuButton
    extends JButton {
        MenuButton() {
            this.putClientProperty("Quaqua.Button.style", "bevel");
            this.putClientProperty("birdlist.buttonSize", (Object)FontManager.ButtonSize.MEDIUM_BOLD);
        }
    }
}

