/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.html.HtmlEscapers;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.scythebill.birdlist.model.checklist.ExtendedTaxonomyChecklists;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.ui.actions.ActionBroker;
import com.scythebill.birdlist.ui.actions.MenuConfiguration;
import com.scythebill.birdlist.ui.actions.TextFieldActions;
import com.scythebill.birdlist.ui.app.FrameRegistry;
import com.scythebill.birdlist.ui.app.NavigableFrame;
import com.scythebill.birdlist.ui.app.ReportSetSaver;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.guice.CurrentVersion;
import com.scythebill.birdlist.ui.guice.Scythebill;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.panels.OtherFileLoader;
import com.scythebill.birdlist.ui.panels.ShrinkToFit;
import com.scythebill.birdlist.ui.panels.TaxonomyChooserPanel;
import com.scythebill.birdlist.ui.panels.ToolbarManager;
import com.scythebill.birdlist.ui.panels.UIMode;
import com.scythebill.birdlist.ui.panels.UIPreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class MainFrame
extends JFrame
implements NavigableFrame {
    private JPanel container;
    private final Injector injector;
    private final Action saveAction;
    private final Action exportAction;
    private final Action fullExportAction;
    private final Action openContainingAction;
    private final Action identifyChecklistErrorsAction;
    private final Action identifyChecklistRaritiesAction;
    private final Action reconcileAgainstChecklistsAction;
    private final ActionBroker actionBroker;
    private final TextFieldActions textFieldActions;
    private final ReportSetSaver reportSetSaver;
    private final File reportSetFile;
    private final MenuConfiguration menuConfiguration;
    private final TaxonomyChooserPanel taxonomyChooserPanel;
    private final String versionInfo;
    private final Action importAction;
    private final List<JComponent> toolbarComponents = Lists.newArrayList();
    private final FontManager.FontsUpdatedListener fontsUpdatedListener = new FontManager.FontsUpdatedListener(){

        @Override
        public void fontsUpdated(FontManager fontManager) {
            fontManager.applyTo(MainFrame.this);
            MainFrame.this.pack();
            UIUtils.keepWindowOnScreen(MainFrame.this);
        }
    };
    private final FontManager fontManager;
    private final Alerts alerts;
    private final Toolbar toolbar = new Toolbar();
    private Dimension lastSavedSize = new Dimension();
    private JPanel toolbarPanel;
    private final ListeningScheduledExecutorService executorService;
    private ScheduledFuture<?> saveIfDirtyFuture;
    private Action importChecklistsAction;
    private OtherFileLoader otherFileLoader;
    private JPanel currentPanel;
    private final Action preferencesAction;
    private final Action saveACopyAsAction;
    private final TaxonomyStore taxonomyStore;
    private AbstractAction closeAction;
    private final Action manageTaxonomies;
    private Action onCompletion;
    private FrameRegistry frameRegistry;
    private FilePreferences filePreferences;
    private final ReportSet reportSet;
    private UIPreferences uiPreferences;

    public static void initCommonUI(UIMode mode) {
        mode.apply();
        String css = String.format("<head><style type=\"text/css\">b { font: 13pt \"%s\" }p { font: 11pt \"%s\"; margin-top: 8px }</style></head>", FontManager.getFontName(), FontManager.getFontName());
        UIManager.put("OptionPane.css", css);
    }

    public static MainFrame start(Injector injector, String startNav) {
        MainFrame inst = injector.getInstance(MainFrame.class);
        inst.start(startNav);
        return inst;
    }

    @Inject
    public MainFrame(Injector injector, ActionBroker actionBroker, File reportSetFile, @Named(value="save") Action saveAction, @Named(value="saveACopyAs") Action saveACopyAsAction, @Named(value="export") Action exportAction, @Named(value="fullExport") Action fullExportAction, @Named(value="import") Action importAction, @Named(value="manageTaxonomies") Action manageTaxonomies, @Named(value="openContaining") Action openContainingAction, @Named(value="identifyChecklistErrors") Action identifyChecklistErrorsAction, @Named(value="identifyChecklistRarities") Action identifyChecklistRaritiesAction, @Named(value="recocileAgainstChecklists") Action reconcileAgainstChecklistsAction, @Named(value="importChecklists") Action importChecklistsAction, @Named(value="preferences") Action preferencesAction, TextFieldActions textFieldActions, MenuConfiguration menuConfiguration, TaxonomyStore taxonomyStore, TaxonomyChooserPanel taxonomyChooserPanel, EventBus eventBus, ReportSetSaver reportSetSaver, ReportSet reportSet, @Scythebill Image image, @Nullable @CurrentVersion String versionInfo, FontManager fontManager, Alerts alerts, ListeningScheduledExecutorService executorService, FilePreferences filePreferences, UIPreferences uiPreferences, OtherFileLoader otherFileLoader, FrameRegistry frameRegistry) {
        this.injector = injector;
        this.actionBroker = actionBroker;
        this.reportSetFile = reportSetFile;
        this.saveAction = saveAction;
        this.saveACopyAsAction = saveACopyAsAction;
        this.exportAction = exportAction;
        this.fullExportAction = fullExportAction;
        this.importAction = importAction;
        this.manageTaxonomies = manageTaxonomies;
        this.openContainingAction = openContainingAction;
        this.identifyChecklistErrorsAction = identifyChecklistErrorsAction;
        this.identifyChecklistRaritiesAction = identifyChecklistRaritiesAction;
        this.reconcileAgainstChecklistsAction = reconcileAgainstChecklistsAction;
        this.importChecklistsAction = importChecklistsAction;
        this.preferencesAction = preferencesAction;
        this.textFieldActions = textFieldActions;
        this.menuConfiguration = menuConfiguration;
        this.taxonomyStore = taxonomyStore;
        this.taxonomyChooserPanel = taxonomyChooserPanel;
        this.reportSetSaver = reportSetSaver;
        this.reportSet = reportSet;
        this.versionInfo = versionInfo;
        this.fontManager = fontManager;
        this.alerts = alerts;
        this.executorService = executorService;
        this.filePreferences = filePreferences;
        this.uiPreferences = uiPreferences;
        this.otherFileLoader = otherFileLoader;
        this.frameRegistry = frameRegistry;
        fontManager.addListener(this.fontsUpdatedListener);
        this.setIconImage(image);
        this.initGUI();
        eventBus.register(this);
        reportSetSaver.getDirty().addDirtyListener(e -> this.getRootPane().putClientProperty("Window.documentModified", reportSetSaver.getDirty().isDirty()));
        this.getRootPane().putClientProperty("Window.documentModified", reportSetSaver.getDirty().isDirty());
    }

    void start(String startNav) {
        File directory;
        this.navigateTo(startNav);
        this.setLocationByPlatform(true);
        Point location = this.filePreferences.getLocation(this.reportSetFile);
        if (location != null) {
            this.setLocation(location);
        }
        this.setVisible(true);
        UIUtils.keepWindowOnScreen(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                MainFrame.this.filePreferences.setLocation(MainFrame.this.reportSetFile, MainFrame.this.getLocation());
            }
        });
        final FocusTraversalPolicy current = this.getFocusTraversalPolicy();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getLastComponent(Container c) {
                return current.getLastComponent(c);
            }

            @Override
            public Component getFirstComponent(Container c) {
                return current.getFirstComponent(c);
            }

            @Override
            public Component getDefaultComponent(Container c) {
                return current.getDefaultComponent(c);
            }

            @Override
            public Component getComponentBefore(Container c, Component child) {
                return current.getComponentBefore(c, child);
            }

            @Override
            public Component getComponentAfter(Container c, Component child) {
                return current.getComponentAfter(c, child);
            }
        });
        final Runnable askToSave = new Runnable(){

            @Override
            public void run() {
                int okCancel = MainFrame.this.alerts.showOkCancel((Object)MainFrame.this, Messages.Name.SAVE_SIGHTINGS_TITLE, Messages.Name.SAVE_SIGHTINGS_MESSAGE, new Object[0]);
                if (okCancel == 0) {
                    try {
                        MainFrame.this.reportSetSaver.save();
                    }
                    catch (IOException e) {
                        FileDialogs.showFileSaveError(MainFrame.this.alerts, e, MainFrame.this.reportSetSaver.file());
                    }
                }
            }
        };
        Runnable saveIfDirty = new Runnable(){

            @Override
            public void run() {
                Instant oldestAllowable;
                Instant dirtySince = MainFrame.this.reportSetSaver.getDirty().dirtySince();
                if (dirtySince != null && dirtySince.isBefore(oldestAllowable = new Instant().minus(Duration.standardHours(2L)))) {
                    try {
                        SwingUtilities.invokeAndWait(askToSave);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e.getCause());
                    }
                }
            }
        };
        this.saveIfDirtyFuture = this.executorService.scheduleWithFixedDelay(saveIfDirty, 1L, 1L, TimeUnit.HOURS);
        if (!this.reportSetFile.canWrite() && !Files.isWritable((directory = this.reportSetFile.getParentFile()).toPath())) {
            this.alerts.showMessage((Object)this, Messages.Name.NOT_WRITABLE_TITLE, Messages.Name.NOT_WRITABLE_FORMAT, directory.getName());
        }
    }

    private void initGUI() {
        JMenu helpMenu;
        this.getRootPane().putClientProperty("apple.awt.transparentTitleBar", true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout());
        this.container = new JPanel();
        BorderLayout containerBorderLayout = new BorderLayout();
        this.toolbarPanel = new JPanel();
        this.layoutToolbar();
        this.getContentPane().add((Component)this.toolbarPanel, "North");
        this.getContentPane().add((Component)this.container, "Center");
        this.container.setLayout(containerBorderLayout);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.menuConfiguration.getFileMenu());
        int keyModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        JMenu editMenu = new JMenu(Messages.getMessage(Messages.Name.EDIT_MENU));
        menuBar.add(editMenu);
        JMenuItem cut = new JMenuItem();
        cut.setAction(this.actionBroker.createAction("cut"));
        cut.setText(Messages.getMessage(Messages.Name.CUT_MENU));
        cut.setAccelerator(KeyStroke.getKeyStroke(88, keyModifier));
        JMenuItem copy = new JMenuItem();
        copy.setAction(this.actionBroker.createAction("copy"));
        copy.setText(Messages.getMessage(Messages.Name.COPY_MENU));
        copy.setAccelerator(KeyStroke.getKeyStroke(67, keyModifier));
        JMenuItem paste = new JMenuItem();
        paste.setAction(this.actionBroker.createAction("paste"));
        paste.setText(Messages.getMessage(Messages.Name.PASTE_MENU));
        paste.setAccelerator(KeyStroke.getKeyStroke(86, keyModifier));
        editMenu.add(cut);
        editMenu.add(copy);
        editMenu.add(paste);
        this.textFieldActions.install(this.getRootPane());
        JMenu viewMenu = this.menuConfiguration.getViewMenu();
        if (viewMenu != null) {
            menuBar.add(viewMenu);
        }
        if ((helpMenu = this.menuConfiguration.getHelpMenu()) != null) {
            menuBar.add(helpMenu);
        }
        this.setJMenuBar(menuBar);
        this.closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (MainFrame.this.saveBeforeClosing()) {
                    MainFrame.this.dispose();
                }
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                if (MainFrame.this.saveBeforeClosing()) {
                    try {
                        MainFrame.this.dispose();
                    }
                    catch (IndexOutOfBoundsException e) {
                        MainFrame.this.dispose();
                    }
                }
            }

            @Override
            public void windowActivated(WindowEvent event) {
                MainFrame.this.publishActions();
                MainFrame.this.otherFileLoader.register();
                MainFrame.this.checkFileModified();
                MainFrame.this.checkUIMode();
            }

            @Override
            public void windowDeactivated(WindowEvent event) {
                MainFrame.this.unpublishActions();
                MainFrame.this.otherFileLoader.unregister();
            }
        });
        this.getRootPane().putClientProperty("Window.documentFile", this.reportSetFile);
    }

    private void checkUIMode() {
        if (this.uiPreferences.uiMode == UIMode.AUTOMATIC) {
            this.uiPreferences.uiMode.apply();
        }
    }

    @Override
    public JPanel navigateTo(String target) {
        JPanel panel = this.injector.getInstance(Key.get(JPanel.class, (Annotation)Names.named(target)));
        if (!this.navigateTo(panel)) {
            return null;
        }
        return panel;
    }

    @Override
    public void complete(ActionEvent evt) {
        if (this.onCompletion != null) {
            this.onCompletion.actionPerformed(evt);
            this.onCompletion = null;
        } else {
            this.navigateTo("main");
        }
    }

    @Override
    public JPanel navigateToAndPush(String target, Action onCompletion) {
        JPanel panel = this.injector.getInstance(Key.get(JPanel.class, (Annotation)Names.named(target)));
        if (!this.navigateTo(panel)) {
            return null;
        }
        this.onCompletion = onCompletion;
        return panel;
    }

    @Override
    public boolean navigateTo(JPanel panel) {
        Component firstComponent;
        if (!this.reportSetSaver.beforeNavigation()) {
            return false;
        }
        this.checkFileModified();
        if (!(this.currentPanel instanceof ShrinkToFit)) {
            this.lastSavedSize = this.getSize();
        }
        this.container.removeAll();
        this.container.add((Component)panel, "Center");
        this.currentPanel = panel;
        this.updateTitle();
        Dimension preferredSize = this.getPreferredSize();
        if (panel instanceof ShrinkToFit) {
            this.setSize(preferredSize);
        } else {
            this.setSize(Math.max(preferredSize.width, this.lastSavedSize.width), Math.max(preferredSize.height, this.lastSavedSize.height));
        }
        UIUtils.keepWindowOnScreen(this);
        this.validate();
        FocusTraversalPolicy traversalPolicy = this.getFocusTraversalPolicy();
        if (traversalPolicy != null && (firstComponent = traversalPolicy.getFirstComponent(panel)) != null) {
            firstComponent.requestFocusInWindow();
        }
        return true;
    }

    @Override
    public void updateTitle() {
        String fileName = this.reportSetFile.getName();
        if (fileName.lastIndexOf(46) > 0) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        Component panel = this.container.getComponent(0);
        String baseTitle = String.format("Scythebill %s - %s", this.versionInfo, fileName);
        String title = panel instanceof Titled ? String.format("%s - %s", baseTitle, ((Titled)((Object)panel)).getTitle()) : baseTitle;
        this.setTitle(title);
    }

    public boolean saveBeforeClosing() {
        if (this.reportSetSaver.getDirty().isDirty()) {
            int option = this.alerts.showConfirm((Object)this, Messages.Name.UNSAVED_CHANGES_TITLE, Messages.Name.UNSAVED_CHANGES_MESSAGE, new Object[0]);
            if (option == 2) {
                return false;
            }
            if (option == 0) {
                try {
                    this.reportSetSaver.save();
                }
                catch (IOException ioe) {
                    FileDialogs.showFileSaveError(this.alerts, ioe, this.reportSetSaver.file());
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void dispose() {
        this.saveIfDirtyFuture.cancel(false);
        this.fontManager.removeListener(this.fontsUpdatedListener);
        super.dispose();
    }

    public ToolbarManager getToolbarManager() {
        return this.toolbar;
    }

    private void layoutToolbar() {
        this.toolbarPanel.removeAll();
        BoxLayout layout = new BoxLayout(this.toolbarPanel, 0);
        this.toolbarPanel.setLayout(layout);
        this.toolbarPanel.add(this.taxonomyChooserPanel);
        this.toolbarPanel.add(Box.createGlue());
        for (JComponent component : this.toolbarComponents) {
            this.toolbarPanel.add(component);
        }
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        this.publishActions();
    }

    private void publishActions() {
        this.actionBroker.publishAction("save", this.saveAction);
        this.actionBroker.publishAction("saveACopyAs", this.saveACopyAsAction);
        this.actionBroker.publishAction("close", this.closeAction);
        this.actionBroker.publishAction("export", this.exportAction);
        this.actionBroker.publishAction("fullExport", this.fullExportAction);
        this.actionBroker.publishAction("import", this.importAction);
        this.actionBroker.publishAction("manageTaxonomies", this.manageTaxonomies);
        this.actionBroker.publishAction("openContaining", this.openContainingAction);
        if (this.taxonomyStore.isBirdTaxonomy()) {
            this.actionBroker.publishAction("importChecklists", this.importChecklistsAction);
            this.actionBroker.publishAction("identifyChecklistErrors", this.identifyChecklistErrorsAction);
            this.actionBroker.publishAction("identifyChecklistRarities", this.identifyChecklistRaritiesAction);
            this.actionBroker.publishAction("recocileAgainstChecklists", this.reconcileAgainstChecklistsAction);
        } else {
            boolean hasChecklists;
            ExtendedTaxonomyChecklists extendedTaxonomyChecklists = this.reportSet.getExtendedTaxonomyChecklist(this.taxonomyStore.getTaxonomy().getId());
            boolean bl = hasChecklists = extendedTaxonomyChecklists != null && extendedTaxonomyChecklists.getChecklists() != null && !extendedTaxonomyChecklists.getChecklists().isEmpty();
            if (hasChecklists) {
                this.actionBroker.publishAction("identifyChecklistErrors", this.identifyChecklistErrorsAction);
                this.actionBroker.publishAction("identifyChecklistRarities", this.identifyChecklistRaritiesAction);
            } else {
                this.actionBroker.unpublishAction("identifyChecklistErrors", this.identifyChecklistErrorsAction);
                this.actionBroker.unpublishAction("identifyChecklistRarities", this.identifyChecklistRaritiesAction);
            }
            this.actionBroker.unpublishAction("recocileAgainstChecklists", this.reconcileAgainstChecklistsAction);
            this.actionBroker.unpublishAction("importChecklists", this.importChecklistsAction);
        }
        this.actionBroker.publishAction("preferences", this.preferencesAction);
    }

    private void unpublishActions() {
        this.actionBroker.unpublishAction("save", this.saveAction);
        this.actionBroker.unpublishAction("saveACopyAs", this.saveACopyAsAction);
        this.actionBroker.unpublishAction("close", this.closeAction);
        this.actionBroker.unpublishAction("export", this.exportAction);
        this.actionBroker.unpublishAction("fullExport", this.fullExportAction);
        this.actionBroker.unpublishAction("import", this.importAction);
        this.actionBroker.unpublishAction("manageTaxonomies", this.manageTaxonomies);
        this.actionBroker.unpublishAction("importChecklists", this.importAction);
        this.actionBroker.unpublishAction("openContaining", this.openContainingAction);
        this.actionBroker.unpublishAction("identifyChecklistErrors", this.identifyChecklistErrorsAction);
        this.actionBroker.unpublishAction("identifyChecklistRarities", this.identifyChecklistRaritiesAction);
        this.actionBroker.unpublishAction("recocileAgainstChecklists", this.reconcileAgainstChecklistsAction);
        this.actionBroker.unpublishAction("preferences", this.preferencesAction);
    }

    private void checkFileModified() {
        if (this.frameRegistry.isLoaded(this.reportSetFile) && this.reportSetSaver.hasBeenModifiedElsewhere() && this.alerts.showYesNo((Object)this, Messages.Name.FILE_HAS_BEEN_MODIFIED_TITLE, this.reportSetSaver.getDirty().isDirty() ? Messages.Name.FILE_HAS_BEEN_MODIFIED_AND_DIRTY_MESSAGE : Messages.Name.FILE_HAS_BEEN_MODIFIED_MESSAGE, HtmlEscapers.htmlEscaper().escape(this.reportSetFile.getName())) == 0) {
            this.frameRegistry.reload(this.reportSetFile, this);
        }
    }

    private class Toolbar
    implements ToolbarManager {
        private Toolbar() {
        }

        @Override
        public void addComponent(final JComponent component, final JComponent listenForRemoval) {
            MainFrame.this.toolbarComponents.add(component);
            final AtomicReference<1> reference = new AtomicReference<1>();
            AncestorListener listener = new AncestorListener(){

                @Override
                public void ancestorRemoved(AncestorEvent e) {
                    MainFrame.this.toolbarComponents.remove(component);
                    MainFrame.this.layoutToolbar();
                    AncestorListener ancestorListener = (AncestorListener)reference.get();
                    if (ancestorListener != null) {
                        listenForRemoval.removeAncestorListener(ancestorListener);
                    }
                }

                @Override
                public void ancestorMoved(AncestorEvent e) {
                }

                @Override
                public void ancestorAdded(AncestorEvent e) {
                }
            };
            reference.set(listener);
            listenForRemoval.addAncestorListener(listener);
            MainFrame.this.layoutToolbar();
        }
    }
}

