/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.query.SyntheticLocations;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.actions.ReturnAction;
import com.scythebill.birdlist.ui.app.Titled;
import com.scythebill.birdlist.ui.components.DepthChooser;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.SpeciesIndexerPanelConfigurer;
import com.scythebill.birdlist.ui.components.TaxonBrowsePanel;
import com.scythebill.birdlist.ui.components.WherePanelIndexers;
import com.scythebill.birdlist.ui.events.DefaultUserChangedEvent;
import com.scythebill.birdlist.ui.events.DefaultUserStore;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.BrowsePreferences;
import com.scythebill.birdlist.ui.panels.ShowSpeciesMap;
import com.scythebill.birdlist.ui.panels.SpeciesInfoDescriber;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import com.scythebill.birdlist.ui.util.EncounteredTaxa;
import com.scythebill.birdlist.ui.util.VisibilityDetector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class MainBrowsePanel
extends JPanel
implements Titled,
FontManager.FontsUpdatedListener {
    private static final int SPECIES_INFO_HEIGHT = 66;
    private static final Logger logger = Logger.getLogger(MainBrowsePanel.class.getName());
    private JButton returnButton;
    private final TaxonBrowsePanel taxonBrowsePanel;
    private final ReportSet reportSet;
    private final Checklists checklists;
    private final ListeningExecutorService executorService;
    private final TaxonomyStore taxonomyStore;
    private final DefaultUserStore defaultUserStore;
    private final FontManager fontManager;
    private final SpeciesIndexerPanelConfigurer speciesIndexerPanelConfigurer;
    private final Alerts alerts;
    private final BrowsePreferences browsePreferences;
    private final SpeciesInfoDescriber speciesInfoDescriber;
    private final ShowSpeciesMap showSpeciesMap;
    private IndexerPanel<String> speciesIndexer;
    private JButton jumpButton;
    private DepthChooser depthChooser;
    private JEditorPane speciesInfo;
    private JScrollPane taxonScrollPane;
    private JScrollPane speciesInfoScrollPane;
    private JSeparator separator;
    private JLabel depthLabel;
    private JButton addSightingButton;
    private JButton removeSightingButton;
    private JCheckBox onlyEncounteredSpecies;
    private JLabel onlySpeciesOnChecklistLabel;
    private IndexerPanel<Object> onlySpeciesOnChecklistIndexer;
    private Predicate<Taxon> taxonFilter;
    private Predicate<String> taxonIdFilter;
    private SyntheticLocations syntheticLocations;
    private PredefinedLocations predefinedLocations;

    @Inject
    public MainBrowsePanel(TaxonBrowsePanel taxonBrowsePanel, ReturnAction returnAction, SpeciesIndexerPanelConfigurer speciesIndexerPanelConfigurer, ReportSet reportSet, Checklists checklists, PredefinedLocations predefinedLocations, TaxonomyStore taxonomyStore, ListeningExecutorService executorService, DefaultUserStore defaultUserStore, BrowsePreferences browsePreferences, SpeciesInfoDescriber speciesInfoDescriber, ShowSpeciesMap showSpeciesMap, FontManager fontManager, EventBusRegistrar eventBusRegistrar, Alerts alerts, VisibilityDetector visibilityDetector) {
        this.taxonBrowsePanel = taxonBrowsePanel;
        this.speciesIndexerPanelConfigurer = speciesIndexerPanelConfigurer;
        this.reportSet = reportSet;
        this.checklists = checklists;
        this.predefinedLocations = predefinedLocations;
        this.taxonomyStore = taxonomyStore;
        this.executorService = executorService;
        this.defaultUserStore = defaultUserStore;
        this.browsePreferences = browsePreferences;
        this.speciesInfoDescriber = speciesInfoDescriber;
        this.showSpeciesMap = showSpeciesMap;
        this.fontManager = fontManager;
        this.alerts = alerts;
        this.syntheticLocations = new SyntheticLocations(reportSet.getLocations());
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.initGUI();
        visibilityDetector.install(this.returnButton);
        this.hookUpContents(returnAction);
    }

    @Override
    public String getTitle() {
        return Messages.getMessage(Messages.Name.BROWSE_BY_SPECIES);
    }

    private void hookUpContents(ReturnAction returnAction) {
        this.returnButton.setAction(returnAction);
        this.taxonBrowsePanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                MainBrowsePanel.this.updateInfoPanels();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MainBrowsePanel.this.updateInfoPanels();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                MainBrowsePanel.this.hideInfoPanels();
            }
        });
        this.speciesIndexer.addPropertyChangeListener("value", evt -> this.jumpButton.setEnabled(evt.getNewValue() != null));
        this.speciesIndexer.addActionListener(e -> this.jumpButton.doClick(100));
        this.jumpButton.addActionListener(e -> {
            this.taxonBrowsePanel.selectTaxon(this.speciesIndexer.getValue());
            this.updateInfoPanelsLater();
        });
        this.depthChooser.addPropertyChangeListener("depth", e -> {
            this.browsePreferences.depth = this.depthChooser.getDepth();
            this.taxonBrowsePanel.setDepth(this.depthChooser.getDepth());
            this.updateTaxonFilter();
        });
        this.taxonBrowsePanel.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath[] selection = MainBrowsePanel.this.taxonBrowsePanel.getSelectionPaths();
                if (selection == null || selection.length != 1) {
                    MainBrowsePanel.this.hideInfoPanels();
                    MainBrowsePanel.this.addSightingButton.setEnabled(false);
                } else {
                    MainBrowsePanel.this.updateInfoPanelsLater();
                    MainBrowsePanel.this.addSightingButton.setEnabled(selection[0].getLastPathComponent() instanceof Species);
                }
                if (selection == null || selection.length == 0) {
                    MainBrowsePanel.this.removeSightingButton.setEnabled(false);
                    MainBrowsePanel.this.removeSightingButton.setText(Messages.getMessage(Messages.Name.REMOVE_SIGHTING));
                } else if (selection.length == 1) {
                    MainBrowsePanel.this.removeSightingButton.setEnabled(selection[0].getLastPathComponent() instanceof Sighting);
                    MainBrowsePanel.this.removeSightingButton.setText(Messages.getMessage(Messages.Name.REMOVE_SIGHTING));
                } else {
                    boolean allAreSightings = true;
                    for (TreePath path : selection) {
                        if (path.getLastPathComponent() instanceof Sighting) continue;
                        allAreSightings = false;
                        break;
                    }
                    MainBrowsePanel.this.removeSightingButton.setEnabled(allAreSightings);
                    MainBrowsePanel.this.removeSightingButton.setText(Messages.getMessage(Messages.Name.REMOVE_SIGHTINGS));
                }
                if (MainBrowsePanel.this.removeSightingButton.isEnabled()) {
                    MainBrowsePanel.this.removeSightingButton.setVisible(true);
                    MainBrowsePanel.this.addSightingButton.setVisible(false);
                } else {
                    MainBrowsePanel.this.addSightingButton.setVisible(true);
                    MainBrowsePanel.this.removeSightingButton.setVisible(false);
                }
            }
        });
        this.taxonBrowsePanel.setDepth(this.browsePreferences.depth == null ? Taxon.Type.species : this.browsePreferences.depth);
        this.addSightingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath[] selection = MainBrowsePanel.this.taxonBrowsePanel.getSelectionPaths();
                if (selection != null && selection.length == 1 && selection[0].getLastPathComponent() instanceof Species) {
                    MainBrowsePanel.this.addSighting(selection[0], (Species)selection[0].getLastPathComponent());
                }
            }
        });
        this.removeSightingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int okCancel = MainBrowsePanel.this.alerts.showOkCancel((Object)MainBrowsePanel.this, MainBrowsePanel.this.taxonBrowsePanel.getSelectionCount() > 1 ? Messages.Name.REMOVE_SIGHTINGS : Messages.Name.REMOVE_SIGHTING, MainBrowsePanel.this.taxonBrowsePanel.getSelectionCount() > 1 ? Messages.Name.REMOVE_SIGHTINGS_CONFIRM : Messages.Name.REMOVE_SIGHTING_CONFIRM, new Object[0]);
                if (okCancel == 0) {
                    MainBrowsePanel.this.taxonBrowsePanel.saveCurrentPreview();
                    MainBrowsePanel.this.taxonBrowsePanel.getCutAction().actionPerformed(e);
                }
            }
        });
        this.speciesInfo.addHyperlinkListener(this::showSpeciesInfoMap);
        this.onlyEncounteredSpecies.addActionListener(e -> {
            this.browsePreferences.onlyEncounteredSpecies = this.onlyEncounteredSpecies.isSelected();
            this.updateTaxonFilter();
        });
        this.onlySpeciesOnChecklistIndexer.addPropertyChangeListener("value", e -> {
            Object value = this.onlySpeciesOnChecklistIndexer.getValue();
            if (value instanceof SyntheticLocation) {
                SyntheticLocation synthetic = (SyntheticLocation)value;
                this.browsePreferences.onlyOnChecklistLocationId = synthetic.getId();
            } else {
                Location location = WherePanelIndexers.toLocation(this.reportSet.getLocations(), value);
                this.browsePreferences.onlyOnChecklistLocationId = location == null ? null : location.getId();
            }
            this.updateTaxonFilter();
        });
    }

    private void showSpeciesInfoMap(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (SpeciesInfoDescriber.isShowMapUrl(event.getURL())) {
                String id = SpeciesInfoDescriber.getShowMapSpeciesId(event.getURL());
                try {
                    this.showSpeciesMap.showRange(this.reportSet, this.taxonomyStore.getTaxonomy(), id);
                }
                catch (IOException e) {
                    this.alerts.showError((Object)this, (Throwable)e, Messages.Name.MAP_FAILED, Messages.Name.COULDNT_WRITE_MAP, new Object[0]);
                }
            } else {
                try {
                    DesktopUtils.openUrlInBrowser(event.getURL().toURI(), this.alerts);
                }
                catch (URISyntaxException e) {
                    logger.log(Level.WARNING, "Couldn't open URL " + event.getURL(), e);
                }
            }
        }
    }

    private void addSighting(TreePath path, Taxon taxon) {
        Sighting.Builder builder = Sighting.newBuilder().setTaxon(taxon);
        switch (taxon.getStatus()) {
            case IN: {
                builder.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.INTRODUCED);
                break;
            }
            case DO: {
                break;
            }
        }
        Sighting sighting = builder.build();
        if (this.defaultUserStore.getUser() != null) {
            sighting.getSightingInfo().setUsers(ImmutableSet.of(this.defaultUserStore.getUser()));
        }
        this.taxonBrowsePanel.addSighting(path, sighting);
        this.taxonBrowsePanel.setSelectionPath(path.pathByAddingChild(sighting));
    }

    private void showInfoPanel(TreePath treePath) {
        this.hideInfoPanels();
        while (treePath.getPathCount() > 1 && !(treePath.getLastPathComponent() instanceof Species)) {
            treePath = treePath.getParentPath();
        }
        if (treePath.getLastPathComponent() instanceof Species) {
            Rectangle bounds = this.taxonBrowsePanel.getPathBounds(treePath);
            if (bounds == null) {
                return;
            }
            Species species = (Species)treePath.getLastPathComponent();
            String info = this.speciesInfoDescriber.toSimpleLinkedHtmlText(this.reportSet, species);
            this.speciesInfo.setText(info);
            this.speciesInfo.select(0, 0);
            this.speciesInfo.setFont(this.fontManager.getTextFont());
            Point rootPoint = SwingUtilities.convertPoint(this.taxonBrowsePanel, bounds.x, this.taxonScrollPane.getHeight() - this.taxonScrollPane.getInsets().bottom, this.getRootPane());
            this.getRootPane().getLayeredPane().add((Component)this.speciesInfoScrollPane, JLayeredPane.POPUP_LAYER);
            this.speciesInfoScrollPane.setBounds(rootPoint.x, rootPoint.y, bounds.width, this.fontManager.scale(66));
            this.speciesInfoScrollPane.setVisible(true);
        }
    }

    private void updateInfoPanelsLater() {
        SwingUtilities.invokeLater(this::updateInfoPanels);
    }

    private void updateInfoPanels() {
        if (this.isDisplayable()) {
            TreePath[] selection = this.taxonBrowsePanel.getSelectionPaths();
            if (selection == null || selection.length != 1) {
                this.hideInfoPanels();
            } else {
                this.showInfoPanel(selection[0]);
            }
        }
    }

    private void hideInfoPanels() {
        if (this.speciesInfoScrollPane.getParent() != null) {
            this.speciesInfoScrollPane.setVisible(false);
            this.speciesInfoScrollPane.getParent().remove(this.speciesInfoScrollPane);
        }
    }

    private void initGUI() {
        this.onlyEncounteredSpecies = new JCheckBox(Messages.getMessage(Messages.Name.ONLY_ENCOUNTERED_SPECIES));
        this.onlyEncounteredSpecies.setSelected(this.browsePreferences.onlyEncounteredSpecies);
        this.onlySpeciesOnChecklistLabel = new JLabel(Messages.getMessage(Messages.Name.ONLY_SPECIES_FOUND_IN));
        this.onlySpeciesOnChecklistIndexer = new IndexerPanel();
        this.onlySpeciesOnChecklistIndexer.setPreviewText(Messages.Name.START_TYPING_A_LOCATION);
        this.taxonBrowsePanel.setStyledSpeciesWithSightings(!this.onlyEncounteredSpecies.isSelected());
        this.defaultUserChanged(null);
        this.returnButton = new JButton();
        this.separator = new JSeparator();
        this.taxonScrollPane = new JScrollPane();
        this.taxonScrollPane.setViewportView(this.taxonBrowsePanel);
        this.speciesIndexer = new IndexerPanel();
        this.jumpButton = new JButton(Messages.getMessage(Messages.Name.JUMP_TO_BUTTON));
        this.jumpButton.putClientProperty("JComponent.sizeVariant", "small");
        this.depthLabel = new JLabel(Messages.getMessage(Messages.Name.SHOW_LABEL));
        this.depthChooser = new DepthChooser();
        this.depthChooser.setDepth(this.browsePreferences.depth);
        this.addSightingButton = new JButton(Messages.getMessage(Messages.Name.ADD_SIGHTING));
        this.addSightingButton.putClientProperty("JComponent.sizeVariant", "small");
        this.removeSightingButton = new JButton(Messages.getMessage(Messages.Name.REMOVE_SIGHTING));
        this.removeSightingButton.putClientProperty("JComponent.sizeVariant", "small");
        this.speciesInfo = new JEditorPane();
        this.speciesInfo.setEditable(false);
        this.speciesInfo.setContentType("text/html");
        this.speciesInfo.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.fontManager.applyTo(this.speciesInfo);
        this.speciesInfoScrollPane = new JScrollPane(this.speciesInfo);
        this.speciesInfoScrollPane.setVerticalScrollBarPolicy(20);
        this.speciesInfoScrollPane.setHorizontalScrollBarPolicy(31);
        this.speciesInfoScrollPane.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        this.taxonomyChanged(null);
        if (this.browsePreferences.onlyOnChecklistLocationId != null) {
            SyntheticLocation syntheticLocation = this.syntheticLocations.byId(this.browsePreferences.onlyOnChecklistLocationId);
            if (syntheticLocation != null) {
                this.onlySpeciesOnChecklistIndexer.setValue(syntheticLocation);
            } else {
                this.onlySpeciesOnChecklistIndexer.setValue(this.browsePreferences.onlyOnChecklistLocationId);
            }
            this.updateTaxonFilter();
        }
        this.fontManager.applyTo(this);
    }

    private void createTaxonFilters() {
        this.taxonFilter = null;
        this.taxonIdFilter = null;
        EncounteredTaxa encounteredTaxa = null;
        if (this.onlyEncounteredSpecies.isSelected() || !this.browsePreferences.showExtinctTaxa) {
            try {
                encounteredTaxa = (EncounteredTaxa)EncounteredTaxa.scan(this.taxonomyStore.getTaxonomy(), this.reportSet, this.executorService).get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.alerts.showError((Object)this, (Throwable)e, "Scanning taxa failed", "Could not scan taxa.", new Object[0]);
            }
        }
        EncounteredTaxa finalEncounteredTaxa = encounteredTaxa;
        if (this.onlyEncounteredSpecies.isSelected() && finalEncounteredTaxa != null) {
            this.taxonFilter = taxon -> {
                if (taxon.getType() == Taxon.Type.subspecies || taxon.getType() == Taxon.Type.group) {
                    return true;
                }
                return finalEncounteredTaxa.isEncountered((Taxon)taxon);
            };
            this.taxonIdFilter = finalEncounteredTaxa::isEncountered;
        }
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        Object locationValue = this.onlySpeciesOnChecklistIndexer.getValue();
        Location location = WherePanelIndexers.toLocation(this.reportSet.getLocations(), locationValue);
        if (location != null && this.onlySpeciesOnChecklistIndexer.isEnabled()) {
            Checklist checklist = this.checklists.getChecklist(this.reportSet, taxonomy, location);
            ImmutableSet.Builder higherLevelTaxaBuilder = ImmutableSet.builder();
            if (checklist != null) {
                for (SightingTaxon taxon2 : checklist.getTaxa(taxonomy)) {
                    Checklist.Status status = checklist.getStatus(taxonomy, taxon2);
                    if (status == Checklist.Status.ESCAPED) continue;
                    SightingTaxon.Resolved resolved = taxon2.resolveInternal(taxonomy);
                    SightingTaxon family = resolved.getParentOfAtLeastType(Taxon.Type.family);
                    SightingTaxon order = resolved.getParentOfAtLeastType(Taxon.Type.order);
                    higherLevelTaxaBuilder.addAll(family.getIds());
                    higherLevelTaxaBuilder.addAll(order.getIds());
                }
                ImmutableCollection higherLevelTaxa = higherLevelTaxaBuilder.build();
                ImmutableSet<Checklist.Status> excludedStatuses = ImmutableSet.of(Checklist.Status.ESCAPED);
                Predicate<Object> checklistTaxonFilter = arg_0 -> MainBrowsePanel.lambda$createTaxonFilters$7((ImmutableSet)higherLevelTaxa, checklist, excludedStatuses, arg_0);
                Predicate<Object> checklistTaxonIdFilter = id -> {
                    Taxon taxon = TaxonUtils.getParentOfType(taxonomy.getTaxon((String)id), Taxon.Type.species);
                    return checklistTaxonFilter.apply(taxon);
                };
                this.taxonFilter = this.taxonFilter == null ? checklistTaxonFilter : Predicates.and(this.taxonFilter, checklistTaxonFilter);
                this.taxonIdFilter = this.taxonIdFilter == null ? checklistTaxonIdFilter : Predicates.and(this.taxonIdFilter, checklistTaxonIdFilter);
            }
        }
        if (this.depthChooser.getDepth() == Taxon.Type.species) {
            Predicate<Object> onlySpeciesFilter = id -> {
                Taxon taxon = taxonomy.getTaxon((String)id);
                if (taxon == null) {
                    return false;
                }
                return taxon.getType() == Taxon.Type.species;
            };
            this.taxonIdFilter = this.taxonIdFilter == null ? onlySpeciesFilter : Predicates.and(this.taxonIdFilter, onlySpeciesFilter);
        }
        if (!this.browsePreferences.showExtinctTaxa) {
            Predicate<Object> noExtinctTaxa = taxon -> {
                if (taxon.getStatus() != Species.Status.EX) {
                    return true;
                }
                return finalEncounteredTaxa != null && finalEncounteredTaxa.isEncountered((Taxon)taxon);
            };
            Predicate<Object> noExtinctTaxonIds = id -> {
                Taxon taxon = taxonomy.getTaxon((String)id);
                if (taxon == null) {
                    return false;
                }
                return noExtinctTaxa.apply(taxon);
            };
            this.taxonIdFilter = this.taxonIdFilter == null ? noExtinctTaxonIds : Predicates.and(this.taxonIdFilter, noExtinctTaxonIds);
            this.taxonFilter = this.taxonFilter == null ? noExtinctTaxa : Predicates.and(this.taxonFilter, noExtinctTaxa);
        }
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        Taxonomy newTaxonomy = this.taxonomyStore.getTaxonomy();
        if (this.taxonBrowsePanel.getTaxonomy() == null || !this.taxonBrowsePanel.getTaxonomy().isBuiltIn() || !newTaxonomy.isBuiltIn()) {
            boolean hasChecklists;
            boolean bl = hasChecklists = newTaxonomy.isBuiltIn() || this.reportSet.hasExtendedTaxonomyChecklists(newTaxonomy.getId());
            if (hasChecklists) {
                this.onlySpeciesOnChecklistLabel.setEnabled(true);
                this.onlySpeciesOnChecklistIndexer.setEnabled(true);
                Object oldLocationValue = this.onlySpeciesOnChecklistIndexer.getValue();
                Location oldLocation = WherePanelIndexers.toLocation(this.reportSet.getLocations(), oldLocationValue);
                this.onlySpeciesOnChecklistIndexer.removeAllIndexerGroups();
                Predicate locationFilter = location -> this.checklists.hasChecklist(this.taxonomyStore.getTaxonomy(), this.reportSet, (Location)location);
                WherePanelIndexers indexers = new WherePanelIndexers(this.reportSet.getLocations(), this.predefinedLocations, false, null, locationFilter, this.syntheticLocations);
                indexers.configureIndexer(this.onlySpeciesOnChecklistIndexer);
                if (oldLocation != null && !this.checklists.hasChecklist(this.taxonomyStore.getTaxonomy(), this.reportSet, oldLocation)) {
                    this.onlySpeciesOnChecklistIndexer.setTextValue("");
                }
            } else {
                this.onlySpeciesOnChecklistLabel.setEnabled(false);
                this.onlySpeciesOnChecklistIndexer.setEnabled(false);
            }
        }
        this.createTaxonFilters();
        this.speciesIndexerPanelConfigurer.configure(this.speciesIndexer, this.taxonomyStore.getTaxonomy());
        this.speciesIndexer.setValue(null);
        this.speciesIndexer.setFilter(this.taxonIdFilter);
        this.taxonBrowsePanel.setTaxonomy(this.taxonomyStore.getTaxonomy(), this.taxonFilter);
    }

    private void updateTaxonFilter() {
        this.createTaxonFilters();
        this.taxonBrowsePanel.setTaxonFilter(this.taxonFilter);
        this.speciesIndexer.setFilter(this.taxonIdFilter);
        this.taxonBrowsePanel.setStyledSpeciesWithSightings(!this.onlyEncounteredSpecies.isSelected());
    }

    @Subscribe
    public void defaultUserChanged(DefaultUserChangedEvent event) {
        this.taxonBrowsePanel.setSightingPredicate(this.defaultUserStore.getUser() != null ? SightingPredicates.includesUser(this.defaultUserStore.getUser()) : Predicates.alwaysTrue());
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        Dimension size = fontManager.scale(new Dimension(1200, 800));
        size.height = Math.max(size.height, 730);
        this.setPreferredSize(size);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createBaselineGroup(false, false).addComponent(this.speciesIndexer).addComponent(this.jumpButton).addComponent(this.depthLabel).addComponent(this.depthChooser).addComponent(this.onlyEncounteredSpecies).addComponent(this.onlySpeciesOnChecklistLabel).addComponent(this.onlySpeciesOnChecklistIndexer)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.taxonScrollPane, fontManager.scale(200), fontManager.scale(400), Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGap(fontManager.scale(66), fontManager.scale(66), fontManager.scale(66)).addComponent(this.separator, -2, -2, -2).addGap(0, 17, -2).addGroup(layout.createBaselineGroup(false, false).addComponent(this.addSightingButton).addComponent(this.removeSightingButton).addComponent(this.returnButton, -2, -2, -2)).addContainerGap());
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.speciesIndexer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jumpButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.depthLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.depthChooser, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.onlySpeciesOnChecklistLabel, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.onlySpeciesOnChecklistIndexer, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.onlyEncounteredSpecies, -2, -2, -2)).addComponent(this.separator, GroupLayout.Alignment.LEADING, 0, fontManager.scale(376), Short.MAX_VALUE).addComponent(this.taxonScrollPane, GroupLayout.Alignment.LEADING, fontManager.scale(400), fontManager.scale(700), Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.addSightingButton).addComponent(this.removeSightingButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.returnButton, -2, -2, -2))).addContainerGap());
        this.updateInfoPanelsLater();
    }

    private static /* synthetic */ boolean lambda$createTaxonFilters$7(ImmutableSet higherLevelTaxa, Checklist checklist, ImmutableSet excludedStatuses, Taxon taxon) {
        if (taxon.getType() == Taxon.Type.order || taxon.getType() == Taxon.Type.family) {
            return higherLevelTaxa.contains(taxon.getId());
        }
        if (taxon.getType() != Taxon.Type.species) {
            return true;
        }
        return checklist.includesTaxon(taxon, excludedStatuses);
    }
}

