/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.annotations.Preference;
import com.scythebill.birdlist.model.annotations.SerializeAsJson;
import java.awt.Point;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileSystemView;

public class FilePreferences {
    @Preference
    public String lastLoadedReportSet;
    @Preference
    public String lastViewedDirectory = FilePreferences.defaultDirectory();
    @Preference
    public String lastSavedDirectory = null;
    @SerializeAsJson
    @Preference
    public List<String> lastLoadedReportSets = Lists.newArrayList();
    @SerializeAsJson
    @Preference
    public LinkedHashMap<String, Point> fileOrigins = new LinkedHashMap();

    public List<String> getLastLoadedReportSets() {
        if (this.lastLoadedReportSets.isEmpty() && !Strings.isNullOrEmpty(this.lastLoadedReportSet)) {
            return ImmutableList.of(this.lastLoadedReportSet);
        }
        return ImmutableList.copyOf(this.lastLoadedReportSets);
    }

    public void clearLastLoadedReportSets() {
        this.lastLoadedReportSet = null;
        this.lastLoadedReportSets.clear();
    }

    public void rememberFile(File file, FileType fileType) {
        if (file.isDirectory()) {
            if (fileType == FileType.SIGHTINGS) {
                this.lastViewedDirectory = file.getAbsolutePath();
            } else {
                this.lastSavedDirectory = file.getAbsolutePath();
            }
        } else if (fileType == FileType.SIGHTINGS) {
            this.lastViewedDirectory = file.getParentFile().getAbsolutePath();
        } else {
            this.lastSavedDirectory = file.getParentFile().getAbsolutePath();
        }
    }

    public void setLocation(File file, Point point) {
        String path = file.getAbsolutePath();
        LinkedHashMap<String, Point> updated = new LinkedHashMap<String, Point>();
        updated.put(path, point);
        for (Map.Entry<String, Point> entry : this.fileOrigins.entrySet()) {
            if (updated.size() >= 5 || updated.containsKey(entry.getKey())) continue;
            updated.put(entry.getKey(), entry.getValue());
        }
        this.fileOrigins = updated;
    }

    public Point getLocation(File file) {
        return this.fileOrigins.get(file.getAbsolutePath());
    }

    public File getLastDirectory(FileType fileType) {
        if (fileType == FileType.SIGHTINGS) {
            return this.getLastDirectory(this.lastViewedDirectory);
        }
        File directory = this.getLastDirectory(this.lastSavedDirectory);
        if (directory == null) {
            directory = this.getLastDirectory(this.lastViewedDirectory);
        }
        return directory;
    }

    private File getLastDirectory(String preference) {
        File directory;
        if (preference == null) {
            return null;
        }
        for (directory = new File(preference); directory != null && !directory.exists(); directory = directory.getParentFile()) {
        }
        return directory;
    }

    public void setLastLoadedReportSets(Collection<String> reportSetFiles) {
        this.lastLoadedReportSets.clear();
        this.lastLoadedReportSets.addAll(reportSetFiles);
        this.lastLoadedReportSet = null;
    }

    private static String defaultDirectory() {
        try {
            String userHome;
            File file = FileSystemView.getFileSystemView().getDefaultDirectory();
            if (!(file != null && file.exists() || (userHome = System.getProperty("user.home")) == null)) {
                file = new File(userHome);
            }
            if (file != null) {
                if (!file.getName().contains("Documents") && file.exists() && file.isDirectory()) {
                    ImmutableList<String> possibleChildFolders = ImmutableList.of("My Documents", "Documents");
                    for (String possibleChildFolder : possibleChildFolders) {
                        File childFile = new File(file, possibleChildFolder);
                        if (!childFile.exists() || !childFile.isDirectory()) continue;
                        return childFile.getAbsolutePath();
                    }
                }
                return file.getAbsolutePath();
            }
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.WARNING, "Couldn't get default directory", e);
        }
        return null;
    }

    public static enum FileType {
        SIGHTINGS,
        BACKUPS,
        OTHER;

    }
}

