/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.panels;

import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.app.FrameRegistry;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.guice.Clements;
import com.scythebill.birdlist.ui.guice.CurrentVersion;
import com.scythebill.birdlist.ui.guice.IOC;
import com.scythebill.birdlist.ui.guice.Scythebill;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;

@Singleton
public class AboutFrame {
    private static final int FRAME_WIDTH = 400;
    private static final int FRAME_HEIGHT = 350;
    private JFrame aboutFrame;
    private JLabel clementsLabel;
    private JLabel iocLabel;
    private final Supplier<Taxonomy> taxonomySupplier;
    private final Supplier<Taxonomy> iocSupplier;
    private JLabel taxonomyCreditLabel;
    private final String versionInfo;
    private final Icon applicationIcon;
    private final FrameRegistry frameRegistry;
    private JScrollPane additionalCreditScrollPane;
    private static String CORNELL_CREDIT = "eBird/Clements Checklist is \u00a9 Cornell Lab of Ornithology.";

    @Inject
    public AboutFrame(@Clements Supplier<Taxonomy> taxonomySupplier, @IOC Supplier<Taxonomy> iocSupplier, @Scythebill Icon applicationIcon, @Nullable @CurrentVersion String versionInfo, FrameRegistry frameRegistry) {
        this.taxonomySupplier = taxonomySupplier;
        this.iocSupplier = iocSupplier;
        this.applicationIcon = applicationIcon;
        this.versionInfo = versionInfo;
        this.frameRegistry = frameRegistry;
    }

    public void show() {
        this.aboutFrame = this.createAboutFrame();
        this.setTaxonomyLabelText();
        this.aboutFrame.setVisible(true);
        this.aboutFrame.toFront();
    }

    private JFrame createAboutFrame() {
        JFrame frame = new JFrame();
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        Taxonomy taxonomy = this.taxonomySupplier.get();
        Rectangle screenBounds = frame.getGraphicsConfiguration().getBounds();
        frame.setLocation(screenBounds.x + (screenBounds.width - 400) / 2, screenBounds.y + (screenBounds.height - 300) / 2);
        Container contentPane = frame.getRootPane().getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        JPanel centerBox = new JPanel();
        centerBox.setBorder(new EmptyBorder(4, 4, 4, 4));
        contentPane.add(centerBox);
        GroupLayout layout = new GroupLayout(centerBox);
        centerBox.setLayout(layout);
        JLabel image = new JLabel(this.applicationIcon);
        JLabel appName = new JLabel("Scythebill Birdlist");
        appName.setFont(new Font(FontManager.getFontName(), 1, 13));
        String versionText = this.versionInfo == null ? "(unavailable)" : this.versionInfo;
        JLabel version = new JLabel(Messages.getFormattedMessage(Messages.Name.VERSION_FORMAT, versionText));
        this.clementsLabel = new JLabel();
        this.iocLabel = new JLabel();
        this.taxonomyCreditLabel = new JLabel();
        ArrayList<String> additionalCredits = new ArrayList<String>();
        if (taxonomy != null) {
            additionalCredits.addAll(taxonomy.additionalCredits());
        }
        additionalCredits.add(Messages.getMessage(Messages.Name.SCYTHEBILL_IMAGE_COPYRIGHT));
        additionalCredits.add("");
        HashSet<String> extendedTaxonomyIds = Sets.newHashSet();
        for (ReportSet reportSet : this.frameRegistry.loadedReportSets()) {
            for (Taxonomy extendedTaxonomy : reportSet.extendedTaxonomies()) {
                if (!extendedTaxonomyIds.add(extendedTaxonomy.getId())) continue;
                additionalCredits.add(extendedTaxonomy.getName());
                additionalCredits.addAll(extendedTaxonomy.additionalCredits());
                additionalCredits.add("");
            }
        }
        additionalCredits.add(String.format("Java %s", System.getProperty("java.version")));
        JTextArea additionalCreditTextArea = new JTextArea(4, 30);
        additionalCreditTextArea.setText(additionalCredits.stream().collect(Collectors.joining("\n")));
        additionalCreditTextArea.select(0, 0);
        this.additionalCreditScrollPane = new JScrollPane(additionalCreditTextArea);
        frame.setSize(new Dimension(400, 350));
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(image).addComponent(appName).addComponent(version).addComponent(this.clementsLabel).addComponent(this.taxonomyCreditLabel).addComponent(this.iocLabel).addComponent(this.additionalCreditScrollPane, -2, -2, Short.MAX_VALUE);
        layout.setHorizontalGroup(horizontalGroup);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addComponent(image).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(appName).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(version).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clementsLabel).addComponent(this.taxonomyCreditLabel).addComponent(this.iocLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.additionalCreditScrollPane);
        layout.setVerticalGroup(verticalGroup);
        return frame;
    }

    private void setTaxonomyLabelText() {
        Taxonomy ioc;
        Taxonomy taxonomy = this.taxonomySupplier.get();
        String clementsText = null;
        if (taxonomy == null) {
            clementsText = "loading...";
        } else if (this.clementsLabel != null) {
            String string = clementsText = taxonomy.getName() == null ? "Unknown" : taxonomy.getName();
            if (taxonomy.getId() != null && taxonomy.getId().toLowerCase().contains("clements")) {
                this.taxonomyCreditLabel.setText(CORNELL_CREDIT);
            }
        }
        if (clementsText != null) {
            this.clementsLabel.setText(Messages.getFormattedMessage(Messages.Name.TAXONOMY_WITH_NAME, clementsText));
        }
        if ((ioc = this.iocSupplier.get()) != null) {
            this.iocLabel.setText(ioc.getName());
        }
    }
}

