/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.messages;

import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.util.LocalePreferences;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.function.Function;

public class Messages {
    public static String getMessage(Name name) {
        return ResourceBundle.getBundle("com.scythebill.birdlist.ui.messages.messages", LocalePreferences.instance().getUiLocale()).getString(name.name());
    }

    public static String getFormattedMessage(Name name, Object ... args) {
        return String.format(Messages.getMessage(name), args);
    }

    public static String getText(SightingInfo.SightingStatus status) {
        return Messages.getMessage(switch (status) {
            case SightingInfo.SightingStatus.DEAD -> Name.SIGHTING_STATUS_DEAD;
            case SightingInfo.SightingStatus.DOMESTIC -> Name.SIGHTING_STATUS_DOMESTIC;
            case SightingInfo.SightingStatus.ID_UNCERTAIN -> Name.SIGHTING_STATUS_ID_UNCERTAIN;
            case SightingInfo.SightingStatus.INTRODUCED -> Name.SIGHTING_STATUS_INTRODUCED;
            case SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED -> Name.SIGHTING_STATUS_INTRODUCED_NOT_ESTABLISHED;
            case SightingInfo.SightingStatus.NONE -> Name.SIGHTING_STATUS_NONE;
            case SightingInfo.SightingStatus.NOT_BY_ME -> Name.SIGHTING_STATUS_NOT_BY_ME;
            case SightingInfo.SightingStatus.BETTER_VIEW_DESIRED -> Name.SIGHTING_STATUS_BETTER_VIEW_DESIRED;
            case SightingInfo.SightingStatus.UNSATISFACTORY_VIEWS -> Name.SIGHTING_STATUS_UNSATISFACTORY_VIEWS;
            case SightingInfo.SightingStatus.RECORD_NOT_ACCEPTED -> Name.SIGHTING_STATUS_RECORD_NOT_ACCEPTED;
            case SightingInfo.SightingStatus.SIGNS -> Name.SIGHTING_STATUS_SIGNS;
            case SightingInfo.SightingStatus.RESTRAINED -> Name.SIGHTING_STATUS_RESTRAINED;
            default -> throw new AssertionError((Object)("No translation for " + status));
        });
    }

    public static String getText(SightingInfo.BreedingBirdCode code) {
        Name name = Messages.getName(code);
        return Messages.getMessage(name);
    }

    public static Name getName(SightingInfo.BreedingBirdCode code) {
        return switch (code) {
            case SightingInfo.BreedingBirdCode.AGITATED_BEHAVIOR -> Name.BREEDING_BIRD_CODE_AGITATED_BEHAVIOR;
            case SightingInfo.BreedingBirdCode.CARRYING_FECAL_SAC -> Name.BREEDING_BIRD_CODE_CARRYING_FECAL_SAC;
            case SightingInfo.BreedingBirdCode.CARRYING_FOOD -> Name.BREEDING_BIRD_CODE_CARRYING_FOOD;
            case SightingInfo.BreedingBirdCode.CARRYING_NESTING_MATERIAL -> Name.BREEDING_BIRD_CODE_CARRYING_NESTING_MATERIAL;
            case SightingInfo.BreedingBirdCode.COURTSHIP_DISPLAY_OR_COPULATION -> Name.BREEDING_BIRD_CODE_COURTSHIP_DISPLAY_OR_COPULATION;
            case SightingInfo.BreedingBirdCode.DISTRACTION_DISPLAY -> Name.BREEDING_BIRD_CODE_DISTRACTION_DISPLAY;
            case SightingInfo.BreedingBirdCode.FEEDING_YOUNG -> Name.BREEDING_BIRD_CODE_FEEDING_YOUNG;
            case SightingInfo.BreedingBirdCode.FLYOVER -> Name.BREEDING_BIRD_CODE_FLYOVER;
            case SightingInfo.BreedingBirdCode.IN_APPROPRIATE_HABITAT -> Name.BREEDING_BIRD_CODE_IN_APPROPRIATE_HABITAT;
            case SightingInfo.BreedingBirdCode.MULTIPLE_SINGING_BIRDS -> Name.BREEDING_BIRD_CODE_MULTIPLE_SINGING_BIRDS;
            case SightingInfo.BreedingBirdCode.NEST_BUILDING -> Name.BREEDING_BIRD_CODE_NEST_BUILDING;
            case SightingInfo.BreedingBirdCode.NEST_WITH_EGGS -> Name.BREEDING_BIRD_CODE_NEST_WITH_EGGS;
            case SightingInfo.BreedingBirdCode.NEST_WITH_YOUNG -> Name.BREEDING_BIRD_CODE_NEST_WITH_YOUNG;
            case SightingInfo.BreedingBirdCode.NONE -> Name.BREEDING_BIRD_CODE_NONE;
            case SightingInfo.BreedingBirdCode.OCCUPIED_NEST -> Name.BREEDING_BIRD_CODE_OCCUPIED_NEST;
            case SightingInfo.BreedingBirdCode.PAIR_IN_SUITABLE_HABITAT -> Name.BREEDING_BIRD_CODE_PAIR_IN_SUITABLE_HABITAT;
            case SightingInfo.BreedingBirdCode.PHYSIOLOGICAL_EVIDENCE -> Name.BREEDING_BIRD_CODE_PHYSIOLOGICAL_EVIDENCE;
            case SightingInfo.BreedingBirdCode.RECENTLY_FLEDGED -> Name.BREEDING_BIRD_CODE_RECENTLY_FLEDGED;
            case SightingInfo.BreedingBirdCode.SINGING_BIRD -> Name.BREEDING_BIRD_CODE_SINGING_BIRD;
            case SightingInfo.BreedingBirdCode.SINGING_BIRD_7_DAYS -> Name.BREEDING_BIRD_CODE_SINGING_BIRD_7_DAYS;
            case SightingInfo.BreedingBirdCode.TERRITORIAL_DEFENSE -> Name.BREEDING_BIRD_CODE_TERRITORIAL_DEFENSE;
            case SightingInfo.BreedingBirdCode.USED_NEST -> Name.BREEDING_BIRD_CODE_USED_NEST;
            case SightingInfo.BreedingBirdCode.VISITING_PROBABLE_NEST_SITE -> Name.BREEDING_BIRD_CODE_VISITING_PROBABLE_NEST_SITE;
            case SightingInfo.BreedingBirdCode.WOODPECKER_WREN_NEST_BUILDING -> Name.BREEDING_BIRD_CODE_WOODPECKER_WREN_NEST_BUILDING;
            default -> throw new AssertionError((Object)("No translation for " + code));
        };
    }

    public static String getDescription(SightingInfo.BreedingBirdCode code) {
        Name name;
        switch (code) {
            case AGITATED_BEHAVIOR: {
                name = Name.BREEDING_BIRD_CODE_AGITATED_BEHAVIOR_DESCRIPTION;
                break;
            }
            case CARRYING_FECAL_SAC: {
                name = Name.BREEDING_BIRD_CODE_CARRYING_FECAL_SAC_DESCRIPTION;
                break;
            }
            case CARRYING_FOOD: {
                name = Name.BREEDING_BIRD_CODE_CARRYING_FOOD_DESCRIPTION;
                break;
            }
            case CARRYING_NESTING_MATERIAL: {
                name = Name.BREEDING_BIRD_CODE_CARRYING_NESTING_MATERIAL_DESCRIPTION;
                break;
            }
            case COURTSHIP_DISPLAY_OR_COPULATION: {
                name = Name.BREEDING_BIRD_CODE_COURTSHIP_DISPLAY_OR_COPULATION_DESCRIPTION;
                break;
            }
            case DISTRACTION_DISPLAY: {
                name = Name.BREEDING_BIRD_CODE_DISTRACTION_DISPLAY_DESCRIPTION;
                break;
            }
            case FEEDING_YOUNG: {
                name = Name.BREEDING_BIRD_CODE_FEEDING_YOUNG_DESCRIPTION;
                break;
            }
            case FLYOVER: {
                name = Name.BREEDING_BIRD_CODE_FLYOVER_DESCRIPTION;
                break;
            }
            case IN_APPROPRIATE_HABITAT: {
                name = Name.BREEDING_BIRD_CODE_IN_APPROPRIATE_HABITAT_DESCRIPTION;
                break;
            }
            case MULTIPLE_SINGING_BIRDS: {
                name = Name.BREEDING_BIRD_CODE_MULTIPLE_SINGING_BIRDS_DESCRIPTION;
                break;
            }
            case NEST_BUILDING: {
                name = Name.BREEDING_BIRD_CODE_NEST_BUILDING_DESCRIPTION;
                break;
            }
            case NEST_WITH_EGGS: {
                name = Name.BREEDING_BIRD_CODE_NEST_WITH_EGGS_DESCRIPTION;
                break;
            }
            case NEST_WITH_YOUNG: {
                name = Name.BREEDING_BIRD_CODE_NEST_WITH_YOUNG_DESCRIPTION;
                break;
            }
            case NONE: {
                return "";
            }
            case OCCUPIED_NEST: {
                name = Name.BREEDING_BIRD_CODE_OCCUPIED_NEST_DESCRIPTION;
                break;
            }
            case PAIR_IN_SUITABLE_HABITAT: {
                name = Name.BREEDING_BIRD_CODE_PAIR_IN_SUITABLE_HABITAT_DESCRIPTION;
                break;
            }
            case PHYSIOLOGICAL_EVIDENCE: {
                name = Name.BREEDING_BIRD_CODE_PHYSIOLOGICAL_EVIDENCE_DESCRIPTION;
                break;
            }
            case RECENTLY_FLEDGED: {
                name = Name.BREEDING_BIRD_CODE_RECENTLY_FLEDGED_DESCRIPTION;
                break;
            }
            case SINGING_BIRD: {
                name = Name.BREEDING_BIRD_CODE_SINGING_BIRD_DESCRIPTION;
                break;
            }
            case SINGING_BIRD_7_DAYS: {
                name = Name.BREEDING_BIRD_CODE_SINGING_BIRD_7_DAYS_DESCRIPTION;
                break;
            }
            case TERRITORIAL_DEFENSE: {
                name = Name.BREEDING_BIRD_CODE_TERRITORIAL_DEFENSE_DESCRIPTION;
                break;
            }
            case USED_NEST: {
                name = Name.BREEDING_BIRD_CODE_USED_NEST_DESCRIPTION;
                break;
            }
            case VISITING_PROBABLE_NEST_SITE: {
                name = Name.BREEDING_BIRD_CODE_VISITING_PROBABLE_NEST_SITE_DESCRIPTION;
                break;
            }
            case WOODPECKER_WREN_NEST_BUILDING: {
                name = Name.BREEDING_BIRD_CODE_WOODPECKER_WREN_NEST_BUILDING_DESCRIPTION;
                break;
            }
            default: {
                throw new AssertionError((Object)("No translation for " + code));
            }
        }
        return Messages.getMessage(name);
    }

    public static String getText(VisitInfo.ObservationType observationType) {
        return Messages.getMessage(switch (observationType) {
            case VisitInfo.ObservationType.AREA -> Name.VISIT_INFO_AREA;
            case VisitInfo.ObservationType.BANDING -> Name.VISIT_INFO_BANDING;
            case VisitInfo.ObservationType.HISTORICAL -> Name.VISIT_INFO_HISTORICAL;
            case VisitInfo.ObservationType.INCIDENTAL -> Name.VISIT_INFO_INCIDENTAL;
            case VisitInfo.ObservationType.NOCTURNAL_BIRDING -> Name.VISIT_INFO_NOCTURNAL_BIRDING;
            case VisitInfo.ObservationType.NOCTURNAL_FLIGHT_CALL_COUNT -> Name.VISIT_INFO_NOCTURNAL_FLIGHT_CALL_COUNT;
            case VisitInfo.ObservationType.PELAGIC_PROTOCOL -> Name.VISIT_INFO_PELAGIC_PROTOCOL;
            case VisitInfo.ObservationType.RANDOM -> Name.VISIT_INFO_RANDOM;
            case VisitInfo.ObservationType.STATIONARY -> Name.VISIT_INFO_STATIONARY;
            case VisitInfo.ObservationType.TRAVELING -> Name.VISIT_INFO_TRAVELING;
            default -> throw new AssertionError((Object)("No translation for " + observationType));
        });
    }

    public static String getDescription(VisitInfo.ObservationType observationType) {
        return Messages.getMessage(switch (observationType) {
            case VisitInfo.ObservationType.AREA -> Name.VISIT_INFO_AREA_DESCRIPTION;
            case VisitInfo.ObservationType.BANDING -> Name.VISIT_INFO_BANDING_DESCRIPTION;
            case VisitInfo.ObservationType.HISTORICAL -> Name.VISIT_INFO_HISTORICAL_DESCRIPTION;
            case VisitInfo.ObservationType.INCIDENTAL -> Name.VISIT_INFO_INCIDENTAL_DESCRIPTION;
            case VisitInfo.ObservationType.NOCTURNAL_BIRDING -> Name.VISIT_INFO_NOCTURNAL_BIRDING_DESCRIPTION;
            case VisitInfo.ObservationType.NOCTURNAL_FLIGHT_CALL_COUNT -> Name.VISIT_INFO_NOCTURNAL_FLIGHT_CALL_COUNT_DESCRIPTION;
            case VisitInfo.ObservationType.PELAGIC_PROTOCOL -> Name.VISIT_INFO_PELAGIC_PROTOCOL_DESCRIPTION;
            case VisitInfo.ObservationType.RANDOM -> Name.VISIT_INFO_RANDOM_DESCRIPTION;
            case VisitInfo.ObservationType.STATIONARY -> Name.VISIT_INFO_STATIONARY_DESCRIPTION;
            case VisitInfo.ObservationType.TRAVELING -> Name.VISIT_INFO_TRAVELING_DESCRIPTION;
            default -> throw new AssertionError((Object)("No translation for " + observationType));
        });
    }

    public static String getText(Location.Type type) {
        return Messages.getMessage(switch (type) {
            case Location.Type.city -> Name.LOCATION_TYPE_CITY;
            case Location.Type.country -> Name.LOCATION_TYPE_COUNTRY;
            case Location.Type.county -> Name.LOCATION_TYPE_COUNTY;
            case Location.Type.park -> Name.LOCATION_TYPE_PARK;
            case Location.Type.region -> Name.LOCATION_TYPE_REGION;
            case Location.Type.state -> Name.LOCATION_TYPE_STATE;
            case Location.Type.town -> Name.LOCATION_TYPE_TOWN;
            default -> throw new AssertionError((Object)("No translation for " + type));
        });
    }

    public static String getText(Species.Status status) {
        return Messages.getMessage(switch (status) {
            case Species.Status.CR -> Name.STATUS_CR;
            case Species.Status.DD -> Name.STATUS_DD;
            case Species.Status.DO -> Name.STATUS_DO;
            case Species.Status.EN -> Name.STATUS_EN;
            case Species.Status.EW -> Name.STATUS_EW;
            case Species.Status.EX -> Name.STATUS_EX;
            case Species.Status.IN -> Name.STATUS_IN;
            case Species.Status.LC -> Name.STATUS_LC;
            case Species.Status.NE -> Name.STATUS_NE;
            case Species.Status.NT -> Name.STATUS_NT;
            case Species.Status.UN -> Name.STATUS_UN;
            case Species.Status.VU -> Name.STATUS_VU;
            default -> throw new AssertionError((Object)("No translation for " + status));
        });
    }

    public static String getText(Checklist.Status checklistStatus) {
        return Messages.getMessage(switch (checklistStatus) {
            case Checklist.Status.NATIVE -> Name.CHECKLIST_STATUS_REGULAR;
            case Checklist.Status.ENDEMIC -> Name.CHECKLIST_STATUS_ENDEMIC;
            case Checklist.Status.EXTINCT -> Name.CHECKLIST_STATUS_EXTINCT;
            case Checklist.Status.INTRODUCED -> Name.CHECKLIST_STATUS_INTRODUCED;
            case Checklist.Status.RARITY -> Name.CHECKLIST_STATUS_RARITY;
            case Checklist.Status.RARITY_FROM_INTRODUCED -> Name.CHECKLIST_STATUS_RARITY_FROM_INTRODUCED;
            case Checklist.Status.ESCAPED -> Name.CHECKLIST_STATUS_NOT_ESTABLISHED;
            default -> throw new AssertionError((Object)("No translation for " + checklistStatus));
        });
    }

    public static <T> String join(Collection<T> collection, Function<T, String> toString) {
        switch (collection.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return toString.apply(collection.iterator().next());
            }
            case 2: {
                Iterator<T> iterator = collection.iterator();
                return Messages.getFormattedMessage(Name.A_AND_B, toString.apply(iterator.next()), toString.apply(iterator.next()));
            }
        }
        String message = null;
        int i = 0;
        for (T t : collection) {
            String current = toString.apply(t);
            message = i == 0 ? current : (i == collection.size() - 1 ? Messages.getFormattedMessage(Name.A_COMMA_AND_B, message, current) : Messages.getFormattedMessage(Name.A_COMMA_B, message, current));
            ++i;
        }
        return message;
    }

    public static enum Name {
        CANT_FIND_BSXM_FILE_TITLE,
        CANT_FIND_BSXM_FILES_TITLE,
        CANT_FIND_BSXM_FILE_MESSAGE,
        CANT_FIND_BSXM_FILES_MESSAGE,
        PLEASE_SEARCH_FOR_BSXM_FILE,
        PLEASE_SEARCH_FOR_BSXM_FILES,
        FILE_IN_DIRECTORY,
        QUIT_MENU,
        HELP_MENU,
        FILE_MENU,
        NEW_SIGHTINGS_FILE_MENU,
        OPEN_SIGHTINGS_FILE_MENU,
        NEW_MENU,
        CLOSE_MENU,
        SAVE_MENU,
        SAVE_A_COPY_AS,
        IMPORT_SIGHTINGS,
        IMPORT_SIGHTINGS_MENU,
        MANAGE_TAXONOMIES,
        MANAGE_TAXONOMIES_EXPLANATION,
        MANAGE_TAXONOMIES_MENU,
        OPEN_CONTAINING_FOLDER,
        IMPORT_CHECKLISTS_MENU,
        VERIFY_AGAINST_CHECKLISTS,
        FIND_CHECKLIST_RARITIES,
        RECONCILE_AGAINST_CHECKLISTS,
        NO_RECONCILED_SPS_TITLE,
        NO_RECONCILED_SPS_MESSAGE,
        SIGHTING_CAN_BE_RESOLVED,
        SIGHTINGS_CAN_BE_RESOLVED,
        SIGHTING_CAN_BE_PARTIALLY_RESOLVED,
        SIGHTINGS_CAN_BE_PARTIALLY_RESOLVED,
        SIGHTINGS_CAN_BE_FULLY_AND_PARTIALLY_RESOLVED,
        SIGHTING_CAN_BE_RESOLVED_USING_RARITIES,
        SIGHTINGS_CAN_BE_RESOLVED_USING_RARITIES,
        SIGHTING_CAN_BE_PARTIALLY_RESOLVED_USING_RARITIES,
        SIGHTINGS_CAN_BE_PARTIALLY_RESOLVED_USING_RARITIES,
        SIGHTINGS_CAN_BE_FULLY_AND_PARTIALLY_RESOLVED_USING_RARITIES,
        USE_RARITIES_BUTTON,
        DONT_USE_RARITIES_BUTTON,
        WILL_BECOME_FORMAT,
        RESULTS_TITLE,
        PRINT_MENU,
        VIEW_MENU,
        ABOUT_SCYTHEBILL,
        SCYTHEBILL_MANUAL,
        SCYTHEBILL_EMAIL_GROUP,
        DOWNLOAD_LATEST,
        REPORT_ISSUE,
        OPEN_SOURCE_LICENSES,
        EXPORT_MENU,
        PICK_FILE_TITLE,
        CSV_FILES,
        NO_ISSUES_FOUND,
        ALL_SIGHTINGS_CONFORM,
        CHECKLIST_ISSUES,
        CHECKLIST_ISSUES_DESCRIPTION,
        NO_RARITIES_FOUND,
        NO_SIGHTINGS_ARE_RARITIES,
        CHECKLIST_RARITIES_TITLE,
        CHECKLIST_RARITIES_DESCRIPTION,
        TAXONOMY_WITH_NAME,
        SCYTHEBILL_VERSION,
        CUSTOM_CHECKLIST_FORMAT,
        EXPECTED_RANGE_FORMAT,
        IMPORT_CHECKLISTS_TITLE,
        SCYTHEBILL_CHECKLISTS,
        COULDNT_READ_CHECKLIST,
        NOT_VALID_CHECKLIST_FORMAT,
        CHECKLIST_TAXONOMY_OBSOLETE,
        OVERWRITE_SINGLE_CHECKLIST,
        OVERWRITE_MULTIPLE_CHECKLISTS,
        OVERWRITE_SOME_CHECKLISTS,
        OVERWRITE_CHECKLISTS_TITLE,
        ADDED_CHECKLIST_TITLE,
        ADDED_CHECKLIST_FORMAT,
        ADDED_CHECKLISTS_TITLE,
        ADDED_CHECKLISTS_FORMAT,
        NEW_LIST_TITLE,
        FILE_ALREADY_EXISTS_TITLE,
        FILE_ALREADY_EXISTS_FORMAT,
        COPY_OF_FORMAT,
        COULD_NOT_SAVE_TITLE,
        COULD_NOT_SAVE_FORMAT,
        COULD_NOT_CREATE_TITLE,
        ERROR_OCCURRED_TRY_AGAIN,
        OPEN_LIST_TITLE,
        SCYTHEBILL_LISTFILES,
        SCYTHEBILL_COULD_NOT_BE_BUILT,
        RETURN_TO_MAIN_MENU,
        SAVING_FAILED_TITLE,
        WINDOWS_PERMISSION_MESSAGE,
        FEEDBACK_IS_IN_CLIPBOARD,
        PICK_A_NEW_LOCATION,
        SAVING_FILES_NOT_RECOMMENDED_FORMAT,
        OPENING_FILES_IN_ZIP_WARNING,
        NEW_LOCATION,
        EDIT_LOCATION,
        USING_OLD_VERSION_TITLE,
        USING_OLD_VERSION_FORMAT,
        BAD_FILE_TITLE,
        BAD_FILE_FORMAT,
        IO_EXCEPTION_TITLE,
        IO_EXCEPTION_FORMAT,
        CORRUPTED_LOCATIONS_TITLE,
        CORRUPTED_LOCATIONS_FORMAT,
        BACKUP_NEVER,
        BACKUP_OBSESSIVELY,
        BACKUP_WEEKLY,
        BACKUP_MONTHLY,
        ERROR_BACKING_UP_TITLE,
        ERROR_BACKING_UP_FORMAT,
        BACKUP_DIRECTORY_NOT_FOUND_FORMAT,
        BACKUP_BEG_TITLE,
        BACKUP_BEG_MESSAGE,
        DONT_ASK_AGAIN,
        NO_DATE_FOR_SIGHTING,
        NO_DETAILS_FOR_SIGHTING,
        DAY_PROMPT,
        YEAR_PROMPT,
        SPECIES_ONLY,
        EBIRD_GROUPS,
        SUBSPECIES_SHOWN,
        DELETE_ACTION,
        ERROR_MESSAGE,
        CHOOSE_A_LOCATION_NAME,
        LOCATION_TYPE_NO_TYPE,
        LOCATION_TYPE_PARK,
        LOCATION_TYPE_REGION,
        LOCATION_TYPE_CITY,
        LOCATION_TYPE_TOWN,
        LOCATION_TYPE_COUNTY,
        LOCATION_TYPE_STATE,
        LOCATION_TYPE_COUNTRY,
        LOCATION_TYPE_LABEL,
        LOCATION_IS_IN_LABEL,
        START_TYPING_A_LOCATION,
        EVEN_MORE_SPECIFIC,
        LESS_SPECIFIC,
        LATITUDE_LABEL,
        LONGITUDE_LABEL,
        IGNORE_THIS_RESULT,
        IGNORE_RESULT_FORMAT,
        SEARCH_NEARBY,
        MULTIPLE_SEARCH_RESULTS,
        DESCRIPTION_OF_THIS_LOCATION,
        PRIVATE_LOCATION_CHECKBOX,
        DUPLICATE_LOCATION_TITLE,
        DUPLICATE_LOCATION_FORMAT,
        COULDNT_CREATE_LOCATION_TITLE,
        COULDNT_CREATE_LOCATION_MESSAGE,
        SELECT_AN_EXISTING_LOCATION,
        NETWORK_FAILED_ERROR,
        CLICK_FOR_DETAILS,
        LOCATION_DETECTION_FAILED,
        ERROR_FETCHING_LOCATION,
        MULTIPLE_RESULTS_FROM_FORMAT,
        COULDNT_FIND_RESULTS_FOR_LAT_LONG,
        COULDNT_FIND_LOCATION_FORMAT,
        WHO_QUESTION,
        WHERE_QUESTION,
        WHEN_QUESTION,
        START_TIME_QUESTION,
        END_TIME_QUESTION,
        PICK_VALUE_OR_ESCAPE_TO_CLOSE,
        LOCATION_IS_NEW_FORMAT,
        OK_BUTTON,
        CANCEL_BUTTON,
        REQUIRED_TOOLTIP,
        SAVE_BUTTON,
        REVERT_BUTTON,
        VISIT_DATA,
        VISIT_SIGHTINGS,
        TRIP_DATA,
        TRIP_SIGHTINGS,
        BULK_EDIT_TITLE,
        ARE_YOU_SURE,
        VERIFY_CHANGE_ALL_SIGHTINGS_FORMAT,
        VERIFY_DELETE_ALL_SIGHTINGS_FORMAT,
        EDIT_ALL_SIGHTINGS_FORMAT,
        DELETE_ALL,
        REMOVE_BUTTON,
        SIGHTING_STATUS_NONE,
        SIGHTING_STATUS_RECORD_NOT_ACCEPTED,
        SIGHTING_STATUS_RECORD_NOT_ACCEPTED_ABBREVIATION,
        SIGHTING_STATUS_INTRODUCED,
        SIGHTING_STATUS_INTRODUCED_ABBREVIATION,
        SIGHTING_STATUS_INTRODUCED_NOT_ESTABLISHED,
        SIGHTING_STATUS_INTRODUCED_NOT_ESTABLISHED_ABBREVIATION,
        SIGHTING_STATUS_BETTER_VIEW_DESIRED,
        SIGHTING_STATUS_BETTER_VIEW_DESIRED_ABBREVIATION,
        SIGHTING_STATUS_UNSATISFACTORY_VIEWS,
        SIGHTING_STATUS_UNSATISFACTORY_VIEWS_ABBREVIATION,
        SIGHTING_STATUS_DEAD,
        SIGHTING_STATUS_NOT_BY_ME,
        SIGHTING_STATUS_SIGNS,
        SIGHTING_STATUS_DOMESTIC,
        SIGHTING_STATUS_ID_UNCERTAIN,
        SIGHTING_STATUS_RESTRAINED,
        BREEDING_BIRD_CODE_NONE,
        BREEDING_BIRD_CODE_NEST_WITH_YOUNG,
        BREEDING_BIRD_CODE_NEST_WITH_YOUNG_DESCRIPTION,
        BREEDING_BIRD_CODE_NEST_WITH_EGGS,
        BREEDING_BIRD_CODE_NEST_WITH_EGGS_DESCRIPTION,
        BREEDING_BIRD_CODE_OCCUPIED_NEST,
        BREEDING_BIRD_CODE_OCCUPIED_NEST_DESCRIPTION,
        BREEDING_BIRD_CODE_RECENTLY_FLEDGED,
        BREEDING_BIRD_CODE_RECENTLY_FLEDGED_DESCRIPTION,
        BREEDING_BIRD_CODE_FEEDING_YOUNG,
        BREEDING_BIRD_CODE_FEEDING_YOUNG_DESCRIPTION,
        BREEDING_BIRD_CODE_CARRYING_FECAL_SAC,
        BREEDING_BIRD_CODE_CARRYING_FECAL_SAC_DESCRIPTION,
        BREEDING_BIRD_CODE_CARRYING_FOOD,
        BREEDING_BIRD_CODE_CARRYING_FOOD_DESCRIPTION,
        BREEDING_BIRD_CODE_DISTRACTION_DISPLAY,
        BREEDING_BIRD_CODE_DISTRACTION_DISPLAY_DESCRIPTION,
        BREEDING_BIRD_CODE_NEST_BUILDING,
        BREEDING_BIRD_CODE_NEST_BUILDING_DESCRIPTION,
        BREEDING_BIRD_CODE_CARRYING_NESTING_MATERIAL,
        BREEDING_BIRD_CODE_CARRYING_NESTING_MATERIAL_DESCRIPTION,
        BREEDING_BIRD_CODE_TERRITORIAL_DEFENSE,
        BREEDING_BIRD_CODE_TERRITORIAL_DEFENSE_DESCRIPTION,
        BREEDING_BIRD_CODE_COURTSHIP_DISPLAY_OR_COPULATION,
        BREEDING_BIRD_CODE_COURTSHIP_DISPLAY_OR_COPULATION_DESCRIPTION,
        BREEDING_BIRD_CODE_VISITING_PROBABLE_NEST_SITE,
        BREEDING_BIRD_CODE_VISITING_PROBABLE_NEST_SITE_DESCRIPTION,
        BREEDING_BIRD_CODE_AGITATED_BEHAVIOR,
        BREEDING_BIRD_CODE_AGITATED_BEHAVIOR_DESCRIPTION,
        BREEDING_BIRD_CODE_PHYSIOLOGICAL_EVIDENCE,
        BREEDING_BIRD_CODE_PHYSIOLOGICAL_EVIDENCE_DESCRIPTION,
        BREEDING_BIRD_CODE_PAIR_IN_SUITABLE_HABITAT,
        BREEDING_BIRD_CODE_PAIR_IN_SUITABLE_HABITAT_DESCRIPTION,
        BREEDING_BIRD_CODE_MULTIPLE_SINGING_BIRDS,
        BREEDING_BIRD_CODE_MULTIPLE_SINGING_BIRDS_DESCRIPTION,
        BREEDING_BIRD_CODE_SINGING_BIRD_7_DAYS,
        BREEDING_BIRD_CODE_SINGING_BIRD_7_DAYS_DESCRIPTION,
        BREEDING_BIRD_CODE_SINGING_BIRD,
        BREEDING_BIRD_CODE_SINGING_BIRD_DESCRIPTION,
        BREEDING_BIRD_CODE_IN_APPROPRIATE_HABITAT,
        BREEDING_BIRD_CODE_IN_APPROPRIATE_HABITAT_DESCRIPTION,
        BREEDING_BIRD_CODE_FLYOVER,
        BREEDING_BIRD_CODE_FLYOVER_DESCRIPTION,
        BREEDING_BIRD_CODE_USED_NEST,
        BREEDING_BIRD_CODE_USED_NEST_DESCRIPTION,
        BREEDING_BIRD_CODE_WOODPECKER_WREN_NEST_BUILDING,
        BREEDING_BIRD_CODE_WOODPECKER_WREN_NEST_BUILDING_DESCRIPTION,
        MALE_LABEL,
        FEMALE_LABEL,
        IMMATURE_LABEL,
        ADULT_LABEL,
        HEARD_ONLY_LABEL,
        PHOTOGRAPHED_LABEL,
        BREEDING_CODE_LABEL,
        YES_TEXT,
        NO_TEXT,
        MALE_TEXT,
        FEMALE_TEXT,
        IMMATURE_TEXT,
        ADULT_TEXT,
        HEARD_ONLY_TEXT,
        PHOTOGRAPHED_TEXT,
        NUMBER_LABEL,
        NUMBER_TEXT,
        STATUS_LABEL,
        NOTES_LABEL,
        TYPE_A_SPECIES_NAME,
        SPECIES_TEXT,
        CHANGE_TO_LABEL,
        KEEP_AS_FORMAT,
        NONE_IN_BRACKETS,
        RANGE_SUMMARY_LINK,
        RANGE_SUMMARY,
        RANGE_SUMMARY_MESSAGE,
        PAGE_FORMAT,
        TAXON_PAGE,
        EDIT_SIGHTINGS,
        VISIT_DATA_TITLE,
        VISIT_INFO_INCIDENTAL,
        VISIT_INFO_INCIDENTAL_DESCRIPTION,
        VISIT_INFO_TRAVELING,
        VISIT_INFO_TRAVELING_DESCRIPTION,
        VISIT_INFO_STATIONARY,
        VISIT_INFO_STATIONARY_DESCRIPTION,
        VISIT_INFO_HISTORICAL,
        VISIT_INFO_HISTORICAL_DESCRIPTION,
        VISIT_INFO_AREA,
        VISIT_INFO_AREA_DESCRIPTION,
        VISIT_INFO_BANDING,
        VISIT_INFO_BANDING_DESCRIPTION,
        VISIT_INFO_PELAGIC_PROTOCOL,
        VISIT_INFO_PELAGIC_PROTOCOL_DESCRIPTION,
        VISIT_INFO_NOCTURNAL_BIRDING,
        VISIT_INFO_NOCTURNAL_BIRDING_DESCRIPTION,
        VISIT_INFO_NOCTURNAL_FLIGHT_CALL_COUNT,
        VISIT_INFO_NOCTURNAL_FLIGHT_CALL_COUNT_DESCRIPTION,
        VISIT_INFO_RANDOM,
        VISIT_INFO_RANDOM_DESCRIPTION,
        MILES_TEXT,
        KILOMETERS_TEXT,
        ACRES_TEXT,
        HECTARES_TEXT,
        START_TIME_LABEL,
        EBIRD_OBSERVATION_TYPE_LABEL,
        DURATION_LABEL,
        HOURS_ABBREVIATION,
        MINUTES_ABBREVIATION,
        DISTANCE_LABEL,
        AREA_LABEL,
        PARTY_SIZE_LABEL,
        COMMENTS_LABEL,
        SUBSPECIES_COLUMN,
        NEW_FOR_COLUMN,
        USE_CHECKLIST_QUESTION,
        COMPLETE_LIST_OF_SIGHTINGS_QUESTION,
        START_TIME_ISNT_SET,
        NONE_IN_PARENTHESES,
        CHOOSE_NEW_LOCATION,
        WORLD_TEXT,
        YEAR_TEXT,
        DRAG_TRIP_LINK_OR_CLICK,
        LINK_NOT_THERE_ANYMORE,
        CHOOSE_A_LINK,
        LINK_FILE,
        DRAG_PHOTO_OR_CLICK,
        DRAG_PHOTOS_WITH_SPECIES_NAMES,
        CHOOSE_A_PHOTO,
        LOOKING_FOR_FORMAT,
        IMAGE_FILE,
        FILE_NOT_FOUND,
        PHOTO_NOT_THERE_ANYMORE,
        FIX_OTHER_PHOTOS_TITLE,
        FIX_OTHER_PHOTOS_FORMAT,
        OTHER_PHOTOS_FIXED_TITLE,
        OTHER_PHOTOS_FIXED_FORMAT,
        SMALLER_FONTS,
        LARGER_FONTS,
        VERSION_FORMAT,
        SCYTHEBILL_IMAGE_COPYRIGHT,
        REMOVE_SIGHTING,
        REMOVE_SIGHTINGS,
        REMOVE_SIGHTING_CONFIRM,
        REMOVE_SIGHTINGS_CONFIRM,
        MAP_FAILED,
        COULDNT_WRITE_MAP,
        ADD_SIGHTING,
        ONLY_ENCOUNTERED_SPECIES,
        ONLY_SPECIES_FOUND_IN,
        SHOW_LABEL,
        JUMP_TO_BUTTON,
        SAVE_SIGHTINGS_TITLE,
        SAVE_SIGHTINGS_MESSAGE,
        NOT_WRITABLE_TITLE,
        NOT_WRITABLE_FORMAT,
        EDIT_MENU,
        CUT_MENU,
        COPY_MENU,
        PASTE_MENU,
        UNSAVED_CHANGES_TITLE,
        UNSAVED_CHANGES_MESSAGE,
        DOES_NOT_APPEAR_TO_BE_AN_ACTUAL_EBIRD_FILE,
        EBIRD_DATES_DID_NOT_PARSE,
        AVISYS_FIELD_NOTES_FILE_DOES_NOT_MATCH,
        AVISYS_FIELD_NOTES_FILE_NOT_EXPECTED_FORM,
        NEW_USER,
        NEW_USER_IMPORT_HELP_MESSAGE,
        CANCEL_IMPORT,
        NEW_OBSERVER,
        SCYTHEBILL_IMPORT_NEITHER_SCIENTIFIC_NOR_COMMON,
        IMPORT_REQUIRED_HEADER_MISSING_FORMAT,
        WILDLIFE_RECORDER_NO_HEADER_ROW_FORMAT,
        IMPORT_FROM,
        IMPORT_FROM_FORMAT,
        CSV_EXPORT_FROM_FORMAT,
        XLS_EXPORT_FROM_FORMAT,
        XLSX_EXPORT_FROM_FORMAT,
        TXT_EXPORT_FROM_FORMAT,
        XML_EXPORTS_FROM_FORMAT,
        CSV_OR_ZIP_EXPORT_FROM_FORMAT,
        MDB_OR_CSV_EXPORT_FROM_FORMAT,
        OTHER_KINDS_OF_EXPORTS,
        OPEN_EXPORT_FORMAT,
        OPEN_WINGS_FILES,
        CSV_EXPORT_TYPE,
        CSV_OR_MDB_EXPORT_TYPE,
        XLS_EXPORT_TYPE,
        XLSX_EXPORT_TYPE,
        TXT_EXPORT_TYPE,
        XML_EXPORT_TYPE,
        CSV_OR_ZIP_EXPORT_TYPE,
        AVISYS_EXPORT_TYPES,
        AVISYS_OPEN_EXPORT,
        FIELD_NOTES_FILE_TITLE,
        FIELD_NOTES_FILE_MESSAGE,
        FIELD_NOTES_FILE_TYPE,
        OPEN_FIELD_NOTES_FILE,
        WR_LOCATION_EXPORTS_FILE_TITLE,
        WR_LOCATION_EXPORTS_FILE_MESSAGE,
        FAILED_WR_LOCATION_EXPORT_IMPORT_ON_LINE_FORMAT,
        FLICKR_ALBUM,
        FLICKR_IMPORT_INSTRUCTIONS,
        FLICKR_ALBUM_URL_LABEL,
        NOT_A_VALID_FLICKR_ALBUM_URL,
        FLICKR_ALBUM_LOAD_FAILED_TITLE,
        FLICKR_ALBUM_LOAD_FAILED_MESSAGE,
        FLICKR_ALBUM_LOAD_TIMEOUT_MESSAGE,
        FLICKR_ALBUM_LOAD_FAILED_UNEXPECTED_MESSAGE,
        FAILED_IMPORT_TITLE,
        FAILED_IMPORT_FORMAT,
        FAILED_IMPORT_ON_LINE_FORMAT,
        USE_DIFFERENT_INTERNATIONAL_NAMES_TITLE,
        USE_DIFFERENT_INTERNATIONAL_NAMES_FORMAT,
        RIGHT_TAXONOMY_TITLE,
        RIGHT_TAXONOMY_FORMAT_NO_TAXA,
        RIGHT_TAXONOMY_FORMAT_FEW_TAXA,
        IMPORTING_UNSUCCESSFUL_MESSAGE,
        IMPORTING_EMPTY_RESULT_MESSAGE,
        IMPORT_ANYWAY,
        DROP_DUPLICATES,
        IMPORT_ALL,
        OVERWRITE_DUPLICATES,
        ALL_SIGHTINGS_DUPLICATES,
        DUPLICATE_IMPORTS_QUESTION,
        SIGHTINGS_OVERWRITTEN_TITLE,
        SIGHTINGS_OVERWRITTEN_FORMAT,
        SOME_SIGHTINGS_DUPLICATES,
        DUPLICATES_DROPPED_TITLE,
        DUPLICATES_DROPPED_FORMAT,
        IMPORTED_LOCATIONS_DIFFER,
        ALL_SIGHTINGS_HAVE_DIFFERENT_LOCATIONS,
        A_FEW_SIGHTINGS_HAVE_DIFFERENT_LOCATIONS,
        MANY_SIGHTINGS_HAVE_DIFFERENT_LOCATIONS,
        MOST_SIGHTINGS_HAVE_DIFFERENT_LOCATIONS,
        NEARLY_ALL_SIGHTINGS_HAVE_DIFFERENT_LOCATIONS,
        SEPARATE_SIGHTINGS,
        MERGE_SIGHTINGS,
        IMPORTED_OBSERVERS_DIFFER_TITLE,
        IMPORTED_OBSERVERS_DIFFER_MESSAGE,
        MERGE_USERS,
        PREFER_IMPORT,
        PREFER_EXISTING,
        IMPORT_PARTIALLY_SUCCESSFUL_TITLE,
        IMPORT_PARTIALLY_SUCCESSFUL_WITH_FAILED_SIGHTINGS_FORMAT,
        IMPORT_PARTIALLY_SUCCESSFUL_FORMAT,
        ALL_DUPLICATES_TITLE,
        ALL_DUPLICATES_FORMAT,
        IMPORT_SUCCEEDED_TITLE,
        IMPORT_SUCCEEDED_FORMAT,
        IMPORT_SIGHTINGS_MERGED,
        IMPORT_EBIRD_SPUHS_DROPPED,
        IMPORT_NEW_FOR_WORLD_SPECIES_COUNT,
        IMPORT_NEW_FOR_YEAR_SPECIES_COUNT,
        IMPORT_NEW_FOR_LOCATION_SPECIES_COUNT,
        IMPORT_NEW_FOR_WORLD_SPECIES_NAME,
        IMPORT_NEW_FOR_YEAR_SPECIES_NAME,
        IMPORT_NEW_FOR_LOCATION_SPECIES_NAME,
        IMPORT_NEW_FOR_WORLD_SPECIES_COUNT_AND_NAMES,
        IMPORT_NEW_FOR_YEAR_SPECIES_COUNT_AND_NAMES,
        IMPORT_NEW_FOR_LOCATION_SPECIES_COUNT_AND_NAMES,
        CHOOSE_AN_IMPORT_FORMAT,
        CHOOSE_AN_IMPORT_FORMAT_ONLY_NON_BIRD,
        CHOOSE_AN_IMPORT_FORMAT_ONLY_NON_BIRD_EMPTY_FILE,
        LOCATION_OF_FORMAT,
        LOCATION_OF_FORMAT_WITH_HINT,
        IDENTIFY_WHERE_THE_SIGHTINGS_TOOK_PLACE,
        NEXT_BUTTON,
        PREVIOUS_BUTTON,
        EXISTING_LOCATION,
        ASSIGN_ALL_TO_COUNTRY_TITLE_FORMAT,
        ASSIGN_ALL_TO_COUNTRY_MESSAGE_FORMAT,
        NO_COMMON_NAME,
        NO_SCIENTIFIC_NAME,
        RESOLVE_SPECIES_OF_FORMAT,
        COULD_NOT_LOCATE_SOME_SPECIES,
        IMPORTED_COMMON_NAME_LABEL,
        IMPORTED_SCIENTIFIC_NAME_LABEL,
        IMPORTED_DESCRIPTION_LABEL,
        DROP_SPECIES,
        OFTEN_DATES_CANNOT_BE_READ,
        COULD_NOT_EXTRACT_ANY_DATA_FORMAT,
        IMPORT_ONLY_NEW_DATES_TITLE,
        IMPORT_ONLY_NEW_DATES_FORMAT,
        IMPORT_DATES_ARE_ENTIRELY_DUPLICATED_TITLE,
        IMPORT_DATES_ARE_ENTIRELY_DUPLICATED_MESSAGE,
        CHOOSE_A_TAXONOMIC_CLASS_TITLE,
        CHOOSE_A_TAXONOMIC_CLASS_FORMATTED_MESSAGE,
        ENTER_SIGHTINGS,
        ENTER_SIGHTINGS_EXPLANATION,
        SHOW_REPORTS,
        SHOW_REPORTS_EXPLANATION,
        BROWSE_BY_SPECIES,
        BROWSE_BY_SPECIES_EXPLANATION,
        BROWSE_BY_LOCATION,
        BROWSE_BY_LOCATION_EXPLANATION,
        SPECIAL_REPORTS,
        SPECIAL_REPORTS_EXPLANATION,
        PREFERENCES,
        PREFERENCES_MENU,
        PREFERENCES_EXPLANATION,
        WELCOME_TO_SCYTHEBILL,
        WELCOME_MESSAGE,
        OPEN_FILE,
        OPEN_FILE_EXPLANATION,
        NEW_FILE,
        NEW_FILE_EXPLANATION,
        IMPORT_RECORDS,
        IMPORT_RECORDS_EXPLANATION,
        IMPORT_FAILED,
        IMPORTING_TAXONOMY_FAILED_FORMAT,
        SPECIES_NAME_EBIRD_CLEMENTS,
        SPECIES_NAME_IOC,
        COUNTABILITY_PREFERENCES,
        COUNT_INTRODUCED_SPECIES,
        COUNT_HEARD_ONLY_SIGHTINGS,
        COUNT_UNDESCRIBED_SPECIES,
        COUNT_RESTRAINED_INDIVIDUALS,
        SHOW_EXTINCT_TAXA,
        BACKUP_PREFERENCES,
        LANGUAGE_PREFERENCES_NEEDS_RESTART,
        USE_SYSTEM_LANGUAGE,
        HOW_OFTEN,
        BACKUP_NOW,
        YOU_HAVE_UNSAVED_CHANGES,
        SAVE_BEFORE_BACKING_UP,
        CHOOSE_A_DIRECTORY,
        OBSERVER_PREFERENCES,
        ENABLE_MULTIPLE_OBSERVERS,
        DISABLE_MULTIPLE_OBSERVERS,
        DISABLE_OBSERVERS_TITLE,
        DISABLE_OBSERVERS_MESSAGE,
        CREATE_A_FIRST_OBSERVER,
        ADD_TO_ALL_SIGHTINGS,
        ADD_OBSERVER_TO_ALL_SIGHTING_NOW,
        CHOOSE_A_BACKUP_DIRECTORY,
        COULD_NOT_WRITE_INTO_DIRECTORY_TITLE,
        COULD_NOT_WRITE_INTO_DIRECTORY_FORMAT,
        PLEASE_RECONSIDER,
        SAME_FOLDER_IS_NOT_SAFE,
        AND_EXPORT_TO_EBIRD,
        AND_SAVE,
        LOSE_ALL_THE_SIGHTINGS,
        ENTER_LOCATION_HELP_FORMAT,
        NUMBER_OF_SPECIES_FORMAT,
        NUMBER_OF_SPECIES_AND_OTHER_TAXA_FORMAT,
        ENTER_SPECIES,
        YES_WITH_RARITIES,
        NEW_FOR_CHECKLIST,
        NOT_FOUND_ON_CHECKLIST_FORMAT,
        FAILED_MAPPINGS_TITLE,
        FAILED_MAPPINGS_FORMAT,
        ADD_A_PHOTO,
        PHOTOS_TEXT,
        OBSERVERS_TEXT,
        OR_CHOOSE_A_RECENT_VISIT,
        WHO_WHEN_WHERE,
        WHEN_AND_WHERE,
        YOU_DIDNT_ENTER_A_DATE_TITLE,
        YOU_DIDNT_ENTER_A_DATE_MESSAGE,
        YEAR_MAY_BE_WRONG,
        YEAR_IS_FAR_IN_THE_PAST_MESSAGE,
        YEAR_IS_IN_THE_FUTURE_MESSAGE,
        DATE_HAS_CHANGED_TITLE,
        DATE_HAS_CHANGED_MESSAGE,
        DATE_AND_TIME_HAS_CHANGED_TITLE,
        DATE_AND_TIME_HAS_CHANGED_MESSAGE,
        LOCATION_HAS_CHANGED_TITLE,
        LOCATION_HAS_CHANGED_MESSAGE,
        TIME_HAS_CHANGED_TITLE,
        TIME_HAS_CHANGED_MESSAGE,
        TIME_AND_LOCATION_HAS_CHANGED_TITLE,
        TIME_AND_LOCATION_HAS_CHANGED_MESSAGE,
        DATE_AND_LOCATION_HAS_CHANGED_TITLE,
        DATE_AND_LOCATION_HAS_CHANGED_MESSAGE,
        DATE_AND_TIME_AND_LOCATION_HAS_CHANGED_TITLE,
        DATE_AND_TIME_AND_LOCATION_HAS_CHANGED_MESSAGE,
        NOT_ON_THE_CHECKLIST_FORMAT,
        ENDEMIC_TO_FORMAT,
        ESCAPEE_IN_FORMAT,
        INTRODUCED_IN_FORMAT,
        EXTINCT_IN_FORMAT,
        RARITY_IN_FORMAT,
        RARITY_FROM_INTRODUCED_IN_FORMAT,
        ALTERNATE_NAMES_LABEL,
        RANGE_LABEL,
        TAXONOMY_LABEL,
        SPECIES_INFORMATION_WILL_APPEAR_HERE,
        SPUH_LABEL,
        HYBRID_LABEL,
        ADD_SPECIES,
        SP_HYBRID_BUTTON,
        SP_BUTTON,
        HYBRID_BUTTON,
        KEEP_AS_SP,
        KEEP_AS_HYBRID,
        CHANGE_TO_SP_OR_HYBRID,
        MAKE_SP_OR_HYBRID_FORMAT,
        AND_LABEL,
        SCYTHEBILL_IS_STARTING,
        RECORDS_HAVE_BEEN_UPDATED_AFTER_BACKUP,
        RECORDS_UPDATED_WITH_ONE_OFF_COPY,
        COULD_NOT_BACKUP_DURING_UPGRADE_TITLE,
        COULD_NOT_BACKUP_DURING_UPGRADE_MESSAGE,
        RECORDS_UPDATED_WITHOUT_BACKUP,
        UPGRADE_SUCCESSFUL,
        SCYTHEBILL_UPGRADED_TO_TAXONOMY_FORMAT,
        SCYTHEBILL_UPGRADE_EVEN_FOR_IOC_USERS,
        UPGRADE_MANUALLY_EXAMINE_TAXA,
        UPGRADE_SOME_SPUH_TAXA,
        UPGRADE_SOME_IOC_SPUH_TAXA,
        RESOLVE_NOW,
        NOT_NOW,
        OUT_OF_SIGHTINGS_TO_RESOLVE_FORMAT,
        SOME_CAN_BE_ENTIRELY_RESOLVED_USING_CHECKLISTS,
        SOME_CAN_BE_PARTIALLY_RESOLVED,
        SOME_CANNOT_BE_RESOLVED_AT_ALL,
        LET_SCYTHEBILL_RESOLVE_SIGHTINGS_AUTOMATICALLY,
        AUTO_RESOLVE_WITH_CHECKLISTS,
        OBSERVER_LABEL,
        OBSERVERS_LABEL,
        OBSERVER_NAME,
        ADD_BUTTON,
        NAME_LABEL,
        ABBREVIATION_LABEL,
        ALREADY_AN_OBSERVER_WITH_THAT_ABBREVIATION,
        ILLEGAL_ABBREVIATION_CHARACTER,
        ADD_WITH_ELLIPSIS,
        EDIT_WITH_ELLIPSIS,
        DELETE_WITH_ELLIPSIS,
        ADD_OBSERVER,
        EDIT_OBSERVER,
        DELETE_OBSERVER_TITLE,
        DELETE_OBSERVER_AND_MAYBE_SIGHTINGS_MESSAGE,
        DROP_SIGHTINGS,
        LEAVE_EMPTY,
        DELETE_OBSERVER_MESSAGE,
        NEW_VERSION_IS_AVAILABLE,
        NEW_VERSION_MESSAGE_ONE_VERSION,
        NEW_VERSION_MESSAGE_MULTIPLE_VERSIONS,
        SKIP_THIS_VERSION,
        ASK_ME_LATER,
        DOWNLOAD_NOW,
        PLEASE_QUIT_TITLE,
        PLEASE_QUIT_MESSAGE,
        NEXT_WITH_RIGHT_ARROW,
        BACK_WITH_LEFT_ARROW,
        DONE_BUTTON,
        SPREADSHEET_OPTIONS,
        CHOOSE_OPTIONS_FOR_CHECKLIST,
        SCIENTIFIC_NAME_QUESTION,
        LIFERS_IN_BOLD_QUESTION,
        NEW_FOR_COLUMN_QUESTION,
        SHOW_THREATENED_STATUS_QUESTION,
        INCLUDE_ONE_SIGHTING_QUESTION,
        WHICH_SIGHTING_QUESTION,
        FIRST_IN_FORMAT,
        FIRST_IN_CHECKLIST_REGION,
        MOST_RECENT_IN_FORMAT,
        MOST_RECENT_IN_CHECKLIST_REGION,
        LIFER_SIGHTING,
        MOST_RECENT_ANYWHERE,
        NUMBERS_OF_COLUMNS_FOR_RECORDS,
        CLICK_START_HELP,
        CLICK_TRY_HARDER_HELP,
        OR_ENTER_MORE_TEXT,
        NOTHING_FOUND,
        NOTHING_NEW_STILL_FORMAT,
        FOUND_SPECIES_CLICK_REMAINING_TEXT,
        FOUND_SPECIES_NOW_TOTAL,
        FOUND_EVEN_MORE_SPECIES,
        CREATE_A_CHECKLIST,
        TRY_HARDER,
        START_BUTTON,
        ADD_MORE,
        HOW_TO_GET_STARTED_WITH_CHECKLIST,
        START_WITH_YOUR_SIGHTINGS,
        START_WITH_YOUR_SIGHTINGS_HELP,
        COPY_AND_PASTE_MAGIC,
        COPY_AND_PASTE_MAGIC_HELP,
        COMMON_COLUMN,
        SCIENTIFIC_COLUMN,
        STATUS_COLUMN,
        DELETE_COLUMN,
        CHECKLIST_CORRECTIONS_ARE_READY,
        DELETE_CHECKLIST_BUTTON,
        DELETE_CHECKLIST_TITLE,
        DELETE_CHECKLIST_MESSAGE,
        CHECKLIST_STATUS_REGULAR,
        CHECKLIST_STATUS_INTRODUCED,
        CHECKLIST_STATUS_NOT_ESTABLISHED,
        CHECKLIST_STATUS_RARITY,
        CHECKLIST_STATUS_RARITY_FROM_INTRODUCED,
        CHECKLIST_STATUS_ENDEMIC,
        CHECKLIST_STATUS_EXTINCT,
        TOTAL_FORMAT,
        NAME_ALREADY_EXISTS_TITLE,
        NAME_ALREADY_EXISTS_MESSAGE,
        MERGE_LOCATIONS_TITLE,
        MERGE_SINGLE_LOCATION_MESSAGE,
        MERGE_MULTIPLE_LOCATIONS_MESSAGE,
        CORRECT_CHECKLIST,
        EDIT_CHECKLIST,
        CREATE_CHECKLIST,
        POSSIBLE_LIFERS_FORMAT,
        SIGHTINGS_NEW_FOR_FORMAT,
        CUSTOM_REPORT,
        TOTAL_SPECIES_WITH_LIFERS_FORMAT,
        TOTAL_SPECIES_WITH_LIFERS_AND_ENDEMICS_SOME_SEEN,
        TOTAL_SPECIES_WITH_LIFERS_AND_ENDEMICS,
        TOTAL_SPECIES_FORMAT,
        TOTAL_SPECIES_WITH_ENDEMICS_SOME_SEEN,
        TOTAL_SPECIES_WITH_ENDEMICS,
        TOTAL_SPECIES_FORMAT_NO_CHECKLIST,
        TRIP_TOTALS_COUNT_AND_LIFERS,
        TRIP_TOTALS_COUNT_AND_ENDEMICS,
        TRIP_TOTALS_COUNT_AND_LIFERS_AND_ENDEMICS,
        ONLY_VISITED_LOCATIONS,
        CREATES_A_NEW_LOCATION,
        CREATES_A_NEW_LOCATION_INSIDE_FORMAT,
        DELETE_LOCATION_TITLE,
        DELETE_LOCATION_MESSAGE,
        SAVE_A_SPREADSHEET,
        COULD_NOT_SAVE,
        SAVING_THE_SPREADSHEET_DID_NOT_SUCCEED,
        OPENING_FAILED,
        NO_APPLICATION_FOR_XLS_FILES,
        CORRECTING_A_BUILT_IN_CHECKLIST_TITLE,
        CORRECTING_A_BUILT_IN_CHECKLIST_MESSAGE,
        EDITING_CHECKLIST,
        CREATING_CHECKLIST,
        SHARE_A_CHECKLIST,
        DELETE_LOCATION_HELP,
        HIDE_RARITIES,
        SAVE_AS_SPREADSHEET,
        CREATE_TRIP_REPORT,
        SHARE_CHECKLIST,
        SHOW_EVERYTHING,
        ONLY_RECORDED,
        ONLY_LIFERS,
        NOT_SEEN_HERE,
        ONLY_ENDEMICS,
        CUSTOM_FILTER,
        NEW_FOR_FORMAT,
        NEW_FOR_CUSTOM_REPORT,
        CUSTOM_FILTER_HELP,
        ERROR_LOADING_IMAGE,
        BIG_DAY,
        BIG_MONTH,
        BIG_YEAR,
        BACK_TO_SPECIAL_REPORTS,
        CODE_IS,
        CODE_IS_AT_LEAST,
        CODE_IS_NOT,
        CODE_IS_ANY,
        VALUE_IS,
        VALUE_YES,
        VALUE_NO,
        VALUE_ANY,
        CODE_CONFIRMED,
        CODE_CONFIRMED_PROBABLE,
        CODE_PROBABLE,
        CODE_POSSIBLE,
        DATE_IS_DURING,
        DATE_IS_BETWEEN,
        DATE_IS_AFTER,
        DATE_IS_BEFORE,
        DATE_IS_THIS_YEAR,
        DATE_IS_TODAY,
        DATE_IS_NOT_DURING,
        DATE_IS_NOT_SET,
        DATE_AFTER_FORMAT,
        DATE_NOT_FORMAT,
        DATE_BEFORE_FORMAT,
        DATE_YEAR,
        DATE_TODAY,
        DATE_NOT_SET,
        DESCRIPTION_CONTAINS,
        DESCRIPTION_DOESNT_CONTAIN,
        DESCRIPTION_CONTAINS_CASE_SENSITIVE,
        DESCRIPTION_DOESNT_CONTAIN_CASE_SENSITIVE,
        DESCRIPTION_IS_EXACTLY,
        DESCRIPTION_IS_EXACTLY_CASE_SENSITIVE,
        DESCRIPTION_STARTS_WITH_WORD,
        DESCRIPTION_STARTS_WITH_WORD_CASE_SENSITIVE,
        NO_SIGHTINGS_TO_EXPORT,
        NO_SIGHTINGS_SUFFICIENTLY_DETAILED,
        SAVE_FOR_EBIRD,
        COULD_NOT_WRITE_FORMAT,
        FILE_WAS_TOO_LONG,
        SAVE_FOR_INATURALIST,
        SAVE_FOR_BIRDTRACK,
        BIRDTRACK_NO_ACCEPTABLE_SIGHTINGS_TITLE,
        BIRDTRACK_NO_ACCEPTABLE_SIGHTINGS_MESSAGE,
        SPECIAL_REPORTS_TITLE,
        BIG_DAYS_MONTHS_YEARS,
        BIG_DAYS_MONTHS_YEARS_EXPLANATION,
        YEAR_COMPARISONS,
        YEAR_COMPARISONS_EXPLANATION,
        TOTAL_TICKS,
        TOTAL_TICKS_LABEL,
        TOTAL_TICKS_EXPLANATION,
        TOTAL_TICKS_MAP,
        WORLD_LIFER_MAP,
        WORLD_LIFER_MAP_EXPLANATION,
        WORLD_FAMILY_LIFER_MAP,
        WORLD_FAMILY_LIFER_MAP_EXPLANATION,
        SPLITS_AND_LUMPS,
        SPLITS_AND_LUMPS_EXPLANATION,
        VERSUS_FORMAT,
        START_TYPING_A_FAMILY,
        NO_FAMILY,
        FIRST_RECORDS_HIGHLIGHTED,
        FIRST_RECORDS_INCLUDED,
        MY_FIRST_RECORDS_IN,
        SHOULD_BE,
        LOCATION_IS_IN,
        LOCATION_IS_NOT_IN,
        LOCATION_IS,
        LOCATION_IS_NOT,
        LOCATION_IS_NEARER_THAN,
        LOCATION_FROM,
        LOCATION_IS_NOT_SET,
        LOCATION_NOT_SET,
        SAVE_AS_SCYTHEBILL_CSV,
        COULD_NOT_PRINT,
        COULD_NOT_CREATE_TEMPORARY_FILE_TO_PRINT,
        COULD_NOT_CREATE_TEMPORARY_FILE_TO_PRINT_IN,
        CHOOSE_A_REPORT,
        QUERY_LOCATION,
        QUERY_DATE,
        QUERY_OBSERVERS,
        QUERY_FIRST_RECORDS,
        QUERY_HEARD_ONLY,
        QUERY_IUCN_READLIST,
        QUERY_STATUS,
        QUERY_BREEDING_CODE,
        QUERY_PHOTOGRAPHED,
        QUERY_SIGHTING_NOTES,
        QUERY_VISIT_COMMENTS,
        QUERY_SEX_AGE,
        QUERY_TIMES_SIGHTED,
        QUERY_FAMILY,
        QUERY_SUBSPECIES,
        QUERY_SP_OR_HYBRID,
        QUERY_AND,
        QUERY_OR,
        QUERY_NEVER,
        QUERY_NEVER_ALL,
        NEVER_FORMAT,
        PRINT_OPTIONS_TITLE,
        PRINT_OPTIONS_MESSAGE,
        SHOW_FAMILIES_QUESTION,
        COMPACT_PRINT_QUESTION,
        ONLY_COUNTABLE_SIGHTINGS_QUESTION,
        OMIT_SP_AND_HYBRID_QUESTION,
        HOW_MANY_SIGHTINGS_QUESTION,
        SORT_BY,
        SORT_SPECIES_BY,
        SORT_SIGHTINGS_BY,
        INCLUDE_ITINERARY_QUESTION,
        INCLUDE_SPECIES_TABLE_QUESTION,
        INCLUDE_SPECIES_LIST_QUESTION,
        INCLUDE_OTHER_TAXONOMIES_QUESTION,
        INCLUDE_FAVORITE_PHOTOS_QUESTION,
        INCLUDE_ALL_TAXONOMIES_QUESTION,
        VISITS_FORMAT,
        VISITS_CAPITALIZED_FORMAT,
        TRIPS_FORMAT,
        TRIPS_CAPITALIZED_FORMAT,
        EXPORT_TO_BIRDTRACK,
        EXPORT_TO_EBIRD,
        EXPORT_TO_INATURALIST,
        EXPORT_TO_SPREADSHEET,
        EXPORT_TO_SCYTHEBILL,
        EXPORT_TO_TRIP_REPORT,
        EXPORT_TO_FAMILY_REPORT,
        UPDATE_REPORT,
        BULK_EDIT,
        REMEMBER_MENU,
        REPORT_DEFAULT_NAME,
        GROUPS_FORMAT,
        SSPS_FORMAT,
        SPUHS_FORMAT,
        LIFERS_FORMAT_2,
        FAMILIES_FORMAT,
        FAMILIES_OF_FORMAT,
        SPREADSHEET_OPTIONS_MESSAGE,
        WHAT_DATA_QUESTION,
        WHICH_SPECIES_QUESTION,
        WHICH_SIGHTINGS_QUESTION,
        SHOW_NOTES_COUNT_ETC_QUESTION,
        SHOW_OBSERVERS_QUESTION,
        RESOLVE_SELECT_EACH_SPECIES,
        RESOLVE_DONT_NEED_TO_FINISH,
        XLS_FILES,
        COULD_NOT_SAVE_REPORT,
        TRIP_REPORT_OPTIONS,
        TRIP_REPORT_OPTIONS_MESSAGE,
        TRIP_REPORT_EXPLANATION,
        FAMILY_REPORT_OPTIONS,
        FAMILY_REPORT_OPTIONS_MESSAGE,
        FAMILY_REPORT_EXPLANATION,
        SEX_IS_FEMALE,
        SEX_IS_MALE,
        AGE_IS_ADULT,
        AGE_IS_IMMATURE,
        STATUS_IS,
        STATUS_IS_NOT,
        STATUS_IS_OR_WORSE,
        STATUS_ANY,
        HAS_FAVORITE,
        HAS_NO_FAVORITE,
        SET_AS_FAVORITE_FORMAT,
        REMOVE_AS_FAVORITE_FORMAT,
        REMOVE_FORMAT,
        SORT_BY_DEFAULT,
        SORT_BY_DATE,
        SORT_BY_DATE_DESCENDING,
        SORT_BY_DAY_OF_YEAR,
        SORT_BY_DAY_OF_YEAR_DESCENDING,
        SORT_BY_NUMBER_RECORDED,
        SORT_TAXONOMICALLY,
        SORT_MOST_RECORDED,
        SORT_GREATEST_FRACTION,
        SPLITS_AND_LUMPS_FULL_EXPLANATION,
        NO_SPLITS_OR_LUMPS_FOUND,
        GAINED_FORMAT,
        PLUS_POSSIBLE_FORMAT,
        LOST_FORMAT,
        SPLITS_TEXT,
        POSSIBLE_SPLITS,
        LUMPS_TEXT,
        POSSIBLE_LUMPS,
        UNKNOWN_LUMPS_OR_SPLITS,
        IS_NOW_FORMAT,
        ARE_NOW_FORMAT,
        SOME_OR_ALL_OF_IS_NOW_FORMAT,
        SOME_OR_ALL_OF_ARE_NOW_FORMAT,
        SOME_OR_ALL_OF_AND_POSSIBLY_IS_NOW_FORMAT,
        SOME_OR_ALL_OF_AND_POSSIBLY_ARE_NOW_FORMAT,
        SOME_OR_ALL_OF_AND_SOME_NONE_ALL_IS_NOW_FORMAT,
        SOME_OR_ALL_OF_AND_SOME_NONE_ALL_ARE_NOW_FORMAT,
        IS_NOW_SOME_OR_ALL_OF_FORMAT,
        ARE_NOW_SOME_OR_ALL_OF_FORMAT,
        IS_NOW_SOME_OR_ALL_OF_AND_POSSIBLY_FORMAT,
        ARE_NOW_SOME_OR_ALL_OF_AND_POSSIBLY_FORMAT,
        IS_NOW_SOME_OR_ALL_OF_AND_SOME_NONE_ALL_FORMAT,
        ARE_NOW_SOME_OR_ALL_OF_AND_SOME_NONE_ALL_FORMAT,
        A_AND_B,
        A_COMMA_B,
        A_COMMA_AND_B,
        SPECIES_IS,
        SPECIES_IS_NOT,
        NEITHER_TEXT,
        NAME_THIS_REPORT_TITLE,
        NAME_THIS_REPORT_MESSAGE,
        NAME_CANT_BE_EMPTY_TITLE,
        NAME_CANT_BE_EMPTY_MESSAGE,
        NAME_ALREADY_TAKEN_TITLE,
        NAME_ALREADY_TAKEN_MESSAGE,
        SHOW_THE_FULL_REPORT_FORMAT,
        DELETE_REMEMBERED_REPORT_TITLE,
        DELETE_REMEMBERED_REPORT_FORMAT,
        SUBSPECIES_IS_ALLOCATED,
        SUBSPECIES_IS_NOT_ALLOCATED,
        TOTAL_TICKS_COUNTRY_EXPLANATION,
        TOTAL_TICKS_COUNTY_EXPLANATION,
        TOTAL_TICKS_STATE_EXPLANATION,
        OUTPUT_NO_NAMES,
        OUTPUT_USER_NAMES,
        OUTPUT_USER_ABBREVIATIONS,
        OUTPUT_BOTH,
        USER_INCLUDES,
        USER_DOES_NOT_INCLUDE,
        USER_IS_ONLY,
        USER_ARE_EMPTY,
        FROM_LABEL,
        TO_LABEL,
        YEAR_COMPARISON_FULL_EXPLANATION,
        SPLIT_YEARS_CHECKBOX,
        TOTAL_SPECIES_TEXT,
        XLSX_FILES,
        FIRST_SEEN,
        LAST_SEEN,
        SPECIES_WITH_NUMBER,
        GROUPS_WITH_NUMBER,
        SUBSPECIES_WITH_NUMBER,
        LIFER_GROUPS_WITH_NUMBER,
        LIFER_SUBSPECIES_WITH_NUMBER,
        TOTAL_SIGHTINGS_WITH_NUMBER,
        COMMON_NAME,
        SCIENTIFIC_NAME,
        LOCATION_TEXT,
        DATE_TEXT,
        LIFER_TEXT,
        GROUP_LIFER,
        SSP_LIFER,
        SIGHTING_TEXT,
        NOTES_TEXT,
        OBSERVER_NAMES,
        ADDED_TAXONOMY_SUCCESSFULLY_TITLE,
        ADDED_TAXONOMY_SUCCESSFULLY_MESSAGE,
        ADDED_TAXONOMY_SUCCESSFULLY_WITH_CREDITS_MESSAGE,
        ADDED_TAXONOMY_SOME_SIGHTINGS_NOT_UPGRADED_TITLE,
        ADDED_TAXONOMY_SOME_SIGHTINGS_NOT_UPGRADED_MESSAGE,
        SAVE_SIGHTINGS_THAT_FAILED_UPGRADE,
        SAVE_FAILED_ABORTING_UPGRADE,
        UPGRADED_TAXONOMY_SUCCESSFULLY_TITLE,
        UPGRADED_TAXONOMY_SUCCESSFULLY_MESSAGE,
        OPEN_A_TAXONOMY,
        BTXM_OR_CSV_FILES,
        SAVE_TAXONOMY,
        EXPORT_FAILED_TITLE,
        EXPORT_FAILED_MESSAGE,
        SAVE_TAXONOMY_AS_CSV,
        ADD_OR_UPGRADE_A_TAXONOMY,
        ADD_OR_UPGRADE_A_TAXONOMY_EXPLANATION,
        EXPORT_THIS_TAXONOMY,
        EXPORT_THIS_TAXONOMY_EXPLANATION,
        EXPORT_THIS_TAXONOMY_AS_CSV,
        EXPORT_THIS_TAXONOMY_AS_CSV_EXPLANATION,
        DELETE_THIS_TAXONOMY,
        DELETE_THIS_TAXONOMY_EXPLANATION,
        DOWNLOAD_TAXONOMIES,
        DOWNLOAD_TAXONOMIES_EXPLANATION,
        REMOVE_TAXONOMY_TITLE,
        REMOVE_TAXONOMY_MESSAGE,
        EXCEPTION_TITLE,
        EXCEPTION_MESSAGE,
        REPLACE_TEXT,
        FILE_EXISTS_TITLE,
        FILE_EXISTS_MESSAGE,
        ALL_DIRECTORIES,
        SELECT_TEXT,
        SUBSPECIES_UNSPECIFIED,
        SCYTHEBILL_DOESNT_FIT_TITLE,
        SCYTHEBILL_DOESNT_FIT_MESSAGE,
        COMMON_THEN_SCIENTIFIC,
        SCIENTIFIC_THEN_COMMON,
        COMMON_ONLY,
        SCIENTIFIC_ONLY,
        STATUS_LC,
        STATUS_NE,
        STATUS_DD,
        STATUS_NT,
        STATUS_VU,
        STATUS_EN,
        STATUS_CR,
        STATUS_EW,
        STATUS_EX,
        STATUS_IN,
        STATUS_DO,
        STATUS_UN,
        COULDNT_OPEN_WEB_PAGE_TITLE,
        COULDNT_OPEN_WEB_PAGE_MESSAGE,
        FILE_HAS_BEEN_MODIFIED_TITLE,
        FILE_HAS_BEEN_MODIFIED_MESSAGE,
        FILE_HAS_BEEN_MODIFIED_AND_DIRTY_MESSAGE,
        EXACTLY,
        AT_MOST,
        AT_LEAST,
        LESS_THAN,
        MORE_THAN,
        AUTOMATICALLY_CREATE_TRIPS_TITLE,
        CREATE_ONE_TRIP,
        NO_TRIPS_TO_CREATE,
        CREATE_TRIPS_FORMAT,
        CREATE_TRIPS_EXPLANATION,
        EXCLUDE,
        UNTIL_WHEN,
        BROWSE_BY_TRIPS,
        BROWSE_BY_TRIPS_EXPLANATION,
        AUTOMATICALLY_CREATE_TRIPS,
        HIGHLIGHT_LIFERS_QUESTION,
        MERGE_TRIPS,
        DELETE_TRIP,
        DELETE_TRIP_TITLE,
        DELETE_TRIP_TEXT,
        DELETE_TRIPS,
        DELETE_TRIPS_TITLE,
        DELETE_TRIPS_TEXT,
        MERGE_TRIPS_TITLE,
        MERGE_TRIPS_TEXT,
        NO_TRIPS_EXPLANATION_FORMAT,
        CREATE_TRIP,
        CONVERT_TO_A_TRIP,
        CONVERT_TO_A_TRIP_TITLE,
        CONVERT_TO_A_TRIP_MESSAGE_NOTE,
        CONVERT_TO_A_TRIP_MESSAGE_WARNING,
        TRIP_DETAILS,
        TRIP_NAME_LABEL,
        TRIP_NOTES_LABEL,
        TRIP_END_DATE_MUST_NOT_PRECEDE_START_DATE,
        TRIP_DATE_FORMAT,
        TRIP_DATES_FORMAT,
        START_TYPING_A_TRIP,
        UI_MODE_QUERY,
        UI_MODE_AUTOMATIC,
        UI_MODE_LIGHT,
        UI_MODE_DARK,
        PRIVACY_PREFERENCES,
        USE_GOOGLE_LOCATION_APIS,
        USE_EBIRD_LOCATION_APIS,
        MAP_PROVIDER,
        MAP_PROVIDER_NONE,
        PRIVACY_POLICY_MENU,
        EXPORT_PREFERENCES,
        EXCEL_COMPATIBLE_CSVS,
        ADD_LEFTOVER_PHOTOS,
        ADD_LEFTOVER_PHOTOS_TO_TRIP,
        ADD_LEFTOVER_PHOTOS_TO_VISIT,
        ADD_PHOTOS,
        DROP_PHOTOS;


        public String toString() {
            return Messages.getMessage(this);
        }
    }
}

