/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.io;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.primitives.Ints;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.io.ResponseWriter;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.sighting.Link;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.sighting.VisitInfoKeyOrdering;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.model.util.Abbreviations;
import com.scythebill.birdlist.ui.io.TeeToPlainTextResponseWriter;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import org.joda.time.DateTimeFieldType;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TripReportDocOutput {
    private static final int MAX_LOCATION_IDS_TO_LIST = 3;
    private final QueryResults queryResults;
    private final ReportSet reportSet;
    private final SortedSet<VisitInfoKey> visits;
    private final Location rootLocation;
    private NamesPreferences.ScientificOrCommon scientificOrCommon = NamesPreferences.ScientificOrCommon.COMMON_FIRST;
    private BiMap<String, String> locationIdToAbbreviation;
    private boolean writeItinerary = true;
    private boolean writeSpeciesTable = true;
    private boolean writeSpeciesList = true;
    private boolean allDatesAreTheSameYear;
    private DateTimeFormatter noYearFormatter;
    private String name;
    private Multimap<SightingTaxon.Resolved, SightingTaxon.Resolved> taxaBySpecies;
    private boolean queryHasDateRestriction;
    private boolean includeFavoritePhotos;
    private boolean showAllTaxonomies;
    private ImmutableList<Trip> trips;
    private boolean showStatus;
    private ImmutableSet<String> STRINGS_TO_STRIP = ImmutableSet.of("Part", "part", "(", "[");
    static Abbreviations.AbbreviationConfig abbreviationConfig = new Abbreviations.AbbreviationConfig();

    public TripReportDocOutput(QueryResults queryResults, ReportSet reportSet, Location rootLocation) {
        this.queryResults = queryResults;
        this.reportSet = reportSet;
        this.rootLocation = rootLocation;
        this.visits = new TreeSet<VisitInfoKey>(new VisitInfoKeyOrdering());
        this.visits.addAll(queryResults.getAllVisitInfoKeys());
        this.noYearFormatter = this.noYearFormatter();
        this.taxaBySpecies = this.gatherTaxaIntoSpecies(queryResults.getTaxaAsList());
    }

    public void setWriteItinerary(boolean writeItinerary) {
        this.writeItinerary = writeItinerary;
    }

    public void setWriteSpeciesTable(boolean writeSpeciesTable) {
        this.writeSpeciesTable = writeSpeciesTable;
    }

    public void setWriteSpeciesList(boolean writeSpeciesList) {
        this.writeSpeciesList = writeSpeciesList;
    }

    public void setShowStatus(boolean showStatus) {
        this.showStatus = showStatus;
    }

    public void setIncludeFavoritePhotos(boolean includeFavoritePhotos) {
        this.includeFavoritePhotos = includeFavoritePhotos;
    }

    public void setShowAllTaxonomies(boolean showAllTaxonomies) {
        this.showAllTaxonomies = showAllTaxonomies;
    }

    public void setScientificOrCommon(NamesPreferences.ScientificOrCommon scientificOrCommon) {
        this.scientificOrCommon = scientificOrCommon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setQueryHasDateRestriction(boolean queryHasDateRestriction) {
        this.queryHasDateRestriction = queryHasDateRestriction;
    }

    public void setTrips(Iterable<Trip> trips) {
        ImmutableList<Object> immutableList = this.trips = trips == null ? ImmutableList.of() : ImmutableList.copyOf(trips);
        if (this.name == null && this.trips.size() >= 1) {
            Trip trip;
            String name = Strings.nullToEmpty(((Trip)this.trips.get(0)).name());
            Iterator iterator = Iterables.skip(this.trips, 1).iterator();
            while (iterator.hasNext() && !(name = Strings.commonPrefix(name, Strings.nullToEmpty((trip = iterator.next()).name()))).isEmpty()) {
            }
            for (String stringToStrip : this.STRINGS_TO_STRIP) {
                if (!name.endsWith(stringToStrip)) continue;
                name = name.substring(0, name.length() - stringToStrip.length());
            }
            if (name.length() > 3) {
                this.setName(name);
            }
        }
    }

    public String writeReport(Writer writer) throws IOException {
        this.locationIdToAbbreviation = this.computeLocationAbbreviations();
        if (this.trips == null) {
            this.trips = ImmutableList.of();
        }
        this.allDatesAreTheSameYear = IntStream.concat(IntStream.concat(this.visits.stream().mapToInt(TripReportDocOutput::toYear), this.trips.stream().mapToInt(TripReportDocOutput::toStartYear)), this.trips.stream().mapToInt(TripReportDocOutput::toEndYear)).distinct().count() == 1L;
        TeeToPlainTextResponseWriter out = new TeeToPlainTextResponseWriter(new HtmlResponseWriter(new BufferedWriter(writer), "UTF-8"));
        out.startDocument();
        out.startElement("document");
        out.startElement("body");
        if (!Strings.isNullOrEmpty(this.name)) {
            out.startElement("h1");
            out.writeAttribute("style", "text-align: center");
            out.writeText(this.name);
            if (this.allDatesAreTheSameYear && !this.queryHasDateRestriction) {
                out.writeText(" ");
                if (!this.visits.isEmpty()) {
                    out.writeText(TripReportDocOutput.toYear(this.visits.first()));
                } else if (!this.trips.isEmpty()) {
                    out.writeText(TripReportDocOutput.toStartYear((Trip)this.trips.get(0)));
                }
            }
            out.endElement("h1");
        }
        if (!(this.trips == null || this.trips.size() != 1 && this.writeItinerary)) {
            for (Trip trip : this.trips) {
                if (Strings.isNullOrEmpty(trip.notes())) continue;
                for (String paragraph : Splitter.on('\n').split(trip.notes())) {
                    out.startElement("p");
                    out.write(paragraph);
                    out.endElement("p");
                }
            }
        }
        out.startElement("div");
        if (this.writeItinerary) {
            this.writeItinerary(out);
        }
        if (this.writeSpeciesTable) {
            this.writeSpeciesTable(out);
        }
        if (this.writeSpeciesList) {
            this.writeSpeciesList(out);
        }
        out.endElement("div");
        out.endElement("body");
        out.endElement("document");
        out.endDocument();
        out.flush();
        return out.getPlainText();
    }

    private void writeItinerary(ResponseWriter out) throws IOException {
        Trip trip;
        LinkedHashSet<String> documentedLocationIds = new LinkedHashSet<String>();
        Multimap<ReadablePartial, VisitInfoKey> infoKeysByDate = Multimaps.newMultimap(new LinkedHashMap(), ArrayList::new);
        for (VisitInfoKey visit : this.visits) {
            infoKeysByDate.put(visit.date(), visit);
        }
        ArrayList dates = new ArrayList(infoKeysByDate.keySet());
        ArrayList<Object> optimizedSort = new ArrayList<Object>();
        for (int i = 0; i < dates.size(); ++i) {
            Collection keysForCurrentDate = infoKeysByDate.get((ReadablePartial)dates.get(i));
            if (keysForCurrentDate.size() == 1) {
                optimizedSort.addAll(keysForCurrentDate);
                continue;
            }
            ImmutableSet keysForPreviousDate = i > 0 ? infoKeysByDate.get((ReadablePartial)dates.get(i - 1)) : ImmutableSet.of();
            ImmutableSet locationsForPreviousDate = keysForPreviousDate.stream().map(key -> key.locationId()).collect(ImmutableSet.toImmutableSet());
            ImmutableSet keysForNextDate = i < dates.size() - 1 ? infoKeysByDate.get((ReadablePartial)dates.get(i + 1)) : ImmutableSet.of();
            ImmutableSet locationsForNextDate = keysForNextDate.stream().map(key -> key.locationId()).collect(ImmutableSet.toImmutableSet());
            List keysForCurrentWithNoTime = keysForCurrentDate.stream().filter(key -> !key.startTime().isPresent()).collect(Collectors.toCollection(ArrayList::new));
            ArrayList middleKeys = keysForCurrentDate.stream().filter(key -> key.startTime().isPresent()).collect(Collectors.toCollection(ArrayList::new));
            ArrayList<VisitInfoKey> endKeys = new ArrayList<VisitInfoKey>();
            for (VisitInfoKey key2 : keysForCurrentWithNoTime) {
                if (locationsForPreviousDate.contains(key2.locationId())) {
                    optimizedSort.add(key2);
                    continue;
                }
                if (locationsForNextDate.contains(key2.locationId())) {
                    endKeys.add(key2);
                    continue;
                }
                middleKeys.add(key2);
            }
            optimizedSort.addAll(middleKeys);
            optimizedSort.addAll(endKeys);
        }
        if (optimizedSort.size() == 0 && (this.trips == null || this.trips.size() <= 1)) {
            return;
        }
        class TripOrVisitInfoKey {
            final Trip trip;
            final VisitInfoKey visitInfoKey;

            TripOrVisitInfoKey(Trip trip) {
                this.trip = trip;
                this.visitInfoKey = null;
            }

            TripOrVisitInfoKey(VisitInfoKey visitInfoKey) {
                this.trip = null;
                this.visitInfoKey = visitInfoKey;
            }
        }
        ArrayList<TripOrVisitInfoKey> tripsAndVisits = new ArrayList<TripOrVisitInfoKey>();
        if (this.trips == null || this.trips.size() <= 1) {
            optimizedSort.forEach(v -> tripsAndVisits.add(new TripOrVisitInfoKey((VisitInfoKey)v)));
        } else {
            int visitIndex = 0;
            int tripIndex = 0;
            while (visitIndex < optimizedSort.size() || tripIndex < this.trips.size()) {
                if (visitIndex >= optimizedSort.size()) {
                    tripsAndVisits.add(new TripOrVisitInfoKey((Trip)this.trips.get(tripIndex++)));
                    continue;
                }
                if (tripIndex >= this.trips.size()) {
                    tripsAndVisits.add(new TripOrVisitInfoKey((VisitInfoKey)optimizedSort.get(visitIndex++)));
                    continue;
                }
                trip = (Trip)this.trips.get(tripIndex);
                VisitInfoKey visit = (VisitInfoKey)optimizedSort.get(visitIndex);
                if (SightingComparators.comparePartials(trip.startDate(), visit.date()) <= 0) {
                    tripsAndVisits.add(new TripOrVisitInfoKey((Trip)this.trips.get(tripIndex++)));
                    continue;
                }
                tripsAndVisits.add(new TripOrVisitInfoKey((VisitInfoKey)optimizedSort.get(visitIndex++)));
            }
        }
        out.startElement("ul");
        for (int i = 0; i < tripsAndVisits.size(); ++i) {
            TripOrVisitInfoKey tripOrVisit = (TripOrVisitInfoKey)tripsAndVisits.get(i);
            out.startElement("li");
            if (tripOrVisit.visitInfoKey != null) {
                Optional<String> comments;
                VisitInfoKey visit = tripOrVisit.visitInfoKey;
                VisitInfo visitInfo = this.reportSet.getVisitInfo(visit);
                VisitInfoKey endVisitKey = null;
                int endVisitIndex = -1;
                if (!this.visitInfoComments(visitInfo).isPresent()) {
                    int j = i + 1;
                    while (j < tripsAndVisits.size()) {
                        VisitInfoKey laterVisit;
                        TripOrVisitInfoKey tripOrVisitInfoKey = (TripOrVisitInfoKey)tripsAndVisits.get(j);
                        if (tripOrVisitInfoKey.visitInfoKey == null || !(laterVisit = tripOrVisitInfoKey.visitInfoKey).locationId().equals(visit.locationId()) || this.visitInfoComments(this.reportSet.getVisitInfo(laterVisit)).isPresent()) break;
                        endVisitKey = laterVisit;
                        endVisitIndex = j++;
                    }
                }
                ReadablePartial date = visit.date();
                out.write(this.dateToString(date));
                if (visit.startTime().isPresent()) {
                    out.writeText(" ");
                    out.writeText(TimeIO.toShortUserString(visit.startTime().get(), Locale.getDefault()));
                }
                if (endVisitKey != null) {
                    out.writeText(" - ");
                    out.write(this.dateToString(endVisitKey.date()));
                    if (endVisitKey.startTime().isPresent()) {
                        out.writeText(" ");
                        endTime = endVisitKey.startTime().get();
                        VisitInfo endVisitInfo = this.reportSet.getVisitInfo(endVisitKey);
                        if (endVisitInfo != null && endVisitInfo.duration().isPresent()) {
                            endTime = endTime.plusSeconds(Ints.saturatedCast(endVisitInfo.duration().get().getStandardSeconds()));
                        }
                        out.writeText(TimeIO.toShortUserString(endTime, Locale.getDefault()));
                    }
                    i = endVisitIndex;
                } else if (visit.startTime().isPresent() && visitInfo != null && visitInfo.duration().isPresent()) {
                    endTime = visit.startTime().get().plusSeconds(Ints.saturatedCast(visitInfo.duration().get().getStandardSeconds()));
                    out.writeText(" - ");
                    out.writeText(TimeIO.toShortUserString(endTime, Locale.getDefault()));
                }
                out.writeText(": ");
                out.writeText(this.locationName(visit));
                if (this.writeSpeciesList && !documentedLocationIds.contains(visit.locationId()) && this.locationIdToAbbreviation.containsKey(visit.locationId())) {
                    documentedLocationIds.add(visit.locationId());
                    out.writeText(" (");
                    out.writeText(this.locationIdToAbbreviation.get(visit.locationId()));
                    out.writeText(")");
                }
                if ((comments = this.visitInfoComments(visitInfo)).isPresent()) {
                    out.startElement("br");
                    out.endElement("br");
                    out.writeText(comments.get());
                }
            } else {
                trip = tripOrVisit.trip;
                out.writeText(this.dateToString(trip.startDate()));
                if (!trip.startDate().equals(trip.endDate())) {
                    out.writeText("-");
                    out.writeText(this.dateToString(trip.endDate()));
                }
                if (trip.locationId() != null) {
                    out.writeText(": ");
                    out.writeText(this.locationName(trip.locationId()));
                    if (this.writeSpeciesList && !documentedLocationIds.contains(trip.locationId()) && this.locationIdToAbbreviation.containsKey(trip.locationId())) {
                        documentedLocationIds.add(trip.locationId());
                        out.writeText(" (");
                        out.writeText(this.locationIdToAbbreviation.get(trip.locationId()));
                        out.writeText(")");
                    }
                }
                if (!Strings.isNullOrEmpty(trip.notes())) {
                    for (String note : Splitter.on('\n').split(trip.notes())) {
                        out.startElement("br");
                        out.writeText(note);
                        out.endElement("br");
                    }
                }
            }
            out.endElement("li");
        }
        out.endElement("ul");
    }

    private Optional<String> visitInfoComments(VisitInfo visitInfo) {
        if (visitInfo == null) {
            return Optional.empty();
        }
        if (!visitInfo.comments().isPresent()) {
            return Optional.empty();
        }
        String comments = visitInfo.comments().get();
        int indexOfSubmittedFrom = comments.indexOf("<br />Submitted from");
        if (indexOfSubmittedFrom >= 0) {
            comments = comments.substring(0, indexOfSubmittedFrom);
        }
        if ((comments = CharMatcher.whitespace().trimFrom(comments)).isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(comments);
    }

    private void writeSpeciesTable(ResponseWriter out) throws IOException {
        ImmutableList dates = this.visits.stream().map(VisitInfoKey::date).distinct().collect(ImmutableList.toImmutableList());
        if (dates.isEmpty()) {
            return;
        }
        out.startElement("table");
        out.writeAttribute("border", 1);
        out.writeAttribute("cellspacing", 0);
        out.startElement("tr");
        out.startElement("th");
        out.endElement("th");
        if (!(this.writeSpeciesList || this.scientificOrCommon != NamesPreferences.ScientificOrCommon.COMMON_FIRST && this.scientificOrCommon != NamesPreferences.ScientificOrCommon.SCIENTIFIC_FIRST)) {
            out.startElement("th");
            out.endElement("th");
        }
        for (ReadablePartial date : dates) {
            out.startElement("th");
            out.writeText(this.dateToString(date));
            out.endElement("th");
        }
        out.endElement("tr");
        for (SightingTaxon.Resolved taxon : this.queryResults.getTaxaAsList()) {
            if (taxon.getSmallestTaxonType() == Taxon.Type.family) continue;
            out.startElement("tr");
            switch (this.scientificOrCommon) {
                case COMMON_FIRST: {
                    out.startElement("th");
                    out.writeAttribute("style", "text-align:left");
                    out.writeText(taxon.getCommonName());
                    out.endElement("th");
                    if (this.writeSpeciesList) break;
                }
                case SCIENTIFIC_ONLY: {
                    out.startElement("th");
                    out.writeAttribute("style", "text-align:left");
                    out.startElement("i");
                    out.writeText(taxon.getFullName());
                    out.endElement("i");
                    out.endElement("th");
                    break;
                }
                case SCIENTIFIC_FIRST: {
                    out.startElement("th");
                    out.writeAttribute("style", "text-align:left");
                    out.startElement("i");
                    out.writeText(taxon.getFullName());
                    out.endElement("i");
                    out.endElement("th");
                    if (this.writeSpeciesList) break;
                }
                case COMMON_ONLY: {
                    out.startElement("th");
                    out.writeAttribute("style", "text-align:left");
                    out.writeText(taxon.getCommonName());
                    out.endElement("th");
                }
            }
            ImmutableListMultimap sightingsByDate = Multimaps.index(this.queryResults.getAllSightings(taxon).stream().filter(s -> s.getStoredDateAsPartial() != null).iterator(), Sighting::getStoredDateAsPartial);
            for (ReadablePartial date : dates) {
                out.startElement("td");
                out.writeText(this.textForSightings(sightingsByDate.get(date)));
                out.endElement("td");
            }
            out.endElement("tr");
        }
        out.endElement("table");
    }

    private void writeSpeciesList(ResponseWriter out) throws IOException {
        LinkedHashSet<String> usedAbbreviations = new LinkedHashSet<String>();
        VisitInfoKeyOrdering visitInfoKeyOrdering = new VisitInfoKeyOrdering();
        out.startElement("ol");
        for (SightingTaxon.Resolved species : this.taxaBySpecies.keySet()) {
            out.startElement("li");
            Collection<SightingTaxon.Resolved> taxaInSpecies = this.taxaBySpecies.get(species);
            if (taxaInSpecies.size() == 1) {
                SightingTaxon.Resolved resolved = taxaInSpecies.iterator().next();
                this.writeTaxonListText(out, resolved);
                this.writeTaxonListSightingText(out, visitInfoKeyOrdering, resolved, this.queryResults.getAllSightings(resolved), usedAbbreviations);
            } else {
                this.writeTaxonListText(out, species);
                out.startElement("ul");
                for (SightingTaxon.Resolved taxonInSpecies : taxaInSpecies) {
                    out.startElement("li");
                    this.writeAbbreviatedTaxonListText(out, species, taxonInSpecies);
                    this.writeTaxonListSightingText(out, visitInfoKeyOrdering, taxonInSpecies, this.queryResults.getAllSightings(taxonInSpecies), usedAbbreviations);
                    out.endElement("li");
                }
                out.endElement("ul");
            }
            out.endElement("li");
        }
        out.endElement("ol");
        if (this.showAllTaxonomies) {
            for (Taxonomy taxonomy : this.queryResults.getIncompatibleTaxonomies()) {
                out.startElement("br");
                out.endElement("br");
                out.startElement("h2");
                out.writeText(taxonomy.getName());
                out.endElement("h2");
                out.startElement("ol");
                for (SightingTaxon.Resolved resolved : this.queryResults.getIncompatibleTaxaAsList(taxonomy, false)) {
                    out.startElement("li");
                    this.writeTaxonListText(out, resolved);
                    this.writeTaxonListSightingText(out, visitInfoKeyOrdering, resolved, this.queryResults.getAllSightings(resolved), usedAbbreviations);
                    out.endElement("li");
                }
                out.endElement("ol");
            }
        }
        if (!this.writeItinerary) {
            out.startElement("p");
            TreeSet abbreviations = new TreeSet(usedAbbreviations);
            out.writeText(abbreviations.stream().map(abbreviation -> String.format("%s - %s", abbreviation, this.locationName((String)this.locationIdToAbbreviation.inverse().get(abbreviation)))).collect(Collectors.joining(", ")));
            out.endElement("p");
        }
    }

    private void writeTaxonListSightingText(ResponseWriter out, VisitInfoKeyOrdering visitInfoKeyOrdering, SightingTaxon.Resolved taxon, Collection<Sighting> taxonSightings, Set<String> usedAbbreviations) throws IOException {
        ImmutableSet locationIds = taxonSightings.stream().map(VisitInfoKey::forSighting).filter(key -> key != null).sorted(visitInfoKeyOrdering).map(VisitInfoKey::locationId).filter(this.locationIdToAbbreviation::containsKey).collect(ImmutableSet.toImmutableSet());
        boolean writtenSightingDescription = false;
        if (locationIds.size() <= 3) {
            String abbreviation;
            ImmutableList locationSightings;
            out.writeText("\t");
            out.writeText("(");
            boolean firstLocation = true;
            for (String locationId : locationIds) {
                locationSightings = taxonSightings.stream().filter(s -> locationId.equals(s.getLocationId())).collect(ImmutableList.toImmutableList());
                if (!firstLocation) {
                    out.writeText(", ");
                }
                firstLocation = false;
                abbreviation = (String)this.locationIdToAbbreviation.get(locationId);
                usedAbbreviations.add(abbreviation);
                out.writeText(abbreviation);
                if (Iterables.all(locationSightings, TripReportDocOutput::isHeardOnly)) {
                    out.writeText(" (H)");
                }
                if (locationIds.size() != 1) continue;
                for (Sighting sighting : locationSightings) {
                    if (!sighting.hasSightingInfo() || Strings.isNullOrEmpty(sighting.getSightingInfo().getDescription())) continue;
                    if (writtenSightingDescription) {
                        out.startElement("br");
                        out.endElement("br");
                    } else {
                        out.writeText(Character.valueOf('\t'));
                        writtenSightingDescription = true;
                    }
                    out.writeText(sighting.getSightingInfo().getDescription());
                }
            }
            out.writeText(")");
            if (locationIds.size() > 1) {
                for (String locationId : locationIds) {
                    locationSightings = taxonSightings.stream().filter(s -> locationId.equals(s.getLocationId())).collect(ImmutableList.toImmutableList());
                    abbreviation = (String)this.locationIdToAbbreviation.get(locationId);
                    for (Sighting sighting : locationSightings) {
                        if (!sighting.hasSightingInfo() || Strings.isNullOrEmpty(sighting.getSightingInfo().getDescription())) continue;
                        if (writtenSightingDescription) {
                            out.startElement("br");
                            out.endElement("br");
                        } else {
                            out.writeText(Character.valueOf('\t'));
                            writtenSightingDescription = true;
                        }
                        out.writeText(abbreviation);
                        out.writeText(": ");
                        out.writeText(sighting.getSightingInfo().getDescription());
                    }
                }
            }
        }
        for (Sighting sighting : taxonSightings) {
            String abbreviation;
            if (VisitInfoKey.forSighting(sighting) != null || !sighting.hasSightingInfo() || Strings.isNullOrEmpty(sighting.getSightingInfo().getDescription())) continue;
            if (writtenSightingDescription) {
                out.startElement("br");
                out.endElement("br");
            } else {
                out.writeText(Character.valueOf('\t'));
                writtenSightingDescription = true;
            }
            if (sighting.getLocationId() != null && (abbreviation = (String)this.locationIdToAbbreviation.get(sighting.getLocationId())) != null) {
                out.writeText(abbreviation);
                out.writeText(": ");
            }
            out.writeText(sighting.getSightingInfo().getDescription());
        }
        if (this.includeFavoritePhotos) {
            ImmutableList favoriteFilePhotos = taxonSightings.stream().filter(Sighting::hasSightingInfo).map(Sighting::getSightingInfo).map(SightingInfo::getPhotos).flatMap(Collection::stream).filter(Link::isFileBased).filter(Photo::isFavorite).collect(ImmutableList.toImmutableList());
            for (Photo photo : favoriteFilePhotos) {
                try {
                    BufferedImage image = ImageIO.read(photo.toFile());
                    if (image == null) continue;
                    int width = image.getWidth();
                    int height = image.getHeight();
                    int largest = Math.max(width, height);
                    out.startElement("br");
                    out.endElement("br");
                    out.startElement("img");
                    out.writeAttribute("src", photo.getUri().toASCIIString());
                    int maxSize = 450;
                    if (largest > maxSize) {
                        out.writeAttribute("width", (int)((double)width * ((double)maxSize / (double)largest)));
                        out.writeAttribute("height", (int)((double)height * ((double)maxSize / (double)largest)));
                    }
                    out.endElement("img");
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeTaxonListText(ResponseWriter out, SightingTaxon.Resolved taxon) throws IOException {
        boolean showInBold;
        boolean bl = showInBold = !this.queryResults.hasAnnotation(QueryDefinition.QueryAnnotation.LIFER) || this.queryResults.containsAnnotation(QueryDefinition.QueryAnnotation.LIFER, taxon);
        if (showInBold) {
            out.startElement("b");
        }
        switch (this.scientificOrCommon) {
            case COMMON_FIRST: {
                out.writeText(this.getCommonNameAtLeastAtGroup(taxon));
                out.writeText("\t(");
                out.startElement("i");
                out.writeText(taxon.getFullName());
                out.endElement("i");
                out.writeText(")");
                break;
            }
            case COMMON_ONLY: {
                out.writeText(taxon.getCommonName());
                break;
            }
            case SCIENTIFIC_FIRST: {
                out.writeText(taxon.getFullName());
                out.writeText("\t");
                out.startElement("i");
                out.writeText(this.getCommonNameAtLeastAtGroup(taxon));
                out.endElement("i");
                break;
            }
            case SCIENTIFIC_ONLY: {
                out.writeText(taxon.getFullName());
            }
        }
        if (showInBold) {
            out.endElement("b");
        }
        this.writeChecklistInfo(out, taxon);
    }

    private void writeChecklistInfo(ResponseWriter out, SightingTaxon.Resolved taxon) throws IOException {
        Species.Status taxonStatus;
        SightingTaxon species;
        Checklist checklist = this.queryResults.getChecklist(taxon.getTaxonomy());
        if (checklist != null && (species = taxon.getParentOfAtLeastType(Taxon.Type.species)).getType() == SightingTaxon.Type.SINGLE) {
            Checklist.Status status = checklist.getStatus(taxon.getTaxonomy(), species);
            if (status == Checklist.Status.ENDEMIC) {
                out.writeText(" - " + Messages.getMessage(Messages.Name.CHECKLIST_STATUS_ENDEMIC).toLowerCase());
            } else if (status == Checklist.Status.INTRODUCED) {
                out.writeText(" - " + Messages.getMessage(Messages.Name.CHECKLIST_STATUS_INTRODUCED).toLowerCase());
            } else if (status == Checklist.Status.ESCAPED) {
                out.writeText(" - " + Messages.getMessage(Messages.Name.CHECKLIST_STATUS_NOT_ESTABLISHED).toLowerCase());
            } else if (status == Checklist.Status.RARITY || status == Checklist.Status.RARITY_FROM_INTRODUCED) {
                out.writeText(" - " + Messages.getMessage(Messages.Name.CHECKLIST_STATUS_RARITY).toLowerCase());
            }
        }
        if (this.showStatus && (taxonStatus = taxon.getTaxonStatus()) != Species.Status.LC && taxonStatus != Species.Status.NT) {
            out.writeText(" - " + taxonStatus.name());
        }
    }

    private String getCommonNameAtLeastAtGroup(SightingTaxon.Resolved taxon) {
        if (taxon.getSmallestTaxonType() != Taxon.Type.subspecies) {
            return taxon.getCommonName();
        }
        taxon = taxon.getParentOfAtLeastType(Taxon.Type.group).resolveInternal(taxon.getTaxonomy());
        return taxon.getCommonName();
    }

    private void writeAbbreviatedTaxonListText(ResponseWriter out, SightingTaxon.Resolved species, SightingTaxon.Resolved taxonInSpecies) throws IOException {
        Species.Status taxonStatus;
        boolean isLifer = this.queryResults.containsAnnotation(QueryDefinition.QueryAnnotation.LIFER, taxonInSpecies);
        if (isLifer) {
            out.startElement("b");
        }
        switch (this.scientificOrCommon) {
            case COMMON_FIRST: {
                if (!taxonInSpecies.hasCommonName()) {
                    out.writeText(taxonInSpecies.getName());
                    break;
                }
                out.writeText(this.abbreviatedCommonName(species, taxonInSpecies));
                out.writeText(" (");
                out.startElement("i");
                out.writeText(taxonInSpecies.getName());
                out.endElement("i");
                out.writeText(")");
                break;
            }
            case COMMON_ONLY: {
                out.writeText(this.abbreviatedCommonName(species, taxonInSpecies));
                break;
            }
            case SCIENTIFIC_FIRST: {
                out.writeText(taxonInSpecies.getName());
                if (taxonInSpecies.hasCommonName()) break;
                out.writeText(" - ");
                out.startElement("i");
                out.writeText(this.abbreviatedCommonName(species, taxonInSpecies));
                out.endElement("i");
                break;
            }
            case SCIENTIFIC_ONLY: {
                out.writeText(taxonInSpecies.getName());
            }
        }
        if (isLifer) {
            out.endElement("b");
        }
        if (this.showStatus && (taxonStatus = taxonInSpecies.getTaxonStatus()) != Species.Status.LC && taxonStatus != Species.Status.NT) {
            out.writeText(" - " + taxonStatus.name());
        }
    }

    private String abbreviatedCommonName(SightingTaxon.Resolved species, SightingTaxon.Resolved taxonInSpecies) {
        String speciesCommon = species.getCommonName();
        String name = taxonInSpecies.getCommonName();
        if (name.startsWith(speciesCommon)) {
            name = name.substring(speciesCommon.length());
            name = name.trim();
        }
        return name;
    }

    private Multimap<SightingTaxon.Resolved, SightingTaxon.Resolved> gatherTaxaIntoSpecies(Collection<SightingTaxon.Resolved> taxa) {
        LinkedHashMultimap<SightingTaxon.Resolved, SightingTaxon.Resolved> multimap = LinkedHashMultimap.create(taxa.size(), 2);
        for (SightingTaxon.Resolved taxon : taxa) {
            if (!taxon.getSmallestTaxonType().isAtOrLowerLevelThan(Taxon.Type.species)) continue;
            if (taxon.getSmallestTaxonType() == Taxon.Type.species) {
                multimap.put((Object)taxon, (Object)taxon);
                continue;
            }
            SightingTaxon.Resolved species = taxon.getParentOfAtLeastType(Taxon.Type.species).resolveInternal(taxon.getTaxonomy());
            multimap.put((Object)species, (Object)taxon);
        }
        return multimap;
    }

    private BiMap<String, String> computeLocationAbbreviations() {
        Optional<String> abbreviation;
        String locationId;
        HashBiMap<String, String> locationIdToAbbreviation = HashBiMap.create();
        for (VisitInfoKey visit : this.visits) {
            locationId = visit.locationId();
            if (locationIdToAbbreviation.containsKey(locationId)) continue;
            abbreviation = Abbreviations.abbreviate(this.locationName(visit), locationIdToAbbreviation::containsValue, abbreviationConfig);
            if (!abbreviation.isPresent()) continue;
            locationIdToAbbreviation.put(locationId, abbreviation.get());
        }
        if (this.trips != null && this.trips.size() > 1) {
            for (Trip trip : this.trips) {
                locationId = trip.locationId();
                if (locationId == null || locationIdToAbbreviation.containsKey(locationId)) continue;
                abbreviation = Abbreviations.abbreviate(this.locationName(trip.locationId()), locationIdToAbbreviation::containsValue, abbreviationConfig);
                if (!abbreviation.isPresent()) continue;
                locationIdToAbbreviation.put(locationId, abbreviation.get());
            }
        }
        return locationIdToAbbreviation;
    }

    private String textForSightings(Collection<Sighting> collection) {
        if (collection.isEmpty()) {
            return "";
        }
        if (Iterables.all(collection, TripReportDocOutput::isHeardOnly)) {
            return "(H)";
        }
        int count = 0;
        for (Sighting sighting : collection) {
            if (!sighting.hasSightingInfo() || sighting.getSightingInfo().getNumber() == null) continue;
            count += sighting.getSightingInfo().getNumber().getNumber();
        }
        if (count > 0) {
            return DecimalFormat.getNumberInstance().format(count);
        }
        return "X";
    }

    private static boolean isHeardOnly(Sighting sighting) {
        return sighting.hasSightingInfo() && sighting.getSightingInfo().isHeardOnly();
    }

    private String dateToString(ReadablePartial date) {
        if (this.allDatesAreTheSameYear && this.noYearFormatter != null && date.isSupported(DateTimeFieldType.dayOfMonth()) && date.isSupported(DateTimeFieldType.monthOfYear())) {
            return this.noYearFormatter.print(date);
        }
        return PartialIO.toShortUserString(date, Locale.getDefault());
    }

    private DateTimeFormatter noYearFormatter() {
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        if (!(dateFormat instanceof SimpleDateFormat)) {
            return null;
        }
        String pattern = ((SimpleDateFormat)dateFormat).toPattern();
        pattern = pattern.replace("y", "").replace("Y", "");
        pattern = CharMatcher.anyOf("MLwWDd").negate().trimFrom(pattern);
        return DateTimeFormat.forPattern(pattern);
    }

    private String locationName(VisitInfoKey visit) {
        return this.locationName(visit.locationId());
    }

    private String locationName(String locationId) {
        return LocationIdToString.getString(this.reportSet.getLocations(), locationId, false, this.rootLocation);
    }

    private static int toYear(VisitInfoKey visitInfoKey) {
        ReadablePartial date = visitInfoKey.date();
        if (!date.isSupported(DateTimeFieldType.year())) {
            return 0;
        }
        return date.get(DateTimeFieldType.year());
    }

    private static int toStartYear(Trip trip) {
        ReadablePartial date = trip.startDate();
        if (!date.isSupported(DateTimeFieldType.year())) {
            return 0;
        }
        return date.get(DateTimeFieldType.year());
    }

    private static int toEndYear(Trip trip) {
        ReadablePartial date = trip.endDate();
        if (!date.isSupported(DateTimeFieldType.year())) {
            return 0;
        }
        return date.get(DateTimeFieldType.year());
    }

    static {
        TripReportDocOutput.abbreviationConfig.ignoredCharacters = CharMatcher.anyOf("-/.,()'\"").or(CharMatcher.inRange('0', '9'));
        TripReportDocOutput.abbreviationConfig.maxPerWordChars = 4;
        TripReportDocOutput.abbreviationConfig.maxWords = 5;
        TripReportDocOutput.abbreviationConfig.minLength = 2;
    }
}

