/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.io;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.scythebill.birdlist.model.io.ResponseWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;

class TeeToPlainTextResponseWriter
extends ResponseWriter {
    private final StringBuilder plainTextBuffer = new StringBuilder();
    private final ResponseWriter inner;
    private final ArrayDeque<Object> listDeque = new ArrayDeque();
    private String lineIndent = "";
    private ArrayList<ArrayList<StringBuilder>> currentTable = null;

    public TeeToPlainTextResponseWriter(ResponseWriter inner) {
        this.inner = inner;
    }

    public String getPlainText() {
        return this.plainTextBuffer.toString();
    }

    @Override
    public void startDocument() throws IOException {
        this.inner.startDocument();
    }

    @Override
    public void endDocument() throws IOException {
        this.inner.endDocument();
    }

    @Override
    public void writeAttribute(String name, Object value) throws IOException {
        this.inner.writeAttribute(name, value);
    }

    @Override
    public void writeComment(Object comment) throws IOException {
        this.inner.writeComment(comment);
    }

    @Override
    public void writeText(char[] buffer, int offset, int length) throws IOException {
        this.inner.writeText(buffer, offset, length);
        this.writeToBuffer(buffer, offset, length);
    }

    @Override
    public void writeText(Object text) throws IOException {
        this.inner.writeText(text);
        this.writeToBuffer(text.toString());
    }

    @Override
    public void startElement(String name, Object objectFor) throws IOException {
        this.inner.startElement(name, objectFor);
        if (name.equals("br")) {
            this.newLineWithIndent();
        } else if (name.equals("ul")) {
            this.listDeque.push((Object)UnorderedList.element);
            this.updateLineIndent();
            this.newLineWithIndent();
        } else if (name.equals("ol")) {
            this.listDeque.push(0);
            this.updateLineIndent();
            this.newLineWithIndent();
        } else if (name.equals("li")) {
            Object peek = this.listDeque.peek();
            if (peek == UnorderedList.element) {
                this.writeToBuffer("\t");
            } else {
                int elementCount = (Integer)peek + 1;
                this.listDeque.pop();
                this.listDeque.push(elementCount);
                this.writeToBuffer(String.format("%d\t", elementCount));
            }
        } else if (name.equals("th") || name.equals("td")) {
            if (this.currentTable == null) {
                throw new IllegalStateException("Not in table");
            }
            if (this.currentTable.isEmpty()) {
                throw new IllegalStateException("Not in table row");
            }
            Iterables.getLast(this.currentTable).add(new StringBuilder());
        } else if (name.equals("tr")) {
            if (this.currentTable == null) {
                throw new IllegalStateException("Not in a table");
            }
            this.currentTable.add(new ArrayList());
        } else if (name.equals("table")) {
            this.currentTable = new ArrayList();
        }
    }

    @Override
    public void endElement(String name) throws IOException {
        this.inner.endElement(name);
        if (name.equals("p") || name.equals("div")) {
            this.writeToBuffer(System.lineSeparator());
            this.writeToBuffer(System.lineSeparator());
        } else if (name.equals("ul") || name.equals("ol")) {
            this.writeToBuffer(System.lineSeparator());
            this.listDeque.pop();
            this.updateLineIndent();
        } else if (name.equals("li")) {
            this.newLineWithIndent();
        } else if (name.equals("table")) {
            if (!this.currentTable.isEmpty()) {
                ArrayList<ArrayList<StringBuilder>> previousTable = this.currentTable;
                this.currentTable = null;
                int columnCount = previousTable.stream().mapToInt(ArrayList::size).max().getAsInt();
                if (columnCount > 0) {
                    StringBuilder cell;
                    int i;
                    int[] columnWidth = new int[columnCount];
                    for (ArrayList<StringBuilder> row : previousTable) {
                        for (i = 0; i < row.size(); ++i) {
                            cell = row.get(i);
                            columnWidth[i] = Math.max(columnWidth[i], cell.length());
                        }
                    }
                    for (ArrayList<StringBuilder> row : previousTable) {
                        this.newLineWithIndent();
                        for (i = 0; i < row.size(); ++i) {
                            cell = row.get(i);
                            this.writeToBuffer(cell.toString());
                            this.writeToBuffer(Strings.repeat(" ", 2 + columnWidth[i] - cell.length()));
                        }
                    }
                }
            }
            this.writeToBuffer(System.lineSeparator());
            this.writeToBuffer(System.lineSeparator());
        }
    }

    @Override
    public ResponseWriter cloneWithWriter(Writer writer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeRawText(String text) throws IOException {
        this.inner.writeRawText(text);
        this.writeToBuffer(text);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.inner.write(cbuf, off, len);
        this.writeToBuffer(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.inner.flush();
    }

    @Override
    public void close() throws IOException {
        this.inner.close();
    }

    private void updateLineIndent() {
        this.lineIndent = Strings.repeat("  ", this.listDeque.size());
    }

    private void newLineWithIndent() {
        this.writeToBuffer(System.lineSeparator());
        this.writeToBuffer(this.lineIndent);
    }

    private void writeToBuffer(String s) {
        ArrayList<StringBuilder> row;
        if (this.currentTable != null && !this.currentTable.isEmpty() && !(row = Iterables.getLast(this.currentTable)).isEmpty()) {
            Iterables.getLast(row).append(s);
            return;
        }
        this.plainTextBuffer.append(s);
    }

    private void writeToBuffer(char[] cbuf, int off, int len) {
        ArrayList<StringBuilder> row;
        if (this.currentTable != null && !this.currentTable.isEmpty() && !(row = Iterables.getLast(this.currentTable)).isEmpty()) {
            Iterables.getLast(row).append(cbuf, off, len);
            return;
        }
        this.plainTextBuffer.append(cbuf, off, len);
    }

    private static enum UnorderedList {
        element;

    }
}

