/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.io;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.UserOutput;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.ss.util.DateFormatConverter;
import org.apache.poi.ss.util.WorkbookUtil;
import org.joda.time.DateTimeFieldType;
import org.joda.time.ReadablePartial;

public class ReportXlsOutput {
    private final File file;
    private final QueryResults queryResults;
    private final LocationSet locations;
    private boolean showStatus;
    private boolean showFamilyTotals;
    private Location rootLocation;
    private int sightingsCount = 1;
    private boolean showFamilies;
    private boolean showNotes;
    private boolean sortAllSightings;
    private CellStyle scientificStyle;
    private CellStyle dateStyle;
    private boolean showSpeciesLifers;
    private boolean showGroupLifers;
    private boolean showSspLifers;
    private Set<SightingTaxon.Resolved> lifers = ImmutableSet.of();
    private Set<SightingTaxon.Resolved> groupLifers = ImmutableSet.of();
    private Set<SightingTaxon.Resolved> sspLifers = ImmutableSet.of();
    private NamesPreferences.ScientificOrCommon scientificOrCommon;
    private UserOutput userOutput = UserOutput.NONE;
    private boolean omitSpAndHybrid = false;
    private boolean showAllTaxonomies = false;
    private CellStyle headerStyle;
    private int countableCount = 0;

    public ReportXlsOutput(File file, QueryResults queryResults, LocationSet locations) {
        this.file = file;
        this.queryResults = queryResults;
        this.locations = locations;
    }

    public void writeSpeciesList(Ordering<Sighting> speciesOrdering, Ordering<Sighting> sightingOrdering) throws IOException {
        try (HSSFWorkbook workbook = new HSSFWorkbook();){
            this.headerStyle = workbook.createCellStyle();
            Font headerFont = workbook.createFont();
            headerFont.setBold(true);
            this.headerStyle.setFont(headerFont);
            CellStyle familyStyle = workbook.createCellStyle();
            Font familyFont = workbook.createFont();
            familyFont.setBold(true);
            familyStyle.setFont(familyFont);
            this.dateStyle = workbook.createCellStyle();
            String formatPattern = DateFormatConverter.convert(Locale.getDefault(), DateFormat.getDateInstance(3));
            short dateFormat = workbook.getCreationHelper().createDataFormat().getFormat(formatPattern);
            this.dateStyle.setDataFormat(dateFormat);
            this.scientificStyle = workbook.createCellStyle();
            Font scientificFont = workbook.createFont();
            scientificFont.setItalic(true);
            this.scientificStyle.setFont(scientificFont);
            Sheet sheet = workbook.createSheet(this.sanitizeTaxonomyName(this.queryResults.getTaxonomy().getName()));
            List<SightingTaxon.Resolved> taxa = this.queryResults.getTaxaAsList();
            this.writeTaxa(speciesOrdering, sightingOrdering, headerFont, familyStyle, sheet, this.queryResults.getTaxonomy(), taxa);
            if (this.showAllTaxonomies) {
                for (Taxonomy taxonomy : this.queryResults.getIncompatibleTaxonomies()) {
                    List<SightingTaxon.Resolved> incompatibleTaxa = this.queryResults.getIncompatibleTaxaAsList(taxonomy, this.showFamilies);
                    if (incompatibleTaxa.isEmpty()) continue;
                    sheet = workbook.createSheet(this.sanitizeTaxonomyName(taxonomy.getName()));
                    this.writeTaxa(speciesOrdering, sightingOrdering, headerFont, familyStyle, sheet, taxonomy, incompatibleTaxa);
                }
            }
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.file));){
                workbook.write(out);
            }
        }
    }

    private String sanitizeTaxonomyName(String name) {
        return WorkbookUtil.createSafeSheetName(name);
    }

    private void writeTaxa(Ordering<Sighting> speciesOrdering, Ordering<Sighting> sightingOrdering, Font headerFont, CellStyle familyStyle, Sheet sheet, Taxonomy taxonomy, List<SightingTaxon.Resolved> taxa) {
        Row row;
        this.countableCount = 0;
        Row header = sheet.createRow(0);
        int columnNumber = 0;
        boolean showLifers = !this.queryResults.getSightingsWithAnnotation(QueryDefinition.QueryAnnotation.LIFER).isEmpty();
        this.showSpeciesLifers = false;
        this.showGroupLifers = false;
        this.showSspLifers = false;
        if (showLifers) {
            this.lifers = this.queryResults.getTaxaWithAnnotation(taxonomy, QueryDefinition.QueryAnnotation.LIFER, Taxon.Type.species);
            boolean bl = this.showSpeciesLifers = !this.lifers.isEmpty();
            if (this.queryResults.getSmallestType() != Taxon.Type.species) {
                this.groupLifers = this.queryResults.getTaxaWithAnnotation(taxonomy, QueryDefinition.QueryAnnotation.LIFER, Taxon.Type.group);
                boolean bl2 = this.showGroupLifers = this.groupLifers.size() != this.lifers.size();
                if (this.queryResults.getSmallestType() == Taxon.Type.subspecies) {
                    this.sspLifers = this.queryResults.getTaxaWithAnnotation(taxonomy, QueryDefinition.QueryAnnotation.LIFER, Taxon.Type.subspecies);
                    boolean bl3 = this.showSspLifers = this.groupLifers.size() != this.sspLifers.size();
                }
            }
        }
        if (this.sortAllSightings) {
            CellUtil.createCell(header, columnNumber++, "#", this.headerStyle);
        }
        switch (this.scientificOrCommon) {
            case COMMON_FIRST: {
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.COMMON_NAME), this.headerStyle);
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.SCIENTIFIC_NAME), this.headerStyle);
                break;
            }
            case COMMON_ONLY: {
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.COMMON_NAME), this.headerStyle);
                break;
            }
            case SCIENTIFIC_FIRST: {
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.SCIENTIFIC_NAME), this.headerStyle);
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.COMMON_NAME), this.headerStyle);
                break;
            }
            case SCIENTIFIC_ONLY: {
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.SCIENTIFIC_NAME), this.headerStyle);
            }
        }
        if (this.sightingsCount > 0) {
            CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.LOCATION_TEXT), this.headerStyle);
            CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.DATE_TEXT), this.headerStyle);
            if (this.showSpeciesLifers) {
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.LIFER_TEXT), this.headerStyle);
            }
            if (this.showGroupLifers) {
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.GROUP_LIFER), this.headerStyle);
            }
            if (this.showSspLifers) {
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.SSP_LIFER), this.headerStyle);
            }
            CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.SIGHTING_TEXT), this.headerStyle);
            if (this.showNotes) {
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.NOTES_TEXT), this.headerStyle);
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.NUMBER_TEXT), this.headerStyle);
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.HEARD_ONLY_TEXT), this.headerStyle);
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.ADULT_TEXT), this.headerStyle);
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.IMMATURE_TEXT), this.headerStyle);
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.FEMALE_TEXT), this.headerStyle);
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.MALE_TEXT), this.headerStyle);
            }
            if (this.userOutput.showAbbreviations()) {
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.OBSERVERS_TEXT), this.headerStyle);
            }
            if (this.userOutput.showNames()) {
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.OBSERVER_NAMES), this.headerStyle);
            }
        } else {
            if (this.showSpeciesLifers) {
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.LIFER_TEXT), this.headerStyle);
            }
            if (this.showGroupLifers) {
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.GROUP_LIFER), this.headerStyle);
            }
            if (this.showSspLifers) {
                CellUtil.createCell(header, columnNumber++, Messages.getMessage(Messages.Name.SSP_LIFER), this.headerStyle);
            }
        }
        int rowCount = 1;
        if (this.sortAllSightings) {
            TreeMap<Sighting, SightingTaxon.Resolved> allSightings = this.queryResults.gatherSortedSightings(taxa, speciesOrdering.compound(SightingComparators.inTaxonomicOrder(taxonomy)), this.sightingsCount);
            for (Map.Entry<Sighting, SightingTaxon.Resolved> entry : allSightings.entrySet()) {
                if (this.omitSpAndHybrid && (entry.getValue().getType() == SightingTaxon.Type.HYBRID || entry.getValue().getType() == SightingTaxon.Type.SP)) continue;
                UnmodifiableIterator<Sighting> sightings = Iterators.singletonIterator(entry.getKey());
                rowCount = this.writeTaxonAndSightings(entry.getValue(), sightings, sheet, rowCount);
            }
        } else {
            for (int i = 0; i < taxa.size(); ++i) {
                boolean foundFamily;
                SightingTaxon.Resolved taxon = taxa.get(i);
                if (this.omitSpAndHybrid && (taxon.getType() == SightingTaxon.Type.HYBRID || taxon.getType() == SightingTaxon.Type.SP)) continue;
                boolean bl = foundFamily = taxon.getSmallestTaxonType() == Taxon.Type.family;
                if (foundFamily && !this.showFamilies) continue;
                if (foundFamily && rowCount > 1) {
                    ++rowCount;
                }
                int cellColumn = 0;
                if (foundFamily) {
                    row = sheet.createRow(rowCount++);
                    Cell common = row.createCell(cellColumn++);
                    common.setCellStyle(familyStyle);
                    String text = this.getFamilyTitle(taxon, taxa.subList(i + 1, taxa.size()), this.queryResults);
                    common.setCellValue(text);
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), 0, 1));
                    continue;
                }
                Iterator<Sighting> sightings = this.sightingsCount > 0 ? this.queryResults.getBestSightings(taxon, sightingOrdering, this.sightingsCount).iterator() : Collections.emptyIterator();
                rowCount = this.writeTaxonAndSightings(taxon, sightings, sheet, rowCount);
            }
        }
        ++rowCount;
        int summaryColumn = this.sortAllSightings ? 1 : 0;
        Set<String> countableSpeciesIds = this.queryResults.getCountableSpeciesIds(taxonomy);
        Set familyIds = countableSpeciesIds.stream().map(id -> {
            Taxon taxon = taxonomy.getTaxon((String)id);
            Taxon family = TaxonUtils.getParentOfTypeOrNull(taxon, Taxon.Type.family);
            return family == null ? null : family.getId();
        }).filter(s -> s != null).collect(ImmutableSet.toImmutableSet());
        int speciesSetSize = countableSpeciesIds.size();
        row = sheet.createRow(rowCount++);
        Cell cell = row.createCell(summaryColumn);
        cell.setCellValue(this.textWithNumber(headerFont, Messages.Name.SPECIES_WITH_NUMBER, speciesSetSize));
        if (this.queryResults.getSmallestType() != Taxon.Type.species) {
            int subspeciesIds;
            int groupsAndSpeciesIds = this.queryResults.getCountableGroupsAndSpeciesSize(taxonomy, false);
            if (groupsAndSpeciesIds != speciesSetSize) {
                row = sheet.createRow(rowCount++);
                cell = row.createCell(summaryColumn);
                cell.setCellValue(this.textWithNumber(headerFont, Messages.Name.GROUPS_WITH_NUMBER, groupsAndSpeciesIds));
            }
            if (this.queryResults.getSmallestType() == Taxon.Type.subspecies && (subspeciesIds = this.queryResults.getCountableSubspeciesGroupsAndSpeciesSize(taxonomy, false)) != groupsAndSpeciesIds) {
                row = sheet.createRow(rowCount++);
                cell = row.createCell(summaryColumn);
                cell.setCellValue(this.textWithNumber(headerFont, Messages.Name.SUBSPECIES_WITH_NUMBER, subspeciesIds));
            }
        }
        if (!familyIds.isEmpty()) {
            row = sheet.createRow(rowCount++);
            cell = row.createCell(summaryColumn);
            cell.setCellValue(this.textWithNumber(headerFont, Messages.Name.FAMILIES_FORMAT, familyIds.size()));
        }
        if (showLifers) {
            if (!this.lifers.isEmpty()) {
                row = sheet.createRow(rowCount++);
                cell = row.createCell(summaryColumn);
                cell.setCellValue(this.textWithNumber(headerFont, Messages.Name.LIFERS_FORMAT_2, this.lifers.size()));
            }
            if (this.queryResults.getSmallestType() != Taxon.Type.species) {
                int subspeciesCount;
                int groupsAndSpeciesCount = this.queryResults.getTaxaWithAnnotation(taxonomy, QueryDefinition.QueryAnnotation.LIFER, Taxon.Type.group).size();
                if (groupsAndSpeciesCount != this.lifers.size()) {
                    row = sheet.createRow(rowCount++);
                    cell = row.createCell(summaryColumn);
                    cell.setCellValue(this.textWithNumber(headerFont, Messages.Name.LIFER_GROUPS_WITH_NUMBER, groupsAndSpeciesCount));
                }
                if (this.queryResults.getSmallestType() == Taxon.Type.subspecies && (subspeciesCount = this.queryResults.getTaxaWithAnnotation(taxonomy, QueryDefinition.QueryAnnotation.LIFER, Taxon.Type.subspecies).size()) != groupsAndSpeciesCount) {
                    row = sheet.createRow(rowCount++);
                    cell = row.createCell(summaryColumn);
                    cell.setCellValue(this.textWithNumber(headerFont, Messages.Name.LIFER_SUBSPECIES_WITH_NUMBER, subspeciesCount));
                }
            }
        }
        row = sheet.createRow(rowCount++);
        cell = row.createCell(summaryColumn);
        cell.setCellValue(this.textWithNumber(headerFont, Messages.Name.TOTAL_SIGHTINGS_WITH_NUMBER, this.queryResults.getSightingsCount(taxonomy)));
        if (!taxa.isEmpty()) {
            row = sheet.createRow(rowCount++);
            CellUtil.createCell(row, summaryColumn, taxonomy.getName());
        }
        if (this.sortAllSightings) {
            sheet.autoSizeColumn(0);
        }
        boolean commonAndScientific = this.scientificOrCommon.includesCommon() && this.scientificOrCommon.includesScientific();
        for (int column = 0; column < (commonAndScientific ? 2 : 1) + (this.sightingsCount > 0 ? 2 : 0); ++column) {
            sheet.setColumnWidth(column + (this.sortAllSightings ? 1 : 0), 7680);
        }
    }

    private int writeTaxonAndSightings(SightingTaxon.Resolved taxon, Iterator<Sighting> sightings, Sheet sheet, int rowCount) {
        Species.Status taxonStatus;
        boolean hasCommonName;
        Taxonomy taxonomy = taxon.getTaxonomy();
        Row row = sheet.createRow(rowCount++);
        int cellColumn = 0;
        if (this.sortAllSightings && taxon.getType() == SightingTaxon.Type.SINGLE && this.queryResults.getAllSightings(taxon).stream().anyMatch(this.queryResults.getCountablePredicate())) {
            Cell countCell = row.createCell(cellColumn);
            countCell.setCellValue("" + ++this.countableCount);
        }
        int n = ++cellColumn;
        ++cellColumn;
        Cell firstNameCell = row.createCell(n);
        Checklist.Status status = null;
        if (this.queryResults.getChecklist(taxonomy) != null) {
            status = this.queryResults.getChecklist(taxonomy).getStatus(taxonomy, taxon.getSightingTaxon());
        }
        if (!(hasCommonName = taxon.hasCommonName()) && taxon.getLargestTaxonType() != Taxon.Type.species) {
            SightingTaxon.Resolved speciesParent = taxon.getParentOfAtLeastType(Taxon.Type.species).resolveInternal(taxonomy);
            hasCommonName = speciesParent.hasCommonName();
        }
        Object firstText = switch (this.scientificOrCommon) {
            case NamesPreferences.ScientificOrCommon.COMMON_FIRST -> hasCommonName ? this.getCommonNameAtLeastAtGroup(taxon) : "";
            case NamesPreferences.ScientificOrCommon.COMMON_ONLY -> hasCommonName ? taxon.getCommonName() : taxon.getFullName();
            case NamesPreferences.ScientificOrCommon.SCIENTIFIC_FIRST, NamesPreferences.ScientificOrCommon.SCIENTIFIC_ONLY -> taxon.getFullName();
            default -> throw new AssertionError();
        };
        if (status == Checklist.Status.ENDEMIC) {
            firstText = (String)firstText + " (" + Messages.getMessage(Messages.Name.CHECKLIST_STATUS_ENDEMIC) + ")";
        }
        if (this.showStatus && (taxonStatus = taxon.getTaxonStatus()) != Species.Status.LC && taxonStatus != Species.Status.NT) {
            firstText = (String)firstText + " - " + taxonStatus.name();
        }
        firstNameCell.setCellValue((String)firstText);
        if (this.scientificOrCommon.includesCommon() && this.scientificOrCommon.includesScientific()) {
            Cell secondCell = row.createCell(cellColumn++);
            secondCell.setCellStyle(this.scientificStyle);
            secondCell.setCellValue(this.scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_FIRST ? taxon.getFullName() : (taxon.hasCommonName() ? this.getCommonNameAtLeastAtGroup(taxon) : ""));
        }
        if (this.sightingsCount > 0) {
            int sightingColumnStart = cellColumn;
            while (sightings.hasNext()) {
                String sightingNotes;
                cellColumn = sightingColumnStart;
                Sighting sighting = sightings.next();
                Cell locationCell = row.createCell(cellColumn++);
                if (sighting.getLocationId() != null) {
                    String locationText = LocationIdToString.getString(this.locations, sighting.getLocationId(), true, this.rootLocation);
                    locationCell.setCellValue(locationText);
                }
                Cell dateCell = row.createCell(cellColumn++);
                ReadablePartial date = sighting.getSingleDateAsPartial();
                if (date != null) {
                    if (this.shouldWriteAsDateType(date)) {
                        this.setDateValue(dateCell, date);
                    } else {
                        dateCell.setCellValue(PartialIO.toShortUserString(date, Locale.getDefault()));
                    }
                } else if (sighting.getTrip() != null) {
                    dateCell.setCellValue(String.format("%s-%s", PartialIO.toShortUserString(sighting.getTrip().startDate(), Locale.getDefault()), PartialIO.toShortUserString(sighting.getTrip().endDate(), Locale.getDefault())));
                }
                Object sightingText = null;
                if (sighting.getSightingInfo().getSightingStatus() != SightingInfo.SightingStatus.NONE) {
                    sightingText = Messages.getText(sighting.getSightingInfo().getSightingStatus()).toLowerCase();
                }
                if (!this.showNotes && sighting.getSightingInfo().isHeardOnly()) {
                    sightingText = sightingText == null ? Messages.getMessage(Messages.Name.HEARD_ONLY_TEXT).toLowerCase() : (String)sightingText + " (H)";
                }
                boolean wasASpeciesLifer = false;
                if (this.showSpeciesLifers) {
                    if (this.queryResults.getAnnotation(sighting, taxon.getParentOfAtLeastType(Taxon.Type.species)).orNull() == QueryDefinition.QueryAnnotation.LIFER) {
                        row.createCell(cellColumn++).setCellValue("Y");
                        wasASpeciesLifer = true;
                    } else {
                        ++cellColumn;
                    }
                }
                boolean wasAGroupLifer = false;
                if (this.showGroupLifers) {
                    if (!wasASpeciesLifer && this.queryResults.getAnnotation(sighting, taxon.getParentOfAtLeastType(Taxon.Type.group)).orNull() == QueryDefinition.QueryAnnotation.LIFER) {
                        row.createCell(cellColumn++).setCellValue("Y");
                        wasAGroupLifer = true;
                    } else {
                        ++cellColumn;
                    }
                }
                if (this.showSspLifers) {
                    if (!wasASpeciesLifer && !wasAGroupLifer && this.queryResults.getAnnotation(sighting, taxon.getParentOfAtLeastType(Taxon.Type.subspecies)).orNull() == QueryDefinition.QueryAnnotation.LIFER) {
                        row.createCell(cellColumn++).setCellValue("Y");
                    } else {
                        ++cellColumn;
                    }
                }
                String string = sightingNotes = this.showNotes ? sighting.getSightingInfo().getDescription() : null;
                if (sightingText != null) {
                    row.createCell(cellColumn++).setCellValue((String)sightingText);
                } else if (this.showNotes) {
                    ++cellColumn;
                }
                if (this.showNotes) {
                    if (sightingNotes != null) {
                        row.createCell(cellColumn).setCellValue(sightingNotes);
                    }
                    ++cellColumn;
                    if (sighting.hasSightingInfo() && sighting.getSightingInfo().getNumber() != null) {
                        row.createCell(cellColumn).setCellValue(sighting.getSightingInfo().getNumber().toString());
                    }
                    ++cellColumn;
                    if (sighting.hasSightingInfo() && sighting.getSightingInfo().isHeardOnly()) {
                        row.createCell(cellColumn).setCellValue("Y");
                    }
                    ++cellColumn;
                    if (sighting.hasSightingInfo() && sighting.getSightingInfo().isAdult()) {
                        row.createCell(cellColumn).setCellValue("Y");
                    }
                    ++cellColumn;
                    if (sighting.hasSightingInfo() && sighting.getSightingInfo().isImmature()) {
                        row.createCell(cellColumn).setCellValue("Y");
                    }
                    ++cellColumn;
                    if (sighting.hasSightingInfo() && sighting.getSightingInfo().isFemale()) {
                        row.createCell(cellColumn).setCellValue("Y");
                    }
                    ++cellColumn;
                    if (sighting.hasSightingInfo() && sighting.getSightingInfo().isMale()) {
                        row.createCell(cellColumn).setCellValue("Y");
                    }
                }
                if (this.userOutput.showAbbreviations()) {
                    ++cellColumn;
                    if (sighting.hasSightingInfo() && !sighting.getSightingInfo().getUsers().isEmpty()) {
                        row.createCell(cellColumn).setCellValue(ReportXlsOutput.toAbbreviations(sighting.getSightingInfo().getUsers()));
                    }
                }
                if (this.userOutput.showNames()) {
                    ++cellColumn;
                    if (sighting.hasSightingInfo() && !sighting.getSightingInfo().getUsers().isEmpty()) {
                        row.createCell(cellColumn).setCellValue(ReportXlsOutput.toNames(sighting.getSightingInfo().getUsers()));
                    }
                }
                if (!sightings.hasNext()) continue;
                row = sheet.createRow(rowCount++);
            }
        } else {
            boolean wasASpeciesLifer = false;
            if (this.showSpeciesLifers) {
                SightingTaxon.Resolved species = taxon.getParentOfAtLeastType(Taxon.Type.species).resolveInternal(taxonomy);
                if (this.lifers.contains(species)) {
                    row.createCell(cellColumn++).setCellValue("Y");
                    wasASpeciesLifer = true;
                } else {
                    ++cellColumn;
                }
            }
            boolean wasAGroupLifer = false;
            if (this.showGroupLifers) {
                SightingTaxon.Resolved group = taxon.getParentOfAtLeastType(Taxon.Type.group).resolveInternal(taxonomy);
                if (!wasASpeciesLifer && this.groupLifers.contains(group)) {
                    row.createCell(cellColumn++).setCellValue("Y");
                    wasAGroupLifer = true;
                } else {
                    ++cellColumn;
                }
            }
            if (this.showSspLifers) {
                SightingTaxon.Resolved ssp = taxon.getParentOfAtLeastType(Taxon.Type.subspecies).resolveInternal(taxonomy);
                if (!wasASpeciesLifer && !wasAGroupLifer && this.sspLifers.contains(ssp)) {
                    row.createCell(cellColumn++).setCellValue("Y");
                } else {
                    ++cellColumn;
                }
            }
        }
        return rowCount;
    }

    private void setDateValue(Cell dateCell, ReadablePartial dateAsPartial) {
        if (Locale.getDefault().getLanguage().equals(Locale.CHINESE.getLanguage())) {
            String date = PartialIO.toShortUserString(dateAsPartial, Locale.getDefault());
            dateCell.setCellValue(date);
            return;
        }
        Date date = Date.from(LocalDate.of(dateAsPartial.get(DateTimeFieldType.year()), dateAsPartial.get(DateTimeFieldType.monthOfYear()), dateAsPartial.get(DateTimeFieldType.dayOfMonth())).atStartOfDay(ZoneId.systemDefault()).toInstant());
        dateCell.setCellStyle(this.dateStyle);
        dateCell.setCellValue(date);
    }

    private String getCommonNameAtLeastAtGroup(SightingTaxon.Resolved taxon) {
        if (taxon.getSmallestTaxonType() != Taxon.Type.subspecies) {
            return taxon.getCommonName();
        }
        taxon = taxon.getParentOfAtLeastType(Taxon.Type.group).resolveInternal(taxon.getTaxonomy());
        return taxon.getCommonName();
    }

    private boolean shouldWriteAsDateType(ReadablePartial dateAsPartial) {
        return dateAsPartial.isSupported(DateTimeFieldType.dayOfMonth()) && dateAsPartial.isSupported(DateTimeFieldType.monthOfYear()) && dateAsPartial.isSupported(DateTimeFieldType.year());
    }

    private HSSFRichTextString textWithNumber(Font font, Messages.Name text, int number) {
        HSSFRichTextString string = new HSSFRichTextString(Messages.getFormattedMessage(text, number));
        string.applyFont(font);
        return string;
    }

    private String getFamilyTitle(SightingTaxon.Resolved taxon, List<SightingTaxon.Resolved> list, QueryResults queryResults) {
        Object text = switch (this.scientificOrCommon) {
            case NamesPreferences.ScientificOrCommon.COMMON_FIRST -> taxon.hasCommonName() ? String.format("%s (%s)", taxon.getCommonName(), taxon.getFullName()) : taxon.getFullName();
            case NamesPreferences.ScientificOrCommon.SCIENTIFIC_FIRST -> taxon.hasCommonName() ? String.format("%s (%s)", taxon.getFullName(), taxon.getCommonName()) : taxon.getFullName();
            case NamesPreferences.ScientificOrCommon.SCIENTIFIC_ONLY -> taxon.getFullName();
            case NamesPreferences.ScientificOrCommon.COMMON_ONLY -> taxon.hasCommonName() ? taxon.getCommonName() : taxon.getFullName();
            default -> throw new AssertionError();
        };
        Taxon family = taxon.getTaxon();
        if (this.showFamilyTotals) {
            HashSet<String> speciesIds = Sets.newHashSet();
            for (SightingTaxon.Resolved taxonInFamily : list) {
                SightingTaxon speciesParent;
                if (!taxonInFamily.isChildOf(family)) break;
                if (!queryResults.isCountable(taxonInFamily) || (speciesParent = taxonInFamily.getParentOfAtLeastType(Taxon.Type.species)).getType() != SightingTaxon.Type.SINGLE) continue;
                speciesIds.add(speciesParent.getId());
            }
            int speciesInFamily = TaxonUtils.countChildren(family, Taxon.Type.species, queryResults.getChecklist(taxon.getTaxonomy()), new Checklist.Status[0]);
            text = (String)text + String.format(" - %s / %s", speciesIds.size(), speciesInFamily);
        }
        return text;
    }

    private static String toAbbreviations(ImmutableSet<User> users) {
        return users.stream().map(User::abbreviation).filter(Predicates.notNull()).collect(Collectors.joining(","));
    }

    private static String toNames(ImmutableSet<User> users) {
        return users.stream().map(User::name).filter(Predicates.notNull()).collect(Collectors.joining("\n"));
    }

    public void setShowStatus(boolean showStatus) {
        this.showStatus = showStatus;
    }

    public void setShowFamilyTotals(boolean showFamilyTotals) {
        this.showFamilyTotals = showFamilyTotals;
    }

    public void setRootLocation(Location rootLocation) {
        this.rootLocation = rootLocation;
    }

    public void setSightingsCount(int sightingsCount) {
        this.sightingsCount = sightingsCount;
    }

    public void setShowFamilies(boolean showFamilies) {
        this.showFamilies = showFamilies;
    }

    public void setShowNotes(boolean showNotes) {
        this.showNotes = showNotes;
    }

    public void setSortAllSightings(boolean sortAllSightings) {
        this.sortAllSightings = sortAllSightings;
    }

    public void setScientificOrCommon(NamesPreferences.ScientificOrCommon scientificOrCommon) {
        this.scientificOrCommon = scientificOrCommon;
    }

    public void setUserOutput(UserOutput userOutput) {
        this.userOutput = userOutput;
    }

    public void setOmitSpAndHybrid(boolean omitSpAndHybrid) {
        this.omitSpAndHybrid = omitSpAndHybrid;
    }

    public void setShowAllTaxonomies(boolean showAllTaxonomies) {
        this.showAllTaxonomies = showAllTaxonomies;
    }
}

