/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.io;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.io.IndentingResponseWriter;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.io.ResponseWriter;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.ui.io.IOUtils;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import com.scythebill.birdlist.ui.util.SightingFlags;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.joda.time.ReadablePartial;

public class HtmlOutput {
    private final String CSS_STYLE_COMMON = Joiner.on(System.getProperty("line.separator")).join("body { font-size: 13px; }", "th.familyTitle { font-weight: bold; font-size: 135%; padding-top: 10px; text-align: left }", ".lifer { font-weight: bold }", ".total { font-size: 110%; font-weight: bold }");
    private final String CSS_STYLE_COMPACT_OUTPUT = Joiner.on(System.getProperty("line.separator")).join("body { font-size: 11px; }", "h2.familyTitle { font-weight: bold; font-size: 135%; text-transform: uppercase; font-style: italic; }", ".lifer { font-weight: bold }", ".scientific { font-style: italic }", ".main { column-count: 3; -webkit-column-count: 3; -moz-column-count: 3; }", ".total { font-size: 110%; font-weight: bold }");
    private final String CSS_STYLE_COMPACT_OUTPUT_WITH_ONE_NAME = Joiner.on(System.getProperty("line.separator")).join("body { font-size: 13px; }", "h2.familyTitle { font-weight: bold; font-size: 135%; text-transform: uppercase; font-style: italic; }", ".lifer { font-weight: bold }", ".scientific { font-style: italic }", ".main { column-count: 3; -webkit-column-count: 3; -moz-column-count: 3; }", ".total { font-size: 110%; font-weight: bold }");
    private final String CSS_STYLE_SINGLE_SIGHTING = Joiner.on(System.getProperty("line.separator")).join("td.common { margin-right: 20px; width: 30% }", "td.scientific { margin-right: 20px; width: 30%; font-style: italic; }", "td.sighting { margin-left: 20px; width: 40% }");
    private final String CSS_STYLE_SINGLE_SIGHTING_NO_SCI = Joiner.on(System.getProperty("line.separator")).join("th.familyTitle { font-weight: bold; font-size: 135%; padding-top: 10px; text-align: left }", "td.common { margin-right: 20px; width: 60% }", new Object[0]);
    private final String CSS_STYLE_MULTI_SIGHTING = Joiner.on(System.getProperty("line.separator")).join("td.common { margin-right: 20px; width: 20% }", "td.scientific { margin-right: 20px; width: 40%; font-style: italic; }", "td.sighting { padding-left: 50px; width: 40% }");
    private final String CSS_STYLE_MULTI_SIGHTING_NO_SCI = Joiner.on(System.getProperty("line.separator")).join("td.common { margin-right: 20px}", "td.sighting { padding-left: 50px}", new Object[0]);
    private String title;
    private final Taxonomy taxonomy;
    private final Location rootLocation;
    private final Alerts alerts;
    private String script;
    private boolean showFamilyTotals;
    private boolean showFamilies;
    private boolean showStatus;
    private NamesPreferences.ScientificOrCommon scientificOrCommon;
    private int maximumSightings;
    private boolean sortAllSightings;
    private boolean compactOutput;
    private int familyCount;
    private boolean foundAnyEntriesInFamily;
    private boolean omitSpAndHybrid;

    public HtmlOutput(Taxonomy taxonomy, Location rootLocation, Alerts alerts) {
        this.taxonomy = taxonomy;
        this.rootLocation = rootLocation;
        this.alerts = alerts;
    }

    public void setShowFamilyTotals(boolean showFamilyTotals) {
        this.showFamilyTotals = showFamilyTotals;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void writeSpeciesList(File outFile, QueryResults queryResults, Ordering<Sighting> speciesOrdering, Ordering<Sighting> sightingOrdering, LocationSet locations) {
        try {
            Writer out = IOUtils.openNewFile(outFile, StandardCharsets.UTF_8);
            this.writeSpeciesList(out, queryResults, speciesOrdering, sightingOrdering, locations);
            out.close();
        }
        catch (IOException ioe) {
            FileDialogs.showFileSaveError(this.alerts, ioe, outFile);
        }
    }

    public void writeSpeciesList(Writer out, QueryResults queryResults, Ordering<Sighting> speciesOrdering, Ordering<Sighting> sightingOrdering, LocationSet locations) throws IOException {
        IndentingResponseWriter rw = new IndentingResponseWriter(new HtmlResponseWriter(out, "UTF-8"));
        this.startHtml(rw, this.title);
        List<SightingTaxon.Resolved> taxa = queryResults.getTaxaAsList();
        boolean isInTable = false;
        int liferCount = 0;
        if (this.sortAllSightings) {
            TreeMap<Sighting, SightingTaxon.Resolved> allSightings = queryResults.gatherSortedSightings(taxa, speciesOrdering, this.getSightingsCount());
            int rowCount = 0;
            for (Map.Entry<Sighting, SightingTaxon.Resolved> entry : allSightings.entrySet()) {
                if (this.omitSpAndHybrid && (entry.getValue().getType() == SightingTaxon.Type.HYBRID || entry.getValue().getType() == SightingTaxon.Type.SP)) continue;
                if (rowCount % 100 == 0) {
                    if (isInTable) {
                        this.endFamilyTable(rw);
                    }
                    this.startFamilyTable(rw);
                    isInTable = true;
                }
                liferCount = this.writeSpeciesAndSightingsRows(queryResults, locations, rw, liferCount, entry.getValue(), ImmutableList.of(entry.getKey()));
            }
        } else {
            for (int i = 0; i < taxa.size(); ++i) {
                SightingTaxon.Resolved taxon = taxa.get(i);
                if (this.omitSpAndHybrid && (taxon.getType() == SightingTaxon.Type.HYBRID || taxon.getType() == SightingTaxon.Type.SP)) continue;
                if (taxon.getSmallestTaxonType() == Taxon.Type.family) {
                    if (isInTable) {
                        this.endFamilyTable(rw);
                    }
                    if (this.foundAnyEntriesInFamily) {
                        ++this.familyCount;
                    }
                    this.startFamilyTable(rw);
                    this.writeFamilyHeader(rw, taxon.getTaxon(), taxa.subList(i + 1, taxa.size()), queryResults);
                    this.foundAnyEntriesInFamily = false;
                    isInTable = true;
                    continue;
                }
                if (!isInTable) {
                    this.startFamilyTable(rw);
                    isInTable = true;
                }
                List<Sighting> sightings = queryResults.getBestSightings(taxon, sightingOrdering, this.getSightingsCount());
                liferCount = this.writeSpeciesAndSightingsRows(queryResults, locations, rw, liferCount, taxon, sightings);
            }
        }
        if (isInTable) {
            this.endFamilyTable(rw);
        }
        if (this.foundAnyEntriesInFamily) {
            ++this.familyCount;
        }
        int speciesSetSize = queryResults.getCountableSpeciesSize(this.taxonomy, false);
        rw.startElement("p");
        ((ResponseWriter)rw).writeAttribute("class", "total");
        ((Writer)rw).write(Messages.getFormattedMessage(Messages.Name.SPECIES_WITH_NUMBER, speciesSetSize));
        if (queryResults.getSmallestType() != Taxon.Type.species) {
            int subspeciesIds;
            int groupsAndSpeciesIds = queryResults.getCountableGroupsAndSpeciesSize(this.taxonomy, false);
            if (groupsAndSpeciesIds != speciesSetSize) {
                rw.startElement("br");
                ((ResponseWriter)rw).endElement("br");
                ((Writer)rw).write(Messages.getFormattedMessage(Messages.Name.GROUPS_WITH_NUMBER, groupsAndSpeciesIds));
            }
            if (queryResults.getSmallestType() == Taxon.Type.subspecies && (subspeciesIds = queryResults.getCountableSubspeciesGroupsAndSpeciesSize(this.taxonomy, false)) != groupsAndSpeciesIds) {
                rw.startElement("br");
                ((ResponseWriter)rw).endElement("br");
                ((Writer)rw).write(Messages.getFormattedMessage(Messages.Name.SUBSPECIES_WITH_NUMBER, subspeciesIds));
            }
        }
        if (liferCount > 0) {
            Set<SightingTaxon.Resolved> lifers = queryResults.getTaxaWithAnnotation(this.taxonomy, QueryDefinition.QueryAnnotation.LIFER, Taxon.Type.species);
            if (!lifers.isEmpty()) {
                rw.startElement("br");
                ((ResponseWriter)rw).endElement("br");
                ((Writer)rw).write(Messages.getFormattedMessage(Messages.Name.LIFERS_FORMAT_2, lifers.size()));
            }
            if (queryResults.getSmallestType() != Taxon.Type.species) {
                int subspeciesCount;
                int groupsAndSpeciesCount = queryResults.getTaxaWithAnnotation(this.taxonomy, QueryDefinition.QueryAnnotation.LIFER, Taxon.Type.group).size();
                if (groupsAndSpeciesCount != lifers.size()) {
                    rw.startElement("br");
                    ((ResponseWriter)rw).endElement("br");
                    ((Writer)rw).write(Messages.getFormattedMessage(Messages.Name.LIFER_GROUPS_WITH_NUMBER, groupsAndSpeciesCount));
                }
                if (queryResults.getSmallestType() == Taxon.Type.subspecies && (subspeciesCount = queryResults.getTaxaWithAnnotation(this.taxonomy, QueryDefinition.QueryAnnotation.LIFER, Taxon.Type.subspecies).size()) != groupsAndSpeciesCount) {
                    rw.startElement("br");
                    ((ResponseWriter)rw).endElement("br");
                    ((Writer)rw).write(Messages.getFormattedMessage(Messages.Name.LIFER_SUBSPECIES_WITH_NUMBER, subspeciesCount));
                }
            }
        }
        ((ResponseWriter)rw).endElement("p");
        if (this.showFamilies) {
            rw.startElement("p");
            ((ResponseWriter)rw).writeAttribute("class", "total");
            if (this.showFamilyTotals) {
                int possibleFamilies = TaxonUtils.countFamilies(this.taxonomy, queryResults.getChecklist(this.taxonomy), Checklist.Status.ESCAPED);
                ((ResponseWriter)rw).writeText(Messages.getFormattedMessage(Messages.Name.FAMILIES_OF_FORMAT, this.familyCount, possibleFamilies));
            } else {
                ((ResponseWriter)rw).writeText(Messages.getFormattedMessage(Messages.Name.FAMILIES_FORMAT, this.familyCount));
            }
            ((ResponseWriter)rw).endElement("p");
        }
        rw.startElement("p");
        ((ResponseWriter)rw).writeAttribute("class", "total");
        ((Writer)rw).write(Messages.getFormattedMessage(Messages.Name.TOTAL_SIGHTINGS_WITH_NUMBER, queryResults.getSightingsCount(this.taxonomy)));
        ((ResponseWriter)rw).endElement("p");
        rw.startElement("p");
        ((Writer)rw).write(this.taxonomy.getName());
        ((ResponseWriter)rw).endElement("p");
        this.endHtml(rw);
        ((Writer)rw).flush();
    }

    private int writeSpeciesAndSightingsRows(QueryResults queryResults, LocationSet locations, ResponseWriter rw, int liferCount, SightingTaxon.Resolved taxon, List<Sighting> sightings) throws IOException {
        Species.Status status;
        Optional<QueryDefinition.QueryAnnotation> annotation;
        Sighting sighting;
        Sighting sighting2 = sighting = this.getSightingsCount() == 1 ? sightings.get(0) : null;
        if (this.compactOutput) {
            rw.startElement("div");
            rw.writeAttribute("class", "species");
            rw.startElement("span");
        } else {
            rw.startElement("tr");
            rw.writeAttribute("class", "species");
            rw.startElement("td");
        }
        if (!this.foundAnyEntriesInFamily && queryResults.isCountable(taxon)) {
            this.foundAnyEntriesInFamily = true;
        }
        if ((annotation = queryResults.getAnnotation(sighting, taxon.getSightingTaxon())).orNull() == QueryDefinition.QueryAnnotation.LIFER) {
            rw.writeAttribute("class", "common lifer");
            ++liferCount;
        } else {
            rw.writeAttribute("class", "common");
        }
        switch (this.scientificOrCommon) {
            case COMMON_FIRST: {
                rw.writeText(taxon.getSimpleCommonName());
                break;
            }
            case COMMON_ONLY: {
                rw.writeText(taxon.getCommonName());
                break;
            }
            case SCIENTIFIC_FIRST: 
            case SCIENTIFIC_ONLY: {
                rw.writeText(taxon.getFullName());
            }
        }
        if (sighting != null) {
            rw.writeText(SightingFlags.appendSightingInfo("", sighting));
        }
        if (queryResults.getChecklist(this.taxonomy) != null) {
            SightingTaxon species = taxon.getSmallestTaxonType() == Taxon.Type.species ? taxon.getSightingTaxon() : taxon.getParentOfAtLeastType(Taxon.Type.species);
            if (queryResults.getChecklist(this.taxonomy).getStatus(taxon.getTaxonomy(), species) == Checklist.Status.ENDEMIC) {
                rw.writeText(" - " + Messages.getMessage(Messages.Name.CHECKLIST_STATUS_ENDEMIC));
            }
        }
        if (this.showStatus && (status = taxon.getTaxonStatus()) != Species.Status.LC && status != Species.Status.NT) {
            rw.writeText(" (" + status + ")");
        }
        if (this.compactOutput) {
            rw.endElement("span");
        } else {
            rw.endElement("td");
        }
        if (this.scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_FIRST || this.scientificOrCommon == NamesPreferences.ScientificOrCommon.SCIENTIFIC_FIRST) {
            if (this.compactOutput) {
                rw.startElement("span");
            } else {
                rw.startElement("td");
            }
            rw.writeAttribute("class", "scientific");
            rw.writeText(this.scientificOrCommon == NamesPreferences.ScientificOrCommon.SCIENTIFIC_FIRST ? taxon.getSimpleCommonName() : taxon.getFullName());
            if (this.compactOutput) {
                rw.endElement("span");
            } else {
                rw.endElement("td");
            }
        }
        if (!this.compactOutput) {
            if (this.getSightingsCount() == 1) {
                rw.startElement("td");
                rw.writeAttribute("class", "sighting");
                this.writeSighting(rw, sighting, locations);
                rw.endElement("td");
            } else if (this.getSightingsCount() > 0) {
                for (Sighting orderedSighting : sightings) {
                    rw.endElement("tr");
                    rw.startElement("tr");
                    rw.startElement("td");
                    rw.writeAttribute("class", "sighting");
                    this.writeSighting(rw, orderedSighting, locations);
                    rw.endElement("td");
                }
            }
        }
        if (this.compactOutput) {
            rw.endElement("div");
        } else {
            rw.endElement("tr");
        }
        return liferCount;
    }

    private void startFamilyTable(ResponseWriter rw) throws IOException {
        if (!this.compactOutput) {
            rw.startElement("table");
            rw.writeAttribute("width", "100%");
        }
    }

    private void writeFamilyHeader(ResponseWriter rw, Taxon family, List<SightingTaxon.Resolved> list, QueryResults queryResults) throws IOException {
        if (!this.showFamilies) {
            return;
        }
        if (this.compactOutput) {
            rw.startElement("h2");
        } else {
            rw.startElement("tr");
            rw.startElement("th");
            rw.writeAttribute("colspan", 3);
        }
        rw.writeAttribute("class", "familyTitle");
        switch (this.scientificOrCommon) {
            case COMMON_FIRST: {
                rw.writeText(family.getCommonName());
                rw.writeText(" (");
                rw.writeText(family.getName());
                rw.writeText(")");
                break;
            }
            case SCIENTIFIC_FIRST: {
                rw.writeText(family.getName());
                rw.writeText(" (");
                rw.writeText(family.getCommonName());
                rw.writeText(")");
                break;
            }
            case SCIENTIFIC_ONLY: {
                rw.writeText(family.getName());
                break;
            }
            case COMMON_ONLY: {
                rw.writeText(family.getCommonName());
            }
        }
        if (this.showFamilyTotals) {
            HashSet<String> speciesIds = Sets.newHashSet();
            for (SightingTaxon.Resolved taxonInFamily : list) {
                SightingTaxon speciesParent;
                if (!taxonInFamily.isChildOf(family)) break;
                if (!queryResults.isCountable(taxonInFamily) || (speciesParent = taxonInFamily.getParentOfAtLeastType(Taxon.Type.species)).getType() != SightingTaxon.Type.SINGLE) continue;
                speciesIds.add(speciesParent.getId());
            }
            int speciesInFamily = TaxonUtils.countChildren(family, Taxon.Type.species, queryResults.getChecklist(this.taxonomy), new Checklist.Status[0]);
            rw.writeText(" - ");
            rw.writeText(speciesIds.size());
            rw.writeText("/");
            rw.writeText(speciesInFamily);
        }
        if (this.compactOutput) {
            rw.endElement("h2");
        } else {
            rw.endElement("th");
            rw.endElement("tr");
        }
    }

    private void endFamilyTable(ResponseWriter rw) throws IOException {
        if (!this.compactOutput) {
            rw.endElement("table");
        }
    }

    private void writeSighting(ResponseWriter rw, Sighting sighting, LocationSet locations) throws IOException {
        String locationText;
        ReadablePartial date = sighting.getSingleDateAsPartial();
        String string = locationText = sighting.getLocationId() != null ? LocationIdToString.getString(locations, sighting.getLocationId(), true, this.rootLocation) : null;
        if (date == null && sighting.getTrip() != null) {
            Trip trip = sighting.getTrip();
            if (!(locationText == null || trip.hasName() && trip.name().contains(locationText))) {
                rw.writeText(locationText);
                rw.writeText(Character.valueOf(' '));
            }
            rw.writeText(Trips.nameWithDate(trip, Locale.getDefault()));
        } else {
            if (locationText != null) {
                rw.writeText(locationText);
                if (date != null) {
                    rw.writeText(Character.valueOf(' '));
                }
            }
            if (date != null) {
                rw.writeText(PartialIO.toShortUserString(date, Locale.getDefault()));
            }
        }
    }

    private void startHtml(ResponseWriter rw, String title) throws IOException {
        boolean scientificAndCommon;
        rw.startDocument();
        rw.writeComment("saved from url=(0016)http://localhost");
        rw.startElement("html");
        rw.startElement("head");
        rw.startElement("meta");
        rw.writeAttribute("http-equiv", "Content-Type");
        rw.writeAttribute("content", "text/html; charset=UTF-8");
        rw.endElement("meta");
        if (title != null) {
            rw.startElement("title");
            rw.writeText(title);
            rw.endElement("title");
        }
        rw.startElement("style");
        rw.writeAttribute("type", "text/css");
        boolean bl = scientificAndCommon = this.scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_FIRST || this.scientificOrCommon == NamesPreferences.ScientificOrCommon.SCIENTIFIC_FIRST;
        if (this.compactOutput) {
            rw.writeText(scientificAndCommon ? this.CSS_STYLE_COMPACT_OUTPUT : this.CSS_STYLE_COMPACT_OUTPUT_WITH_ONE_NAME);
        } else {
            rw.writeText(this.CSS_STYLE_COMMON);
            rw.writeText(this.getSightingsCount() > 1 ? (scientificAndCommon ? this.CSS_STYLE_MULTI_SIGHTING : this.CSS_STYLE_MULTI_SIGHTING_NO_SCI) : (scientificAndCommon ? this.CSS_STYLE_SINGLE_SIGHTING : this.CSS_STYLE_SINGLE_SIGHTING_NO_SCI));
        }
        rw.endElement("style");
        if (this.script != null) {
            rw.startElement("script");
            rw.writeAttribute("type", "text/javascript");
            rw.writeRawText("function onload_script() {\n");
            rw.writeRawText(this.script);
            rw.writeRawText("\n}");
            rw.endElement("script");
        }
        rw.endElement("head");
        rw.startElement("body");
        if (this.script != null) {
            rw.writeAttribute("onload", "onload_script();");
        }
        if (this.compactOutput) {
            rw.startElement("div");
            rw.writeAttribute("class", "main");
        }
    }

    private void endHtml(ResponseWriter rw) throws IOException {
        if (this.compactOutput) {
            rw.endElement("div");
        }
        rw.endElement("body");
        rw.endElement("html");
        rw.endDocument();
    }

    public void setShowFamilies(boolean showFamilies) {
        this.showFamilies = showFamilies;
    }

    public void setShowStatus(boolean showStatus) {
        this.showStatus = showStatus;
    }

    public void setScientificOrCommon(NamesPreferences.ScientificOrCommon scientificOrCommon) {
        this.scientificOrCommon = scientificOrCommon;
    }

    private int getSightingsCount() {
        return this.compactOutput ? 1 : this.maximumSightings;
    }

    public void setSightingsCount(int maximumSightings) {
        this.maximumSightings = maximumSightings;
    }

    public void setSortAllSightings(boolean sortAllSightings) {
        this.sortAllSightings = sortAllSightings;
    }

    public void setCompactOutput(boolean compactPrinting) {
        this.compactOutput = compactPrinting;
    }

    public void setOmitSpAndHybrid(boolean omitSpAndHybrid) {
        this.omitSpAndHybrid = omitSpAndHybrid;
    }
}

