/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.io;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.TaxonVisitor;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.ui.io.TeeToPlainTextResponseWriter;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.reports.FamilyReportPreferences;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class FamilyReportOutput {
    private final QueryResults queryResults;
    private NamesPreferences.ScientificOrCommon scientificOrCommon = NamesPreferences.ScientificOrCommon.COMMON_FIRST;
    private Checklist checklist;
    private Taxonomy taxonomy;
    private QueryPreferences queryPreferences;
    private FamilyReportPreferences.SortBy sortBy = FamilyReportPreferences.SortBy.topCount;

    public FamilyReportOutput(QueryResults queryResults, Taxonomy taxonomy, QueryPreferences queryPreferences) {
        this.queryResults = queryResults;
        this.taxonomy = taxonomy;
        this.queryPreferences = queryPreferences;
    }

    public void setChecklist(Checklist checklist) {
        this.checklist = checklist;
    }

    public void setScientificOrCommon(NamesPreferences.ScientificOrCommon scientificOrCommon) {
        this.scientificOrCommon = scientificOrCommon;
    }

    public void setSortBy(FamilyReportPreferences.SortBy sortBy) {
        this.sortBy = sortBy;
    }

    public String writeReport(Writer writer) throws IOException {
        LinkedHashMap<String, Integer> observedTaxaByFamily = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> possibleTaxaByFamily = new LinkedHashMap<String, Integer>();
        Collection<String> sortedFamilies = this.computeTotalsAndSort(observedTaxaByFamily, possibleTaxaByFamily);
        TeeToPlainTextResponseWriter out = new TeeToPlainTextResponseWriter(new HtmlResponseWriter(new BufferedWriter(writer), "UTF-8"));
        out.startDocument();
        out.startElement("document");
        out.startElement("body");
        int observedFamilies = 0;
        int possibleFamilies = 0;
        for (String familyId : sortedFamilies) {
            if ((Integer)possibleTaxaByFamily.get(familyId) == 0) continue;
            ++possibleFamilies;
            if ((Integer)observedTaxaByFamily.get(familyId) <= 0) continue;
            ++observedFamilies;
        }
        out.startElement("b");
        out.writeText(Messages.getFormattedMessage(Messages.Name.FAMILIES_OF_FORMAT, observedFamilies, possibleFamilies));
        out.endElement("b");
        out.startElement("br");
        out.endElement("br");
        out.startElement("br");
        out.endElement("br");
        for (String familyId : sortedFamilies) {
            if ((Integer)possibleTaxaByFamily.get(familyId) == 0) continue;
            Taxon family = this.taxonomy.getTaxon(familyId);
            out.startElement("b");
            switch (this.scientificOrCommon) {
                case COMMON_FIRST: {
                    if (!Strings.isNullOrEmpty(family.getCommonName())) {
                        out.writeText(family.getCommonName());
                        out.writeText(" (");
                        out.startElement("i");
                        out.writeText(family.getName());
                        out.endElement("i");
                        out.writeText(")");
                        break;
                    }
                    out.writeText(family.getName());
                    break;
                }
                case COMMON_ONLY: {
                    if (!Strings.isNullOrEmpty(family.getCommonName())) {
                        out.writeText(family.getCommonName());
                        break;
                    }
                    out.writeText(family.getName());
                    break;
                }
                case SCIENTIFIC_FIRST: {
                    if (!Strings.isNullOrEmpty(family.getCommonName())) {
                        out.writeText(family.getName());
                        out.writeText(" - ");
                        out.writeText(family.getCommonName());
                        break;
                    }
                    out.writeText(family.getName());
                    break;
                }
                case SCIENTIFIC_ONLY: {
                    out.writeText(family.getName());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected " + this.scientificOrCommon));
                }
            }
            out.endElement("b");
            out.writeText(":\t");
            out.writeText(observedTaxaByFamily.get(familyId));
            out.writeText("/");
            out.writeText(possibleTaxaByFamily.get(familyId));
            out.startElement("br");
            out.endElement("br");
        }
        out.endElement("body");
        out.endElement("document");
        out.endDocument();
        out.flush();
        return out.getPlainText();
    }

    public String writeToTabDelimitedText() throws IOException {
        StringWriter writer = new StringWriter();
        LinkedHashMap<String, Integer> observedTaxaByFamily = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> possibleTaxaByFamily = new LinkedHashMap<String, Integer>();
        Collection<String> sortedFamilies = this.computeTotalsAndSort(observedTaxaByFamily, possibleTaxaByFamily);
        int observedFamilies = 0;
        int possibleFamilies = 0;
        for (String familyId : sortedFamilies) {
            if ((Integer)possibleTaxaByFamily.get(familyId) == 0) continue;
            ++possibleFamilies;
            if ((Integer)observedTaxaByFamily.get(familyId) <= 0) continue;
            ++observedFamilies;
        }
        writer.write(Messages.getFormattedMessage(Messages.Name.FAMILIES_OF_FORMAT, observedFamilies, possibleFamilies));
        writer.write(10);
        for (String familyId : sortedFamilies) {
            if ((Integer)possibleTaxaByFamily.get(familyId) == 0) continue;
            ArrayList<Object> line = new ArrayList<Object>();
            Taxon family = this.taxonomy.getTaxon(familyId);
            switch (this.scientificOrCommon) {
                case COMMON_FIRST: {
                    if (!Strings.isNullOrEmpty(family.getCommonName())) {
                        line.add(family.getCommonName());
                        line.add(family.getName());
                        break;
                    }
                    line.add(family.getName());
                    line.add("");
                    break;
                }
                case COMMON_ONLY: {
                    if (!Strings.isNullOrEmpty(family.getCommonName())) {
                        line.add(family.getCommonName());
                        break;
                    }
                    line.add(family.getName());
                    break;
                }
                case SCIENTIFIC_FIRST: {
                    if (!Strings.isNullOrEmpty(family.getCommonName())) {
                        line.add(family.getName());
                        line.add(family.getCommonName());
                        break;
                    }
                    line.add(family.getName());
                    line.add("");
                    break;
                }
                case SCIENTIFIC_ONLY: {
                    line.add(family.getName());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected " + this.scientificOrCommon));
                }
            }
            line.add("" + observedTaxaByFamily.get(familyId));
            line.add("" + possibleTaxaByFamily.get(familyId));
            writer.write(Joiner.on('\t').join(line));
            writer.write(10);
        }
        return writer.toString();
    }

    private Collection<String> computeTotalsAndSort(final Map<String, Integer> observedTaxaByFamily, final Map<String, Integer> possibleTaxaByFamily) throws AssertionError {
        TaxonUtils.visitTaxa(this.taxonomy, new TaxonVisitor(){

            @Override
            public boolean visitTaxon(Taxon taxon) {
                if (taxon.getType() == Taxon.Type.family) {
                    final LinkedHashSet speciesSet = new LinkedHashSet();
                    TaxonUtils.visitTaxa(taxon, new TaxonVisitor(){

                        @Override
                        public boolean visitTaxon(Taxon child) {
                            if (FamilyReportOutput.this.queryResults.containsTaxonCountably(child)) {
                                Taxon species = TaxonUtils.getParentOfType(child, Taxon.Type.species);
                                speciesSet.add(species.getId());
                                return false;
                            }
                            return true;
                        }
                    });
                    observedTaxaByFamily.put(taxon.getId(), speciesSet.size());
                    int speciesCount = TaxonUtils.countChildren(taxon, Taxon.Type.species, FamilyReportOutput.this.checklist, FamilyReportOutput.this.queryPreferences.excludedChecklistStatuses());
                    if (!FamilyReportOutput.this.queryPreferences.countUndescribed) {
                        final AtomicInteger undescribedCount = new AtomicInteger();
                        TaxonUtils.visitTaxa(taxon, new TaxonVisitor(){

                            @Override
                            public boolean visitTaxon(Taxon child) {
                                if (child.getType() == Taxon.Type.species) {
                                    if (child.getStatus() == Species.Status.UN) {
                                        undescribedCount.incrementAndGet();
                                        speciesSet.remove(child.getId());
                                    }
                                    return false;
                                }
                                return true;
                            }
                        });
                        speciesCount -= undescribedCount.get();
                    }
                    possibleTaxaByFamily.put(taxon.getId(), Math.max(speciesSet.size(), speciesCount));
                    return false;
                }
                return true;
            }
        });
        return switch (this.sortBy) {
            case FamilyReportPreferences.SortBy.taxonomic -> observedTaxaByFamily.keySet();
            case FamilyReportPreferences.SortBy.topCount -> {
                Comparator<String> sortByCount = Comparator.comparingInt(observedTaxaByFamily::get).reversed().thenComparingInt(possibleTaxaByFamily::get);
                yield observedTaxaByFamily.keySet().stream().sorted(sortByCount).collect(ImmutableList.toImmutableList());
            }
            case FamilyReportPreferences.SortBy.topFraction -> {
                Comparator<String> sortByFraction = Comparator.comparingDouble(id -> {
                    if ((Integer)observedTaxaByFamily.get(id) == 0) {
                        return -((Integer)possibleTaxaByFamily.get(id)).intValue();
                    }
                    return (double)((Integer)observedTaxaByFamily.get(id)).intValue() / (double)((Integer)possibleTaxaByFamily.get(id)).intValue();
                }).thenComparingInt(possibleTaxaByFamily::get).reversed();
                yield observedTaxaByFamily.keySet().stream().sorted(sortByFraction).collect(ImmutableList.toImmutableList());
            }
            default -> throw new AssertionError((Object)("Unexpected sort: " + this.sortBy));
        };
    }
}

