/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.io;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.ScanSeenTaxa;
import com.scythebill.birdlist.ui.util.SightingFlags;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.WorkbookUtil;

public class ChecklistXlsOutput {
    private final File file;
    private boolean includeScientific;
    private boolean showLifersInBold;
    private boolean showStatus;
    private boolean includeSighting;
    private boolean showNewForColumn;
    private boolean showFamilies;
    private ImmutableMap<Taxonomy, String> totalText;
    private ImmutableMap<Taxonomy, Checklist> otherTaxonomiesWithChecklists;
    private CellStyle headerStyle;
    private CellStyle familyStyle;
    private CellStyle liferStyle;
    private CellStyle newForLocationStyle;
    private CellStyle scientificStyle;
    private CellStyle headerRowStyle;
    private CellStyle totalStyle;
    private boolean showAllTaxonomies;
    private ChecklistSightingOption checklistSightingOption;

    public ChecklistXlsOutput(File file) {
        this.file = file;
    }

    public void write(ReportSet reportSet, QueryResults queryResults, QueryResults worldResults, Checklist checklist, ScanSeenTaxa scannedTaxa, List<Location> locations, int days) throws IOException {
        try (HSSFWorkbook workbook = new HSSFWorkbook();){
            this.headerStyle = workbook.createCellStyle();
            Font headerFont = workbook.createFont();
            headerFont.setBold(true);
            this.headerStyle.setFont(headerFont);
            this.headerStyle.setBorderBottom(BorderStyle.THICK);
            this.headerStyle.setAlignment(HorizontalAlignment.CENTER);
            this.familyStyle = workbook.createCellStyle();
            Font familyFont = workbook.createFont();
            familyFont.setBold(true);
            this.familyStyle.setFont(familyFont);
            this.liferStyle = workbook.createCellStyle();
            Font liferFont = workbook.createFont();
            liferFont.setBold(true);
            this.liferStyle.setFont(liferFont);
            this.newForLocationStyle = workbook.createCellStyle();
            Font newForLocationFont = workbook.createFont();
            newForLocationFont.setItalic(true);
            this.newForLocationStyle.setFont(newForLocationFont);
            this.scientificStyle = workbook.createCellStyle();
            Font scientificFont = workbook.createFont();
            scientificFont.setItalic(true);
            this.scientificStyle.setFont(scientificFont);
            this.headerRowStyle = workbook.createCellStyle();
            this.headerStyle.setBorderBottom(BorderStyle.THICK);
            this.headerStyle.setAlignment(HorizontalAlignment.CENTER);
            this.totalStyle = workbook.createCellStyle();
            this.totalStyle.cloneStyleFrom(this.headerStyle);
            this.totalStyle.setAlignment(HorizontalAlignment.GENERAL);
            Sheet sheet = workbook.createSheet(WorkbookUtil.createSafeSheetName(queryResults.getTaxonomy().getName()));
            this.writeSheet(sheet, reportSet, queryResults, worldResults, checklist, scannedTaxa, locations, days, queryResults.getTaxonomy());
            if (this.showAllTaxonomies && this.otherTaxonomiesWithChecklists != null) {
                this.otherTaxonomiesWithChecklists.forEach((otherTaxonomy, otherChecklist) -> {
                    Sheet otherSheet = workbook.createSheet(WorkbookUtil.createSafeSheetName(otherTaxonomy.getName()));
                    this.writeSheet(otherSheet, reportSet, queryResults, worldResults, (Checklist)otherChecklist, scannedTaxa, locations, days, (Taxonomy)otherTaxonomy);
                });
            }
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.file));){
                workbook.write(out);
            }
        }
    }

    private void writeSheet(Sheet sheet, ReportSet reportSet, QueryResults queryResults, QueryResults worldResults, Checklist checklist, ScanSeenTaxa scannedTaxa, List<Location> locations, int days, Taxonomy taxonomy) {
        ArrayList<Location> locationsWithSightings = new ArrayList<Location>();
        for (Location location : locations) {
            Set<String> seenTaxa;
            if (location == null || (seenTaxa = scannedTaxa.getSeenTaxa(taxonomy, location)) == null || seenTaxa.isEmpty()) continue;
            locationsWithSightings.add(0, location);
        }
        Set<String> worldSeenTaxa = scannedTaxa.getSeenTaxa(taxonomy, null);
        Set<String> photographedTaxa = scannedTaxa.getPhotographedTaxa(taxonomy);
        boolean includePhotographedColumn = photographedTaxa != null && photographedTaxa.size() > 50;
        Row header = sheet.createRow(0);
        header.setRowStyle(this.headerRowStyle);
        if (this.totalText != null) {
            Cell cell = header.createCell(0);
            cell.setCellValue(this.totalText.get(taxonomy));
            cell.setCellStyle(this.totalStyle);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 1 + (this.includeScientific ? 1 : 0) + (this.includeSighting ? 1 : 0)));
        }
        int firstDayOffset = 2;
        int sightingColumn = -1;
        if (this.includeScientific) {
            ++firstDayOffset;
        }
        if (this.includeSighting) {
            sightingColumn = firstDayOffset++;
        }
        int newForColumn = -1;
        if (this.showNewForColumn) {
            newForColumn = firstDayOffset++;
            Cell cell = header.createCell(newForColumn);
            cell.setCellValue(Messages.getMessage(Messages.Name.NEW_FOR_COLUMN));
            cell.setCellStyle(this.headerStyle);
        }
        for (int i = 0; i < days; ++i) {
            Cell cell = header.createCell(i + firstDayOffset);
            cell.setCellValue(i + 1);
            cell.setCellStyle(this.headerStyle);
        }
        sheet.createFreezePane(0, 1, 0, 1);
        int rowCount = 1;
        int speciesCount = 1;
        List<SightingTaxon.Resolved> taxa = taxonomy == queryResults.getTaxonomy() ? queryResults.getTaxaAsList() : queryResults.getIncompatibleTaxaAsList(taxonomy, this.showFamilies);
        block6: for (SightingTaxon.Resolved resolved : taxa) {
            Species.Status taxonStatus;
            boolean foundFamily;
            boolean bl = foundFamily = resolved.getLargestTaxonType() == Taxon.Type.family;
            if (foundFamily && rowCount > 1 && this.showFamilies) {
                ++rowCount;
            }
            int column = 0;
            if (foundFamily) {
                if (!this.showFamilies) continue;
                Row row = sheet.createRow(rowCount++);
                Cell common = row.createCell(column++);
                common.setCellStyle(this.familyStyle);
                String text = this.includeScientific ? String.format("%s (%s)", resolved.getCommonName(), resolved.getFullName()) : resolved.getCommonName();
                common.setCellValue(text);
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), 0, 1 + (this.includeScientific ? 1 : 0) + (this.includeSighting ? 1 : 0)));
                continue;
            }
            Checklist.Status status = checklist.getStatus(resolved.getTaxonomy(), resolved.getSightingTaxon());
            boolean sightingFromWorld = this.checklistSightingOption == ChecklistSightingOption.FIRST_IN_WORLD || this.checklistSightingOption == ChecklistSightingOption.MOST_RECENT_IN_WORLD;
            QueryResults resultsForSighting = sightingFromWorld ? worldResults : queryResults;
            Ordering<Sighting> ordering = this.checklistSightingOption == ChecklistSightingOption.FIRST_IN_LOCATION || this.checklistSightingOption == ChecklistSightingOption.FIRST_IN_WORLD ? SightingComparators.preferEarlier() : SightingComparators.preferMoreRecent();
            Sighting bestSighting = resultsForSighting.getBestSighting(resolved, ordering);
            if (status == Checklist.Status.ESCAPED && (!this.includeSighting || bestSighting == null || sightingFromWorld)) continue;
            Row row = sheet.createRow(rowCount++);
            Cell speciesNumber = row.createCell(column);
            speciesNumber.setCellValue(Integer.toString(speciesCount++));
            int n = ++column;
            ++column;
            Cell common = row.createCell(n);
            boolean isLifer = false;
            if ((this.showLifersInBold || this.showNewForColumn) && worldSeenTaxa != null && resolved.getType() == SightingTaxon.Type.SINGLE) {
                boolean bl2 = isLifer = !worldSeenTaxa.contains(resolved.getTaxon().getId());
            }
            if (this.showLifersInBold) {
                if (isLifer) {
                    common.setCellStyle(this.liferStyle);
                } else if (bestSighting == null) {
                    common.setCellStyle(this.newForLocationStyle);
                }
            }
            Object text = resolved.getCommonName();
            if (status != null) {
                switch (status) {
                    case ENDEMIC: 
                    case RARITY: 
                    case INTRODUCED: 
                    case ESCAPED: 
                    case EXTINCT: {
                        text = (String)text + " (" + Messages.getText(status) + ")";
                        break;
                    }
                    case RARITY_FROM_INTRODUCED: {
                        text = (String)text + " (" + Messages.getText(Checklist.Status.RARITY) + ")";
                        break;
                    }
                }
            }
            if (this.showStatus && (taxonStatus = resolved.getTaxonStatus()) != Species.Status.LC && taxonStatus != Species.Status.NT) {
                text = (String)text + " - " + taxonStatus.name();
            }
            common.setCellValue((String)text);
            if (this.includeScientific) {
                Cell scientific = row.createCell(column++);
                scientific.setCellStyle(this.scientificStyle);
                scientific.setCellValue(resolved.getFullName());
            }
            if (this.includeSighting && bestSighting != null) {
                Object sightingText;
                if (bestSighting.getLocationId() != null) {
                    Location location = reportSet.getLocations().getLocation(bestSighting.getLocationId());
                    if (sightingFromWorld) {
                        Location country;
                        Location parentOfType;
                        Location.Type locationType;
                        Location.Type type = locationType = locations.get(0) == null ? null : locations.get(0).getType();
                        if (locationType == null) {
                            locationType = Location.Type.country;
                        }
                        if ((parentOfType = Locations.getAncestorOfType(location, locationType)) != null) {
                            location = parentOfType;
                        } else if (locationType != Location.Type.country && (country = Locations.getAncestorOfType(location, Location.Type.country)) != null) {
                            location = country;
                        }
                    }
                    sightingText = location.getDisplayName();
                } else {
                    sightingText = "";
                }
                if (bestSighting.getStoredDateAsPartial() != null) {
                    String dateText = PartialIO.toShortUserString(bestSighting.getStoredDateAsPartial(), Locale.getDefault());
                    sightingText = ((String)sightingText).isEmpty() ? dateText : (String)sightingText + " " + dateText;
                } else if (bestSighting.getTrip() != null && !Strings.isNullOrEmpty(bestSighting.getTrip().name())) {
                    sightingText = (String)sightingText + " " + bestSighting.getTrip().name();
                }
                sightingText = SightingFlags.appendSightingInfo((String)sightingText, bestSighting);
                Cell sightingCell = row.createCell(column++);
                sightingCell.setCellValue((String)sightingText);
            }
            if (!this.showNewForColumn || resolved.getType() != SightingTaxon.Type.SINGLE) continue;
            Cell newFor = row.createCell(newForColumn);
            if (isLifer) {
                newFor.setCellValue(Messages.getMessage(Messages.Name.WORLD_TEXT));
                continue;
            }
            if (includePhotographedColumn && scannedTaxa.getPhotographedTaxa(taxonomy) != null && !scannedTaxa.getPhotographedTaxa(taxonomy).contains(resolved.getTaxon().getId())) {
                newFor.setCellValue(Messages.getMessage(Messages.Name.PHOTOGRAPHED_TEXT));
                continue;
            }
            for (Location location : locationsWithSightings) {
                Set<String> locationSeenTaxa = scannedTaxa.getSeenTaxa(taxonomy, location);
                if (locationSeenTaxa == null || locationSeenTaxa.contains(resolved.getTaxon().getId())) continue;
                newFor.setCellValue(location.getDisplayName());
                continue block6;
            }
        }
        sheet.autoSizeColumn(0);
        sheet.autoSizeColumn(1);
        if (this.includeScientific) {
            sheet.autoSizeColumn(2);
        }
        sheet.setRepeatingRows(new CellRangeAddress(0, 0, 0, 1));
        sheet.getPrintSetup().setLandscape(true);
        sheet.getPrintSetup().setFitWidth((short)1);
        sheet.getPrintSetup().setFitHeight((short)(rowCount / 20));
        sheet.setPrintGridlines(true);
        sheet.setFitToPage(true);
        if (sightingColumn >= 0) {
            sheet.autoSizeColumn(sightingColumn);
        }
        if (newForColumn >= 0) {
            sheet.autoSizeColumn(newForColumn);
        }
    }

    public void setIncludeScientific(boolean includeScientific) {
        this.includeScientific = includeScientific;
    }

    public void setShowLifersInBold(boolean showLifersInBold) {
        this.showLifersInBold = showLifersInBold;
    }

    public void setShowNewForColumn(boolean showNewForColumn) {
        this.showNewForColumn = showNewForColumn;
    }

    public void setShowFamilies(boolean showFamilies) {
        this.showFamilies = showFamilies;
    }

    public void setShowStatus(boolean showStatus) {
        this.showStatus = showStatus;
    }

    public void setIncludeSighting(boolean includeSighting) {
        this.includeSighting = includeSighting;
    }

    public void setChecklistSightingOption(ChecklistSightingOption checklistSightingOption) {
        this.checklistSightingOption = checklistSightingOption;
    }

    public void setTotalText(Map<Taxonomy, String> totalTextMap) {
        this.totalText = ImmutableMap.copyOf(totalTextMap);
    }

    public void setOtherTaxonomiesWithChecklists(Map<Taxonomy, Checklist> otherTaxonomiesWithChecklists) {
        this.otherTaxonomiesWithChecklists = ImmutableMap.copyOf(otherTaxonomiesWithChecklists);
    }

    public void setShowAllTaxonomies(boolean showAllTaxonomies) {
        this.showAllTaxonomies = showAllTaxonomies;
    }

    public static enum ChecklistSightingOption {
        FIRST_IN_LOCATION,
        MOST_RECENT_IN_LOCATION,
        FIRST_IN_WORLD,
        MOST_RECENT_IN_WORLD;

    }
}

