/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.io;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.io.IndentingResponseWriter;
import com.scythebill.birdlist.model.io.ResponseWriter;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.ui.io.IOUtils;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.ScanSeenTaxa;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ChecklistHtmlOutput {
    private static final String PRINT_SCRIPT = "window.print();";
    private static final String TEST_FOR_SAFARI = Joiner.on('\n').join("var isSafari = navigator.vendor && navigator.vendor.indexOf('Apple') > -1 &&", "    navigator.userAgent && !navigator.userAgent.match('CriOS');", "if (isSafari) {", "  alert('Compact printing is not supported in Safari;  please load in Chrome or Firefox');", "} else {", "window.print();", "}");
    private final String CSS_STYLE_COMMON = Joiner.on(System.getProperty("line.separator")).join("body { font-size: 13px; }", "table { border-spacing: 0px; }", "th.familyTitle { font-weight: bold; font-size: 135%; padding-top: 10px; text-align: left }", ".lifer { font-weight: bold }", ".scientific { font-style: italic }", ".total { font-size: 110%; font-weight: bold }");
    private final String CSS_STYLE_COMPACT_OUTPUT = Joiner.on(System.getProperty("line.separator")).join("body { font-size: 11px; }", "h2.familyTitle { font-weight: bold; font-size: 135%; text-transform: uppercase; font-style: italic; }", ".lifer { font-weight: bold }", ".scientific { font-style: italic }", ".main { column-count: 3; -webkit-column-count: 3; -moz-column-count: 3; }", ".total { font-size: 110%; font-weight: bold }");
    private final String CSS_STYLE_COMPACT_OUTPUT_WITH_ONE_NAME = Joiner.on(System.getProperty("line.separator")).join("body { font-size: 13px; }", "h2.familyTitle { font-weight: bold; font-size: 135%; text-transform: uppercase; font-style: italic; }", ".lifer { font-weight: bold }", ".main { column-count: 3; -webkit-column-count: 3; -moz-column-count: 3; }", ".total { font-size: 110%; font-weight: bold }");
    private final String CSS_STYLE_SINGLE_SIGHTING = "td.name { margin-right: 20px; width: 45% }";
    private final String CSS_STYLE_SINGLE_SIGHTING_NO_SCI = "td.name { margin-right: 20px; width: 30% }";
    private final String CSS_STYLE_WITH_DAYS_FORMAT = Joiner.on(System.getProperty("line.separator")).join("th.days { font-weight: bold; font-size: 135%%; text-align: center; width %.1f%%; border-width: 1px; border-style: dotted}", "td.days {border-width: 1px; border-style: dotted}", new Object[0]);
    private String title;
    private final Taxonomy taxonomy;
    private boolean showFamilies;
    private boolean showStatus;
    private NamesPreferences.ScientificOrCommon scientificOrCommon;
    private boolean compactOutput;
    private String totalText;
    private boolean print;
    private boolean showLifersInBold;
    private int daysToInclude = 0;

    public ChecklistHtmlOutput(Taxonomy taxonomy) {
        this.taxonomy = taxonomy;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void writeSpeciesList(File outFile, ReportSet reportSet, QueryResults queryResults, Checklist checklist, ScanSeenTaxa scannedTaxa, List<Location> locations) throws IOException {
        try (Writer out = IOUtils.openNewFile(outFile, StandardCharsets.UTF_8);){
            this.writeSpeciesList(out, reportSet, queryResults, checklist, scannedTaxa, locations);
        }
    }

    public void writeSpeciesList(Writer out, ReportSet reportSet, QueryResults queryResults, Checklist checklist, ScanSeenTaxa scannedTaxa, List<Location> locations) throws IOException {
        IndentingResponseWriter rw = new IndentingResponseWriter(new HtmlResponseWriter(out, "UTF-8"));
        this.startHtml(rw, this.title);
        this.startChecklist(rw);
        ArrayList<Location> locationsWithSightings = new ArrayList<Location>();
        for (Location location : locations) {
            Set<String> seenTaxa;
            if (location == null || (seenTaxa = scannedTaxa.getSeenTaxa(this.taxonomy, location)) == null || seenTaxa.isEmpty()) continue;
            locationsWithSightings.add(0, location);
        }
        List<SightingTaxon.Resolved> taxa = queryResults.getTaxaAsList();
        for (int i = 0; i < taxa.size(); ++i) {
            SightingTaxon.Resolved taxon = taxa.get(i);
            if (taxon.getSmallestTaxonType() == Taxon.Type.family) {
                this.writeFamilyHeader(rw, taxon.getTaxon(), taxa.subList(i + 1, taxa.size()), queryResults);
                continue;
            }
            this.writeSpecies(rw, taxon, checklist, scannedTaxa, locationsWithSightings);
        }
        this.endChecklist(rw);
        if (!Strings.isNullOrEmpty(this.totalText)) {
            rw.startElement("p");
            ((ResponseWriter)rw).writeAttribute("class", "total");
            ((Writer)rw).write(this.totalText);
            ((ResponseWriter)rw).endElement("p");
        }
        rw.startElement("p");
        ((Writer)rw).write(this.taxonomy.getName());
        ((ResponseWriter)rw).endElement("p");
        this.endHtml(rw);
        ((Writer)rw).flush();
    }

    private void writeSpecies(ResponseWriter rw, SightingTaxon.Resolved taxon, Checklist checklist, ScanSeenTaxa scannedTaxa, List<Location> locationsWithSightings) throws IOException {
        Species.Status status;
        Checklist.Status checklistStatus;
        if (this.compactOutput) {
            rw.startElement("div");
            rw.writeAttribute("class", "species");
            rw.startElement("span");
        } else {
            rw.startElement("tr");
            rw.writeAttribute("class", "species");
            rw.startElement("td");
            rw.writeAttribute("class", "name");
        }
        rw.writeText("___ ");
        rw.startElement("span");
        if (this.showLifersInBold && taxon.getType() == SightingTaxon.Type.SINGLE && !scannedTaxa.getSeenTaxa(this.taxonomy, null).contains(taxon.getTaxon().getId())) {
            rw.writeAttribute("class", "common lifer");
        } else {
            rw.writeAttribute("class", "common");
        }
        switch (this.scientificOrCommon) {
            case COMMON_FIRST: {
                rw.writeText(taxon.getSimpleCommonName());
                break;
            }
            case COMMON_ONLY: {
                rw.writeText(taxon.getCommonName());
                break;
            }
            case SCIENTIFIC_FIRST: 
            case SCIENTIFIC_ONLY: {
                rw.writeText(taxon.getFullName());
            }
        }
        SightingTaxon species = taxon.getSmallestTaxonType() == Taxon.Type.species ? taxon.getSightingTaxon() : taxon.getParentOfAtLeastType(Taxon.Type.species);
        rw.endElement("span");
        if (this.scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_FIRST || this.scientificOrCommon == NamesPreferences.ScientificOrCommon.SCIENTIFIC_FIRST) {
            rw.startElement("span");
            rw.writeAttribute("class", "scientific");
            rw.writeText(Character.valueOf('('));
            rw.writeText(this.scientificOrCommon == NamesPreferences.ScientificOrCommon.SCIENTIFIC_FIRST ? taxon.getSimpleCommonName() : taxon.getFullName());
            rw.writeText(Character.valueOf(')'));
            rw.endElement("span");
        }
        if ((checklistStatus = checklist.getStatus(this.taxonomy, species)) != Checklist.Status.NATIVE && checklistStatus != null) {
            rw.writeText(" - " + Messages.getText(checklistStatus));
        }
        if (this.showStatus && (status = taxon.getTaxonStatus()) != Species.Status.LC && status != Species.Status.NT) {
            rw.writeText(" (" + status + ")");
        }
        if (this.compactOutput) {
            rw.endElement("span");
        } else {
            rw.endElement("td");
        }
        if (!this.compactOutput && this.daysToInclude > 0) {
            for (int i = 1; i <= this.daysToInclude; ++i) {
                rw.startElement("td");
                rw.writeAttribute("class", "days");
                rw.endElement("td");
            }
        }
        if (this.compactOutput) {
            rw.endElement("div");
        } else {
            rw.endElement("tr");
        }
    }

    private void writeFamilyHeader(ResponseWriter rw, Taxon family, List<SightingTaxon.Resolved> list, QueryResults queryResults) throws IOException {
        if (!this.showFamilies) {
            return;
        }
        if (this.compactOutput) {
            rw.startElement("h2");
        } else {
            rw.startElement("tr");
            rw.startElement("th");
            rw.writeAttribute("colspan", 1 + this.daysToInclude);
        }
        rw.writeAttribute("class", "familyTitle");
        switch (this.scientificOrCommon) {
            case COMMON_FIRST: {
                rw.writeText(family.getCommonName());
                rw.writeText(" (");
                rw.writeText(family.getName());
                rw.writeText(")");
                break;
            }
            case SCIENTIFIC_FIRST: {
                rw.writeText(family.getName());
                rw.writeText(" (");
                rw.writeText(family.getCommonName());
                rw.writeText(")");
                break;
            }
            case SCIENTIFIC_ONLY: {
                rw.writeText(family.getName());
                break;
            }
            case COMMON_ONLY: {
                rw.writeText(family.getCommonName());
            }
        }
        if (this.compactOutput) {
            rw.endElement("h2");
        } else {
            rw.endElement("th");
            rw.endElement("tr");
        }
    }

    private void startHtml(ResponseWriter rw, String title) throws IOException {
        boolean scientificAndCommon;
        rw.startDocument();
        rw.writeComment("saved from url=(0016)http://localhost");
        rw.startElement("html");
        rw.startElement("head");
        rw.startElement("meta");
        rw.writeAttribute("http-equiv", "Content-Type");
        rw.writeAttribute("content", "text/html; charset=UTF-8");
        rw.endElement("meta");
        if (title != null) {
            rw.startElement("title");
            rw.writeText(title);
            rw.endElement("title");
        }
        rw.startElement("style");
        rw.writeAttribute("type", "text/css");
        boolean bl = scientificAndCommon = this.scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_FIRST || this.scientificOrCommon == NamesPreferences.ScientificOrCommon.SCIENTIFIC_FIRST;
        if (this.compactOutput) {
            rw.writeText(scientificAndCommon ? this.CSS_STYLE_COMPACT_OUTPUT : this.CSS_STYLE_COMPACT_OUTPUT_WITH_ONE_NAME);
        } else {
            rw.writeText(this.CSS_STYLE_COMMON);
            rw.writeText(scientificAndCommon ? "td.name { margin-right: 20px; width: 45% }" : "td.name { margin-right: 20px; width: 30% }");
            if (this.daysToInclude > 0) {
                double daysPercentage = (scientificAndCommon ? 55.0 : 70.0) / (double)this.daysToInclude;
                rw.writeText(String.format(this.CSS_STYLE_WITH_DAYS_FORMAT, daysPercentage));
            }
        }
        rw.endElement("style");
        if (this.print) {
            rw.startElement("script");
            rw.writeAttribute("type", "text/javascript");
            rw.writeRawText("function onload_script() {\n");
            if (this.compactOutput) {
                rw.writeRawText(TEST_FOR_SAFARI);
            } else {
                rw.writeRawText(PRINT_SCRIPT);
            }
            rw.writeRawText("\n}");
            rw.endElement("script");
        }
        rw.endElement("head");
        rw.startElement("body");
        if (this.print) {
            rw.writeAttribute("onload", "onload_script();");
        }
    }

    private void startChecklist(ResponseWriter rw) throws IOException {
        if (this.compactOutput) {
            rw.startElement("div");
            rw.writeAttribute("class", "main");
        } else {
            rw.startElement("table");
            rw.writeAttribute("width", "100%");
            if (this.daysToInclude > 0) {
                rw.startElement("thead");
                rw.startElement("tr");
                rw.startElement("th");
                rw.endElement("th");
                for (int i = 1; i <= this.daysToInclude; ++i) {
                    rw.startElement("th");
                    rw.writeAttribute("class", "days");
                    rw.writeText("\u00a0\u00a0");
                    rw.writeText(i);
                    rw.writeText("\u00a0\u00a0");
                    rw.endElement("th");
                }
                rw.endElement("tr");
                rw.endElement("thead");
            }
            rw.startElement("tbody");
        }
    }

    private void endChecklist(ResponseWriter rw) throws IOException {
        if (this.compactOutput) {
            rw.endElement("div");
        } else {
            rw.endElement("tbody");
            rw.endElement("table");
        }
    }

    private void endHtml(ResponseWriter rw) throws IOException {
        rw.endElement("body");
        rw.endElement("html");
        rw.endDocument();
    }

    public void setShowFamilies(boolean showFamilies) {
        this.showFamilies = showFamilies;
    }

    public void setShowStatus(boolean showStatus) {
        this.showStatus = showStatus;
    }

    public void setScientificOrCommon(NamesPreferences.ScientificOrCommon scientificOrCommon) {
        this.scientificOrCommon = scientificOrCommon;
    }

    public void setCompactOutput(boolean compactPrinting) {
        this.compactOutput = compactPrinting;
    }

    public void setTotalText(String totalText) {
        this.totalText = totalText;
    }

    public void setShowLifersInBold(boolean showLifersInBold) {
        this.showLifersInBold = showLifersInBold;
    }

    public void setDaysToInclude(int daysToInclude) {
        this.daysToInclude = daysToInclude;
    }
}

