/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports.flickr;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.flickr.FlickrApi;
import com.scythebill.birdlist.ui.imports.flickr.FlickrApiException;
import com.scythebill.birdlist.ui.imports.flickr.FlickrImporter;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;

public class FlickrImporterFactory {
    private final FlickrApi flickrApi;
    private final ReportSet reportSet;
    private final File reportSetFile;
    private final TaxonomyStore taxonomyStore;
    private final Checklists checklists;
    private final PredefinedLocations predefinedLocations;
    private final Gson gson;

    @Inject
    public FlickrImporterFactory(ReportSet reportSet, @Nullable File reportSetFile, TaxonomyStore taxonomyStore, Checklists checklists, PredefinedLocations predefinedLocations, FlickrApi flickrApi, Gson gson) {
        this.reportSet = reportSet;
        this.reportSetFile = reportSetFile;
        this.taxonomyStore = taxonomyStore;
        this.checklists = checklists;
        this.predefinedLocations = predefinedLocations;
        this.flickrApi = flickrApi;
        this.gson = gson;
    }

    public SightingsImporter<?> newFlickrImporter(String albumUri, Location location) throws IOException, FlickrApiException {
        FlickrApi.PhotoSet lookupAlbum = this.flickrApi.isAlbumUrl(albumUri) ? this.flickrApi.lookupAlbum(albumUri) : this.flickrApi.lookupPhoto(albumUri);
        return new FlickrImporter(this.reportSet, this.taxonomyStore.getTaxonomy(), this.checklists, this.predefinedLocations, lookupAlbum, albumUri, location, this.reportSetFile, this.gson);
    }
}

