/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports.flickr;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.checklist.TransposedChecklist;
import com.scythebill.birdlist.model.checklist.TransposedChecklists;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TaxonPossibilities;
import com.scythebill.birdlist.ui.imports.flickr.FlickrApi;
import com.scythebill.birdlist.ui.util.FindSpeciesInText;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.joda.time.ReadablePartial;

class FlickrImporter
extends SightingsImporter<PhotoWithTaxa> {
    private final FlickrApi.PhotoSet photoSet;
    private final String uri;
    private final Location location;
    private final File reportSetFile;
    private final Gson gson;
    private final List<PhotoWithTaxa> photosWithTaxa;
    private final List<PhotoWithTaxa> failedPhotos = new ArrayList<PhotoWithTaxa>();

    public FlickrImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, FlickrApi.PhotoSet photoSet, String uri, Location location, @Nullable File reportSetFile, Gson gson) {
        super(reportSet, taxonomy, checklists, predefinedLocations);
        this.reportSetFile = reportSetFile;
        this.gson = gson;
        this.photoSet = Preconditions.checkNotNull(photoSet);
        this.uri = Preconditions.checkNotNull(uri);
        this.location = location;
        this.photosWithTaxa = this.extractTaxa();
    }

    @Override
    protected void operateOnAllRows(SightingsImporter.RowOperator<PhotoWithTaxa> operator2) throws IOException {
        for (PhotoWithTaxa photo : this.photosWithTaxa) {
            operator2.operate(photo);
        }
    }

    @Override
    protected TaxonImporter<PhotoWithTaxa> newTaxonImporter(Taxonomy taxonomy) {
        return new TaxonImporter<PhotoWithTaxa>(){

            @Override
            public TaxonPossibilities map(PhotoWithTaxa line) {
                return line.possibilities;
            }

            @Override
            public TaxonImporter.ToBeDecided decideLater(PhotoWithTaxa line) {
                TaxonImporter.ToBeDecided tbd = new TaxonImporter.ToBeDecided();
                tbd.longText = Joiner.on('\n').skipNulls().join(line.photo.title, line.photo.description(), new Object[0]);
                return tbd;
            }
        };
    }

    @Override
    protected RowExtractor<PhotoWithTaxa, ? extends Object> taxonomyIdExtractor() {
        return new RowExtractor<PhotoWithTaxa, Object>(){

            @Override
            public Object extract(PhotoWithTaxa row) {
                return String.format("%s|%s", Strings.nullToEmpty(row.photo.title), Strings.nullToEmpty(row.photo.description()));
            }
        };
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
    }

    @Override
    public List<Sighting> parseSightings() throws IOException {
        if (this.location != null) {
            this.reportSet.getLocations().ensureAdded(this.location);
        }
        RowExtractor<PhotoWithTaxa, ? extends Object> taxonomyIdExtractor = this.taxonomyIdExtractor();
        ArrayList mappers = new ArrayList();
        mappers.add((photo, builder) -> {
            Object description;
            if (this.location != null) {
                builder.setLocation(this.location);
            } else if (this.getTaxonomy().isBuiltIn()) {
                SightingTaxon.Resolved resolved = builder.getTaxon().resolve(this.getTaxonomy());
                TransposedChecklist transposedChecklist = TransposedChecklists.instance().getTransposedChecklist(this.reportSet, this.getTaxonomy());
                Location location = TransposedChecklists.getAssumedLocation(resolved, this.reportSet.getLocations(), this.predefinedLocations, transposedChecklist);
                if (location != null) {
                    this.reportSet.getLocations().ensureAdded(location);
                    builder.setLocation(location);
                }
            }
            ReadablePartial date = photo.photo.date();
            if (date != null) {
                builder.setDate(date);
            }
            if ((description = photo.remainingDescription) != null) {
                ImmutableSet<String> words = ImmutableSet.copyOf(Splitter.on(CharMatcher.whitespace().or(CharMatcher.anyOf(",."))).split(((String)description).toLowerCase()));
                if (words.contains("male") || words.contains("males")) {
                    builder.getSightingInfo().setMale(true);
                }
                if (words.contains("female") || words.contains("females")) {
                    builder.getSightingInfo().setFemale(true);
                }
                if (words.contains("adult") || words.contains("adults")) {
                    builder.getSightingInfo().setAdult(true);
                }
                if (words.contains("imm") || words.contains("immature") || words.contains("juv") || words.contains("juvenile") || words.contains("immatures") || words.contains("juveniles")) {
                    builder.getSightingInfo().setImmature(true);
                }
            }
            if (photo.photo.latitude != null && !photo.photo.latitude.equals("0") && photo.photo.longitude != null && !photo.photo.longitude.equals("0")) {
                try {
                    String latLong = String.format(Strings.isNullOrEmpty((String)description) ? "LL:%s,%s" : "\nLL:%s,%s", photo.photo.latitude, photo.photo.longitude);
                    description = Strings.nullToEmpty((String)description) + latLong;
                }
                catch (IllegalArgumentException latLong) {
                    // empty catch block
                }
            }
            if (!Strings.isNullOrEmpty(photo.photo.tags)) {
                String addingHashTags = Splitter.on(CharMatcher.whitespace()).splitToList(photo.photo.tags).stream().map(s -> s.startsWith("#") ? s : "#" + s).collect(Collectors.joining(" "));
                Object object = description = Strings.isNullOrEmpty((String)description) ? addingHashTags : (String)description + "\n" + addingHashTags;
            }
            if (!Strings.isNullOrEmpty((String)description)) {
                builder.getSightingInfo().setDescription((String)description);
            }
            builder.getSightingInfo().setPhotos(ImmutableList.of(new Photo(URI.create(photo.photo.photoPage(this.photoSet.originalOwnerString)))));
        });
        ComputedMappings computedMappings = new ComputedMappings(new SightingsImporter.TaxonFieldMapper(this, this.taxonomyIdExtractor()), null, mappers);
        ArrayList<Sighting> sightings = new ArrayList<Sighting>();
        for (PhotoWithTaxa photo2 : this.photosWithTaxa) {
            this.parseSighting(photo2, computedMappings::mapAll, taxonomyIdExtractor::extract, sightings, computedMappings::skipLocationAndTaxonAndUser);
        }
        return sightings;
    }

    @Override
    public String importFileName() {
        List<String> list = Splitter.on('/').omitEmptyStrings().splitToList(this.uri);
        return list.get(list.size() - 1);
    }

    @Override
    protected void importRowFailed(PhotoWithTaxa importRow) {
        this.failedPhotos.add(importRow);
    }

    @Override
    public File writeFailedLines() {
        File file;
        File reportSetFileDirectory;
        if (this.reportSetFile != null) {
            reportSetFileDirectory = this.reportSetFile.getParentFile();
        } else {
            Path currentRelativePath = Paths.get("", new String[0]);
            reportSetFileDirectory = currentRelativePath.toFile();
        }
        File baseFailedLinesFile = new File(reportSetFileDirectory, this.importFileName() + ".json");
        File failedLinesFile = null;
        for (int i = 0; i < 50 && (failedLinesFile = this.failedFile(baseFailedLinesFile, i)).exists(); ++i) {
        }
        if (failedLinesFile == null || failedLinesFile.exists()) {
            return null;
        }
        if (!failedLinesFile.createNewFile()) {
            return null;
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(failedLinesFile), StandardCharsets.UTF_8));
        try {
            this.gson.toJson((Object)this.failedPhotos.stream().map(p -> p.photo).collect(ImmutableList.toImmutableList()).toArray(), (Appendable)out);
            file = failedLinesFile;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)out).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        ((Writer)out).close();
        return file;
    }

    private File failedFile(File openFile, int index) {
        Object failedLinesFileName = openFile.getName();
        if (((String)failedLinesFileName).indexOf(46) >= 0) {
            failedLinesFileName = ((String)failedLinesFileName).substring(0, ((String)failedLinesFileName).lastIndexOf(46));
        }
        failedLinesFileName = index == 0 ? (String)failedLinesFileName + "-failed.json" : (String)failedLinesFileName + "-" + index + "-failed.json";
        return new File(openFile.getParentFile(), (String)failedLinesFileName);
    }

    private List<PhotoWithTaxa> extractTaxa() {
        ArrayList<PhotoWithTaxa> photosWithTaxa = new ArrayList<PhotoWithTaxa>(this.photoSet.photo.size());
        Checklist checklist = this.getBuiltInChecklist(this.location);
        FindSpeciesInText globalFindSpecies = new FindSpeciesInText(this.getTaxonomy(), null);
        FindSpeciesInText localFindSpecies = checklist == null ? null : new FindSpeciesInText(this.getTaxonomy(), checklist);
        for (FlickrApi.FlickrPhoto photo : this.photoSet.photo) {
            PhotoWithTaxa photoWithTaxa = new PhotoWithTaxa(photo);
            photosWithTaxa.add(photoWithTaxa);
            if (localFindSpecies != null) {
                photoWithTaxa.search(localFindSpecies, photo.title);
                photoWithTaxa.search(localFindSpecies, photo.description());
            }
            if (photoWithTaxa.possibilities != null) continue;
            photoWithTaxa.remainingDescription = null;
            photoWithTaxa.search(globalFindSpecies, photo.title);
            photoWithTaxa.search(globalFindSpecies, photo.description());
        }
        return photosWithTaxa;
    }

    @Override
    public boolean expectTaxonSuccess() {
        return false;
    }

    class PhotoWithTaxa {
        final FlickrApi.FlickrPhoto photo;
        TaxonPossibilities possibilities;
        String remainingDescription;

        PhotoWithTaxa(FlickrApi.FlickrPhoto photo) {
            this.photo = photo;
        }

        void search(FindSpeciesInText findSpecies, String text) {
            if (Strings.isNullOrEmpty(text)) {
                return;
            }
            FindSpeciesInText.Results results = findSpecies.search(text, findSpecies.primarySearch());
            if (results.found.size() > 2) {
                LinkedHashSet taxa = new LinkedHashSet();
                for (SightingTaxon.Resolved result : results.found) {
                    taxa.addAll(result.getSightingTaxon().getIds());
                }
                this.addPrimary(SightingTaxons.newPossiblySpTaxon(taxa));
            } else {
                for (SightingTaxon.Resolved result : results.found) {
                    this.addPrimary(result.getSightingTaxon());
                }
            }
            results = findSpecies.search(results.remainingText, findSpecies.secondarySearch(false));
            boolean noPrimariesYet = this.possibilities == null;
            for (SightingTaxon.Resolved result : results.found) {
                if (noPrimariesYet) {
                    this.addPrimary(result.getSightingTaxon());
                    continue;
                }
                this.addPossibility(result.getSightingTaxon());
            }
            if (this.possibilities == null) {
                results = findSpecies.search(text, findSpecies.tertiarySearch());
                for (SightingTaxon.Resolved result : results.found) {
                    this.addPossibility(result.getSightingTaxon());
                }
            }
            this.addDescription(results.remainingText);
        }

        private void addPrimary(SightingTaxon sightingTaxon) {
            this.possibilities = TaxonPossibilities.withPrimary(this.possibilities, this.mapToBase(sightingTaxon));
        }

        private void addPossibility(SightingTaxon sightingTaxon) {
            this.possibilities = TaxonPossibilities.adding(this.possibilities, this.mapToBase(sightingTaxon));
        }

        private SightingTaxon mapToBase(SightingTaxon sightingTaxon) {
            if (sightingTaxon == null) {
                return null;
            }
            if (FlickrImporter.this.getTaxonomy() instanceof MappedTaxonomy) {
                return ((MappedTaxonomy)FlickrImporter.this.getTaxonomy()).getMapping(sightingTaxon);
            }
            return sightingTaxon;
        }

        private void addDescription(String newDescription) {
            if (!Strings.isNullOrEmpty(newDescription) && !(newDescription = CharMatcher.whitespace().trimFrom(newDescription)).isEmpty()) {
                this.remainingDescription = this.remainingDescription == null ? newDescription : this.remainingDescription + "\n" + newDescription;
            }
        }
    }
}

