/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports.flickr;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.ui.guice.FlickrApiKey;
import com.scythebill.birdlist.ui.imports.flickr.FlickrApiException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.joda.time.ReadablePartial;

class FlickrApi {
    private static final Logger logger = Logger.getLogger(FlickrApi.class.getName());
    private static final RequestConfig REQUEST_CONFIG = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(10000).setSocketTimeout(10000).build();
    private static final String FLICKR_API_URI = "https://www.flickr.com/services/rest/";
    private final CloseableHttpClient httpClient;
    private final Gson gson;
    private final String key;
    private static final Pattern ALBUM_URL_PATTERN = Pattern.compile("https://www.flickr.com/photos/(.*)/albums/(.*)");
    private static final Pattern PHOTO_URL_PATTERN = Pattern.compile("https://www.flickr.com/photos/(.*)/([0-9]+)");

    @Inject
    FlickrApi(CloseableHttpClient httpClient, Gson gson, @FlickrApiKey String key) {
        this.httpClient = httpClient;
        this.gson = gson;
        this.key = key;
    }

    public String lookupUser(String url) throws IOException, FlickrApiException {
        JsonObject userLookup;
        try {
            URIBuilder apiUri = this.apiUri("flickr.urls.lookupUser");
            apiUri.addParameter("url", url);
            userLookup = this.sendApi(apiUri.build());
        }
        catch (URISyntaxException e) {
            throw new AssertionError("Unexpected Invalid URI", e);
        }
        if (!"ok".equals(userLookup.get("stat").getAsString())) {
            JsonElement codeElement = userLookup.get("code");
            JsonElement messageElement = userLookup.get("message");
            throw new FlickrApiException(codeElement == null ? -1 : codeElement.getAsInt(), messageElement == null ? "" : messageElement.getAsString());
        }
        JsonObject userElement = userLookup.get("user").getAsJsonObject();
        return userElement.get("id").getAsString();
    }

    public PhotoSet lookupAlbum(String albumUrl) throws IOException, FlickrApiException {
        Matcher matcher = ALBUM_URL_PATTERN.matcher(albumUrl);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Not an album: " + albumUrl);
        }
        String user = this.lookupUser(albumUrl);
        PhotoSet firstPage = this.lookupAlbum(albumUrl, user, 1);
        for (int page = 2; page <= firstPage.pages; ++page) {
            PhotoSet extraPages = this.lookupAlbum(albumUrl, user, page);
            firstPage.photo.addAll(extraPages.photo);
        }
        firstPage.populateUrls();
        return firstPage;
    }

    public PhotoSet lookupPhoto(String photoUrl) throws FlickrApiException, IOException {
        PhotoReply reply;
        Matcher matcher = PHOTO_URL_PATTERN.matcher(photoUrl);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Not a photo: " + photoUrl);
        }
        String photoId = matcher.group(2);
        try {
            URIBuilder apiUri = this.apiUri("flickr.photos.getInfo");
            apiUri.addParameter("photo_id", photoId);
            apiUri.addParameter("extras", "date_taken,geo,tags,description");
            reply = this.sendApi(apiUri.build(), PhotoReply.class);
        }
        catch (URISyntaxException e) {
            throw new AssertionError("Unexpected Invalid URI", e);
        }
        if (!"ok".equals(reply.stat)) {
            throw new FlickrApiException(reply.code, reply.message);
        }
        PhotoSet photoSet = new PhotoSet();
        photoSet.originalOwnerString = matcher.group(1);
        photoSet.photo.add(reply.photo.toFlickrPhoto(photoSet.originalOwnerString));
        return photoSet;
    }

    public boolean isAlbumUrl(String albumUrl) {
        return ALBUM_URL_PATTERN.matcher(albumUrl).matches();
    }

    private PhotoSet lookupAlbum(String albumUrl, String user, int page) throws IOException, FlickrApiException {
        PhotosetReply reply;
        Matcher matcher = ALBUM_URL_PATTERN.matcher(albumUrl);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Not an album: " + albumUrl);
        }
        String photoSetId = matcher.group(2);
        try {
            URIBuilder apiUri = this.apiUri("flickr.photosets.getPhotos");
            apiUri.addParameter("user_id", user);
            apiUri.addParameter("photoset_id", photoSetId);
            apiUri.addParameter("extras", "date_taken,geo,tags,description");
            apiUri.addParameter("per_page", "500");
            apiUri.addParameter("page", Integer.toString(page));
            reply = this.sendApi(apiUri.build(), PhotosetReply.class);
        }
        catch (URISyntaxException e) {
            throw new AssertionError("Unexpected Invalid URI", e);
        }
        if (!"ok".equals(reply.stat)) {
            throw new FlickrApiException(reply.code, reply.message);
        }
        reply.photoset.originalOwnerString = matcher.group(1);
        return reply.photoset;
    }

    private URIBuilder apiUri(String method) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(FLICKR_API_URI);
        uriBuilder.addParameter("method", method);
        uriBuilder.addParameter("api_key", this.key);
        uriBuilder.addParameter("format", "json");
        uriBuilder.addParameter("nojsoncallback", "1");
        return uriBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject sendApi(URI uri) throws IOException {
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setConfig(REQUEST_CONFIG);
        CloseableHttpResponse get = this.httpClient.execute(httpGet);
        HttpEntity entity = get.getEntity();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(entity.getContent()), StandardCharsets.UTF_8);){
            JsonObject jsonObject = JsonParser.parseReader(reader).getAsJsonObject();
            return jsonObject;
        }
    }

    private <T> T sendApi(URI uri, Class<T> clazz) throws JsonSyntaxException, IOException {
        return this.gson.fromJson((JsonElement)this.sendApi(uri), clazz);
    }

    static class PhotoSet {
        String owner;
        String originalOwnerString;
        List<FlickrPhoto> photo = new ArrayList<FlickrPhoto>();
        int page;
        int pages;
        String title;

        PhotoSet() {
        }

        public void populateUrls() {
            this.photo.forEach(p -> {
                p.page_url = p.photoPage(this.originalOwnerString);
            });
        }
    }

    static class PhotoReply {
        SingleFlickrPhoto photo;
        String stat;
        String message;
        int code;

        PhotoReply() {
        }
    }

    static class SingleFlickrPhoto {
        String id;
        String farm;
        String secret;
        String server;
        FlickrContent description;
        FlickrContent title;
        Dates dates;
        Tags tags;

        SingleFlickrPhoto() {
        }

        FlickrPhoto toFlickrPhoto(String owner) {
            FlickrPhoto photo = new FlickrPhoto();
            photo.id = this.id;
            photo.farm = this.farm;
            photo.secret = this.secret;
            photo.server = this.server;
            photo.title = this.title._content;
            photo.description = this.description;
            photo.datetaken = this.dates.taken;
            photo.page_url = photo.photoPage(owner);
            photo.tags = this.tags.tag.stream().map(t -> t._content).collect(Collectors.joining(" "));
            return photo;
        }

        static class Dates {
            String taken;

            Dates() {
            }
        }

        static class Tags {
            List<Tag> tag = new ArrayList<Tag>();

            Tags() {
            }

            static class Tag {
                String _content;

                Tag() {
                }
            }
        }

        static class Owner {
            String nsid;
            String path_alias;

            Owner() {
            }
        }
    }

    static class FlickrPhoto {
        String id;
        String farm;
        String secret;
        String server;
        String title;
        String datetaken;
        String url_k;
        String tags;
        String latitude;
        String longitude;
        FlickrContent description;
        String page_url;

        FlickrPhoto() {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("datetaken", this.datetaken).add("title", this.title).toString();
        }

        public ReadablePartial date() {
            if (this.datetaken == null) {
                return null;
            }
            List<String> dateComponents = Splitter.on(' ').splitToList(this.datetaken);
            if (dateComponents.isEmpty()) {
                return null;
            }
            try {
                return PartialIO.fromString(dateComponents.get(0));
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, "Couldn't parse date " + this.datetaken, e);
                return null;
            }
        }

        public String description() {
            if (this.description == null) {
                return null;
            }
            return Strings.emptyToNull(this.description._content);
        }

        public String photoUrl() {
            return String.format("https://farm%s.staticflickr.com/%s/%s_%s.jpg", this.farm, this.server, this.id, this.secret);
        }

        public String photoPage(String owner) {
            return String.format("https://www.flickr.com/photos/%s/%s", owner, this.id);
        }
    }

    static class PhotosetReply {
        PhotoSet photoset;
        String stat;
        String message;
        int code;

        PhotosetReply() {
        }
    }

    static class FlickrContent {
        String _content;

        FlickrContent() {
        }
    }
}

