/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DateFromYearMonthDayFieldMapper;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FemaleFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.ImmatureFieldMapper;
import com.scythebill.birdlist.ui.imports.ImportException;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.MaleFieldMapper;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TaxonResolver;
import com.scythebill.birdlist.ui.imports.WingsImportLines;
import com.scythebill.xml.BaseNodeParser;
import com.scythebill.xml.NodeParser;
import com.scythebill.xml.ParseContext;
import com.scythebill.xml.StringParser;
import com.scythebill.xml.TreeBuilder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class WingsImporter
extends CsvSightingsImporter {
    private final ImmutableList<File> files;
    private static final ImmutableMap<String, String> REGION_NAMES = ImmutableMap.builder().put("Antarctica", "South Polar Region").put("Australia", "Australasia").put("Pacific", "Pacific Ocean").put("Atlantic", "Atlantic Ocean").put("Indian", "Indian Ocean").build();

    WingsImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, List<File> files) {
        super(reportSet, taxonomy, checklists, predefinedLocations, files.get(0), files.get(0));
        this.files = ImmutableList.copyOf(files);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return LineExtractors.stringFromIndex(0);
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        LinkedHashMap<String, String> idToCommonName = new LinkedHashMap<String, String>(11000);
        LinkedHashMap<String, String> idToSciName = new LinkedHashMap<String, String>(11000);
        try (ImportLines importLines = CsvImportLines.fromUrl(Resources.getResource(this.getClass(), "wings-taxa.csv"), StandardCharsets.UTF_8);){
            String[] line2;
            while ((line2 = importLines.nextLine()) != null) {
                if (line2.length != 3) {
                    throw new RuntimeException("Unexpected line " + Arrays.asList(line2));
                }
                idToCommonName.put(line2[0], line2[1]);
                idToSciName.put(line2[0], line2[2]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LineExtractor<String> keyExtractor = LineExtractors.stringFromIndex(0);
        TaxonResolver taxonResolver = new TaxonResolver(taxonomy);
        taxonResolver.setMaximumNameDistance(0);
        return new FieldTaxonImporter<String[]>(taxonResolver, line -> idToCommonName.getOrDefault(keyExtractor.extract((String)line), (String)keyExtractor.extract((String)line)), line -> (String)idToSciName.get(keyExtractor.extract((String)line)));
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        ArrayList mappers = Lists.newArrayList();
        mappers.add(new DateFromYearMonthDayFieldMapper(LineExtractors.intFromIndex(2), LineExtractors.intFromIndex(3), LineExtractors.intFromIndex(4)));
        mappers.add(new DescriptionFieldMapper(LineExtractors.stringFromIndex(7)));
        mappers.add(new CountFieldMapper<String[]>(line -> {
            Object count = line[6];
            if (Strings.isNullOrEmpty((String)count)) {
                return count;
            }
            if ("false".equalsIgnoreCase(line[5])) {
                count = "~" + (String)count;
            }
            return count;
        }));
        mappers.add(new MaleFieldMapper<String[]>(line -> "M".equals(line[9])));
        mappers.add(new FemaleFieldMapper<String[]>(line -> "F".equals(line[9])));
        mappers.add(new ImmatureFieldMapper<String[]>(line -> "IMM".equals(line[10]) || "JUV".equals(line[10])));
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(LineExtractors.stringFromIndex(0)), new SightingsImporter.LocationMapper(LineExtractors.stringFromIndex(1)), mappers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        LinkedHashMap<String, WingsLocation> locationByKey = new LinkedHashMap<String, WingsLocation>();
        for (File file : this.files) {
            try {
                List wingsLocations = (List)new TreeBuilder().parse(new InputSource(new BufferedInputStream(new FileInputStream(file))), new RootLocationParser());
                for (WingsLocation location : wingsLocations) {
                    locationByKey.put(location.key, location);
                }
            }
            catch (SAXException e) {
                throw new IOException("Could not parse locations from " + file.getName(), e);
            }
        }
        try (ImportLines lines = this.importLines(this.locationsFile);){
            String[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                if (this.skipLine(line) || line.length < 1) continue;
                String locationKey = CharMatcher.whitespace().trimFrom(line[1]);
                WingsLocation wingsLocation = (WingsLocation)locationByKey.get(locationKey);
                if (wingsLocation == null) {
                    throw new ImportException("Couldn't find the location \"" + locationKey + "\" in the Wings exports.<br>Check your location exports to make sure everything is present.");
                }
                ImportedLocation imported = new ImportedLocation();
                this.populateImportedLocation(imported, wingsLocation, locationByKey);
                if (wingsLocation.latitude != null && wingsLocation.longitude != null) {
                    imported.latitude = wingsLocation.latitude;
                    imported.longitude = wingsLocation.longitude;
                }
                if (wingsLocation.comment != null) {
                    imported.description = wingsLocation.comment;
                }
                String locationId = imported.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                this.locationIds.put((Object)wingsLocation.key, locationId);
            }
        }
    }

    private void populateImportedLocation(ImportedLocation imported, WingsLocation location, Map<String, WingsLocation> locationByKey) {
        WingsLocation parent;
        if (location.parent != null && (parent = locationByKey.get(location.parent)) != null) {
            this.populateImportedLocation(imported, parent, locationByKey);
        }
        if (location.type == Location.Type.region) {
            imported.region = REGION_NAMES.getOrDefault(location.name, location.name);
        } else if (location.type == Location.Type.country) {
            imported.country = location.name;
            if (location.code != null) {
                imported.countryCode = location.code.toUpperCase();
            }
        } else if (location.type == Location.Type.state) {
            imported.state = location.name;
        } else if (location.type == Location.Type.county) {
            imported.county = location.name;
        } else {
            imported.locationNames.add(location.name);
        }
    }

    @Override
    protected ImportLines importLines(File file) throws IOException {
        return new WingsImportLines(this.files);
    }

    static class RootLocationParser
    extends BaseNodeParser {
        private final List<WingsLocation> locations = new ArrayList<WingsLocation>();

        RootLocationParser() {
        }

        @Override
        public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
            return this.locations;
        }

        @Override
        public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            switch (localName) {
                case "LOCN_Continent": {
                    return new LocationParser(Location.Type.region);
                }
                case "LOCN_Province": {
                    return new LocationParser(Location.Type.state);
                }
                case "LOCN_Country": {
                    return new LocationParser(Location.Type.country);
                }
                case "LOCN_County": {
                    return new LocationParser(Location.Type.county);
                }
                case "LOCN_Place": 
                case "LOCN_Site": 
                case "LOCN_Station": {
                    return new LocationParser(null);
                }
            }
            return this;
        }

        @Override
        public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
            this.locations.add((WingsLocation)child);
        }
    }

    static class WingsLocation {
        Location.Type type;
        String parent;
        String key;
        String name;
        String latitude;
        String longitude;
        String comment;
        public String code;

        WingsLocation() {
        }

        public String toString() {
            MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper(this).add("code", this.code);
            if (this.parent != null) {
                stringHelper.add("parent", this.parent);
            }
            if (this.name != null) {
                stringHelper.add("name", this.name);
            }
            if (this.key != null) {
                stringHelper.add("key", this.key);
            }
            return stringHelper.toString();
        }
    }

    static class LocationParser
    extends BaseNodeParser {
        private WingsLocation location = new WingsLocation();

        LocationParser(Location.Type type) {
            this.location.type = type;
        }

        @Override
        public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
            if (this.location.name == null) {
                this.location.name = this.location.key;
            }
            return this.location;
        }

        @Override
        public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            return new StringParser();
        }

        @Override
        public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
            String s = CharMatcher.whitespace().trimFrom((String)child);
            if (localName.equals("KEY_InternetCode")) {
                this.location.code = s;
            } else if (localName.startsWith("KEY_")) {
                this.location.key = (localName.substring("KEY_".length()) + "_" + s).toUpperCase();
            } else if (localName.startsWith("EXT_KEY_")) {
                this.location.parent = (localName.substring("EXT_KEY_".length()) + "_" + s).toUpperCase();
            } else {
                switch (localName) {
                    case "Name": {
                        this.location.name = s;
                        break;
                    }
                    case "Latitude_Decimal": {
                        if ("0".equals(s)) break;
                        this.location.latitude = s;
                        break;
                    }
                    case "Longitude_Decimal": {
                        if ("0".equals(s)) break;
                        this.location.longitude = s;
                        break;
                    }
                    case "Comment": {
                        if ("".equals(s)) break;
                        this.location.comment = s;
                    }
                }
            }
        }
    }
}

