/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.xml.BaseNodeParser;
import com.scythebill.xml.NodeParser;
import com.scythebill.xml.ParseContext;
import com.scythebill.xml.StringParser;
import com.scythebill.xml.TreeBuilder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class WingsImportLines
implements ImportLines {
    static final int SPECIES_COLUMN = 0;
    static final int LOCATION_COLUMN = 1;
    static final int YEAR_COLUMN = 2;
    static final int MONTH_COLUMN = 3;
    static final int DAY_COLUMN = 4;
    static final int EXACT_NUMBER_COLUMN = 5;
    static final int NUMBER_COLUMN = 6;
    static final int COMMENT_COLUMN = 7;
    static final int INDICATORS_COLUMN = 8;
    static final int SEX_COLUMN = 9;
    static final int PLUMAGE_COLUMN = 10;
    static final int S_OR_H_COLUMN = 11;
    private static final int COLUMN_COUNT = 12;
    private final UnmodifiableIterator<File> files;
    private int lineNumber = 0;
    private Iterator<String[]> currentLines;

    WingsImportLines(List<File> files) {
        this.files = ImmutableList.copyOf(files).iterator();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String[] nextLine() throws IOException {
        while (this.currentLines == null || !this.currentLines.hasNext()) {
            if (!this.files.hasNext()) {
                return null;
            }
            this.currentLines = this.parseCurrentFile().iterator();
        }
        if (this.currentLines == null && !this.currentLines.hasNext()) {
            return null;
        }
        ++this.lineNumber;
        return this.currentLines.next();
    }

    @Override
    public int lineNumber() {
        return this.lineNumber;
    }

    @Override
    public ImportLines withoutTrimming() {
        throw new UnsupportedOperationException();
    }

    private List<String[]> parseCurrentFile() throws IOException {
        final ArrayList<String[]> list = new ArrayList<String[]>();
        File file = (File)this.files.next();
        try {
            class RootParser
            extends BaseNodeParser {
                RootParser() {
                }

                @Override
                public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
                    if (localName.equals("SGHT_Sightings")) {
                        return new SightingsParser();
                    }
                    return this;
                }

                @Override
                public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
                    list.add((String[])child);
                }
            }
            new TreeBuilder().parse(new InputSource(new BufferedInputStream(new FileInputStream(file))), new RootParser());
        }
        catch (SAXException e) {
            throw new IOException("Could not parse file " + file.getName(), e);
        }
        return list;
    }

    class SightingsParser
    extends BaseNodeParser {
        private String[] line = new String[12];

        SightingsParser() {
        }

        @Override
        public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
            return this.line;
        }

        @Override
        public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            return new StringParser();
        }

        @Override
        public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
            String s = CharMatcher.whitespace().trimFrom((String)child);
            switch (localName) {
                case "EXT_KEY_Species": {
                    this.line[0] = s;
                    break;
                }
                case "EXT_KEY_Continent": 
                case "EXT_KEY_Country": 
                case "EXT_KEY_Province": 
                case "EXT_KEY_County": 
                case "EXT_KEY_Place": 
                case "EXT_KEY_Site": 
                case "EXT_KEY_Station": {
                    this.line[1] = (localName.substring("EXT_KEY_".length()) + "_" + s).toUpperCase();
                    break;
                }
                case "DT_Year": {
                    this.line[2] = s;
                    break;
                }
                case "DT_Month": {
                    this.line[3] = s;
                    break;
                }
                case "DT_Day": {
                    this.line[4] = s;
                    break;
                }
                case "NBR_Is_Number_Seen_Exact": {
                    this.line[5] = s;
                    break;
                }
                case "NBR_Number_Seen": {
                    this.line[6] = s;
                    break;
                }
                case "INFO_Comment": {
                    this.line[7] = s;
                    break;
                }
                case "INFO_Indicators": {
                    this.line[8] = s;
                    break;
                }
                case "INFO_Sex_Code": {
                    this.line[9] = s;
                    break;
                }
                case "INFO_Plumage_Code": {
                    this.line[10] = s;
                    break;
                }
                case "INFO_S_or_H": {
                    this.line[11] = s;
                }
            }
        }
    }
}

