/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvExportLines;
import com.scythebill.birdlist.model.io.ExportLines;
import com.scythebill.birdlist.model.sighting.ApproximateNumber;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.user.UserSet;
import com.scythebill.birdlist.ui.imports.ImportException;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TaxonPossibilities;
import com.scythebill.birdlist.ui.imports.TaxonResolver;
import com.scythebill.birdlist.ui.imports.TripImporter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.chrono.GJChronology;

public class WildlifeRecorderMdbImporter
extends SightingsImporter<Row> {
    private static final Splitter STATUS_SPLITTER = Splitter.on(',').omitEmptyStrings();
    private static final Splitter AGES_SPLITTER = Splitter.on(';').omitEmptyStrings();
    private static final Splitter SCI_NAME_SPLITTER = Splitter.on(CharMatcher.whitespace());
    private static final Splitter OBSERVER_SPLITTER = Splitter.on('|').omitEmptyStrings();
    private final File file;
    private Database db;
    private List<Row> failedRows = new ArrayList<Row>();
    private Map<Integer, SpeciesEntry> speciesMap = new LinkedHashMap<Integer, SpeciesEntry>();
    private Map<String, ObserverEntry> observerMap = new LinkedHashMap<String, ObserverEntry>();
    private Map<Integer, LocationEntry> locationMap = new LinkedHashMap<Integer, LocationEntry>();
    private Map<Integer, TripEntry> tripMap = new LinkedHashMap<Integer, TripEntry>();
    private Map<VisitInfoKey, VisitInfo> visitInfoMap = new LinkedHashMap<VisitInfoKey, VisitInfo>();
    private boolean importContainedUserInformation;
    private TripImporter tripImporter;

    public WildlifeRecorderMdbImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations);
        this.file = file;
    }

    @Override
    public Optional<String> initialCheck() throws IOException {
        if (this.db == null) {
            this.db = DatabaseBuilder.open(this.file);
        }
        if (this.db.getTable("Sightings") == null || this.db.getTable("Species") == null || this.db.getTable("Locations") == null || this.db.getTable("Trips") == null) {
            return Optional.of("This does not look like a Wildlife Recorder database.");
        }
        return Optional.absent();
    }

    @Override
    protected void operateOnAllRows(SightingsImporter.RowOperator<Row> operator2) throws IOException {
        Table sightings = this.db.getTable("Sightings");
        for (Row row : sightings) {
            operator2.operate(row);
        }
    }

    @Override
    protected TaxonImporter<Row> newTaxonImporter(final Taxonomy taxonomy) {
        return new TaxonImporter<Row>(){
            private final TaxonResolver resolver;
            {
                this.resolver = new TaxonResolver(taxonomy);
            }

            @Override
            public TaxonPossibilities map(Row row) {
                Integer speciesId = row.getInt("SpeciesId");
                if (speciesId == null) {
                    return null;
                }
                SpeciesEntry speciesEntry = WildlifeRecorderMdbImporter.this.speciesMap.get(speciesId);
                if (speciesEntry == null) {
                    return null;
                }
                String genusAndSpecies = 1.justGenusAndSpecies(speciesEntry.sciName);
                String subspecies = 1.subspeciesIfPresent(speciesEntry.sciName);
                return this.resolver.map(speciesEntry.commonName, genusAndSpecies, subspecies);
            }

            @Override
            public TaxonImporter.ToBeDecided decideLater(Row row) {
                TaxonImporter.ToBeDecided tbd = new TaxonImporter.ToBeDecided();
                Integer speciesId = row.getInt("SpeciesId");
                if (speciesId == null) {
                    return null;
                }
                SpeciesEntry speciesEntry = WildlifeRecorderMdbImporter.this.speciesMap.get(speciesId);
                if (speciesEntry == null) {
                    return null;
                }
                tbd.commonName = speciesEntry.commonName;
                tbd.scientificName = 1.justGenusAndSpecies(speciesEntry.sciName);
                tbd.subspecies = 1.subspeciesIfPresent(speciesEntry.sciName);
                return tbd;
            }
        };
    }

    @Override
    public void beforeParseTaxonomyIds() throws IOException {
        if (this.db == null) {
            this.db = DatabaseBuilder.open(this.file);
        }
        this.parseSpecies();
        this.parseObservers();
        this.parseLocations();
        this.parseTrips();
        this.tripImporter = new TripImporter(this.reportSet);
    }

    @Override
    protected RowExtractor<Row, ? extends Object> taxonomyIdExtractor() {
        return row -> row.getInt("SpeciesId");
    }

    private static String locationIdForTrip(int tripId) {
        return "T" + tripId;
    }

    private static String locationIdForLocation(int locationId) {
        return "L" + locationId;
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        for (Row sighting : this.db.getTable("Sightings")) {
            Integer tripId = sighting.getInt("TripId");
            if (tripId == null) {
                throw new ImportException("Expected TripId field in Sightings table");
            }
            TripEntry tripEntry = this.tripMap.get(tripId);
            if (tripEntry == null) {
                throw new ImportException("No trip with ID " + tripId + " in Trips table");
            }
            if (this.locationIds.hasBeenParsed(WildlifeRecorderMdbImporter.locationIdForTrip(tripId))) continue;
            LocationEntry locationEntry = this.locationMap.get(tripEntry.location);
            if (locationEntry == null) {
                throw new ImportException("No location with ID " + tripEntry.location + " in Locations table");
            }
            if (tripEntry.startDate.equals(tripEntry.endDate)) {
                ImportedLocation importedLocation = new ImportedLocation();
                this.fillImportedLocation(importedLocation, OptionalInt.of(tripEntry.location));
                String locationId = importedLocation.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                if (locationId != null) {
                    this.locationIds.put((Object)WildlifeRecorderMdbImporter.locationIdForTrip(tripId), locationId);
                    continue;
                }
                this.locationIds.addToBeResolvedLocationName(WildlifeRecorderMdbImporter.locationIdForTrip(tripId), new ParsedLocationIds.ToBeDecided(locationEntry.locationName));
                continue;
            }
            ParsedLocationIds.TripInfo tripInfo = new ParsedLocationIds.TripInfo();
            tripInfo.startDate = tripEntry.startDate;
            tripInfo.startTime = tripEntry.startTime;
            tripInfo.endDate = tripEntry.endDate;
            tripInfo.endTime = tripEntry.endTime;
            tripInfo.name = locationEntry.locationName;
            tripInfo.notes = Strings.emptyToNull(Joiner.on('\n').skipNulls().join(Strings.emptyToNull(tripEntry.notes), Strings.emptyToNull(tripEntry.weather), new Object[0]));
            OptionalInt locationIdForTrip = locationEntry.locationType != null ? OptionalInt.of(tripEntry.location) : locationEntry.parentId;
            if (locationIdForTrip.isPresent() && this.locationIds.containsKey(WildlifeRecorderMdbImporter.locationIdForLocation(locationIdForTrip.getAsInt()))) {
                tripInfo.locationId = this.locationIds.getLocationId(WildlifeRecorderMdbImporter.locationIdForLocation(locationIdForTrip.getAsInt()));
            } else if (locationIdForTrip.isPresent() && this.locationIds.isToBeResolved(WildlifeRecorderMdbImporter.locationIdForLocation(locationIdForTrip.getAsInt()))) {
                tripInfo.toBeResolvedId = WildlifeRecorderMdbImporter.locationIdForLocation(locationIdForTrip.getAsInt());
            } else {
                ImportedLocation importedLocation = new ImportedLocation();
                this.fillImportedLocation(importedLocation, locationIdForTrip);
                String locationId = importedLocation.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                if (locationId != null) {
                    tripInfo.locationId = locationId;
                } else if (!locationIdForTrip.isEmpty()) {
                    LocationEntry tripLocation = this.locationMap.get(locationIdForTrip.getAsInt());
                    this.locationIds.addToBeResolvedLocationName(WildlifeRecorderMdbImporter.locationIdForLocation(locationIdForTrip.getAsInt()), new ParsedLocationIds.ToBeDecided(tripLocation.locationName));
                    tripInfo.toBeResolvedId = locationIdForTrip.getAsInt();
                }
            }
            this.locationIds.put((Object)WildlifeRecorderMdbImporter.locationIdForTrip(tripId), tripInfo);
        }
    }

    private void fillImportedLocation(ImportedLocation importedLocation, OptionalInt optionalParentId) {
        if (optionalParentId.isEmpty()) {
            return;
        }
        int parentId = optionalParentId.getAsInt();
        LocationEntry location = this.locationMap.get(parentId);
        if (location == null) {
            return;
        }
        if (location.locationType == Location.Type.country) {
            if (location.locationName.equals("USA")) {
                importedLocation.countryCode = "US";
            } else if (location.locationName.contains(" - ")) {
                int index = location.locationName.indexOf(" - ");
                String countryName = location.locationName.substring(0, index);
                String continentName = location.locationName.substring(index + 3);
                importedLocation.country = countryName;
                importedLocation.region = continentName;
            } else {
                importedLocation.country = location.locationName;
            }
            return;
        }
        this.fillImportedLocation(importedLocation, location.parentId);
        if (location.locationName.endsWith(" Mainland")) {
            return;
        }
        if (location.locationType == Location.Type.state) {
            if (importedLocation.state == null) {
                importedLocation.state = location.locationName;
            } else if (importedLocation.county == null && location.locationName.contains("County")) {
                importedLocation.county = location.locationName;
            } else {
                importedLocation.locationNames.add(location.locationName);
            }
        } else {
            importedLocation.locationNames.add(location.locationName);
        }
        if (!Strings.isNullOrEmpty(location.notes)) {
            importedLocation.description = location.notes;
        }
    }

    @Override
    public List<Sighting> parseSightings() throws IOException {
        ArrayList<Sighting> sightings = Lists.newArrayList();
        RowExtractor<Row, ? extends Object> taxonomyIdExtractor = this.taxonomyIdExtractor();
        SightingsImporter.TaxonFieldMapper taxonImporter = new SightingsImporter.TaxonFieldMapper(taxonomyIdExtractor);
        for (Row row : this.db.getTable("Sightings")) {
            this.parseSighting(row, (r, sighting) -> this.parseRow((Row)r, (Sighting.Builder)sighting, taxonImporter), taxonomyIdExtractor::extract, sightings, (r, sightingBuilder) -> {});
        }
        return sightings;
    }

    private void parseRow(Row row, Sighting.Builder sighting, SightingsImporter.TaxonFieldMapper taxonMapper) {
        String observers;
        Integer totalCount;
        String status;
        String ages;
        int tripId = row.getInt("TripId");
        TripEntry tripEntry = this.tripMap.get(tripId);
        String locationId = this.locationIds.getLocationId(WildlifeRecorderMdbImporter.locationIdForTrip(tripId));
        if (locationId != null) {
            sighting.setLocation(this.reportSet.getLocations().getLocation(locationId));
            sighting.setDate(tripEntry.startDate);
            if (tripEntry.startTime != null) {
                sighting.setTime(tripEntry.startTime);
            }
        } else {
            if (tripEntry.trip == null) {
                Trip trip;
                ParsedLocationIds.TripInfo tripInfo = Preconditions.checkNotNull(this.locationIds.getTripInfo(WildlifeRecorderMdbImporter.locationIdForTrip(tripId)), "No trip for ID %s", tripId);
                tripEntry.trip = trip = this.tripImporter.createTrip(this.reportSet, this.locationIds, tripInfo);
            }
            sighting.setTrip(tripEntry.trip);
            if (tripEntry.trip.locationId() != null) {
                sighting.setLocation(this.reportSet.getLocations().getLocation(tripEntry.trip.locationId()));
            }
        }
        taxonMapper.map(row, sighting);
        ArrayList<String> notesList = new ArrayList<String>();
        String notes = row.getString("Notes");
        if (!Strings.isNullOrEmpty(notes)) {
            notesList.add(this.rtfToText(notes));
        }
        if (!Strings.isNullOrEmpty(ages = row.getString("Ages"))) {
            if (ages.endsWith(";")) {
                ages = ages.substring(0, ages.length() - 1);
            }
            for (String age : AGES_SPLITTER.split(ages)) {
                if (age.startsWith("Ad")) {
                    sighting.getSightingInfo().setAdult(true);
                } else if (age.startsWith("Imm") || age.startsWith("Juv") || age.startsWith("1W")) {
                    sighting.getSightingInfo().setImmature(true);
                }
                if (age.contains(",M,")) {
                    sighting.getSightingInfo().setMale(true);
                    continue;
                }
                if (!age.contains(",F,")) continue;
                sighting.getSightingInfo().setFemale(true);
            }
            notesList.add(ages);
        }
        if (!Strings.isNullOrEmpty(status = row.getString("Status"))) {
            ArrayList<String> statuses = Lists.newArrayList(STATUS_SPLITTER.split(status));
            block18: for (int i = statuses.size() - 1; i >= 0; --i) {
                String statusStr = (String)statuses.get(i);
                switch (statusStr) {
                    case "H": {
                        sighting.getSightingInfo().setHeardOnly(true);
                        continue block18;
                    }
                    case "E": {
                        sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED);
                        continue block18;
                    }
                    case "X": {
                        sighting.getSightingInfo().setPhotographed(true);
                        continue block18;
                    }
                    case "BVD": {
                        sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.BETTER_VIEW_DESIRED);
                    }
                }
            }
            notesList.add(statuses.stream().map(s -> "(" + s + ")").collect(Collectors.joining(" ")));
        }
        if ((totalCount = row.getInt("TotalCount")) != null && totalCount > 0) {
            sighting.getSightingInfo().setNumber(ApproximateNumber.exact(totalCount));
        } else if (totalCount != null && totalCount < 0) {
            switch (totalCount) {
                case -3: {
                    notesList.add("Very common");
                    break;
                }
                case -2: {
                    notesList.add("Common");
                    break;
                }
                case -1: {
                    notesList.add("Scarce");
                    break;
                }
            }
        }
        if (!notesList.isEmpty()) {
            sighting.getSightingInfo().setDescription(Joiner.on('\n').join(notesList));
        }
        if (!(this.observerMap.size() <= 1 && this.reportSet.getUserSet() == null || Strings.isNullOrEmpty(observers = row.getString("Observers")))) {
            HashSet<User> users = new HashSet<User>();
            for (String observer : OBSERVER_SPLITTER.split(observers)) {
                ObserverEntry observerEntry = this.observerMap.get(observer);
                if (observerEntry.user == null) {
                    if (this.reportSet.getUserSet() == null) {
                        this.reportSet.setUserSet(new UserSet());
                    }
                    if (this.reportSet.getUserSet().hasUserWithAbbreviation(observerEntry.initials)) {
                        observerEntry.user = this.reportSet.getUserSet().userByAbbreviation(observerEntry.initials);
                    } else {
                        User.Builder builder = this.reportSet.getUserSet().newUserBuilder();
                        builder.setAbbreviation(observerEntry.initials);
                        builder.setName(observerEntry.name);
                        observerEntry.user = this.reportSet.getUserSet().addUser(builder);
                    }
                }
                users.add(observerEntry.user);
            }
            this.importContainedUserInformation = true;
            sighting.getSightingInfo().setUsers(users);
        }
    }

    @Override
    public boolean importContainedUserInformation() {
        return this.importContainedUserInformation;
    }

    @Override
    public String importFileName() {
        return this.file.getName();
    }

    @Override
    protected void importRowFailed(Row importRow) {
        this.failedRows.add(importRow);
    }

    @Override
    public File writeFailedLines() {
        File file;
        block18: {
            File failedLinesFile = null;
            for (int i = 0; i < 50 && (failedLinesFile = this.failedFile(this.file, i)).exists(); ++i) {
            }
            if (failedLinesFile == null || failedLinesFile.exists()) {
                return null;
            }
            if (!failedLinesFile.createNewFile()) {
                return null;
            }
            ExportLines writer = CsvExportLines.fromWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(failedLinesFile), StandardCharsets.UTF_8)));
            try {
                Table sightingsTable = this.db.getTable("Sightings");
                ImmutableList columnNames = sightingsTable.getColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
                String[] headerRow = columnNames.toArray(new String[columnNames.size()]);
                writer.nextLine(headerRow);
                for (Row row : this.failedRows) {
                    String[] nextLine = new String[columnNames.size()];
                    for (int i = 0; i < nextLine.length; ++i) {
                        String columnName = (String)columnNames.get(i);
                        if (columnName.equals("TripId")) {
                            int tripId = row.getInt(columnName);
                            LocationEntry locationEntry = this.locationMap.get(this.tripMap.get((Object)Integer.valueOf((int)tripId)).location);
                            nextLine[i] = locationEntry.locationName;
                            continue;
                        }
                        if (columnName.equals("SpeciesId")) {
                            int speciesId = row.getInt(columnName);
                            SpeciesEntry speciesEntry = this.speciesMap.get(speciesId);
                            if (speciesEntry.commonName == null) {
                                nextLine[i] = speciesEntry.sciName;
                                continue;
                            }
                            if (speciesEntry.sciName == null) {
                                nextLine[i] = speciesEntry.commonName;
                                continue;
                            }
                            nextLine[i] = String.format("%s (%s)", speciesEntry.commonName, speciesEntry.sciName);
                            continue;
                        }
                        if (columnName.equals("Observers")) {
                            String observers = row.getString(columnName);
                            if (Strings.isNullOrEmpty(observers)) continue;
                            nextLine[i] = OBSERVER_SPLITTER.splitToList(observers).stream().map(o -> {
                                ObserverEntry observerEntry = this.observerMap.get(o);
                                if (observerEntry == null) {
                                    return o;
                                }
                                return observerEntry.initials;
                            }).collect(Collectors.joining(","));
                            continue;
                        }
                        Object o2 = row.get(columnName);
                        if (o2 == null) continue;
                        nextLine[i] = o2.toString();
                    }
                    writer.nextLine(nextLine);
                }
                file = failedLinesFile;
                if (writer == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            writer.close();
        }
        return file;
    }

    private File failedFile(File openFile, int index) {
        Object failedLinesFileName = openFile.getName();
        if (((String)failedLinesFileName).indexOf(46) >= 0) {
            failedLinesFileName = ((String)failedLinesFileName).substring(0, ((String)failedLinesFileName).lastIndexOf(46));
        }
        failedLinesFileName = index == 0 ? (String)failedLinesFileName + "-failed.csv" : (String)failedLinesFileName + "-" + index + "-failed.csv";
        return new File(openFile.getParentFile(), (String)failedLinesFileName);
    }

    private void parseSpecies() throws IOException {
        HashMap<Integer, Integer> speciesIdToUniqueId = new HashMap<Integer, Integer>();
        String desiredName = null;
        if (this.getTaxonomy().isBuiltIn()) {
            desiredName = this.getTaxonomy() instanceof MappedTaxonomy ? "IOC" : "Clements";
        }
        Short taxonomyId = null;
        Table taxonNameTable = this.db.getTable("TaxonName");
        for (Object taxonNameRow : taxonNameTable) {
            String taxonName = taxonNameRow.getString("TaxonName");
            if (taxonomyId != null && !Objects.equal(taxonName, desiredName)) continue;
            taxonomyId = taxonNameRow.getInt("TaxonId").shortValue();
        }
        Table taxonomyTable = this.db.getTable("Taxonomy");
        for (Row taxonomyRow : taxonomyTable) {
            if (!Objects.equal(taxonomyId, taxonomyRow.getShort("TaxonId"))) continue;
            speciesIdToUniqueId.put(taxonomyRow.getInt("SpeciesId"), taxonomyRow.getInt("UniqueId"));
        }
        Table species = this.db.getTable("Species");
        for (Row row : species) {
            List<String> splitToList;
            int id = row.getInt("SpeciesId");
            String commonName = row.getString("SpeciesName");
            Object sciName = row.getString("ScientificName");
            String superName = row.getString("SuperName");
            if (!Strings.isNullOrEmpty(superName) && (splitToList = SCI_NAME_SPLITTER.splitToList((CharSequence)sciName)).size() == 2) {
                sciName = String.format("%s %s %s", splitToList.get(0), superName, splitToList.get(1));
                String subspEnding = String.format(" [%s]", splitToList.get(1));
                if (commonName.endsWith(subspEnding)) {
                    commonName = commonName.substring(0, commonName.length() - subspEnding.length());
                }
            }
            int uniqueId = row.getInt("UniqueId");
            Integer expectedUniqueId = (Integer)speciesIdToUniqueId.get(id);
            boolean primary = expectedUniqueId != null && uniqueId == expectedUniqueId;
            SpeciesEntry speciesEntry = this.speciesMap.computeIfAbsent(id, k -> new SpeciesEntry());
            if (!primary && speciesEntry.commonName != null) continue;
            speciesEntry.commonName = commonName;
            speciesEntry.sciName = sciName;
            speciesEntry.primary = primary;
            if (!primary) continue;
            if (((String)sciName).contains("-group")) {
                speciesEntry.sciName = ((String)sciName).replace("-group", " Group");
                sciName = speciesEntry.sciName;
            }
            if (!CharMatcher.inRange('a', 'z').matches(((String)sciName).charAt(0))) continue;
            sciName = speciesEntry.sciName = Character.toUpperCase(((String)sciName).charAt(0)) + ((String)sciName).substring(1);
        }
    }

    private void parseObservers() throws IOException {
        Table observers = this.db.getTable("Observers");
        if (observers != null) {
            for (Row row : observers) {
                int observerId = row.getInt("ObserverId");
                ObserverEntry entry = this.observerMap.computeIfAbsent(Integer.toString(observerId), k -> new ObserverEntry());
                entry.name = row.getString("ObserverName");
                entry.initials = row.getString("ObserverInitials");
            }
        }
    }

    @Override
    protected void lookForVisitInfo(ReportSet reportSet, Row row, Sighting newSighting, VisitInfoKey visitInfoKey) {
        VisitInfo visitInfo;
        if (this.visitInfoMap.containsKey(visitInfoKey)) {
            return;
        }
        Integer tripId = row.getInt("TripId");
        if (tripId == null) {
            return;
        }
        TripEntry tripEntry = this.tripMap.get(tripId);
        if (tripEntry == null) {
            return;
        }
        VisitInfo.Builder builder = VisitInfo.builder();
        String notes = Strings.emptyToNull(Joiner.on('\n').skipNulls().join(Strings.emptyToNull(tripEntry.notes), Strings.emptyToNull(tripEntry.weather), new Object[0]));
        if (!Strings.isNullOrEmpty(notes)) {
            builder.withComments(notes);
        }
        if (tripEntry.startTime != null && tripEntry.endTime != null && !tripEntry.startTime.equals(tripEntry.endTime)) {
            int startTime = tripEntry.startTime.getHourOfDay() * 60 + tripEntry.startTime.getMinuteOfHour();
            int endTime = tripEntry.endTime.getHourOfDay() * 60 + tripEntry.endTime.getMinuteOfHour();
            if (endTime - startTime > 1) {
                builder.withDuration(Duration.standardMinutes(endTime - startTime));
            }
        }
        if (tripEntry.allRecords != null) {
            builder.withCompleteChecklist(tripEntry.allRecords);
        }
        if (tripEntry.partySize != null && tripEntry.partySize > 0) {
            builder.withPartySize(tripEntry.partySize);
        }
        try {
            visitInfo = builder.build();
        }
        catch (IllegalStateException e) {
            builder.withObservationType(VisitInfo.ObservationType.HISTORICAL);
            visitInfo = builder.build();
        }
        if (visitInfo.hasData()) {
            this.visitInfoMap.put(visitInfoKey, visitInfo);
        }
    }

    @Override
    public Map<VisitInfoKey, VisitInfo> getAccumulatedVisitInfoMap() {
        return this.visitInfoMap;
    }

    @Override
    public boolean isMassExport() {
        return false;
    }

    private void parseLocations() throws IOException {
        Table locations = this.db.getTable("Locations");
        for (Row row : locations) {
            int locationId = row.getInt("LocationId");
            int locationType = row.getByte("LocationType").intValue();
            if (locationType == 0) continue;
            LocationEntry entry = this.locationMap.computeIfAbsent(locationId, k -> new LocationEntry());
            entry.locationName = row.getString("LocationName");
            switch (locationType) {
                case 1: {
                    entry.locationType = Location.Type.country;
                    break;
                }
                case 2: {
                    entry.locationType = Location.Type.state;
                    break;
                }
            }
            int parentId = row.getInt("ParentId");
            entry.parentId = parentId == 0 ? OptionalInt.empty() : OptionalInt.of(parentId);
            String notes = row.getString("Notes");
            if (notes != null && notes.startsWith("{\\rtf")) {
                notes = this.rtfToText(notes);
            }
            entry.notes = notes;
        }
    }

    private void parseTrips() throws IOException {
        Table trips = this.db.getTable("Trips");
        for (Row row : trips) {
            int tripId = row.getInt("TripId");
            TripEntry entry = this.tripMap.computeIfAbsent(tripId, k -> new TripEntry());
            LocalDateTime firstDateTime = row.getLocalDateTime("FirstDate");
            entry.startDate = this.toJodaLocalDate(firstDateTime);
            entry.startTime = this.toJodaLocalTime(firstDateTime);
            LocalDateTime lastDateTime = row.getLocalDateTime("LastDate");
            entry.endDate = this.toJodaLocalDate(lastDateTime);
            entry.endTime = this.toJodaLocalTime(lastDateTime);
            String notes = row.getString("Notes");
            if (notes != null && notes.startsWith("{\\rtf")) {
                notes = this.rtfToText(notes);
            }
            entry.notes = notes;
            entry.weather = row.getString("Weather");
            entry.location = row.getInt("Location");
            entry.partySize = row.getInt("EBirdPartySize");
            Integer allRecords = row.getInt("EBirdAllRecords");
            if (allRecords == null || allRecords <= 0) continue;
            entry.allRecords = true;
        }
    }

    private LocalTime toJodaLocalTime(LocalDateTime dateTime) {
        if (dateTime.getHour() == 0 && dateTime.getMinute() == 0) {
            return null;
        }
        return new LocalTime(dateTime.getHour(), dateTime.getMinute());
    }

    private LocalDate toJodaLocalDate(LocalDateTime dateTime) {
        return new LocalDate(dateTime.getYear(), dateTime.getMonthValue(), dateTime.getDayOfMonth(), GJChronology.getInstance());
    }

    private String rtfToText(String notes) {
        if (notes == null) {
            return null;
        }
        if (!notes.startsWith("{\\rtf")) {
            return notes;
        }
        JEditorPane p = new JEditorPane();
        p.setContentType("text/rtf");
        EditorKit kitRtf = p.getEditorKitForContentType("text/rtf");
        try {
            kitRtf.read(new StringReader(notes), p.getDocument(), 0);
        }
        catch (IOException | BadLocationException e) {
            throw new IllegalArgumentException(e);
        }
        kitRtf = null;
        EditorKit kitText = p.getEditorKitForContentType("text/plain");
        StringWriter writer = new StringWriter();
        try {
            kitText.write(writer, p.getDocument(), 0, p.getDocument().getLength());
        }
        catch (IOException | BadLocationException e) {
            throw new IllegalArgumentException(e);
        }
        return ((Object)writer).toString();
    }

    class TripEntry {
        LocalDate startDate;
        LocalTime startTime;
        LocalDate endDate;
        LocalTime endTime;
        String notes;
        String weather;
        int location;
        Boolean allRecords;
        Integer partySize;
        Trip trip;

        TripEntry() {
        }
    }

    class LocationEntry {
        String locationName;
        OptionalInt parentId;
        String notes;
        Location.Type locationType;

        LocationEntry() {
        }
    }

    class ObserverEntry {
        String initials;
        String name;
        public User user;

        ObserverEntry() {
        }
    }

    class SpeciesEntry {
        String commonName;
        String sciName;
        public boolean primary;

        SpeciesEntry() {
        }
    }
}

