/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DateParseException;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.ImportException;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.MultiFormatDateFromStringFieldMapper;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.UserFieldMapper;
import com.scythebill.birdlist.ui.messages.Messages;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.Minutes;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GJChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class WildlifeRecorderImporter
extends CsvSightingsImporter {
    private static final Logger logger = Logger.getLogger(WildlifeRecorderImporter.class.getName());
    private static final DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendHourOfDay(1).appendLiteral(':').appendMinuteOfHour(2).toFormatter();
    private static final DateTimeFormatter DATE_FORMATTER_WITH_DOTS = DateTimeFormat.forPattern("dd.MM.yy").withChronology(GJChronology.getInstance()).withPivotYear(2000);
    private static final DateTimeFormatter DATE_FORMATTER_WITH_SLASHES = DateTimeFormat.forPattern("dd/MM/yy").withChronology(GJChronology.getInstance()).withPivotYear(2000);
    private LineExtractor<String> locationIdExtractor;
    private LineExtractor<String> taxonomyIdExtractor;
    private LineExtractor<String> commonNameExtractor;
    private LineExtractor<String> scientificExtractor;
    private LineExtractor<String> subspeciesExtractor;
    private LineExtractor<String> locationExtractor;
    private LineExtractor<String> longitudeExtractor;
    private LineExtractor<String> latitudeExtractor;
    private LinkedHashMap<Object, String> visitDescriptionMap = Maps.newLinkedHashMap();
    private LinkedHashMap<VisitInfoKey, VisitInfo> visitInfoMap = Maps.newLinkedHashMap();
    private LineExtractor<String> timeExtractor;
    private LineExtractor<String> descriptionExtractor;
    private LineExtractor<String> observersExtractor;
    private LineExtractor<String> dateExtractor;
    private LineExtractor<String> lastDateExtractor;
    private LineExtractor<String> lastTimeExtractor;
    private MultiFormatDateFromStringFieldMapper<String[]> dateMapper;

    public WildlifeRecorderImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File sightingsFile, File locationFile) {
        super(reportSet, taxonomy, checklists, predefinedLocations, sightingsFile, locationFile);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        return new FieldTaxonImporter<String[]>(taxonomy, this.commonNameExtractor, this.scientificExtractor, this.subspeciesExtractor);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        ImportLines lines;
        if (this.locationsFile != null) {
            lines = CsvImportLines.fromFile(this.locationsFile, this.getCharset());
            try {
                String[] line;
                boolean hasLatLongIndices;
                String[] header = lines.nextLine();
                LinkedHashMap<String, Integer> headersByIndex = new LinkedHashMap<String, Integer>();
                for (int i = 0; i < header.length; ++i) {
                    headersByIndex.put(CharMatcher.whitespace().removeFrom(header[i]).toLowerCase(), i);
                }
                int nameIndex = this.getRequiredHeader(headersByIndex, "name");
                Integer stateIndex = (Integer)headersByIndex.get("state");
                Integer countryIndex = (Integer)headersByIndex.get("country");
                Integer parentIndex = (Integer)headersByIndex.get("parent");
                Integer countyIndex = (Integer)headersByIndex.get("countyname");
                Integer nwLatitudeIndex = (Integer)headersByIndex.get("nwlatitude");
                Integer seLatitudeIndex = (Integer)headersByIndex.get("selatitude");
                Integer nwLongitudeIndex = (Integer)headersByIndex.get("nwlongitude");
                Integer seLongitudeIndex = (Integer)headersByIndex.get("selongitude");
                boolean bl = hasLatLongIndices = nwLatitudeIndex != null && seLatitudeIndex != null && nwLongitudeIndex != null && seLongitudeIndex != null;
                while ((line = lines.nextLine()) != null) {
                    String locationId;
                    ImportedLocation location = new ImportedLocation();
                    String id = line[nameIndex];
                    if (this.locationIds.hasBeenParsed(id)) continue;
                    if (parentIndex != null && !Strings.isNullOrEmpty(line[parentIndex])) {
                        location.locationNames.add(line[parentIndex]);
                    }
                    location.locationNames.add(line[nameIndex]);
                    if (stateIndex != null) {
                        location.state = line[stateIndex];
                    }
                    if (countryIndex != null) {
                        location.country = line[countryIndex];
                    }
                    if (countyIndex != null) {
                        location.county = line[countyIndex];
                    }
                    if (hasLatLongIndices) {
                        Double nwLat = Doubles.tryParse(line[nwLatitudeIndex]);
                        Double nwLong = Doubles.tryParse(line[nwLongitudeIndex]);
                        Double seLat = Doubles.tryParse(line[seLatitudeIndex]);
                        Double seLong = Doubles.tryParse(line[seLongitudeIndex]);
                        if (nwLat != null && nwLong != null && seLat != null && seLong != null) {
                            location.latitude = Double.toString((nwLat + seLat) / 2.0);
                            location.longitude = Double.toString((nwLong + seLong) / 2.0);
                        }
                    }
                    if ((locationId = location.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations)) != null) {
                        Location county;
                        Location state;
                        Location locationObj;
                        Location country;
                        this.locationIds.put((Object)id, locationId);
                        if (!Strings.isNullOrEmpty(location.country) && (country = Locations.getAncestorOfType(locationObj = locations.getLocation(locationId), Location.Type.country)) != null) {
                            this.locationIds.put((Object)location.country, country.getId());
                        }
                        if (!Strings.isNullOrEmpty(location.state) && (state = Locations.getAncestorOfType(locationObj = locations.getLocation(locationId), Location.Type.state)) != null) {
                            this.locationIds.put((Object)location.state, state.getId());
                        }
                        if (Strings.isNullOrEmpty(location.county) || (county = Locations.getAncestorOfType(locationObj = locations.getLocation(locationId), Location.Type.county)) == null) continue;
                        this.locationIds.put((Object)location.county, county.getId());
                        continue;
                    }
                    this.locationIds.addToBeResolvedLocationName(id, new ParsedLocationIds.ToBeDecided(id, location.getLatLong()));
                }
            }
            catch (IOException | RuntimeException e) {
                throw new ImportException(Messages.getFormattedMessage(Messages.Name.FAILED_WR_LOCATION_EXPORT_IMPORT_ON_LINE_FORMAT, lines.lineNumber(), e.getMessage()), e);
            }
            finally {
                lines.close();
            }
        }
        lines = CsvImportLines.fromFile(this.sightingsFile, this.getCharset());
        try {
            String[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                String id = (String)this.locationIdExtractor.extract((String)line);
                if (this.locationIds.hasBeenParsed(id)) continue;
                ImportedLocation location = new ImportedLocation();
                location.locationNames.add(id);
                location.latitude = (String)this.latitudeExtractor.extract((String)line);
                location.longitude = (String)this.longitudeExtractor.extract((String)line);
                String locationId = location.tryAddToLocationSetWithLatLong(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                if (locationId != null) {
                    this.locationIds.put((Object)id, locationId);
                    continue;
                }
                this.locationIds.addToBeResolvedLocationName(id, new ParsedLocationIds.ToBeDecided(id, location.getLatLong()));
            }
        }
        catch (IOException | RuntimeException e) {
            throw new ImportException(Messages.getFormattedMessage(Messages.Name.FAILED_IMPORT_ON_LINE_FORMAT, lines.lineNumber()), e);
        }
        finally {
            lines.close();
        }
    }

    @Override
    protected void beforeParseSightings() throws IOException {
        try (ImportLines lines = this.importLines(this.sightingsFile);){
            String[] line;
            String[] header = lines.nextLine();
            LinkedHashMap<String, Integer> headersByIndex = new LinkedHashMap<String, Integer>();
            for (int i = 0; i < header.length; ++i) {
                headersByIndex.put(CharMatcher.whitespace().removeFrom(header[i]).toLowerCase(), i);
            }
            LineExtractor<String> date = LineExtractors.stringFromIndex(this.getRequiredHeader(headersByIndex, "First Date", "firstdate", "date"));
            MultiFormatDateFromStringFieldMapper<String[]> mapper0 = new MultiFormatDateFromStringFieldMapper<String[]>(date, "MM/dd/yy", "MM/yy");
            MultiFormatDateFromStringFieldMapper<String[]> mapper1 = new MultiFormatDateFromStringFieldMapper<String[]>(date, "dd/MM/yy", "MM/yy");
            MultiFormatDateFromStringFieldMapper<String[]> mapper2 = new MultiFormatDateFromStringFieldMapper<String[]>(date, "dd.MM.yy", "MM.yy");
            int successCount0 = 0;
            int successCount1 = 0;
            int successCount2 = 0;
            Sighting.Builder sighting = Sighting.newBuilder();
            while ((line = lines.nextLine()) != null) {
                if (this.skipLine(line)) continue;
                try {
                    mapper0.map(line, sighting);
                    if (++successCount0 > successCount1 + 100 && successCount0 > successCount2 + 100) {
                        break;
                    }
                }
                catch (DateParseException dateParseException) {
                    // empty catch block
                }
                try {
                    mapper1.map(line, sighting);
                    if (++successCount1 > successCount0 + 100 && successCount1 > successCount2 + 100) {
                        break;
                    }
                }
                catch (DateParseException dateParseException) {
                    // empty catch block
                }
                try {
                    mapper2.map(line, sighting);
                    if (++successCount2 <= successCount0 + 100 || successCount2 <= successCount1 + 100) continue;
                    break;
                }
                catch (DateParseException dateParseException) {
                }
            }
            this.dateMapper = successCount2 >= successCount1 && successCount2 >= successCount0 ? mapper2 : (successCount1 >= successCount0 && successCount1 >= successCount2 ? mapper1 : mapper0);
        }
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        String[] header = lines.nextLine();
        LinkedHashMap<String, Integer> headersByIndex = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(CharMatcher.whitespace().removeFrom(header[i]).toLowerCase(), i);
        }
        ArrayList mappers = Lists.newArrayList();
        this.commonNameExtractor = LineExtractors.stringFromIndex(this.getRequiredHeader(headersByIndex, "Common Name", "commonname", "common"));
        int sciIndex = this.getRequiredHeader(headersByIndex, "Scientific Name", "scientificname", "scientific");
        this.scientificExtractor = new DropSspFromSci(LineExtractors.stringFromIndex(sciIndex));
        this.subspeciesExtractor = new ExtractSspFromSci(LineExtractors.stringFromIndex(sciIndex));
        this.taxonomyIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), ImmutableList.of(this.commonNameExtractor, this.scientificExtractor, this.subspeciesExtractor));
        this.locationExtractor = LineExtractors.stringFromIndex(this.getRequiredHeader(headersByIndex, "Site Name", "sitename", "site"));
        this.latitudeExtractor = LineExtractors.stringFromIndex(this.getRequiredHeader(headersByIndex, "Trip Latitude", "triplatitude", "latitude"));
        this.longitudeExtractor = LineExtractors.stringFromIndex(this.getRequiredHeader(headersByIndex, "Trip Longitude", "triplongitude", "longitude"));
        this.locationIdExtractor = this.locationExtractor;
        this.dateExtractor = LineExtractors.stringFromIndex(this.getRequiredHeader(headersByIndex, "First Date", "firstdate", "date"));
        if (this.dateMapper != null) {
            mappers.add(this.dateMapper);
        } else {
            mappers.add(new MultiFormatDateFromStringFieldMapper(this.dateExtractor, "dd.MM.yy", "dd/MM/yy"));
        }
        this.lastDateExtractor = LineExtractors.stringFromIndex(this.getRequiredHeader(headersByIndex, "Last Date", "lastdate"));
        this.timeExtractor = LineExtractors.stringFromIndex(this.getRequiredHeader(headersByIndex, "First Time", "firsttime", "time"));
        this.lastTimeExtractor = LineExtractors.stringFromIndex(this.getRequiredHeader(headersByIndex, "Last Time", "lasttime"));
        mappers.add((line, sighting) -> {
            String time = (String)this.timeExtractor.extract((String)line);
            if (Strings.isNullOrEmpty(time)) {
                return;
            }
            sighting.setTime(TIME_FORMATTER.parseLocalTime(time));
        });
        LineExtractor<String> numberExtractor = LineExtractors.stringFromIndex(this.getRequiredHeader(headersByIndex, "Total Count", "totalcount", "count"));
        LineExtractor<String> estimationExtractor = LineExtractors.stringFromIndex(this.getRequiredHeader(headersByIndex, "Circa", "circa"));
        mappers.add(new CountFieldMapper<String[]>(new IncorporateEstimation(estimationExtractor, numberExtractor)));
        this.descriptionExtractor = LineExtractors.stringFromIndex(this.getRequiredHeader(headersByIndex, "Notes", "notes"));
        mappers.add(new DescriptionFieldMapper(LineExtractors.joined(Joiner.on('\n').skipNulls(), (RowExtractor<String[], String>)new ApproximateCounts(numberExtractor), this.descriptionExtractor)));
        mappers.add(new WildlifeRecorderStatusMapper(LineExtractors.stringFromIndex(this.getRequiredHeader(headersByIndex, "Status", "status"))));
        mappers.add(new WildlifeRecorderAgesMapper(LineExtractors.stringFromIndex(this.getRequiredHeader(headersByIndex, "Age", "age"))));
        Integer observersIndex = (Integer)headersByIndex.get("observers");
        this.observersExtractor = observersIndex == null ? LineExtractors.constant("") : LineExtractors.stringFromIndex(observersIndex);
        mappers.add(new UserFieldMapper(this.reportSet, this.observersExtractor, LineExtractors.constant("")));
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this.locationIdExtractor), mappers);
    }

    @Override
    protected boolean skipLine(String[] line) {
        if (Strings.isNullOrEmpty((String)this.commonNameExtractor.extract((String)line)) && Strings.isNullOrEmpty((String)this.scientificExtractor.extract((String)line))) {
            String description = (String)this.descriptionExtractor.extract((String)line);
            if ("0".equals(line[0]) && !Strings.isNullOrEmpty(description)) {
                description = description.replace('\\', '\n');
                if (!CharMatcher.whitespace().matchesAllOf(description)) {
                    String unresolvedLocationId = (String)this.locationIdExtractor.extract((String)line);
                    LocalDate date = null;
                    String dateStr = (String)this.dateExtractor.extract((String)line);
                    try {
                        date = DATE_FORMATTER_WITH_DOTS.parseLocalDate(dateStr);
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            date = DATE_FORMATTER_WITH_SLASHES.parseLocalDate(dateStr);
                        }
                        catch (IllegalArgumentException e2) {
                            logger.log(Level.WARNING, "Could not parse " + dateStr, e2);
                        }
                    }
                    String startTimeStr = (String)this.timeExtractor.extract((String)line);
                    LocalTime startTime = null;
                    if (!Strings.isNullOrEmpty(startTimeStr)) {
                        try {
                            startTime = TIME_FORMATTER.parseLocalTime(startTimeStr);
                        }
                        catch (IllegalArgumentException e) {
                            logger.log(Level.WARNING, "Could not parse " + startTimeStr, e);
                        }
                    }
                    if (date != null) {
                        this.visitDescriptionMap.put(WildlifeRecorderImporter.unparsedVisitInfoKey(unresolvedLocationId, date, startTime), description);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected void lookForVisitInfo(ReportSet reportSet, String[] line, Sighting newSighting, VisitInfoKey visitInfoKey) {
        String observers;
        LocalTime startTime;
        ReadablePartial date;
        VisitInfo.Builder builder = VisitInfo.builder().withObservationType(VisitInfo.ObservationType.HISTORICAL);
        String unresolvedLocationId = (String)this.locationIdExtractor.extract((String)line);
        String description = this.visitDescriptionMap.get(WildlifeRecorderImporter.unparsedVisitInfoKey(unresolvedLocationId, date = visitInfoKey.date(), startTime = visitInfoKey.startTime().orNull()));
        if (!Strings.isNullOrEmpty(description)) {
            builder = builder.withComments(description);
        }
        if (!Strings.isNullOrEmpty(observers = (String)this.observersExtractor.extract((String)line))) {
            builder = builder.withPartySize(CharMatcher.is(',').countIn(observers) + 1);
        }
        if (Objects.equals(this.dateExtractor.extract((String)line), this.lastDateExtractor.extract((String)line)) && !Strings.isNullOrEmpty((String)this.lastTimeExtractor.extract((String)line))) {
            Duration duration;
            LocalTime endTime = TIME_FORMATTER.parseLocalTime((String)this.lastTimeExtractor.extract((String)line));
            if (startTime != null && endTime != null && (duration = Minutes.minutesBetween(startTime, endTime).toStandardDuration()).isLongerThan(Duration.standardMinutes(5L))) {
                builder = builder.withDuration(duration);
            }
        }
        this.visitInfoMap.put(visitInfoKey, builder.build());
    }

    @Override
    public Map<VisitInfoKey, VisitInfo> getAccumulatedVisitInfoMap() {
        return this.visitInfoMap;
    }

    private static Object unparsedVisitInfoKey(String unresolvedLocationId, ReadablePartial date, LocalTime startTime) {
        ArrayList<Object> list = new ArrayList<Object>(3);
        list.add(unresolvedLocationId);
        list.add(date);
        list.add(startTime);
        return list;
    }

    private int getRequiredHeader(Map<String, Integer> indexMap, String originalCase, String ... possibilities) throws IOException {
        Preconditions.checkArgument(possibilities.length > 0);
        for (String possibility : possibilities) {
            Integer index = indexMap.get(possibility);
            if (index == null) continue;
            return index;
        }
        throw new ImportException(Messages.getFormattedMessage(Messages.Name.WILDLIFE_RECORDER_NO_HEADER_ROW_FORMAT, originalCase));
    }

    @Override
    public boolean importContainedUserInformation() {
        return true;
    }

    @Override
    protected Charset getCharset() {
        return Charset.availableCharsets().getOrDefault("windows-1252", StandardCharsets.ISO_8859_1);
    }

    private static class DropSspFromSci
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;

        public DropSspFromSci(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            int nextSpace;
            String name = (String)this.extractor.extract((String)line);
            if (name == null) {
                return null;
            }
            if (name.indexOf(47) >= 0) {
                return name;
            }
            if (name.indexOf(" x ") >= 0) {
                return name;
            }
            int firstSpace = name.indexOf(32);
            if (firstSpace >= 0 && (nextSpace = name.indexOf(32, firstSpace + 1)) >= 0) {
                return name.substring(0, nextSpace);
            }
            return name;
        }
    }

    static class ExtractSspFromSci
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;

        public ExtractSspFromSci(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            int nextSpace;
            String name = (String)this.extractor.extract((String)line);
            if (name == null) {
                return null;
            }
            if (name.indexOf(47) >= 0) {
                return null;
            }
            if (name.indexOf(" x ") >= 0) {
                return null;
            }
            int firstSpace = name.indexOf(32);
            if (firstSpace >= 0 && (nextSpace = name.indexOf(32, firstSpace + 1)) >= 0) {
                return name.substring(nextSpace + 1);
            }
            return null;
        }
    }

    static class IncorporateEstimation
    implements LineExtractor<String> {
        private LineExtractor<String> estimationExtractor;
        private LineExtractor<String> numberExtractor;

        public IncorporateEstimation(LineExtractor<String> estimationExtractor, LineExtractor<String> numberExtractor) {
            this.estimationExtractor = estimationExtractor;
            this.numberExtractor = numberExtractor;
        }

        @Override
        public String extract(String[] line) {
            String estimate = (String)this.estimationExtractor.extract((String)line);
            String number = (String)this.numberExtractor.extract((String)line);
            if (Strings.isNullOrEmpty(estimate) || Strings.isNullOrEmpty(number)) {
                return number;
            }
            if ("C".equals(estimate)) {
                estimate = "~";
            }
            return estimate + number;
        }
    }

    static class ApproximateCounts
    implements LineExtractor<String> {
        private LineExtractor<String> numberExtractor;

        public ApproximateCounts(LineExtractor<String> numberExtractor) {
            this.numberExtractor = numberExtractor;
        }

        @Override
        public String extract(String[] line) {
            String number = (String)this.numberExtractor.extract((String)line);
            if (number == null) {
                return null;
            }
            switch (number) {
                case "-3": {
                    return "Very common";
                }
                case "-2": {
                    return "Common";
                }
                case "-1": {
                    return "Scarce";
                }
            }
            return null;
        }
    }

    static class WildlifeRecorderStatusMapper
    implements FieldMapper<String[]> {
        private final LineExtractor<String> statusExtractor;

        public WildlifeRecorderStatusMapper(LineExtractor<String> statusExtractor) {
            this.statusExtractor = statusExtractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String extracted = Strings.nullToEmpty((String)this.statusExtractor.extract((String)line));
            if (extracted.contains("P")) {
                sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.RECORD_NOT_ACCEPTED);
            }
            if (extracted.contains("E")) {
                sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED);
            }
            if (extracted.contains("X") || extracted.contains("V")) {
                sighting.getSightingInfo().setPhotographed(true);
            }
            if (extracted.contains("H")) {
                sighting.getSightingInfo().setHeardOnly(true);
            }
        }
    }

    static class WildlifeRecorderAgesMapper
    implements FieldMapper<String[]> {
        private final LineExtractor<String> agesExtractor;

        public WildlifeRecorderAgesMapper(LineExtractor<String> agesExtractor) {
            this.agesExtractor = agesExtractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String extracted = Strings.nullToEmpty((String)this.agesExtractor.extract((String)line)).toLowerCase();
            if (extracted.contains("ad")) {
                sighting.getSightingInfo().setAdult(true);
            }
            if (extracted.contains("imm")) {
                sighting.getSightingInfo().setImmature(true);
            }
            if (extracted.contains("m,")) {
                sighting.getSightingInfo().setMale(true);
            }
            if (extracted.contains("f,")) {
                sighting.getSightingInfo().setFemale(true);
            }
        }
    }
}

