/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.user.UserSet;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class UserFieldMapper<T>
implements FieldMapper<T> {
    private static final Splitter ABBREVIATION_SPLITTER = Splitter.on(UserSet.NOT_ELIGIBLE_ID_CHARS).trimResults(CharMatcher.whitespace()).omitEmptyStrings();
    private static final Splitter NAME_SPLITTER = Splitter.on(CharMatcher.anyOf("\n\r")).trimResults(CharMatcher.whitespace()).omitEmptyStrings();
    private final ReportSet reportSet;
    private final RowExtractor<T, String> observersExtractor;
    private final RowExtractor<T, String> observerNamesExtractor;
    private final Map<String, ImmutableSet<User>> userCache = new HashMap<String, ImmutableSet<User>>();
    private Map<String, User> usersByName = null;

    UserFieldMapper(ReportSet reportSet, RowExtractor<T, String> observersExtractor, RowExtractor<T, String> observerNamesExtractor) {
        this.reportSet = reportSet;
        this.observersExtractor = observersExtractor;
        this.observerNamesExtractor = observerNamesExtractor;
    }

    @Override
    public void map(T line, Sighting.Builder sighting) {
        String observersStr = Strings.nullToEmpty(this.observersExtractor.extract(line));
        String observerNamesStr = Strings.nullToEmpty(this.observerNamesExtractor.extract(line));
        if (observersStr.isEmpty() && observerNamesStr.isEmpty()) {
            return;
        }
        String key = String.format("%s/%s", observersStr, observerNamesStr);
        ImmutableCollection users = this.userCache.get(key);
        if (users == null) {
            UserSet userSet = this.getUserSet();
            List<String> abbreviationList = ABBREVIATION_SPLITTER.splitToList(observersStr);
            List<String> nameList = NAME_SPLITTER.splitToList(observerNamesStr);
            ImmutableSet.Builder usersBuilder = ImmutableSet.builder();
            if (abbreviationList.isEmpty()) {
                if (this.usersByName == null) {
                    this.usersByName = new HashMap<String, User>();
                    for (User user : userSet.allUsers()) {
                        if (user.name() == null) continue;
                        this.usersByName.put(user.name(), user);
                    }
                }
                for (String name : nameList) {
                    User user = this.usersByName.get(name);
                    if (user == null) {
                        User.Builder builder = userSet.newUserBuilder().setName(name);
                        Optional<String> abbreviation = userSet.computeDefaultAbbreviation(name, Optional.empty());
                        abbreviation.ifPresent(builder::setAbbreviation);
                        user = userSet.addUser(builder);
                        this.usersByName.put(name, user);
                    }
                    usersBuilder.add(user);
                }
            } else {
                for (int i = 0; i < abbreviationList.size(); ++i) {
                    String abbreviation = abbreviationList.get(i);
                    if (userSet.hasUserWithAbbreviation(abbreviation)) {
                        usersBuilder.add(userSet.userByAbbreviation(abbreviation));
                        continue;
                    }
                    User.Builder builder = userSet.newUserBuilder().setAbbreviation(abbreviation);
                    if (nameList.size() > i) {
                        builder.setName(nameList.get(i));
                        this.usersByName = null;
                    }
                    usersBuilder.add(userSet.addUser(builder));
                }
            }
            users = usersBuilder.build();
            this.userCache.put(key, (ImmutableSet<User>)users);
        }
        if (users != null && !users.isEmpty()) {
            sighting.getSightingInfo().setUsers(users);
        }
    }

    private UserSet getUserSet() {
        UserSet userSet = this.reportSet.getUserSet();
        if (userSet == null) {
            userSet = new UserSet();
            this.reportSet.setUserSet(userSet);
        }
        return userSet;
    }
}

