/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class TripImporter {
    private final Map<String, RangeMap<Integer, Trip>> existingTripRangeMap = new HashMap<String, RangeMap<Integer, Trip>>();

    TripImporter(ReportSet reportSet) {
        block0: for (Trip trip : reportSet.getTrips().allTrips()) {
            Location location = trip.locationId() == null ? null : reportSet.getLocations().getLocation(trip.locationId());
            while (true) {
                RangeMap rangeMapForLocation = this.existingTripRangeMap.computeIfAbsent(location == null ? null : location.getId(), k -> TreeRangeMap.create());
                rangeMapForLocation.put(Trips.dateRange(trip), trip);
                if (location == null) continue block0;
                location = location.getParent();
            }
        }
    }

    public Trip createTrip(ReportSet reportSet, ParsedLocationIds locationIds, ParsedLocationIds.TripInfo tripInfo) {
        if (tripInfo.toBeResolvedId != null) {
            tripInfo.locationId = locationIds.getLocationId(tripInfo.toBeResolvedId);
            tripInfo.toBeResolvedId = null;
        }
        Location location = tripInfo.locationId == null ? null : reportSet.getLocations().getLocation(tripInfo.locationId);
        Range<Integer> newTripRange = Trips.dateRange(tripInfo.startDate, tripInfo.endDate);
        Trip trip = null;
        while (true) {
            RangeMap<Integer, Trip> rangeMap;
            if ((rangeMap = this.existingTripRangeMap.get(location == null ? null : location.getId())) != null) {
                Trip existingStartTrip = rangeMap.get(newTripRange.lowerEndpoint());
                Trip existingEndTrip = rangeMap.get(newTripRange.upperEndpoint());
                Trip existingTrip = null;
                boolean useNewTripDates = false;
                if (existingStartTrip != null && existingStartTrip == existingEndTrip) {
                    existingTrip = existingStartTrip;
                } else {
                    Map<Range<Integer>, Trip> subrangeMap = rangeMap.subRangeMap(newTripRange).asMapOfRanges();
                    if (subrangeMap.size() == 1) {
                        existingTrip = Iterables.getOnlyElement(subrangeMap.values());
                        useNewTripDates = true;
                    }
                }
                if (existingTrip != null) {
                    String updatedLocationId = null;
                    if (Objects.equal(tripInfo.locationId, existingTrip.locationId())) {
                        trip = existingTrip;
                    } else if (tripInfo.locationId != null && existingTrip.locationId() != null) {
                        Location newTripLocation;
                        Location existingTripLocation = reportSet.getLocations().getLocation(existingTrip.locationId());
                        if (Locations.isDescendentOfLocation(existingTripLocation, newTripLocation = reportSet.getLocations().getLocation(tripInfo.locationId))) {
                            trip = existingTrip;
                        } else if (Locations.isDescendentOfLocation(newTripLocation, existingTripLocation)) {
                            trip = existingTrip;
                            updatedLocationId = tripInfo.locationId;
                        }
                    }
                    if (trip != null) {
                        if (!trip.hasName()) {
                            trip.setName(tripInfo.name);
                        }
                        if (useNewTripDates) {
                            trip.setDates(tripInfo.startDate, tripInfo.endDate);
                        }
                        if (updatedLocationId != null) {
                            trip.setLocation(reportSet.getLocations().getLocation(updatedLocationId));
                        }
                        if (!Strings.isNullOrEmpty(tripInfo.notes)) {
                            if (Strings.isNullOrEmpty(trip.notes())) {
                                trip.setNotes(tripInfo.notes);
                            } else if (!trip.notes().equals(tripInfo.notes)) {
                                trip.setNotes(trip.notes() + "\n" + tripInfo.notes);
                            }
                        }
                    }
                }
            }
            if (location == null || trip != null) break;
            location = location.getParent();
        }
        if (trip == null) {
            if (Strings.isNullOrEmpty(tripInfo.name)) {
                String dateString = Trips.rangeToUserString(tripInfo.startDate, tripInfo.endDate, Locale.getDefault());
                tripInfo.name = dateString == null ? location.getDisplayName() : String.format("%s, %s", location.getDisplayName(), dateString);
            }
            trip = reportSet.getTrips().newTripBuilder().withStartDate(tripInfo.startDate).withStartTime(tripInfo.startTime).withEndDate(tripInfo.endDate).withEndTime(tripInfo.endTime).withLocationId(tripInfo.locationId).withName(tripInfo.name).withNotes(tripInfo.notes).withLinks(tripInfo.links.build()).build();
        }
        return trip;
    }
}

