/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Strings;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.LocalTime;

final class TimeMapper<T>
implements FieldMapper<T> {
    private static final Logger logger = Logger.getLogger(TimeMapper.class.getCanonicalName());
    private final RowExtractor<T, String> timeExtractor;

    TimeMapper(RowExtractor<T, String> timeExtractor) {
        this.timeExtractor = timeExtractor;
    }

    @Override
    public void map(T line, Sighting.Builder sighting) {
        String string = this.timeExtractor.extract(line);
        if (!Strings.isNullOrEmpty(string)) {
            try {
                LocalTime partial = TimeIO.fromExternalString(string);
                sighting.setTime(partial);
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, "Failed to parse time " + string, e);
            }
        }
    }
}

