/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.TaxonVisitor;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.BKTree;
import com.scythebill.birdlist.model.util.Metrics;
import com.scythebill.birdlist.ui.imports.TaxonPossibilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class TaxonResolver {
    private static final Splitter SP_SPLITTER = Splitter.on('/').trimResults(CharMatcher.whitespace()).omitEmptyStrings();
    private final Map<String, Taxon> newGenusNames = Maps.newHashMap();
    private final Multimap<String, Taxon> newSpeciesNames = LinkedHashMultimap.create();
    private final Multimap<String, Taxon> newCommonNames = LinkedHashMultimap.create();
    private final Multimap<String, Taxon> alternateCommonNames = LinkedHashMultimap.create();
    private final Multimap<String, Taxon> alternateSciNames = LinkedHashMultimap.create();
    private final BKTree<String, Taxon> commonNameTree;
    private final BKTree<String, Taxon> alternateCommonNameTree;
    private final Taxonomy taxonomy;
    private int maximumNameDistance = 2;
    private static Pattern COMMON_WITH_FORM = Pattern.compile("^(.+) \\(.*\\)$");
    private static final CharMatcher VALID_SUBSPECIES_CHARS = CharMatcher.inRange('a', 'z').or(CharMatcher.is('-'));

    public TaxonResolver(Taxonomy taxonomy) {
        this.taxonomy = taxonomy;
        BKTree.Builder<String, Taxon> commonNameTree = BKTree.builder(Metrics.levenshteinDistance());
        this.buildIndicesForTaxonomy(commonNameTree);
        this.commonNameTree = commonNameTree.build();
        BKTree.Builder<String, Taxon> alternateCommonNameTree = BKTree.builder(Metrics.levenshteinDistance());
        for (Map.Entry<String, Collection<Taxon>> alternateEntry : this.alternateCommonNames.asMap().entrySet()) {
            if (alternateEntry.getValue().size() != 1) continue;
            alternateCommonNameTree.add(alternateEntry.getKey(), (Taxon)Iterables.getOnlyElement((Iterable)alternateEntry.getValue()));
        }
        this.alternateCommonNameTree = alternateCommonNameTree.build();
    }

    public void setMaximumNameDistance(int maximumNameDistance) {
        this.maximumNameDistance = maximumNameDistance;
    }

    public TaxonPossibilities mapUnknown(String commonOrSci) {
        TaxonPossibilities ifCommon = this.map(commonOrSci, null, null);
        if (ifCommon != null) {
            return ifCommon;
        }
        TaxonPossibilities ifSci = this.map(null, commonOrSci, null);
        if (ifSci != null) {
            return ifSci;
        }
        int lastSpace = commonOrSci.lastIndexOf(32);
        if (lastSpace > 0) {
            String mainName = commonOrSci.substring(0, lastSpace);
            String subspecies = commonOrSci.substring(lastSpace + 1);
            if (VALID_SUBSPECIES_CHARS.matchesAllOf(subspecies)) {
                TaxonPossibilities commonAndSubspecies = this.map(mainName, null, subspecies);
                if (commonAndSubspecies != null) {
                    return commonAndSubspecies;
                }
                TaxonPossibilities sciAndSubspecies = this.map(null, mainName, subspecies);
                if (sciAndSubspecies != null) {
                    return sciAndSubspecies;
                }
            }
        }
        return null;
    }

    public TaxonPossibilities map(String commonName, String sciName, String subspecies) {
        Taxon matchWithinGenus;
        Collection<Taxon> collection;
        TaxonPossibilities possibilities = null;
        if (commonName != null && (collection = this.newCommonNames.get(commonName = TaxonResolver.normalizeCommonName(commonName, subspecies))).size() == 1) {
            possibilities = TaxonPossibilities.withPrimary(possibilities, this.getTaxon(collection, subspecies));
        }
        if (sciName != null && (collection = this.newSpeciesNames.get(sciName = TaxonResolver.normalizeScientificName(sciName))).size() == 1) {
            possibilities = TaxonPossibilities.withPrimary(possibilities, this.getTaxon(collection, subspecies));
        }
        if (possibilities == null && commonName != null && (collection = this.commonNameTree.search(commonName, this.maximumNameDistance)).size() == 1) {
            Iterator<Taxon> list;
            boolean improvedUsingGenus = false;
            if (sciName != null && (list = Splitter.on(' ').splitToList(sciName)).size() >= 2) {
                String species = (String)list.get(1);
                Taxon genus = TaxonUtils.getParentOfType(collection.iterator().next(), Taxon.Type.genus);
                Taxon speciesInGenus = this.findMatchWithin(genus, species, false);
                if (speciesInGenus != null) {
                    possibilities = TaxonPossibilities.adding(possibilities, this.getTaxon(speciesInGenus, subspecies));
                    improvedUsingGenus = true;
                }
            }
            if (!improvedUsingGenus) {
                possibilities = TaxonPossibilities.adding(possibilities, this.getTaxon(collection, subspecies));
            }
        }
        if (sciName != null && possibilities == null && (matchWithinGenus = this.findTaxonByScientificNameInGenus(sciName)) != null) {
            possibilities = TaxonPossibilities.adding(possibilities, this.getTaxon(matchWithinGenus, subspecies));
        }
        if (commonName != null) {
            Matcher matcher;
            boolean noPossibilitiesYet = possibilities == null;
            for (Taxon exactAlternateCommonName : this.alternateCommonNames.get(commonName)) {
                if (noPossibilitiesYet) {
                    possibilities = TaxonPossibilities.withPrimary(possibilities, this.getTaxon(exactAlternateCommonName, subspecies));
                    continue;
                }
                possibilities = TaxonPossibilities.adding(possibilities, this.getTaxon(exactAlternateCommonName, subspecies));
            }
            if (possibilities == null && commonName.length() > 4) {
                for (Taxon inexactAlternateCommonName : this.alternateCommonNameTree.search(commonName, this.maximumNameDistance)) {
                    possibilities = TaxonPossibilities.withPrimary(possibilities, this.getTaxon(inexactAlternateCommonName, subspecies));
                }
            }
            if ((matcher = COMMON_WITH_FORM.matcher(commonName)).matches()) {
                String reducedCommonName = matcher.group(1);
                collection = this.newCommonNames.get(reducedCommonName);
                if (collection.size() == 1) {
                    possibilities = TaxonPossibilities.adding(possibilities, this.getTaxon(collection, subspecies));
                }
                if ((collection = this.alternateCommonNames.get(reducedCommonName)).size() == 1) {
                    possibilities = TaxonPossibilities.adding(possibilities, this.getTaxon(collection, subspecies));
                }
            }
        }
        if (sciName != null) {
            boolean noPossibilitiesYet = possibilities == null;
            for (Taxon exactAlternateSciName : this.alternateSciNames.get(sciName)) {
                if (noPossibilitiesYet) {
                    possibilities = TaxonPossibilities.withPrimary(possibilities, this.getTaxon(exactAlternateSciName, subspecies));
                    continue;
                }
                possibilities = TaxonPossibilities.adding(possibilities, this.getTaxon(exactAlternateSciName, subspecies));
            }
        }
        if (sciName != null && possibilities == null) {
            possibilities = this.checkForSpuhsInScientificName(sciName, possibilities);
        }
        if (commonName != null && possibilities == null) {
            possibilities = this.checkForSpuhsInCommonName(commonName, possibilities);
        }
        return possibilities;
    }

    /*
     * WARNING - void declaration
     */
    private TaxonPossibilities checkForSpuhsInScientificName(String sciName, TaxonPossibilities possibilities) {
        String first;
        Taxon firstTaxon;
        List<String> split = null;
        boolean hybrid = false;
        if (sciName.contains("/")) {
            split = SP_SPLITTER.splitToList(sciName);
        } else if (sciName.contains(" x ")) {
            hybrid = true;
            split = Splitter.on(" x ").splitToList(sciName);
        }
        if (split != null && split.size() >= 2 && (firstTaxon = this.findTaxonExactAndInGenus(first = split.get(0))) != null) {
            LinkedHashSet<String> taxa = Sets.newLinkedHashSetWithExpectedSize(split.size());
            taxa.add(firstTaxon.getId());
            boolean allSuccessful = true;
            for (String string : Iterables.skip(split, 1)) {
                void var10_10;
                Taxon additionalTaxon;
                if (!string.contains(" ")) {
                    String string2 = first.substring(0, first.indexOf(32) + 1) + string;
                }
                if ((additionalTaxon = this.findTaxonExactAndInGenus((String)var10_10)) != null) {
                    taxa.add(additionalTaxon.getId());
                    continue;
                }
                allSuccessful = false;
            }
            if (allSuccessful) {
                SightingTaxon hybridOrSp = taxa.size() == 1 ? SightingTaxons.newSightingTaxon((String)taxa.iterator().next()) : (hybrid ? SightingTaxons.newHybridTaxon(taxa) : SightingTaxons.newSpTaxon(taxa));
                if (firstTaxon.getTaxonomy() instanceof MappedTaxonomy) {
                    MappedTaxonomy mappedTaxonomy = (MappedTaxonomy)firstTaxon.getTaxonomy();
                    hybridOrSp = mappedTaxonomy.getMapping(hybridOrSp);
                }
                possibilities = TaxonPossibilities.adding(possibilities, hybridOrSp);
            }
        }
        return possibilities;
    }

    private TaxonPossibilities checkForSpuhsInCommonName(String commonName, TaxonPossibilities possibilities) {
        List<String> split = null;
        boolean hybrid = false;
        if (commonName.contains("/")) {
            split = SP_SPLITTER.splitToList(commonName);
        } else if (commonName.contains(" x ")) {
            hybrid = true;
            split = Splitter.on(" x ").splitToList(commonName);
        }
        if (split != null && split.size() >= 2) {
            String last = Iterables.getLast(split);
            Taxon lastTaxon = this.findSpeciesForCommonName(last);
            if (lastTaxon == null && last.contains(" (")) {
                last = last.substring(0, last.indexOf(" ("));
                lastTaxon = this.findSpeciesForCommonName(last);
            }
            if (lastTaxon != null) {
                ArrayList<String> taxa = Lists.newArrayList(lastTaxon.getId());
                boolean allSuccessful = true;
                for (String fromSplit : Iterables.limit(split, split.size() - 1)) {
                    Taxon additionalTaxon = this.findSpeciesForCommonNamePossiblyAppending(fromSplit, last);
                    if (additionalTaxon != null) {
                        taxa.add(additionalTaxon.getId());
                        continue;
                    }
                    allSuccessful = false;
                    break;
                }
                if (allSuccessful) {
                    SightingTaxon hybridOrSp = hybrid ? SightingTaxons.newHybridTaxon(taxa) : SightingTaxons.newSpTaxon(taxa);
                    if (lastTaxon.getTaxonomy() instanceof MappedTaxonomy) {
                        MappedTaxonomy taxonomy = (MappedTaxonomy)lastTaxon.getTaxonomy();
                        hybridOrSp = taxonomy.getMapping(hybridOrSp);
                    }
                    possibilities = TaxonPossibilities.adding(possibilities, hybridOrSp);
                }
            }
        }
        if (possibilities == null && this.taxonomy.isBuiltIn()) {
            if (commonName.contains("brewster's warbler") || commonName.contains("lawrence's warbler")) {
                Taxon bwwa = this.findSpeciesForCommonName("Blue-winged Warbler");
                Taxon gwwa = this.findSpeciesForCommonName("Golden-winged Warbler");
                if (bwwa != null && gwwa != null) {
                    possibilities = TaxonPossibilities.adding(possibilities, SightingTaxons.newHybridTaxon(ImmutableList.of(bwwa.getId(), gwwa.getId())));
                }
            } else if (commonName.contains("sutton's warbler")) {
                Taxon ytwa = this.findSpeciesForCommonName("Yellow-throated Warbler");
                Taxon nopa = this.findSpeciesForCommonName("Northern Parula");
                if (ytwa != null && nopa != null) {
                    possibilities = TaxonPossibilities.adding(possibilities, SightingTaxons.newHybridTaxon(ImmutableList.of(ytwa.getId(), nopa.getId())));
                }
            }
        }
        return possibilities;
    }

    private Taxon findSpeciesForCommonNamePossiblyAppending(String commonName, String possiblyAppend) {
        Taxon taxon = this.findSpeciesForCommonName(commonName);
        if (taxon != null) {
            return taxon;
        }
        int lastSpace = possiblyAppend.lastIndexOf(32);
        while (lastSpace > 0) {
            String commonNameWithAppendedSuffix = commonName + possiblyAppend.substring(lastSpace);
            taxon = this.findSpeciesForCommonName(commonNameWithAppendedSuffix);
            if (taxon != null) {
                return taxon;
            }
            lastSpace = possiblyAppend.lastIndexOf(possiblyAppend, lastSpace - 1);
        }
        return null;
    }

    private Taxon findSpeciesForCommonName(String commonName) {
        Collection<Taxon> collection = this.newCommonNames.get(commonName);
        if (collection.size() == 1) {
            return Iterables.getOnlyElement(collection);
        }
        collection = this.commonNameTree.search(commonName, this.maximumNameDistance);
        if (collection.size() == 1) {
            return Iterables.getOnlyElement(collection);
        }
        return null;
    }

    private Taxon findTaxonExactAndInGenus(String sciName) {
        Collection<Taxon> collection = this.newSpeciesNames.get(sciName);
        if (collection.size() == 1) {
            return Iterables.getOnlyElement(collection);
        }
        return this.findTaxonByScientificNameInGenus(sciName);
    }

    private Taxon findTaxonByScientificNameInGenus(String sciName) {
        Iterator<String> split = Splitter.on(' ').split(sciName).iterator();
        String genusName = split.next();
        Taxon matchWithinGenus = null;
        if (split.hasNext()) {
            Taxon genus;
            String species = split.next();
            if ("sp.".equals(species)) {
                return null;
            }
            if (!split.hasNext() && (genus = this.newGenusNames.get(genusName)) != null) {
                matchWithinGenus = this.findMatchWithin(genus, species, true);
            }
        }
        if (matchWithinGenus != null && matchWithinGenus.getType() == Taxon.Type.subspecies) {
            matchWithinGenus = matchWithinGenus.getParent();
        }
        return matchWithinGenus;
    }

    private SightingTaxon getTaxon(Taxon taxon, String subspeciesName) {
        SightingTaxon sightingTaxon = SightingTaxons.newSightingTaxon(taxon.getId());
        if (subspeciesName != null) {
            if (subspeciesName.contains("/")) {
                LinkedHashSet<String> taxonIds = Sets.newLinkedHashSet();
                for (String fromSpName : SP_SPLITTER.split(subspeciesName)) {
                    Taxon subspecies = this.findMatchWithin(taxon, fromSpName, false);
                    if (subspecies == null) continue;
                    taxonIds.add(subspecies.getId());
                }
                if (!taxonIds.isEmpty()) {
                    sightingTaxon = SightingTaxons.newPossiblySpTaxon(taxonIds);
                }
            } else {
                Taxon subspecies = this.findMatchWithin(taxon, subspeciesName, false);
                if (subspecies == null) {
                    subspecies = this.findMatchWithin(TaxonUtils.getParentOfType(taxon, Taxon.Type.genus), subspeciesName, false);
                }
                if (subspecies != null) {
                    sightingTaxon = SightingTaxons.newSightingTaxon(subspecies.getId());
                }
            }
        }
        if (taxon.getTaxonomy() instanceof MappedTaxonomy) {
            MappedTaxonomy taxonomy = (MappedTaxonomy)taxon.getTaxonomy();
            SightingTaxon mapping = taxonomy.getMapping(sightingTaxon);
            if (mapping == null) {
                mapping = taxonomy.getMapping(taxon);
            }
            return mapping;
        }
        return sightingTaxon;
    }

    private SightingTaxon getTaxon(Collection<Taxon> collection, String subspeciesName) {
        return this.getTaxon(collection.iterator().next(), subspeciesName);
    }

    private void buildIndicesForTaxonomy(final BKTree.Builder<String, Taxon> commonNameTreeBuilder) {
        TaxonUtils.visitTaxa(this.taxonomy, new TaxonVisitor(){
            private static final String IN_PART = " - in part";

            @Override
            public boolean visitTaxon(Taxon taxon) {
                switch (taxon.getType()) {
                    case genus: {
                        TaxonResolver.this.newGenusNames.put(TaxonResolver.normalizeScientificName(taxon.getName()), taxon);
                        break;
                    }
                    case species: {
                        TaxonResolver.this.newSpeciesNames.put(TaxonResolver.normalizeScientificName(TaxonUtils.getFullName(taxon)), taxon);
                        for (String string : ((Species)taxon).getAlternateNames()) {
                            TaxonResolver.this.alternateSciNames.put(TaxonResolver.normalizeScientificName(string), taxon);
                        }
                        if (taxon.getCommonName() == null) break;
                        TaxonResolver.this.newCommonNames.put(TaxonResolver.normalizeCommonName(taxon.getCommonName()), taxon);
                        String localizedName = TaxonUtils.getCommonName(taxon);
                        if (!localizedName.equals(taxon.getCommonName())) {
                            TaxonResolver.this.newCommonNames.put(TaxonResolver.normalizeCommonName(localizedName), taxon);
                        }
                        commonNameTreeBuilder.add(TaxonResolver.normalizeCommonName(taxon.getCommonName()), taxon);
                        for (String alternateCommonName : ((Species)taxon).getAlternateCommonNames()) {
                            TaxonResolver.this.alternateCommonNames.put(TaxonResolver.normalizeCommonName(this.removeInPart(alternateCommonName)), taxon);
                        }
                        int n = taxon.getCommonName().indexOf(" (undesc");
                        if (n <= 0) break;
                        TaxonResolver.this.newCommonNames.put(TaxonResolver.normalizeCommonName(taxon.getCommonName().substring(0, n)), taxon);
                        commonNameTreeBuilder.add(TaxonResolver.normalizeCommonName(taxon.getCommonName().substring(0, n)), taxon);
                        break;
                    }
                    case group: {
                        TaxonResolver.this.newSpeciesNames.put(TaxonResolver.normalizeScientificName(TaxonUtils.getFullName(taxon)), taxon);
                        for (String string : ((Species)taxon).getAlternateNames()) {
                            TaxonResolver.this.alternateSciNames.put(TaxonResolver.normalizeScientificName(string), taxon);
                        }
                        String commonName = TaxonResolver.normalizeCommonName(taxon.getCommonName());
                        TaxonResolver.this.newCommonNames.put(commonName, taxon);
                        String string = TaxonResolver.normalizeCommonName(TaxonUtils.getCommonName(taxon));
                        if (!string.equals(commonName)) {
                            TaxonResolver.this.newCommonNames.put(string, taxon);
                        }
                        for (String alternateCommonName : ((Species)taxon).getAlternateCommonNames()) {
                            TaxonResolver.this.alternateCommonNames.put(this.removeInPart(TaxonResolver.normalizeCommonName(alternateCommonName)), taxon);
                        }
                        break;
                    }
                    case subspecies: {
                        for (String alternateCommonName : ((Species)taxon).getAlternateCommonNames()) {
                            TaxonResolver.this.alternateCommonNames.put(this.removeInPart(TaxonResolver.normalizeCommonName(alternateCommonName)), taxon);
                        }
                        break;
                    }
                }
                return true;
            }

            private String removeInPart(String name) {
                if (name.endsWith(IN_PART)) {
                    name = name.substring(0, name.length() - IN_PART.length());
                }
                return name;
            }
        });
    }

    Taxon findMatchWithin(final Taxon parent, final String name, boolean preferGroups) {
        final ArrayList matches = Lists.newArrayList();
        TaxonUtils.visitTaxa(parent, new TaxonVisitor(){

            @Override
            public boolean visitTaxon(Taxon taxon) {
                if (taxon != parent && name.equals(taxon.getName())) {
                    matches.add(taxon);
                    return false;
                }
                return true;
            }
        });
        if (matches.isEmpty()) {
            TaxonUtils.visitTaxa(parent, new TaxonVisitor(){

                @Override
                public boolean visitTaxon(Taxon taxon) {
                    if (taxon != parent && taxon.getType() == Taxon.Type.species && TaxonResolver.this.equalsOrClose(name, taxon.getName())) {
                        matches.add(taxon);
                        return false;
                    }
                    return true;
                }
            });
        }
        if (matches.size() != 1) {
            return null;
        }
        Taxon match = (Taxon)matches.get(0);
        if (preferGroups && match.getType() == Taxon.Type.subspecies && match.getParent().getType() == Taxon.Type.group) {
            match = match.getParent();
        }
        return match;
    }

    private static String normalizeCommonName(String name, String subspecies) {
        if (subspecies != null && name.indexOf(subspecies) > 0) {
            String subspeciesEnding = " (" + subspecies + "(";
            if (name.endsWith(subspeciesEnding)) {
                name = name.substring(0, name.length() - subspeciesEnding.length());
            }
            if (name.endsWith(subspeciesEnding = " [" + subspecies + "]")) {
                name = name.substring(0, name.length() - subspeciesEnding.length());
            }
        }
        return TaxonResolver.normalizeCommonName(name);
    }

    private static String normalizeCommonName(String name) {
        return name.toLowerCase().replace("grey", "gray").replace('\u00e7', 'c').replace('\u00f1', 'n').replace('\u00b4', '\'').replace('\u2010', ' ').replace('-', ' ').replace("chequer", "checker").replace("racquet", "racket").replace("\u00f6", "oe").replace("\u00fc", "ue").replace("colour", "color");
    }

    private static String normalizeScientificName(String name) {
        return name.toLowerCase();
    }

    private boolean equalsOrClose(String a, String b) {
        if (a.equals(b)) {
            return true;
        }
        if (this.maximumNameDistance == 0) {
            return false;
        }
        return LevenshteinDistance.getDefaultInstance().apply(a, b) <= (a.length() > 4 ? this.maximumNameDistance : 1);
    }
}

