/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TaxonPossibilities {
    private final SightingTaxon primary;
    private SightingTaxon anotherPrimary;
    private Set<SightingTaxon> alternates;

    public static TaxonPossibilities adding(TaxonPossibilities base, SightingTaxon more) {
        if (base == null) {
            return new TaxonPossibilities(more);
        }
        if (base.primary.equals(more)) {
            return base;
        }
        if (base.alternates == null) {
            base.alternates = Sets.newLinkedHashSetWithExpectedSize(4);
        }
        base.alternates.add(more);
        return base;
    }

    public static TaxonPossibilities adding(TaxonPossibilities base, TaxonPossibilities more) {
        if (base == null) {
            return more;
        }
        if (more == null) {
            return base;
        }
        if (base.primary.equals(more.primary)) {
            return base;
        }
        if (base.alternates == null) {
            base.alternates = Sets.newLinkedHashSetWithExpectedSize(4);
        }
        if (more.primary != null) {
            base.alternates.add(more.primary);
        }
        if (more.anotherPrimary != null) {
            base.alternates.add(more.anotherPrimary);
        }
        if (more.alternates != null) {
            base.alternates.addAll(more.alternates);
        }
        return base;
    }

    public static TaxonPossibilities withPrimary(TaxonPossibilities base, SightingTaxon anotherPrimary) {
        if (base != null && base.anotherPrimary == null && !base.primary.equals(anotherPrimary)) {
            base.anotherPrimary = anotherPrimary;
            return base;
        }
        return TaxonPossibilities.adding(base, anotherPrimary);
    }

    public TaxonPossibilities(SightingTaxon primary) {
        this.primary = Preconditions.checkNotNull(primary);
    }

    public SightingTaxon choose(Checklist checklist, Taxonomy taxonomy) {
        SightingTaxon chosen = this.chooseInternal(checklist, taxonomy);
        if (chosen.getType() == SightingTaxon.Type.SP) {
            Taxonomy base = taxonomy instanceof MappedTaxonomy ? ((MappedTaxonomy)taxonomy).getBaseTaxonomy() : taxonomy;
            chosen = SightingTaxons.newPossiblySpTaxon(TaxonUtils.simplifyTaxa(base, chosen.getIds()));
        }
        return chosen;
    }

    private SightingTaxon chooseInternal(Checklist checklist, Taxonomy taxonomy) {
        if (this.alternates == null && this.anotherPrimary == null) {
            return this.primary;
        }
        if (checklist == null) {
            if (this.anotherPrimary == null) {
                return this.primary;
            }
            return this.unify(ImmutableList.of(this.primary, this.anotherPrimary), taxonomy);
        }
        if (this.primary.getType() != SightingTaxon.Type.SINGLE && this.primary.getType() != SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
            return this.primary;
        }
        ArrayList<SightingTaxon> validPrimaries = new ArrayList<SightingTaxon>();
        if (this.resolveStatusOfPossibility(checklist, taxonomy, this.primary) != null) {
            validPrimaries.add(this.primary);
        }
        if (this.anotherPrimary != null && this.resolveStatusOfPossibility(checklist, taxonomy, this.anotherPrimary) != null) {
            validPrimaries.add(this.anotherPrimary);
        }
        if (!validPrimaries.isEmpty()) {
            return this.unify(validPrimaries, taxonomy);
        }
        ArrayList<SightingTaxon> nonRarities = Lists.newArrayList();
        ArrayList<SightingTaxon> rarities = Lists.newArrayList();
        for (SightingTaxon alternate : this.alternates) {
            Checklist.Status status = this.resolveStatusOfPossibility(checklist, taxonomy, alternate);
            if (status == Checklist.Status.RARITY || status == Checklist.Status.RARITY_FROM_INTRODUCED) {
                rarities.add(alternate);
                continue;
            }
            if (status == null) continue;
            nonRarities.add(alternate);
        }
        if (!nonRarities.isEmpty()) {
            return this.unify(nonRarities, taxonomy);
        }
        if (!rarities.isEmpty()) {
            return this.unify(rarities, taxonomy);
        }
        if (this.anotherPrimary == null) {
            return this.primary;
        }
        return this.unify(ImmutableList.of(this.primary, this.anotherPrimary), taxonomy);
    }

    Checklist.Status resolveStatusOfPossibility(Checklist checklist, Taxonomy taxonomy, SightingTaxon alternate) {
        SightingTaxon speciesParent = alternate.resolve(taxonomy).getParentOfAtLeastType(Taxon.Type.species);
        Checklist.Status status = checklist.getStatus(taxonomy, speciesParent);
        return status;
    }

    public boolean choseSpToResolve(SightingTaxon chosen) {
        return chosen.getType() == SightingTaxon.Type.SP && this.primary.getType() != SightingTaxon.Type.SP;
    }

    private SightingTaxon unify(List<SightingTaxon> taxa, Taxonomy taxonomy) {
        if (taxa.size() == 1) {
            return taxa.get(0);
        }
        List sortedResolved = taxa.stream().map(taxon -> taxon.resolve(taxonomy)).sorted(Comparator.comparing(taxon -> taxon.getSmallestTaxonType())).collect(Collectors.toList());
        long countOfTypes = sortedResolved.stream().map(taxon -> taxon.getSmallestTaxonType()).distinct().count();
        if (countOfTypes > 1L) {
            SightingTaxon.Resolved mostSpecific = (SightingTaxon.Resolved)sortedResolved.get(0);
            if (sortedResolved.stream().skip(1L).allMatch(taxon -> this.isParentOf(mostSpecific, (SightingTaxon.Resolved)taxon))) {
                SightingTaxon mostSpecificSightingTaxon = mostSpecific.getSightingTaxon();
                if (taxonomy instanceof MappedTaxonomy) {
                    MappedTaxonomy mappedTaxonomy = (MappedTaxonomy)taxonomy;
                    mostSpecificSightingTaxon = mappedTaxonomy.getMapping(mostSpecificSightingTaxon);
                }
                return mostSpecificSightingTaxon;
            }
            Stream<SightingTaxon> speciesInTaxonomy = sortedResolved.stream().map(taxon -> taxon.getParentOfAtLeastType(Taxon.Type.species)).distinct();
            if (taxonomy instanceof MappedTaxonomy) {
                MappedTaxonomy mappedTaxonomy = (MappedTaxonomy)taxonomy;
                speciesInTaxonomy = speciesInTaxonomy.map(taxon -> mappedTaxonomy.getMapping((SightingTaxon)taxon));
            }
            taxa = speciesInTaxonomy.collect(Collectors.toList());
        }
        LinkedHashSet ids = taxa.stream().flatMap(taxon -> taxon.getIds().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        return SightingTaxons.newPossiblySpTaxon(ids);
    }

    private boolean isParentOf(SightingTaxon.Resolved mostSpecific, SightingTaxon.Resolved maybeParent) {
        if (mostSpecific.getType() == SightingTaxon.Type.SP || mostSpecific.getType() == SightingTaxon.Type.HYBRID) {
            return false;
        }
        Taxon mostSpecificTaxon = mostSpecific.getTaxon();
        if (maybeParent.getType() == SightingTaxon.Type.SP || maybeParent.getType() == SightingTaxon.Type.HYBRID) {
            return false;
        }
        Taxon maybeParentTaxon = maybeParent.getTaxon();
        return TaxonUtils.isChildOf(maybeParentTaxon, mostSpecificTaxon);
    }

    public boolean hasAlternates() {
        return this.alternates != null || this.anotherPrimary != null;
    }

    public String toString() {
        if (this.alternates == null) {
            return this.primary.toString();
        }
        return String.format("%s[%s]", this.primary, Joiner.on('/').join(this.alternates));
    }
}

