/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.scythebill.birdlist.ui.imports.TaxonPossibilities;
import java.util.Iterator;
import javax.annotation.Nullable;

public abstract class TaxonImporter<T> {
    private static final Splitter SCI_SPLITTER = Splitter.on(' ').omitEmptyStrings().trimResults();

    @Nullable
    public abstract TaxonPossibilities map(T var1);

    public abstract ToBeDecided decideLater(T var1);

    static String justGenusAndSpecies(String sci) {
        if (sci == null) {
            return null;
        }
        if (CharMatcher.whitespace().countIn(sci) <= 1) {
            return sci;
        }
        Iterable<String> split = SCI_SPLITTER.split(sci);
        if (Iterables.size(split) != 3) {
            return sci;
        }
        Iterator<String> iterator = split.iterator();
        return iterator.next() + " " + iterator.next();
    }

    static String subspeciesIfPresent(String sci) {
        if (sci == null) {
            return null;
        }
        if (CharMatcher.whitespace().countIn(sci) <= 1) {
            return null;
        }
        Iterable<String> split = SCI_SPLITTER.split(sci);
        if (Iterables.size(split) != 3) {
            return null;
        }
        return Iterables.getLast(split);
    }

    public static class ToBeDecided {
        public String commonName;
        public String scientificName;
        public String subspecies;
        public String longText;

        public boolean shouldIgnore() {
            return !(this.commonName == null || !this.commonName.endsWith(" sp.") && !this.commonName.endsWith(" sp.)") || this.scientificName != null && !this.scientificName.endsWith(" sp."));
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("common", this.commonName).add("scientific", this.scientificName).add("ssp", this.subspecies).add("longText", this.longText).toString();
        }
    }
}

