/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Strings;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.RowExtractor;

public class StatusFieldMapper<T>
implements FieldMapper<T> {
    private RowExtractor<T, String> extractor;

    public StatusFieldMapper(RowExtractor<T, String> extractor) {
        this.extractor = extractor;
    }

    @Override
    public void map(T line, Sighting.Builder sighting) {
        SightingInfo.SightingStatus sightingStatus;
        String statusText = this.extractor.extract(line);
        if (!Strings.isNullOrEmpty(statusText) && (sightingStatus = SightingInfo.SightingStatus.forExportText(statusText)) != null) {
            sighting.getSightingInfo().setSightingStatus(sightingStatus);
        }
    }
}

