/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.LocationShortcuts;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TaxonPossibilities;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.ReadablePartial;

public abstract class SightingsImporter<T> {
    private static final Logger logger = Logger.getLogger(SightingsImporter.class.getName());
    protected final ReportSet reportSet;
    private final Taxonomy taxonomy;
    private final Taxonomy baseTaxonomy;
    protected final PredefinedLocations predefinedLocations;
    private final Checklists checklists;
    private final Map<Object, TaxonPossibilities> taxonomyIds = Maps.newHashMap();
    private int successfullyResolvedTaxa;
    private final Set<SightingTaxon> spToResolve = Sets.newLinkedHashSet();
    protected final ParsedLocationIds locationIds;
    private final Table<VisitInfoKey, SightingTaxon, Sighting> sightingsByVisitInfoAndTaxon = HashBasedTable.create();
    private ImmutableSet<Object> ignoredTaxonIds = ImmutableSet.of();
    private int sightingsFound;
    private int failureCount;
    private int sightingsMerged = 0;
    private Multiset<ReadablePartial> sightingsEBirdSpuhsDroppedCountByDate = HashMultiset.create();
    private int sightingsEBirdSpuhsDroppedCount;
    protected final LocationShortcuts locationShortcuts;
    private static final ReadablePartial NO_DATE_DATE = PartialIO.fromString("1900-01-01");

    public SightingsImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations) {
        this.reportSet = reportSet;
        this.taxonomy = taxonomy;
        this.checklists = checklists;
        this.predefinedLocations = predefinedLocations;
        this.baseTaxonomy = TaxonUtils.getBaseTaxonomy(taxonomy);
        this.locationShortcuts = new LocationShortcuts(reportSet.getLocations(), predefinedLocations);
        this.locationIds = new ParsedLocationIds();
    }

    protected abstract void operateOnAllRows(RowOperator<T> var1) throws IOException;

    protected abstract TaxonImporter<T> newTaxonImporter(Taxonomy var1);

    protected abstract RowExtractor<T, ? extends Object> taxonomyIdExtractor();

    protected abstract void parseLocationIds(LocationSet var1, PredefinedLocations var2) throws IOException;

    public abstract List<Sighting> parseSightings() throws IOException;

    public abstract String importFileName();

    protected abstract void importRowFailed(T var1);

    public abstract File writeFailedLines();

    public Optional<String> initialCheck() throws IOException {
        return Optional.absent();
    }

    public boolean importContainedUserInformation() {
        return false;
    }

    public boolean isMassExport() {
        return false;
    }

    public Collection<ReadablePartial> getAllDates() throws IOException {
        return null;
    }

    public void onlyImportDatesIn(Set<ReadablePartial> newDates) {
    }

    protected Taxonomy getTaxonomy() {
        return this.taxonomy;
    }

    protected Taxonomy getBaseTaxonomy() {
        return this.baseTaxonomy;
    }

    public Runnable longRunningTask() {
        return null;
    }

    public void parseSighting(T importRow, BiConsumer<T, Sighting.Builder> importRowParser, Function<T, Object> taxonomyIdFunction, List<Sighting> sightings, BiConsumer<T, Sighting.Builder> attemptDateRowParser) {
        block12: {
            ++this.sightingsFound;
            Sighting.Builder newBuilder = Sighting.newBuilder().setTaxonomy(this.getBaseTaxonomy());
            try {
                importRowParser.accept(importRow, newBuilder);
                if (this.checkForDefaultSightingStatus()) {
                    this.defaultSightingStatus(newBuilder);
                }
                this.lookForTripInfo(importRow, newBuilder);
                this.finishSighting(newBuilder, importRow);
                Sighting newSighting = newBuilder.build();
                VisitInfoKey visitInfoKey = VisitInfoKey.forSighting(newSighting);
                if (visitInfoKey != null) {
                    Sighting existingSighting = this.sightingsByVisitInfoAndTaxon.get(visitInfoKey, newSighting.getTaxon());
                    if (existingSighting != null) {
                        newSighting = existingSighting.mergeWith(newSighting);
                        sightings.remove(existingSighting);
                        --this.sightingsFound;
                        ++this.sightingsMerged;
                    }
                    this.sightingsByVisitInfoAndTaxon.put(visitInfoKey, newSighting.getTaxon(), newSighting);
                }
                sightings.add(newSighting);
                if (visitInfoKey != null) {
                    this.lookForVisitInfo(this.reportSet, importRow, newSighting, visitInfoKey);
                }
            }
            catch (RuntimeException e) {
                Object taxonomyId = taxonomyIdFunction.apply(importRow);
                if (this.ignoredTaxonIds.contains(taxonomyId)) {
                    ++this.sightingsEBirdSpuhsDroppedCount;
                    try {
                        attemptDateRowParser.accept(importRow, newBuilder);
                        ReadablePartial date = newBuilder.getDate();
                        if (date != null) {
                            this.sightingsEBirdSpuhsDroppedCountByDate.add(date);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    --this.sightingsFound;
                }
                this.importRowFailed(importRow);
                ++this.failureCount;
                if (this.failureCount < 10) {
                    logger.log(Level.WARNING, "Failure building sighting", e);
                }
                if (this.failureCount < 100) {
                    logger.log(Level.WARNING, "Failure building sighting: {0}, {1}", new Object[]{e.getMessage(), e.getClass().getName()});
                }
                if (this.failureCount != 100) break block12;
                logger.severe("Too many errors, not logging more.");
            }
        }
    }

    protected void lookForTripInfo(T importRow, Sighting.Builder newBuilder) {
    }

    protected void finishSighting(Sighting.Builder newSighting, T line) {
        ReadablePartial date = newSighting.getDate();
        if (date != null && date.equals(NO_DATE_DATE)) {
            newSighting.setDate(null);
            newSighting.setTime(null);
        }
    }

    protected void lookForVisitInfo(ReportSet reportSet, T line, Sighting newSighting, VisitInfoKey visitInfoKey) {
    }

    protected boolean checkForDefaultSightingStatus() {
        return true;
    }

    private void defaultSightingStatus(Sighting.Builder builder) {
        Checklist checklist;
        if (builder.getSightingInfo().getSightingStatus() != SightingInfo.SightingStatus.NONE) {
            return;
        }
        SightingInfo.SightingStatus sightingStatus = this.taxonToSightingStatus(builder.getTaxon());
        if ((sightingStatus == SightingInfo.SightingStatus.NONE || sightingStatus == SightingInfo.SightingStatus.DOMESTIC) && (checklist = this.getBuiltInChecklist(builder.getLocation())) != null) {
            Checklist.Status status = checklist.getStatus(this.getBaseTaxonomy(), builder.getTaxon());
            if (status == Checklist.Status.INTRODUCED || status == Checklist.Status.RARITY_FROM_INTRODUCED) {
                sightingStatus = SightingInfo.SightingStatus.INTRODUCED;
            } else if (status == Checklist.Status.ESCAPED) {
                sightingStatus = SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED;
            }
        }
        if (sightingStatus != SightingInfo.SightingStatus.NONE) {
            builder.getSightingInfo().setSightingStatus(sightingStatus);
        }
    }

    private SightingInfo.SightingStatus taxonToSightingStatus(SightingTaxon sightingTaxon) {
        if (sightingTaxon.getType() != SightingTaxon.Type.SINGLE) {
            return SightingInfo.SightingStatus.NONE;
        }
        Taxon taxon = this.getBaseTaxonomy().getTaxon(sightingTaxon.getId());
        switch (taxon.getStatus()) {
            case IN: {
                return SightingInfo.SightingStatus.INTRODUCED;
            }
            case DO: {
                return SightingInfo.SightingStatus.DOMESTIC;
            }
        }
        return SightingInfo.SightingStatus.NONE;
    }

    public final ParsedLocationIds parseLocationIds() throws IOException {
        LocationSet locations = this.reportSet.getLocations();
        this.parseLocationIds(locations, this.predefinedLocations);
        return this.locationIds;
    }

    protected Checklist getBuiltInChecklist(Location location) {
        return this.checklists.getNearestBuiltInChecklist(this.taxonomy, this.reportSet, location);
    }

    public int getSightingsFoundCount() {
        return this.sightingsFound;
    }

    public int getFailedSightingsCount() {
        return this.failureCount;
    }

    public int getSightingsMergedCount() {
        return this.sightingsMerged;
    }

    public int getSightingsEBirdSpuhsDroppedCount() {
        return this.sightingsEBirdSpuhsDroppedCount;
    }

    public Map<VisitInfoKey, VisitInfo> getAccumulatedVisitInfoMap() {
        return ImmutableMap.of();
    }

    public Map<Object, TaxonImporter.ToBeDecided> parseTaxonomyIds() throws IOException {
        this.successfullyResolvedTaxa = 0;
        this.taxonomyIds.clear();
        LinkedHashMap<Object, TaxonImporter.ToBeDecided> tbdMap = Maps.newLinkedHashMap();
        TaxonImporter<T> importer = this.newTaxonImporter(this.getTaxonomy());
        this.operateOnAllRows(row -> {
            Object key = this.taxonomyIdExtractor().extract(row);
            if (!this.taxonomyIds.containsKey(key) && !tbdMap.containsKey(key)) {
                TaxonPossibilities taxon = importer.map(row);
                if (taxon != null) {
                    this.registerTaxon(key, taxon);
                    ++this.successfullyResolvedTaxa;
                } else {
                    TaxonImporter.ToBeDecided decideLater = importer.decideLater(row);
                    tbdMap.put(key, decideLater);
                }
            }
            this.preSightingAnalysis(row);
        });
        return tbdMap;
    }

    public Set<SightingTaxon> getSpToResolve() {
        return Collections.unmodifiableSet(this.spToResolve);
    }

    public void setIgnoredTaxonIds(Set<Object> ignoredTaxonIds) {
        this.ignoredTaxonIds = ImmutableSet.copyOf(ignoredTaxonIds);
    }

    public void registerTaxon(Object key, TaxonPossibilities taxon) {
        if (this.taxonomyIds.containsKey(key)) {
            logger.warning("Re-registering " + key);
        }
        this.taxonomyIds.put(key, taxon);
    }

    public int successfullyResolvedTaxa() {
        return this.successfullyResolvedTaxa;
    }

    protected void preSightingAnalysis(T row) {
    }

    public boolean expectTaxonSuccess() {
        return true;
    }

    public void beforeParseTaxonomyIds() throws IOException {
    }

    public static interface RowOperator<T> {
        public void operate(T var1) throws IOException;
    }

    protected class TaxonFieldMapper
    implements FieldMapper<T> {
        private final RowExtractor<T, ? extends Object> taxonKeyExtractor;

        public TaxonFieldMapper(RowExtractor<T, ? extends Object> taxonKeyExtractor) {
            this.taxonKeyExtractor = taxonKeyExtractor;
        }

        @Override
        public void map(T line, Sighting.Builder sighting) {
            Object key = this.taxonKeyExtractor.extract(line);
            Preconditions.checkState(SightingsImporter.this.taxonomyIds.containsKey(key), "Cannot find taxon key %s", key);
            TaxonPossibilities possibilities = SightingsImporter.this.taxonomyIds.get(key);
            Checklist checklist = null;
            if (possibilities.hasAlternates() && sighting.getLocation() != null) {
                checklist = SightingsImporter.this.getBuiltInChecklist(sighting.getLocation());
            }
            SightingTaxon chosen = possibilities.choose(checklist, SightingsImporter.this.getTaxonomy());
            sighting.setTaxon(chosen);
            if (possibilities.choseSpToResolve(chosen)) {
                SightingsImporter.this.spToResolve.add(chosen);
            }
        }
    }

    protected class LocationMapper
    implements FieldMapper<T> {
        private final RowExtractor<T, ? extends Object> locationKeyExtractor;

        public LocationMapper(RowExtractor<T, ? extends Object> locationKeyExtractor) {
            this.locationKeyExtractor = locationKeyExtractor;
        }

        @Override
        public void map(T line, Sighting.Builder sighting) {
            Object key = this.locationKeyExtractor.extract(line);
            Preconditions.checkState(SightingsImporter.this.locationIds.containsKey(key), "Cannot find location key %s", key);
            String locationId = SightingsImporter.this.locationIds.getLocationId(key);
            if (locationId != null) {
                Location location = SightingsImporter.this.reportSet.getLocations().getLocation(locationId);
                Preconditions.checkNotNull(location, "Location id %s not in report set", (Object)locationId);
                sighting.setLocation(location);
            }
        }
    }
}

