/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.sighting.Area;
import com.scythebill.birdlist.model.sighting.Distance;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Link;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.LocalDateFormatterChooser;
import com.scythebill.birdlist.ui.imports.AdultFieldMapper;
import com.scythebill.birdlist.ui.imports.BreedingBirdCodeFieldMapper;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FemaleFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.HeardOnlyFieldMapper;
import com.scythebill.birdlist.ui.imports.ImmatureFieldMapper;
import com.scythebill.birdlist.ui.imports.ImportException;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.MaleFieldMapper;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import com.scythebill.birdlist.ui.imports.PhotographedFieldMapper;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.StatusFieldMapper;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TimeMapper;
import com.scythebill.birdlist.ui.imports.TripImporter;
import com.scythebill.birdlist.ui.imports.UserFieldMapper;
import com.scythebill.birdlist.ui.messages.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.Duration;
import org.joda.time.LocalTime;
import org.joda.time.Minutes;
import org.joda.time.ReadablePartial;

public class ScythebillImporter
extends CsvSightingsImporter {
    private static final Logger logger = Logger.getLogger(ScythebillImporter.class.getName());
    private LineExtractor<String> locationIdExtractor;
    private LineExtractor<String> taxonomyIdExtractor;
    private LineExtractor<String> commonNameExtractor;
    private LineExtractor<String> scientificExtractor;
    private LineExtractor<String> genusExtractor;
    private LineExtractor<String> speciesExtractor;
    private LineExtractor<String> subspeciesExtractor;
    private LineExtractor<String> regionExtractor;
    private LineExtractor<String> countryExtractor;
    private LineExtractor<String> stateExtractor;
    private LineExtractor<String> countyExtractor;
    private LineExtractor<String> cityExtractor;
    private LineExtractor<String> startTimeExtractor;
    private LineExtractor<String> endTimeExtractor;
    private List<LineExtractor<String>> locationExtractors;
    private LineExtractor<String> observationTypeExtractor;
    private LineExtractor<Integer> durationExtractor;
    private LineExtractor<Integer> partySizeExtractor;
    private LineExtractor<Float> distanceExtractor;
    private LineExtractor<Float> areaExtractor;
    private LineExtractor<Boolean> completeListExtractor;
    private LineExtractor<String> visitCommentsExtractor;
    private LineExtractor<String> visitPhotosExtractor;
    private Map<VisitInfoKey, VisitInfo.Builder> visitInfoMap;
    private LineExtractor<String> latitudeExtractor;
    private LineExtractor<String> longitudeExtractor;
    private LineExtractor<String> locationDescriptionExtractor;
    private LineExtractor<String> dateExtractor;
    private Optional<ImmutableList<LocalDateFormatterChooser.ChosenFormat>> chosenFormatters;
    private boolean importContainedUserInformation = false;
    private LineExtractor<String> tripNameExtractor;
    private LineExtractor<String> tripEndDateExtractor;
    private LineExtractor<String> tripStartDateExtractor;
    private LineExtractor<String> tripNotesExtractor;
    private LineExtractor<String> tripLinksExtractor;
    private LineExtractor<String> tripEndTimeExtractor;
    private LineExtractor<String> tripStartTimeExtractor;
    private TripImporter tripImporter;
    private Set<String> lineLocationIdWithMultipleLatLong = new LinkedHashSet<String>();
    private static final Splitter LINE_SPLITTER = Splitter.on(CharMatcher.anyOf("\r\n")).omitEmptyStrings().trimResults();
    private Map<String, Trip> tripsByKey;
    private Set<String> newlyCreatedTrips;

    public ScythebillImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        LineExtractor combinedScientificExtractor = row -> {
            String sci = (String)this.scientificExtractor.extract((String)row);
            if (!Strings.isNullOrEmpty(sci)) {
                return sci;
            }
            String species = (String)this.speciesExtractor.extract((String)row);
            if (Strings.isNullOrEmpty(species)) {
                return null;
            }
            String genus = (String)this.genusExtractor.extract((String)row);
            if (Strings.isNullOrEmpty(genus)) {
                return null;
            }
            return genus + " " + species;
        };
        return new FieldTaxonImporter<String[]>(taxonomy, this.commonNameExtractor, combinedScientificExtractor, this.subspeciesExtractor);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = CsvImportLines.fromFile(this.locationsFile, this.getCharset());){
            Object[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                try {
                    String id = (String)this.locationIdExtractor.extract((String)line);
                    if (this.locationIds.hasBeenParsed(id)) {
                        Location location;
                        String string;
                        String latitude = Strings.emptyToNull((String)this.latitudeExtractor.extract((String)line));
                        String longitude = Strings.emptyToNull((String)this.longitudeExtractor.extract((String)line));
                        if (latitude == null || longitude == null || (string = this.locationIds.getLocationId(id)) == null || !(location = this.reportSet.getLocations().getLocation(string)).getLatLong().isPresent()) continue;
                        try {
                            LatLongCoordinates newLatLong = LatLongCoordinates.withLatAndLong(latitude, longitude);
                            if (newLatLong.equals(location.getLatLong().get())) continue;
                            this.lineLocationIdWithMultipleLatLong.add(id);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        continue;
                    }
                    ImportedLocation imported = new ImportedLocation();
                    imported.state = (String)this.stateExtractor.extract((String)line);
                    imported.county = (String)this.countyExtractor.extract((String)line);
                    imported.country = (String)this.countryExtractor.extract((String)line);
                    imported.region = (String)this.regionExtractor.extract((String)line);
                    imported.city = (String)this.cityExtractor.extract((String)line);
                    for (LineExtractor lineExtractor : this.locationExtractors) {
                        imported.locationNames.add((String)lineExtractor.extract(line));
                    }
                    imported.latitude = Strings.emptyToNull((String)this.latitudeExtractor.extract((String)line));
                    imported.longitude = Strings.emptyToNull((String)this.longitudeExtractor.extract((String)line));
                    imported.description = Strings.emptyToNull((String)this.locationDescriptionExtractor.extract((String)line));
                    String locationId = imported.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                    this.locationIds.put((Object)id, locationId);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to import location " + Joiner.on(',').join(line), e);
                }
            }
        }
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        String[] header = lines.nextLine();
        LinkedHashMap<String, Integer> headersByIndex = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(CharMatcher.whitespace().removeFrom(header[i]).toLowerCase(), i);
        }
        ArrayList mappers = Lists.newArrayList();
        Integer commonIndex = (Integer)headersByIndex.get("common");
        Integer sciIndex = (Integer)headersByIndex.get("scientific");
        Integer genusIndex = (Integer)headersByIndex.get("genus");
        Integer speciesIndex = (Integer)headersByIndex.get("species");
        Integer sspIndex = (Integer)headersByIndex.get("subspecies");
        int dateIndex = this.getRequiredHeader(headersByIndex, "Date");
        Integer startTimeIndex = (Integer)headersByIndex.get("starttime");
        Integer endTimeIndex = (Integer)headersByIndex.get("endtime");
        Integer numberIndex = (Integer)headersByIndex.get("number");
        Integer femaleIndex = (Integer)headersByIndex.get("female");
        Integer maleIndex = (Integer)headersByIndex.get("male");
        Integer immatureIndex = (Integer)headersByIndex.get("immature");
        Integer adultIndex = (Integer)headersByIndex.get("adult");
        Integer heardOnlyIndex = (Integer)headersByIndex.get("heardonly");
        Integer statusIndex = (Integer)headersByIndex.get("status");
        Integer breedingIndex = (Integer)headersByIndex.get("breeding");
        Integer photographedIndex = (Integer)headersByIndex.get("photographed");
        Integer photosIndex = (Integer)headersByIndex.get("photos");
        Integer descriptionIndex = (Integer)headersByIndex.get("description");
        Integer regionIndex = (Integer)headersByIndex.get("region");
        int countryIndex = this.getRequiredHeader(headersByIndex, "Country");
        Integer stateIndex = (Integer)headersByIndex.get("state");
        Integer countyIndex = (Integer)headersByIndex.get("county");
        Integer cityIndex = (Integer)headersByIndex.get("city");
        Integer latitudeIndex = (Integer)headersByIndex.get("latitude");
        Integer longitudeIndex = (Integer)headersByIndex.get("longitude");
        Integer locationDescriptionIndex = (Integer)headersByIndex.get("locationdescription");
        if (commonIndex == null && sciIndex == null) {
            throw new ImportException(Messages.getMessage(Messages.Name.SCYTHEBILL_IMPORT_NEITHER_SCIENTIFIC_NOR_COMMON));
        }
        this.commonNameExtractor = commonIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(commonIndex);
        this.scientificExtractor = sciIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(sciIndex);
        this.genusExtractor = genusIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(genusIndex);
        this.speciesExtractor = speciesIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(speciesIndex);
        this.subspeciesExtractor = sspIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(sspIndex);
        this.taxonomyIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), ImmutableList.of(this.commonNameExtractor, this.scientificExtractor, this.subspeciesExtractor, this.speciesExtractor, this.genusExtractor));
        this.regionExtractor = regionIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(regionIndex);
        this.countryExtractor = LineExtractors.stringFromIndex(countryIndex);
        this.stateExtractor = stateIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(stateIndex);
        this.countyExtractor = countyIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(countyIndex);
        this.cityExtractor = cityIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(cityIndex);
        ArrayList<RowExtractor<String[], String>> allLocationExtractors = Lists.newArrayList();
        allLocationExtractors.add(this.regionExtractor);
        allLocationExtractors.add(this.countryExtractor);
        allLocationExtractors.add(this.stateExtractor);
        allLocationExtractors.add(this.countyExtractor);
        allLocationExtractors.add(this.cityExtractor);
        this.locationExtractors = Lists.newArrayList();
        Integer locationWithoutIndex = (Integer)headersByIndex.get("location");
        if (locationWithoutIndex != null) {
            this.locationExtractors.add(LineExtractors.stringFromIndex(locationWithoutIndex));
        }
        int i = 1;
        while (true) {
            String locationHeader;
            if (!headersByIndex.containsKey(locationHeader = String.format("location%s", i))) {
                if (i >= 2) break;
                ++i;
                continue;
            }
            int index = (Integer)headersByIndex.get(locationHeader);
            this.locationExtractors.add(LineExtractors.stringFromIndex(index));
            ++i;
        }
        allLocationExtractors.addAll(this.locationExtractors);
        this.locationIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), allLocationExtractors);
        this.latitudeExtractor = latitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(latitudeIndex);
        this.longitudeExtractor = longitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(longitudeIndex);
        this.locationDescriptionExtractor = locationDescriptionIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(locationDescriptionIndex);
        this.startTimeExtractor = startTimeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(startTimeIndex);
        LineExtractor<Object> lineExtractor = this.endTimeExtractor = endTimeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(endTimeIndex);
        if (startTimeIndex != null) {
            mappers.add(new TimeMapper(this.startTimeExtractor));
        }
        if (numberIndex != null) {
            mappers.add(new CountFieldMapper(LineExtractors.stringFromIndex(numberIndex)));
        }
        final LineExtractor<String> justDescriptionExtractor = descriptionIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(descriptionIndex);
        final LineExtractor<String> descriptionWithLatLongExtractor = LineExtractors.appendingLatitudeAndLongitude(justDescriptionExtractor, this.latitudeExtractor, this.longitudeExtractor);
        LineExtractor<String> descriptionExtractor = new LineExtractor<String>(){

            @Override
            public String extract(String[] row) {
                if (ScythebillImporter.this.lineLocationIdWithMultipleLatLong.contains(ScythebillImporter.this.locationIdExtractor.extract((String)row))) {
                    return (String)descriptionWithLatLongExtractor.extract(row);
                }
                return (String)justDescriptionExtractor.extract(row);
            }
        };
        mappers.add(new DescriptionFieldMapper<String[]>(descriptionExtractor));
        if (femaleIndex != null) {
            mappers.add(new FemaleFieldMapper(LineExtractors.booleanFromIndex(femaleIndex)));
        }
        if (maleIndex != null) {
            mappers.add(new MaleFieldMapper(LineExtractors.booleanFromIndex(maleIndex)));
        }
        if (immatureIndex != null) {
            mappers.add(new ImmatureFieldMapper(LineExtractors.booleanFromIndex(immatureIndex)));
        }
        if (adultIndex != null) {
            mappers.add(new AdultFieldMapper(LineExtractors.booleanFromIndex(adultIndex)));
        }
        if (heardOnlyIndex != null) {
            mappers.add(new HeardOnlyFieldMapper(LineExtractors.booleanFromIndex(heardOnlyIndex)));
        }
        if (photographedIndex != null) {
            mappers.add(new PhotographedFieldMapper(LineExtractors.booleanFromIndex(photographedIndex)));
        }
        if (photosIndex != null) {
            mappers.add(new PhotosMapper(LineExtractors.stringFromIndex(photosIndex), photographedIndex == null));
        }
        if (statusIndex != null) {
            mappers.add(new StatusFieldMapper(LineExtractors.stringFromIndex(statusIndex)));
        }
        if (breedingIndex != null) {
            mappers.add(new BreedingBirdCodeFieldMapper(LineExtractors.stringFromIndex(breedingIndex)));
        }
        this.visitInfoMap = new LinkedHashMap<VisitInfoKey, VisitInfo.Builder>();
        Integer observationTypeIndex = (Integer)headersByIndex.get("observationtype");
        Integer durationIndex = (Integer)headersByIndex.get("duration");
        Integer distanceIndex = (Integer)headersByIndex.get("distance");
        Integer areaIndex = (Integer)headersByIndex.get("area");
        Integer partySizeIndex = (Integer)headersByIndex.get("partysize");
        Integer completeListIndex = (Integer)headersByIndex.get("completelist");
        Integer visitCommentsIndex = (Integer)headersByIndex.get("visitcomments");
        Integer visitPhotosIndex = (Integer)headersByIndex.get("visitphotos");
        this.observationTypeExtractor = observationTypeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(observationTypeIndex);
        this.durationExtractor = durationIndex == null ? LineExtractors.alwaysNull() : LineExtractors.intFromIndex(durationIndex);
        this.partySizeExtractor = partySizeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.intFromIndex(partySizeIndex);
        this.distanceExtractor = distanceIndex == null ? LineExtractors.alwaysNull() : LineExtractors.floatFromIndex(distanceIndex);
        this.areaExtractor = areaIndex == null ? LineExtractors.alwaysNull() : LineExtractors.floatFromIndex(areaIndex);
        this.completeListExtractor = completeListIndex == null ? LineExtractors.constant(true) : LineExtractors.booleanFromIndex(completeListIndex);
        this.visitCommentsExtractor = visitCommentsIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(visitCommentsIndex);
        this.visitPhotosExtractor = visitPhotosIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(visitPhotosIndex);
        this.dateExtractor = LineExtractors.stringFromIndex(dateIndex);
        mappers.add(new ScythebillDateMapper(this.dateExtractor));
        Integer observersIndex = (Integer)headersByIndex.get("observers");
        Integer observerNamesIndex = (Integer)headersByIndex.get("observernames");
        if (observersIndex != null || observerNamesIndex != null) {
            LineExtractor<String> observersExtractor = observersIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(observersIndex);
            LineExtractor<String> observerNamesExtractor = observerNamesIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(observerNamesIndex);
            mappers.add(new UserFieldMapper(this.reportSet, observersExtractor, observerNamesExtractor));
            this.importContainedUserInformation = true;
        }
        Integer tripNameIndex = (Integer)headersByIndex.get("tripname");
        Integer tripStartDateIndex = (Integer)headersByIndex.get("tripstartdate");
        Integer tripStartTimeIndex = (Integer)headersByIndex.get("tripstarttime");
        Integer tripEndDateIndex = (Integer)headersByIndex.get("tripenddate");
        Integer tripEndTimeIndex = (Integer)headersByIndex.get("tripendtime");
        Integer tripNotesIndex = (Integer)headersByIndex.get("tripnotes");
        Integer tripLinksIndex = (Integer)headersByIndex.get("triplinks");
        if (tripStartDateIndex != null && tripEndDateIndex != null) {
            this.tripNameExtractor = tripNameIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(tripNameIndex);
            this.tripStartDateExtractor = LineExtractors.stringFromIndex(tripStartDateIndex);
            this.tripEndDateExtractor = LineExtractors.stringFromIndex(tripEndDateIndex);
            this.tripStartTimeExtractor = tripStartTimeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(tripStartTimeIndex);
            this.tripEndTimeExtractor = tripEndTimeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(tripEndTimeIndex);
            this.tripNotesExtractor = tripNotesIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(tripNotesIndex);
            this.tripLinksExtractor = tripLinksIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(tripLinksIndex);
        }
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this, this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this, this.locationIdExtractor), mappers);
    }

    @Override
    protected void computeExtendedMappings() throws IOException {
        if (this.chosenFormatters != null) {
            return;
        }
        try (ImportLines lines = this.importLines(this.sightingsFile);){
            String[] nextLine;
            LinkedHashSet<String> nonStandardDates = Sets.newLinkedHashSet();
            while ((nextLine = lines.nextLine()) != null) {
                String date = (String)this.dateExtractor.extract((String)nextLine);
                if (Strings.isNullOrEmpty(date)) continue;
                try {
                    PartialIO.fromString(date);
                }
                catch (IllegalArgumentException e) {
                    nonStandardDates.add(date);
                }
            }
            this.chosenFormatters = nonStandardDates.isEmpty() ? Optional.absent() : Optional.of(new LocalDateFormatterChooser().chooseFormatters(nonStandardDates));
        }
    }

    private ReadablePartial parseDate(String date) {
        if (Strings.isNullOrEmpty(date)) {
            return null;
        }
        if (!this.chosenFormatters.isPresent()) {
            return PartialIO.fromString(date);
        }
        try {
            return PartialIO.fromString(date);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (LocalDateFormatterChooser.ChosenFormat formatter : this.chosenFormatters.get()) {
                try {
                    return formatter.parse(date);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                }
            }
            throw new IllegalArgumentException(String.format("Could not parse date %s with any of these formats: %s", date, this.chosenFormatters.get()));
        }
    }

    static List<Photo> photosFromString(String photosString) {
        List<String> split = LINE_SPLITTER.splitToList(photosString);
        if (split.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<Photo> photos = new ArrayList<Photo>();
        for (String photoString : split) {
            try {
                URI uri = new URI(photoString);
                photos.add(new Photo(uri));
            }
            catch (URISyntaxException e) {
                File file = new File(photoString);
                if (!file.exists()) continue;
                photos.add(new Photo(file));
            }
        }
        return photos;
    }

    @Override
    protected void lookForTripInfo(String[] line, Sighting.Builder newBuilder) {
        String key;
        Trip trip;
        if (this.tripStartDateExtractor == null || this.tripEndDateExtractor == null) {
            return;
        }
        String startDateString = (String)this.tripStartDateExtractor.extract((String)line);
        String endDateString = (String)this.tripEndDateExtractor.extract((String)line);
        if (startDateString == null || endDateString == null) {
            return;
        }
        ReadablePartial startDate = this.parseDate(startDateString);
        ReadablePartial endDate = this.parseDate(endDateString);
        if (startDate == null || endDate == null) {
            return;
        }
        String tripName = (String)this.tripNameExtractor.extract((String)line);
        if (this.tripImporter == null) {
            this.tripImporter = new TripImporter(this.reportSet);
            this.tripsByKey = new HashMap<String, Trip>();
            this.newlyCreatedTrips = new HashSet<String>();
        }
        if ((trip = this.tripsByKey.get(key = String.format("%s|%s|%s", startDateString, endDateString, Strings.nullToEmpty(tripName)))) != null) {
            if (this.newlyCreatedTrips.contains(key) && trip.locationId() != null && newBuilder.getLocation() != null) {
                Location commonAncestor;
                Location sightingLocation = newBuilder.getLocation();
                Location tripLocation = this.reportSet.getLocations().getLocation(trip.locationId());
                if (!Locations.isDescendentOfLocation(tripLocation, sightingLocation) && (commonAncestor = Locations.getCommonAncestor(sightingLocation, tripLocation)) != null) {
                    trip.setLocation(commonAncestor);
                }
            }
        } else {
            String endTime;
            ParsedLocationIds.TripInfo tripInfo = new ParsedLocationIds.TripInfo();
            tripInfo.startDate = startDate;
            tripInfo.endDate = endDate;
            String startTime = (String)this.tripStartTimeExtractor.extract((String)line);
            if (!Strings.isNullOrEmpty(startTime)) {
                try {
                    tripInfo.startTime = TimeIO.fromExternalString(startTime);
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, "Failed to parse time " + startTime, e);
                }
            }
            if (!Strings.isNullOrEmpty(endTime = (String)this.tripEndTimeExtractor.extract((String)line))) {
                try {
                    tripInfo.endTime = TimeIO.fromExternalString(endTime);
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, "Failed to parse time " + startTime, e);
                }
            }
            tripInfo.name = Strings.emptyToNull((String)this.tripNameExtractor.extract((String)line));
            tripInfo.notes = Strings.emptyToNull((String)this.tripNotesExtractor.extract((String)line));
            String tripLinks = (String)this.tripLinksExtractor.extract((String)line);
            if (!Strings.isNullOrEmpty(tripLinks)) {
                for (String linkString : LINE_SPLITTER.split(tripLinks)) {
                    try {
                        URI uri = new URI(linkString);
                        tripInfo.links.add((Object)new Link(uri));
                    }
                    catch (URISyntaxException e) {
                        File file = new File(linkString);
                        if (!file.exists()) continue;
                        tripInfo.links.add((Object)new Link(file));
                    }
                }
            }
            trip = this.tripImporter.createTrip(this.reportSet, this.locationIds, tripInfo);
        }
        this.tripsByKey.put(key, trip);
        if (trip != null && newBuilder.getDate() == null) {
            newBuilder.setTrip(trip);
        }
    }

    @Override
    protected void lookForVisitInfo(ReportSet reportSet, String[] line, Sighting newSighting, VisitInfoKey visitInfoKey) {
        List<Photo> photos;
        String visitPhotosString;
        String visitComments;
        Integer partySize;
        Float area;
        Integer duration;
        VisitInfo.ObservationType observationType;
        String observationTypeString;
        VisitInfo.Builder builder = this.visitInfoMap.get(visitInfoKey);
        if (builder == null) {
            builder = VisitInfo.builder().withObservationType(VisitInfo.ObservationType.HISTORICAL);
            this.visitInfoMap.put(visitInfoKey, builder);
        }
        if (!Strings.isNullOrEmpty(observationTypeString = (String)this.observationTypeExtractor.extract((String)line)) && (observationType = VisitInfo.ObservationType.fromId(observationTypeString)) != null) {
            builder.withObservationType(observationType);
        }
        if ((duration = (Integer)this.durationExtractor.extract((Integer)line)) != null) {
            builder.withDuration(Duration.standardMinutes(duration.intValue()));
        } else {
            String startTime = (String)this.startTimeExtractor.extract((String)line);
            String endTime = (String)this.endTimeExtractor.extract((String)line);
            if (!Strings.isNullOrEmpty(startTime) && !Strings.isNullOrEmpty(endTime)) {
                try {
                    LocalTime start = TimeIO.fromExternalString(startTime);
                    LocalTime end = TimeIO.fromExternalString(endTime);
                    Duration durationObj = Minutes.minutesBetween(start, end).toStandardDuration();
                    if (durationObj.isLongerThan(Duration.standardMinutes(5L))) {
                        builder.withDuration(durationObj);
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, "Failed to parse times " + startTime + ", " + endTime, e);
                }
            }
        }
        Float distance = (Float)this.distanceExtractor.extract((Float)line);
        if (distance != null) {
            builder.withDistance(Distance.inKilometers(distance.floatValue()));
        }
        if ((area = (Float)this.areaExtractor.extract((Float)line)) != null) {
            builder.withArea(Area.inHectares(area.floatValue()));
        }
        if ((partySize = (Integer)this.partySizeExtractor.extract((Integer)line)) != null && partySize > 0) {
            builder.withPartySize(partySize);
        }
        if (!Strings.isNullOrEmpty(visitComments = (String)this.visitCommentsExtractor.extract((String)line))) {
            builder.withComments(visitComments);
        }
        if (!Strings.isNullOrEmpty(visitPhotosString = (String)this.visitPhotosExtractor.extract((String)line)) && !(photos = ScythebillImporter.photosFromString(visitPhotosString)).isEmpty()) {
            builder.withPhotos(photos);
        }
        if (((Boolean)this.completeListExtractor.extract((Boolean)line)).booleanValue()) {
            builder.withCompleteChecklist(true);
        }
    }

    @Override
    public Map<VisitInfoKey, VisitInfo> getAccumulatedVisitInfoMap() {
        LinkedHashMap<VisitInfoKey, VisitInfo> accumulated = new LinkedHashMap<VisitInfoKey, VisitInfo>();
        for (Map.Entry<VisitInfoKey, VisitInfo.Builder> entry : this.visitInfoMap.entrySet()) {
            VisitInfo visitInfo;
            VisitInfo.Builder builder = entry.getValue();
            try {
                visitInfo = builder.build();
            }
            catch (IllegalStateException e) {
                builder.withObservationType(VisitInfo.ObservationType.HISTORICAL);
                visitInfo = builder.build();
            }
            if (!visitInfo.hasData()) continue;
            accumulated.put(entry.getKey(), visitInfo);
        }
        return accumulated;
    }

    @Override
    public Optional<String> initialCheck() throws IOException {
        Optional<Object> error = super.initialCheck();
        if (error.isPresent()) {
            error = Optional.of(error.get() + "<p>" + Messages.getMessage(Messages.Name.OFTEN_DATES_CANNOT_BE_READ));
        }
        return error;
    }

    @Override
    protected boolean checkForDefaultSightingStatus() {
        return false;
    }

    @Override
    protected String[] getHeaderRow(ImportLines lines) throws IOException {
        return lines.nextLine();
    }

    @Override
    protected boolean skipLine(String[] line) {
        return Strings.isNullOrEmpty((String)this.commonNameExtractor.extract((String)line)) && Strings.isNullOrEmpty((String)this.scientificExtractor.extract((String)line));
    }

    @Override
    public boolean importContainedUserInformation() {
        return this.importContainedUserInformation;
    }

    static class PhotosMapper
    implements FieldMapper<String[]> {
        private final LineExtractor<String> extractor;
        private final boolean alsoSetPhotographed;

        PhotosMapper(LineExtractor<String> extractor, boolean alsoSetPhotographed) {
            this.extractor = extractor;
            this.alsoSetPhotographed = alsoSetPhotographed;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            List<Photo> photos;
            String photosString = Strings.emptyToNull((String)this.extractor.extract((String)line));
            if (photosString != null && !(photos = ScythebillImporter.photosFromString(photosString)).isEmpty()) {
                sighting.getSightingInfo().setPhotos(photos);
                if (this.alsoSetPhotographed) {
                    sighting.getSightingInfo().setPhotographed(true);
                }
            }
        }
    }

    class ScythebillDateMapper
    implements FieldMapper<String[]> {
        private final LineExtractor<String> extractor;

        ScythebillDateMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            Preconditions.checkState(ScythebillImporter.this.chosenFormatters != null, "Date formatting not yet called");
            sighting.setDate(ScythebillImporter.this.parseDate((String)this.extractor.extract((String)line)));
        }
    }
}

