/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Link;
import com.scythebill.birdlist.model.sighting.Location;
import java.util.Map;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class ParsedLocationIds {
    private Map<Object, String> locationIds = Maps.newLinkedHashMap();
    private Map<Object, ToBeDecided> toBeResolvedLocationNames = Maps.newLinkedHashMap();
    private Map<Object, TripInfo> tripInfoById = Maps.newLinkedHashMap();

    public boolean containsKey(Object key) {
        return this.locationIds.containsKey(key);
    }

    public boolean hasBeenParsed(Object key) {
        return this.locationIds.containsKey(key) || this.toBeResolvedLocationNames.containsKey(key) || this.tripInfoById.containsKey(key);
    }

    public boolean isToBeResolved(Object key) {
        return this.toBeResolvedLocationNames.containsKey(key);
    }

    public String getLocationId(Object key) {
        return this.locationIds.get(key);
    }

    public TripInfo getTripInfo(Object key) {
        return this.tripInfoById.get(key);
    }

    public void put(Object id, String locationId) {
        this.locationIds.put(id, locationId);
        this.toBeResolvedLocationNames.remove(id);
    }

    public void put(Object id, TripInfo tripInfo) {
        this.tripInfoById.put(id, tripInfo);
    }

    public void addToBeResolvedLocationName(Object id, ToBeDecided toBeDecided) {
        this.toBeResolvedLocationNames.put(id, toBeDecided);
    }

    public ImmutableMap<Object, ToBeDecided> toBeResolvedNames() {
        return ImmutableMap.copyOf(this.toBeResolvedLocationNames);
    }

    static class TripInfo {
        ReadablePartial startDate;
        LocalTime startTime;
        ReadablePartial endDate;
        LocalTime endTime;
        String name;
        String notes;
        ImmutableList.Builder<Link> links = ImmutableList.builder();
        String locationId;
        Object toBeResolvedId;

        TripInfo() {
        }
    }

    static class ToBeDecided {
        final String name;
        final LatLongCoordinates latLong;
        final String hint;
        final HintType hintType;
        final TripInfo tripInfo;
        Location preferredParent;

        ToBeDecided(String name) {
            this(name, null);
        }

        ToBeDecided(String name, LatLongCoordinates latLong) {
            this(name, latLong, null, HintType.other);
        }

        ToBeDecided(String name, LatLongCoordinates latLong, String hint, HintType hintType) {
            this.name = name;
            this.latLong = latLong;
            this.hint = hint;
            this.hintType = hintType;
            this.tripInfo = null;
        }

        static enum HintType {
            location,
            other;

        }
    }
}

