/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.BKTree;
import com.scythebill.birdlist.model.util.Metrics;
import com.scythebill.birdlist.ui.imports.AlternativeTaxonomicExtractors;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.MultiFormatDateFromStringFieldMapper;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TimeMapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.joda.time.Duration;
import org.joda.time.LocalTime;
import org.joda.time.Minutes;
import org.joda.time.ReadablePartial;

public class OrnithoImporter
extends CsvSightingsImporter {
    private static final Logger logger = Logger.getLogger(OrnithoImporter.class.getName());
    private LineExtractor<String> idExtractor;
    private LineExtractor<String> taxonomyIdExtractor;
    private RowExtractor<String[], String> commonNameExtractor;
    private RowExtractor<String[], String> scientificExtractor;
    private LineExtractor<String> subspeciesExtractor;
    private LineExtractor<String> countryOrStateExtractor;
    private LineExtractor<String> countyExtractor;
    private LineExtractor<String> municipalityExtractor;
    private LineExtractor<String> locationExtractor;
    private LineExtractor<String> longitudeExtractor;
    private LineExtractor<String> latitudeExtractor;
    private LineExtractor<String> timeStartExtractor;
    private LineExtractor<String> timeStopExtractor;
    private LineExtractor<String> visitCommentExtractor;
    private LineExtractor<Boolean> fullFormExtractor;
    private Map<VisitInfoKey, VisitInfo> visitInfoMap;
    private final ImmutableMap<String, SightingInfo.BreedingBirdCode> ATLAS_CODES = ImmutableMap.builder().put("A1", SightingInfo.BreedingBirdCode.IN_APPROPRIATE_HABITAT).put("A2", SightingInfo.BreedingBirdCode.SINGING_BIRD).put("B3", SightingInfo.BreedingBirdCode.PAIR_IN_SUITABLE_HABITAT).put("B4", SightingInfo.BreedingBirdCode.SINGING_BIRD_7_DAYS).put("B5", SightingInfo.BreedingBirdCode.COURTSHIP_DISPLAY_OR_COPULATION).put("B6", SightingInfo.BreedingBirdCode.VISITING_PROBABLE_NEST_SITE).put("B7", SightingInfo.BreedingBirdCode.AGITATED_BEHAVIOR).put("B8", SightingInfo.BreedingBirdCode.PHYSIOLOGICAL_EVIDENCE).put("B9", SightingInfo.BreedingBirdCode.NEST_BUILDING).put("C10", SightingInfo.BreedingBirdCode.DISTRACTION_DISPLAY).put("C11", SightingInfo.BreedingBirdCode.USED_NEST).put("C11a", SightingInfo.BreedingBirdCode.USED_NEST).put("C11b", SightingInfo.BreedingBirdCode.USED_NEST).put("C12", SightingInfo.BreedingBirdCode.RECENTLY_FLEDGED).put("C13", SightingInfo.BreedingBirdCode.OCCUPIED_NEST).put("C13a", SightingInfo.BreedingBirdCode.OCCUPIED_NEST).put("C13b", SightingInfo.BreedingBirdCode.OCCUPIED_NEST).put("C14a", SightingInfo.BreedingBirdCode.CARRYING_FECAL_SAC).put("C14b", SightingInfo.BreedingBirdCode.CARRYING_FOOD).put("C15", SightingInfo.BreedingBirdCode.NEST_WITH_EGGS).put("C16", SightingInfo.BreedingBirdCode.NEST_WITH_YOUNG).build();
    private static final CharMatcher ONLY_CODES = CharMatcher.inRange('A', 'Z').or(CharMatcher.anyOf(" -,*")).or(CharMatcher.inRange('0', '9'));

    public OrnithoImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        return new FieldTaxonImporter<String[]>(taxonomy, this.commonNameExtractor, this.scientificExtractor, this.subspeciesExtractor);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        OrnithoStateShortcuts ornithoStateShortcuts = new OrnithoStateShortcuts(locations, predefinedLocations);
        try (ImportLines lines = this.importLines(this.locationsFile);){
            Object[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                if (this.skipLine((String[])line)) continue;
                try {
                    String area;
                    Location countryExactMatch;
                    String id = (String)this.idExtractor.extract((String)line);
                    if (this.locationIds.hasBeenParsed(id)) continue;
                    ImportedLocation imported = new ImportedLocation();
                    imported.defaultRegion = "Europe";
                    String countryOrState = (String)this.countryOrStateExtractor.extract((String)line);
                    if (countryOrState.endsWith(", The")) {
                        countryOrState = countryOrState.substring(0, countryOrState.length() - 5);
                    }
                    if ((countryExactMatch = this.locationShortcuts.getCountryExactMatch(countryOrState, null, null)) != null) {
                        imported.country = countryExactMatch.getModelName();
                        StateAndCounty stateAndCounty = ornithoStateShortcuts.getStateAndCounty(countryExactMatch, (String)this.countyExtractor.extract((String)line));
                        if (stateAndCounty != null) {
                            imported.state = stateAndCounty.state;
                            imported.county = stateAndCounty.county;
                        }
                    } else {
                        CountryAndState countryFromState = ornithoStateShortcuts.countryFromState(countryOrState);
                        imported.countryCode = countryFromState.country;
                        imported.state = countryFromState.state;
                        String county = (String)this.countyExtractor.extract((String)line);
                        if (!Strings.isNullOrEmpty(county)) {
                            // empty if block
                        }
                    }
                    String municipality = (String)this.municipalityExtractor.extract((String)line);
                    if (!Strings.isNullOrEmpty(municipality)) {
                        municipality = OrnithoImporter.removeParentheticals(municipality);
                        imported.locationNames.add(municipality);
                    }
                    if (!Strings.isNullOrEmpty(area = (String)this.locationExtractor.extract((String)line))) {
                        area = OrnithoImporter.removeParentheticals(area);
                        imported.locationNames.add(area);
                    }
                    imported.longitude = Strings.emptyToNull((String)this.longitudeExtractor.extract((String)line));
                    imported.latitude = Strings.emptyToNull((String)this.latitudeExtractor.extract((String)line));
                    String locationId = imported.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                    this.locationIds.put((Object)id, locationId);
                }
                catch (Exception e) {
                    logger.warning("Failed to import location " + Joiner.on(',').join(line));
                }
            }
        }
    }

    private static String removeParentheticals(String text) {
        int leftParen;
        while ((leftParen = ((String)text).indexOf(" (")) >= 0) {
            int rightParen = ((String)text).indexOf(41, leftParen + 1);
            if (rightParen < 0) {
                return text;
            }
            if (!ONLY_CODES.matchesAllOf(((String)text).substring(leftParen + 2, rightParen))) {
                return text;
            }
            text = ((String)text).substring(0, leftParen) + ((String)text).substring(rightParen + 1);
        }
        return text;
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        Taxon tundraBeanGoose;
        String[] header = lines.nextLine();
        HashMap<String, Integer> headersByIndex = Maps.newHashMap();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(CharMatcher.whitespace().removeFrom(header[i]).toLowerCase(), i);
        }
        lines.nextLine();
        ArrayList mappers = Lists.newArrayList();
        Integer commonIndex = this.findIndex(headersByIndex, "name_species");
        Integer sciIndex = this.findIndex(headersByIndex, "latin_species");
        Integer dateIndex = this.findIndex(headersByIndex, "date");
        Integer estimationCodeIndex = this.findIndex(headersByIndex, "estimation_code");
        Integer numberIndex = this.findIndex(headersByIndex, "total_count");
        Integer descriptionIndex = this.findIndex(headersByIndex, "comment");
        Integer privateDescriptionIndex = this.findIndex(headersByIndex, "private_comment");
        Integer detailIndex = this.findIndex(headersByIndex, "detail");
        Integer observationDetailIndex = this.findIndex(headersByIndex, "observation_detail");
        Integer stateIndex = this.findIndex(headersByIndex, "country");
        Integer countyIndex = this.findIndex(headersByIndex, "county");
        Integer municipalityIndex = this.findIndex(headersByIndex, "municipality");
        Integer locationIndex = this.findIndex(headersByIndex, "place");
        Integer latitudeIndex = this.findIndex(headersByIndex, "coord_lat");
        Integer longitudeIndex = this.findIndex(headersByIndex, "coord_lon");
        Integer timeStartIndex = this.findIndex(headersByIndex, "time_start");
        Integer timeStopIndex = this.findIndex(headersByIndex, "time_stop");
        Integer atlasCodeIndex = this.findIndex(headersByIndex, "atlas_code");
        Integer visitCommentIndex = this.findIndex(headersByIndex, "daily_text_comment_rem");
        this.visitInfoMap = Maps.newHashMap();
        Integer fullFormIndex = this.findIndex(headersByIndex, "full_form");
        this.commonNameExtractor = commonIndex == null ? LineExtractors.alwaysNull() : new DropSspFromCommon(LineExtractors.stringFromIndex(commonIndex));
        this.scientificExtractor = sciIndex == null ? LineExtractors.alwaysNull() : new DropSspFromSci(LineExtractors.stringFromIndex(sciIndex));
        this.subspeciesExtractor = sciIndex == null ? LineExtractors.alwaysNull() : new ExtractSspFromSci(LineExtractors.stringFromIndex(sciIndex));
        AlternativeTaxonomicExtractors<String[]> alternativeScientificExtractors = new AlternativeTaxonomicExtractors<String[]>(this.scientificExtractor, this.subspeciesExtractor, this.commonNameExtractor);
        Taxonomy taxonomy = this.getTaxonomy();
        Taxon taigaBeanGoose = taxonomy.findSpecies("Anser fabalis");
        if (taigaBeanGoose == null) {
            logger.warning("Taiga Bean-Goose not found in " + taxonomy.getName());
        }
        if ((tundraBeanGoose = taxonomy.findSpecies("Anser serrirostris")) == null) {
            logger.warning("Tundra Bean-Goose not found in " + taxonomy.getName());
        }
        if (taigaBeanGoose != null && tundraBeanGoose != null) {
            alternativeScientificExtractors.splitting("Anser fabalis", taigaBeanGoose, tundraBeanGoose);
        }
        this.scientificExtractor = alternativeScientificExtractors.species();
        this.commonNameExtractor = alternativeScientificExtractors.common();
        this.taxonomyIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), ImmutableList.of(this.commonNameExtractor, this.scientificExtractor, this.subspeciesExtractor));
        this.countryOrStateExtractor = LineExtractors.stringFromIndex(stateIndex);
        this.countyExtractor = LineExtractors.stringFromIndex(countyIndex);
        this.municipalityExtractor = municipalityIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(municipalityIndex);
        this.locationExtractor = locationIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(locationIndex);
        this.longitudeExtractor = longitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(longitudeIndex);
        this.latitudeExtractor = latitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(latitudeIndex);
        ArrayList<RowExtractor<String[], String>> allLocationExtractors = Lists.newArrayList();
        allLocationExtractors.add(this.countryOrStateExtractor);
        allLocationExtractors.add(this.countyExtractor);
        allLocationExtractors.add(this.municipalityExtractor);
        allLocationExtractors.add(this.locationExtractor);
        this.idExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), allLocationExtractors);
        mappers.add(new MultiFormatDateFromStringFieldMapper(LineExtractors.stringFromIndex(dateIndex), "dd.MM.yy"));
        if (numberIndex != null) {
            mappers.add(new CountFieldMapper<String[]>(new IncorporateEstimation(estimationCodeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(estimationCodeIndex), LineExtractors.stringFromIndex(numberIndex))));
        }
        this.timeStartExtractor = timeStartIndex == null ? LineExtractors.alwaysNull() : OrnithoImporter.midnightAsNull(LineExtractors.stringFromIndex(timeStartIndex));
        this.timeStopExtractor = timeStopIndex == null ? LineExtractors.alwaysNull() : OrnithoImporter.midnightAsNull(LineExtractors.stringFromIndex(timeStopIndex));
        this.visitCommentExtractor = visitCommentIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(visitCommentIndex);
        this.fullFormExtractor = fullFormIndex == null ? LineExtractors.constant(false) : LineExtractors.booleanFromIndex(fullFormIndex);
        mappers.add(new TimeMapper(this.timeStartExtractor));
        if (atlasCodeIndex != null) {
            final LineExtractor<String> atlasCodeExtractor = LineExtractors.stringFromIndex(atlasCodeIndex);
            mappers.add(new FieldMapper<String[]>(){

                @Override
                public void map(String[] line, Sighting.Builder sighting) {
                    String atlasCode = (String)atlasCodeExtractor.extract(line);
                    SightingInfo.BreedingBirdCode breedingBirdCode = OrnithoImporter.this.ATLAS_CODES.get(atlasCode);
                    if (breedingBirdCode != null) {
                        sighting.getSightingInfo().setBreedingBirdCode(breedingBirdCode);
                    }
                }
            });
        }
        LineExtractor<Object> commentExtractor = descriptionIndex == null ? LineExtractors.constant(null) : LineExtractors.nullIfEmpty(LineExtractors.stringFromIndex(descriptionIndex));
        LineExtractor<Object> privateDescriptionExtractor = privateDescriptionIndex == null ? LineExtractors.constant(null) : LineExtractors.nullIfEmpty(LineExtractors.stringFromIndex(privateDescriptionIndex));
        LineExtractor<Object> detailExtractor = detailIndex == null ? LineExtractors.constant(null) : LineExtractors.nullIfEmpty(LineExtractors.stringFromIndex(detailIndex));
        LineExtractor<Object> observationDetailExtractor = observationDetailIndex == null ? LineExtractors.constant(null) : LineExtractors.nullIfEmpty(LineExtractors.stringFromIndex(observationDetailIndex));
        mappers.add(new DescriptionFieldMapper(LineExtractors.appendingLatitudeAndLongitude(LineExtractors.joined(Joiner.on('\n').skipNulls(), commentExtractor, privateDescriptionExtractor, detailExtractor, observationDetailExtractor), this.latitudeExtractor, this.longitudeExtractor)));
        if (detailIndex != null) {
            mappers.add(new DetailMapper(LineExtractors.stringFromIndex(detailIndex)));
        }
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this.idExtractor), mappers);
    }

    private Integer findIndex(Map<String, Integer> headersByIndex, String ... names) {
        for (String name : names) {
            Integer index = headersByIndex.get(name);
            if (index == null) continue;
            return index;
        }
        return null;
    }

    @Override
    protected ImportLines importLines(File file) throws IOException {
        CSVParser parser = new CSVParserBuilder().withSeparator('\t').withQuoteChar('\u0000').withStrictQuotes(false).build();
        CSVReader csvReader = new CSVReaderBuilder(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), StandardCharsets.UTF_8)).withCSVParser(parser).build();
        return CsvImportLines.fromReader(csvReader);
    }

    private static ImmutableTable<String, String, StateAndCounty> buildStateAndCountyTable() {
        ImmutableTable.Builder<String, String, StateAndCounty> builder = ImmutableTable.builder();
        CharSource source = Resources.asCharSource(Resources.getResource(OrnithoImporter.class, "ornitho-county-codes.csv"), StandardCharsets.UTF_8);
        try (BufferedReader reader = source.openBufferedStream();){
            String[] line;
            ImportLines lines = CsvImportLines.fromReader(reader);
            lines.nextLine();
            while ((line = lines.nextLine()) != null) {
                if (line.length == 0) continue;
                if (line.length != 4) {
                    throw new AssertionError((Object)("Unexpected line: " + Arrays.asList(line)));
                }
                builder.put(line[0].trim(), line[1].trim(), new StateAndCounty(line[2].trim(), line[3].trim()));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return builder.build();
    }

    @Override
    protected void lookForVisitInfo(ReportSet reportSet, String[] line, Sighting newSighting, VisitInfoKey visitInfoKey) {
        VisitInfo visitInfo;
        String visitComment;
        Duration duration;
        LocalTime timeStop;
        String timeStopString;
        VisitInfo.Builder builder = VisitInfo.builder().withObservationType(VisitInfo.ObservationType.HISTORICAL);
        if (((Boolean)this.fullFormExtractor.extract((Boolean)line)).booleanValue()) {
            builder.withCompleteChecklist(true);
        }
        if (visitInfoKey.startTime().isPresent() && !Strings.isNullOrEmpty(timeStopString = (String)this.timeStopExtractor.extract((String)line)) && (timeStop = TimeIO.fromString(timeStopString)) != null && (duration = Minutes.minutesBetween(visitInfoKey.startTime().get(), timeStop).toStandardDuration()).isLongerThan(Duration.standardMinutes(5L))) {
            builder = builder.withDuration(duration);
        }
        if (!Strings.isNullOrEmpty(visitComment = (String)this.visitCommentExtractor.extract((String)line))) {
            builder.withComments(visitComment);
        }
        if ((visitInfo = builder.build()).hasData()) {
            this.visitInfoMap.put(visitInfoKey, visitInfo);
        }
    }

    @Override
    public Map<VisitInfoKey, VisitInfo> getAccumulatedVisitInfoMap() {
        return this.visitInfoMap;
    }

    private static LineExtractor<String> midnightAsNull(final LineExtractor<String> extractor) {
        return new LineExtractor<String>(){

            @Override
            public String extract(String[] row) {
                String extracted = (String)extractor.extract(row);
                if ("0:00".equals(extracted) || "00:00".equals(extracted)) {
                    return null;
                }
                return extracted;
            }
        };
    }

    static class OrnithoStateShortcuts {
        private static final ImmutableTable<String, String, StateAndCounty> STATE_AND_COUNTY_TABLE = OrnithoImporter.buildStateAndCountyTable();
        private static final ImmutableList<String> INCLUDED_COUNTRIES = ImmutableList.of("DE", "AT", "IT", "PL", "CH", "AD", "ES", "LU", "SM", "TN", "FR", "GF", new String[]{"MQ", "LV"});
        private final ImmutableMap<String, CountryAndState> stateNameToCountry;
        private final BKTree<String, CountryAndState> stateNameToCountryInexact;

        OrnithoStateShortcuts(LocationSet locationSet, PredefinedLocations predefinedLocations) {
            ImmutableMap.Builder<String, CountryAndState> stateNameToCountryBuilder = ImmutableMap.builder();
            BKTree.Builder<String, CountryAndState> stateNameToCountryInexactBuilder = BKTree.builder(Metrics.levenshteinDistance());
            for (String includedCountry : INCLUDED_COUNTRIES) {
                Location country = locationSet.getLocationByCode(includedCountry);
                for (PredefinedLocations.PredefinedLocation predefinedLocation : predefinedLocations.getPredefinedLocations(country)) {
                    CountryAndState countryAndState = new CountryAndState(includedCountry, predefinedLocation.getName());
                    stateNameToCountryBuilder.put(predefinedLocation.getName(), countryAndState);
                    stateNameToCountryInexactBuilder.add(predefinedLocation.getName(), countryAndState);
                }
            }
            CountryAndState germanEEZ = new CountryAndState("DE", "Ausschlie\u00dfliche Wirtschaftszone");
            stateNameToCountryBuilder.put(germanEEZ.state, germanEEZ);
            stateNameToCountryInexactBuilder.add(germanEEZ.state, germanEEZ);
            CountryAndState frenchEEZ = new CountryAndState("FR", "Zone \u00e9conomique exclusive");
            stateNameToCountryBuilder.put(frenchEEZ.state, frenchEEZ);
            stateNameToCountryInexactBuilder.add(frenchEEZ.state, frenchEEZ);
            this.stateNameToCountry = stateNameToCountryBuilder.build();
            this.stateNameToCountryInexact = stateNameToCountryInexactBuilder.build();
        }

        public CountryAndState countryFromState(String stateName) {
            CountryAndState country = this.stateNameToCountry.get(stateName);
            if (country == null) {
                for (int i = 1; i <= 3; ++i) {
                    List<CountryAndState> list = this.stateNameToCountryInexact.search(stateName, i);
                    if (list.isEmpty()) continue;
                    country = list.get(0);
                    break;
                }
            }
            if (country == null) {
                country = new CountryAndState(null, stateName);
            }
            return country;
        }

        public StateAndCounty getStateAndCounty(Location country, String countyCode) {
            String ebirdCode = country.getEbirdCode();
            if (ebirdCode == null) {
                return null;
            }
            return (StateAndCounty)STATE_AND_COUNTY_TABLE.get(ebirdCode, countyCode);
        }
    }

    static class StateAndCounty {
        final String state;
        final String county;

        StateAndCounty(String state, String county) {
            this.state = state;
            this.county = county;
        }
    }

    static class CountryAndState {
        final String country;
        final String state;

        CountryAndState(String country, String state) {
            this.country = country;
            this.state = state;
        }
    }

    static class DropSspFromCommon
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;

        public DropSspFromCommon(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            String name = (String)this.extractor.extract((String)line);
            int indexOf = name.indexOf(" ssp ");
            if (indexOf > 0) {
                name = name.substring(0, indexOf);
            }
            return name;
        }
    }

    static class DropSspFromSci
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;

        public DropSspFromSci(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            int nextSpace;
            String name = (String)this.extractor.extract((String)line);
            if (name == null) {
                return null;
            }
            if (name.indexOf(47) >= 0) {
                return name;
            }
            if (name.indexOf(" x ") >= 0) {
                return name;
            }
            int firstSpace = name.indexOf(32);
            if (firstSpace >= 0 && (nextSpace = name.indexOf(32, firstSpace + 1)) >= 0) {
                return name.substring(0, nextSpace);
            }
            return name;
        }
    }

    static class ExtractSspFromSci
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;

        public ExtractSspFromSci(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            int nextSpace;
            String name = (String)this.extractor.extract((String)line);
            if (name == null) {
                return null;
            }
            if (name.indexOf(47) >= 0) {
                return null;
            }
            if (name.indexOf(" x ") >= 0) {
                return null;
            }
            int firstSpace = name.indexOf(32);
            if (firstSpace >= 0 && (nextSpace = name.indexOf(32, firstSpace + 1)) >= 0) {
                return name.substring(nextSpace + 1);
            }
            return null;
        }
    }

    static class IncorporateEstimation
    implements LineExtractor<String> {
        private LineExtractor<String> estimationExtractor;
        private LineExtractor<String> numberExtractor;

        public IncorporateEstimation(LineExtractor<String> estimationExtractor, LineExtractor<String> numberExtractor) {
            this.estimationExtractor = estimationExtractor;
            this.numberExtractor = numberExtractor;
        }

        @Override
        public String extract(String[] line) {
            String estimate = (String)this.estimationExtractor.extract((String)line);
            String number = (String)this.numberExtractor.extract((String)line);
            if (Strings.isNullOrEmpty(estimate)) {
                return number;
            }
            if (estimate.equals("x") || estimate.equals("\u00d7")) {
                return null;
            }
            return estimate + number;
        }
    }

    static class DetailMapper
    implements FieldMapper<String[]> {
        private final LineExtractor<String> extractor;

        public DetailMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String extracted = (String)this.extractor.extract((String)line);
            if (extracted != null) {
                extracted = extracted.toLowerCase();
                for (String substring : Splitter.on('/').split(extracted)) {
                    if (substring.contains("female") || substring.contains("weibchen")) {
                        sighting.getSightingInfo().setFemale(true);
                    } else if (substring.contains("male") || substring.contains("m\u00e4nnchen")) {
                        sighting.getSightingInfo().setMale(true);
                    }
                    if (substring.contains("adult")) {
                        sighting.getSightingInfo().setAdult(true);
                        continue;
                    }
                    if (!substring.contains("diesj\u00e4hrige") && !substring.contains("vorj\u00e4hrig") && !substring.contains("nicht-fl\u00fcgge")) continue;
                    sighting.getSightingInfo().setImmature(true);
                }
            }
        }
    }

    static class StripQuotes
    implements LineExtractor<String> {
        private final CharMatcher QUOTE = CharMatcher.is('\"');
        private final LineExtractor<String> extractor;

        public StripQuotes(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            String extracted = (String)this.extractor.extract((String)line);
            if (extracted == null) {
                return extracted;
            }
            return this.QUOTE.trimFrom(extracted);
        }
    }

    static class ScythebillDateMapper
    implements FieldMapper<String[]> {
        private LineExtractor<String> extractor;

        ScythebillDateMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String date = Strings.emptyToNull((String)this.extractor.extract((String)line));
            if (date != null) {
                ReadablePartial datePartial = PartialIO.fromString(date);
                sighting.setDate(datePartial);
            }
        }
    }
}

