/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.collect.ImmutableSet;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import java.io.IOException;
import org.joda.time.ReadablePartial;

class OnlyIncludeRowsMatchingDates
implements ImportLines {
    private ImportLines importLines;
    boolean readHeader = false;
    private final ImmutableSet<ReadablePartial> onlyImportDatesIn;
    private final LineExtractor<ReadablePartial> dateExtractor;

    OnlyIncludeRowsMatchingDates(ImportLines importLines, ImmutableSet<ReadablePartial> onlyImportDatesIn, LineExtractor<ReadablePartial> dateExtractor) {
        this.importLines = importLines;
        this.onlyImportDatesIn = onlyImportDatesIn;
        this.dateExtractor = dateExtractor;
    }

    @Override
    public void close() throws IOException {
        this.importLines.close();
    }

    @Override
    public String[] nextLine() throws IOException {
        String[] row;
        if (!this.readHeader) {
            String[] header = this.importLines.nextLine();
            this.readHeader = true;
            return header;
        }
        while ((row = this.importLines.nextLine()) != null) {
            if (!this.onlyImportDatesIn.contains(this.dateExtractor.extract((ReadablePartial)row))) continue;
            return row;
        }
        return null;
    }

    @Override
    public int lineNumber() {
        return this.importLines.lineNumber();
    }

    @Override
    public ImportLines withoutTrimming() {
        this.importLines = this.importLines.withoutTrimming();
        return this;
    }
}

