/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.PhotographedFieldMapper;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.ReadablePartial;

public class ObservadoNewImporter
extends CsvSightingsImporter {
    private static final Logger logger = Logger.getLogger(ObservadoNewImporter.class.getName());
    private LineExtractor<String> idExtractor;
    private LineExtractor<String> taxonomyIdExtractor;
    private LineExtractor<String> commonNameExtractor;
    private LineExtractor<String> scientificExtractor;
    private LineExtractor<String> subspeciesExtractor;
    private LineExtractor<String> locationExtractor;
    private LineExtractor<String> countryExtractor;
    private LineExtractor<String> stateExtractor;
    private LineExtractor<String> speciesGroupExtractor;
    private LineExtractor<String> longitudeExtractor;
    private LineExtractor<String> latitudeExtractor;
    private boolean onlyBirds;
    private static final ImmutableSet<String> BIRDS_GROUP_NAMES = ImmutableSet.of("birds", "vogels", "oiseaux", "p\u00e1jaros", "pajaros", "v\u00f6gel", new String[]{"vogel", "f\u00fbgels", "fugels", "uccelli"});

    public ObservadoNewImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
        this.onlyBirds = taxonomy.isBuiltIn();
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        return new FieldTaxonImporter<String[]>(taxonomy, this.commonNameExtractor, this.scientificExtractor, this.subspeciesExtractor);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = this.importLines(this.locationsFile);){
            Object[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                if (this.skipLine((String[])line)) continue;
                try {
                    String location;
                    String state;
                    String id = (String)this.idExtractor.extract((String)line);
                    if (this.locationIds.hasBeenParsed(id)) continue;
                    ImportedLocation imported = new ImportedLocation();
                    String country = (String)this.countryExtractor.extract((String)line);
                    if (!Strings.isNullOrEmpty(country)) {
                        imported.country = country;
                    }
                    if (!Strings.isNullOrEmpty(state = (String)this.stateExtractor.extract((String)line))) {
                        imported.state = state;
                    }
                    if (!Strings.isNullOrEmpty(location = (String)this.locationExtractor.extract((String)line))) {
                        Splitter locationSplitter = Splitter.on(" - ").trimResults(CharMatcher.whitespace());
                        List<String> locationsList = locationSplitter.splitToList(location);
                        if (locationsList.size() > 1 && Strings.isNullOrEmpty(imported.country)) {
                            imported.country = locationsList.get(0);
                            imported.locationNames = new ArrayList<String>(locationsList.subList(1, locationsList.size()));
                        } else {
                            imported.locationNames = new ArrayList<String>(locationsList);
                        }
                    }
                    if (!imported.locationNames.isEmpty()) {
                        String locationName = imported.locationNames.get(0);
                        Pattern abbreviationPattern = Pattern.compile("(.*) \\((.*)\\)");
                        Matcher matcher = abbreviationPattern.matcher(locationName);
                        if (matcher.matches()) {
                            imported.locationNames.set(0, matcher.group(1));
                            if (Strings.isNullOrEmpty(imported.state)) {
                                String stateFromLocation = matcher.group(2);
                                if (CharMatcher.inRange('A', 'Z').matchesAllOf(stateFromLocation)) {
                                    imported.stateCode = stateFromLocation;
                                } else {
                                    imported.state = stateFromLocation;
                                }
                            }
                        }
                    }
                    imported.longitude = Strings.emptyToNull((String)this.longitudeExtractor.extract((String)line));
                    imported.latitude = Strings.emptyToNull((String)this.latitudeExtractor.extract((String)line));
                    String locationId = imported.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                    this.locationIds.put((Object)id, locationId);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to import location " + Joiner.on(',').join(line), e);
                }
            }
        }
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        String[] header = lines.nextLine();
        HashMap<String, Integer> headersByIndex = Maps.newHashMap();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(CharMatcher.whitespace().removeFrom(header[i]).toLowerCase(), i);
        }
        ArrayList mappers = Lists.newArrayList();
        Integer commonIndex = this.findIndex(headersByIndex, "speciesname");
        Integer sciIndex = this.findIndex(headersByIndex, "scientificname");
        Integer dateIndex = this.findIndex(headersByIndex, "date");
        Integer numberIndex = this.findIndex(headersByIndex, "number");
        Integer sexIndex = this.findIndex(headersByIndex, "sex");
        Integer lifeStageIndex = this.findIndex(headersByIndex, "plumage", "lifestage");
        Integer descriptionIndex = this.findIndex(headersByIndex, "notes");
        Integer methodIndex = this.findIndex(headersByIndex, "method");
        Integer countryIndex = this.findIndex(headersByIndex, "country");
        Integer stateIndex = this.findIndex(headersByIndex, "countrydivision");
        Integer locationIndex = this.findIndex(headersByIndex, "location");
        Integer speciesGroupIndex = this.findIndex(headersByIndex, "speciesgroup");
        Integer certainIndex = this.findIndex(headersByIndex, "iscertain");
        Integer isEscapeIndex = this.findIndex(headersByIndex, "isescape");
        Integer activityIndex = this.findIndex(headersByIndex, "activity");
        Integer latitudeIndex = this.findIndex(headersByIndex, "lat");
        Integer longitudeIndex = this.findIndex(headersByIndex, "lng");
        Integer hasphotosIndex = this.findIndex(headersByIndex, "hasphotos");
        this.commonNameExtractor = commonIndex == null ? LineExtractors.alwaysNull() : new DropSspFromCommon(LineExtractors.stringFromIndex(commonIndex));
        this.scientificExtractor = sciIndex == null ? LineExtractors.alwaysNull() : new DropSspFromSci(LineExtractors.stringFromIndex(sciIndex));
        this.subspeciesExtractor = sciIndex == null ? LineExtractors.alwaysNull() : new ExtractSspFromSci(LineExtractors.stringFromIndex(sciIndex));
        this.taxonomyIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), ImmutableList.of(this.commonNameExtractor, this.scientificExtractor, this.subspeciesExtractor));
        this.locationExtractor = locationIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(locationIndex);
        this.countryExtractor = locationIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(countryIndex);
        this.stateExtractor = locationIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(stateIndex);
        this.longitudeExtractor = longitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(longitudeIndex);
        this.latitudeExtractor = latitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(latitudeIndex);
        this.speciesGroupExtractor = LineExtractors.stringFromIndex(speciesGroupIndex);
        this.idExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), ImmutableList.of(this.locationExtractor, this.stateExtractor, this.countryExtractor));
        mappers.add(new ScythebillDateMapper(LineExtractors.stringFromIndex(dateIndex)));
        if (numberIndex != null) {
            mappers.add(new CountFieldMapper(LineExtractors.stringFromIndex(numberIndex)));
        }
        StripQuotes commentExtractor = descriptionIndex == null ? LineExtractors.constant("") : new StripQuotes(LineExtractors.stringFromIndex(descriptionIndex));
        mappers.add(new DescriptionFieldMapper(LineExtractors.appendingLatitudeAndLongitude(commentExtractor, this.latitudeExtractor, this.longitudeExtractor)));
        if (sexIndex != null) {
            mappers.add(new SexMapper(LineExtractors.stringFromIndex(sexIndex)));
        }
        if (lifeStageIndex != null) {
            mappers.add(new LifeStageMapper(LineExtractors.stringFromIndex(lifeStageIndex)));
        }
        if (activityIndex != null) {
            mappers.add(new ActivityMapper(LineExtractors.stringFromIndex(activityIndex)));
        }
        if (hasphotosIndex != null) {
            mappers.add(new PhotographedFieldMapper(LineExtractors.booleanFromIndex(hasphotosIndex)));
        }
        LineExtractor<Boolean> isEscapeExtractor = isEscapeIndex == null ? LineExtractors.constant(false) : LineExtractors.booleanFromIndex(isEscapeIndex);
        LineExtractor<String> certainExtractor = certainIndex == null ? LineExtractors.constant("True") : LineExtractors.stringFromIndex(certainIndex);
        mappers.add(new StatusMapper(certainExtractor, isEscapeExtractor));
        if (methodIndex != null) {
            final LineExtractor<String> methodExtractor = LineExtractors.stringFromIndex(methodIndex);
            mappers.add(new FieldMapper<String[]>(){

                @Override
                public void map(String[] line, Sighting.Builder sighting) {
                    if ("heard".equalsIgnoreCase((String)methodExtractor.extract(line))) {
                        sighting.getSightingInfo().setHeardOnly(true);
                    }
                }
            });
        }
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this, this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this, this.idExtractor), mappers);
    }

    private Integer findIndex(Map<String, Integer> headersByIndex, String ... names) {
        for (String name : names) {
            Integer index = headersByIndex.get(name);
            if (index == null) continue;
            return index;
        }
        return null;
    }

    @Override
    protected boolean skipLine(String[] line) {
        String extracted;
        if (this.onlyBirds && !Strings.isNullOrEmpty(extracted = (String)this.speciesGroupExtractor.extract((String)line))) {
            if (!BIRDS_GROUP_NAMES.stream().anyMatch(extracted::equalsIgnoreCase)) {
                return true;
            }
        }
        return false;
    }

    static class DropSspFromCommon
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;

        public DropSspFromCommon(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            String name = (String)this.extractor.extract((String)line);
            int indexOf = name.indexOf(" ssp ");
            if (indexOf > 0) {
                name = name.substring(0, indexOf);
            }
            return name;
        }
    }

    static class DropSspFromSci
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;

        public DropSspFromSci(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            int nextSpace;
            String name = (String)this.extractor.extract((String)line);
            if (name == null) {
                return null;
            }
            if (name.indexOf(47) >= 0) {
                return name;
            }
            int firstSpace = name.indexOf(32);
            if (firstSpace >= 0 && (nextSpace = name.indexOf(32, firstSpace + 1)) >= 0) {
                return name.substring(0, nextSpace);
            }
            return name;
        }
    }

    static class ExtractSspFromSci
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;

        public ExtractSspFromSci(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            int nextSpace;
            String name = (String)this.extractor.extract((String)line);
            if (name == null) {
                return null;
            }
            int firstSpace = name.indexOf(32);
            if (firstSpace >= 0 && (nextSpace = name.indexOf(32, firstSpace + 1)) >= 0) {
                return name.substring(nextSpace + 1);
            }
            return null;
        }
    }

    static class ScythebillDateMapper
    implements FieldMapper<String[]> {
        private LineExtractor<String> extractor;

        ScythebillDateMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String date = Strings.emptyToNull((String)this.extractor.extract((String)line));
            if (date != null) {
                ReadablePartial datePartial = PartialIO.fromString(date);
                sighting.setDate(datePartial);
            }
        }
    }

    static class StripQuotes
    implements LineExtractor<String> {
        private final CharMatcher QUOTE = CharMatcher.is('\"');
        private final LineExtractor<String> extractor;

        public StripQuotes(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            String extracted = (String)this.extractor.extract((String)line);
            if (extracted == null) {
                return extracted;
            }
            return this.QUOTE.trimFrom(extracted);
        }
    }

    static class SexMapper
    implements FieldMapper<String[]> {
        private final LineExtractor<String> extractor;

        public SexMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String extracted = (String)this.extractor.extract((String)line);
            if (extracted != null) {
                if ("m".equals(extracted = extracted.toLowerCase())) {
                    sighting.getSightingInfo().setMale(true);
                } else if ("f".equals(extracted)) {
                    sighting.getSightingInfo().setFemale(true);
                } else if ("pair".equalsIgnoreCase(extracted)) {
                    sighting.getSightingInfo().setMale(true);
                    sighting.getSightingInfo().setFemale(true);
                }
            }
        }
    }

    static class LifeStageMapper
    implements FieldMapper<String[]> {
        private final LineExtractor<String> extractor;

        public LifeStageMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String extracted = (String)this.extractor.extract((String)line);
            if (extracted != null) {
                if ((extracted = extracted.toLowerCase()).contains("adult")) {
                    sighting.getSightingInfo().setAdult(true);
                } else if ("immature".equals(extracted) || "onvolwassen".equals(extracted) || "juvenile".equals(extracted) || "juveniel".equals(extracted) || "first winter".equals(extracted)) {
                    sighting.getSightingInfo().setImmature(true);
                } else if ("nestling".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.NEST_WITH_YOUNG);
                }
            }
        }
    }

    static class ActivityMapper
    implements FieldMapper<String[]> {
        private final LineExtractor<String> extractor;

        public ActivityMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String extracted = (String)this.extractor.extract((String)line);
            if (extracted != null) {
                if ("territorial behaviour".equals(extracted = extracted.toLowerCase())) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.TERRITORIAL_DEFENSE);
                } else if ("occupied nest".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.OCCUPIED_NEST);
                } else if ("pair in breeding area".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.PAIR_IN_SUITABLE_HABITAT);
                } else if ("adult in breeding area".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.IN_APPROPRIATE_HABITAT);
                } else if ("occupied nest with eggs".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.NEST_WITH_EGGS);
                } else if ("occupied nest with young".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.NEST_WITH_YOUNG);
                } else if ("probable nesting location".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.VISITING_PROBABLE_NEST_SITE);
                } else if ("pair courtship and or mating".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.COURTSHIP_DISPLAY_OR_COPULATION);
                } else if ("courtship/singing".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.SINGING_BIRD);
                } else if ("flying over".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.FLYOVER);
                } else if ("nest building".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.NEST_BUILDING);
                } else if ("recently fletched young".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.RECENTLY_FLEDGED);
                } else if ("bird with brood patch".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.PHYSIOLOGICAL_EVIDENCE);
                } else if ("transport of food or faeces".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.CARRYING_FOOD);
                } else if ("road kill".equals(extracted) || "windfarm victim".equals(extracted) || "window victim".equals(extracted) || "prey (dead)".equals(extracted) || "discovery (dead)".equals(extracted)) {
                    sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.DEAD);
                }
            }
        }
    }

    static class StatusMapper
    implements FieldMapper<String[]> {
        private LineExtractor<String> certainExtractor;
        private LineExtractor<Boolean> isEscapeExtractor;

        public StatusMapper(LineExtractor<String> certainExtractor, LineExtractor<Boolean> isEscapeExtractor) {
            this.certainExtractor = certainExtractor;
            this.isEscapeExtractor = isEscapeExtractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            if ("False".equalsIgnoreCase((String)this.certainExtractor.extract((String)line))) {
                sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.ID_UNCERTAIN);
            } else if (((Boolean)this.isEscapeExtractor.extract((Boolean)line)).booleanValue()) {
                sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED);
            }
        }
    }
}

