/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.mapdata.MapData;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ComputedMappings;
import com.scythebill.birdlist.ui.imports.CountFieldMapper;
import com.scythebill.birdlist.ui.imports.CsvSightingsImporter;
import com.scythebill.birdlist.ui.imports.DescriptionFieldMapper;
import com.scythebill.birdlist.ui.imports.FieldMapper;
import com.scythebill.birdlist.ui.imports.FieldTaxonImporter;
import com.scythebill.birdlist.ui.imports.ImportedLocation;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.LineExtractors;
import com.scythebill.birdlist.ui.imports.RowExtractor;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.ReadablePartial;

public class ObservadoImporter
extends CsvSightingsImporter {
    private static final Logger logger = Logger.getLogger(ObservadoImporter.class.getName());
    private static final Splitter LOCATION_SPLITTER = Splitter.on("- ").trimResults(CharMatcher.whitespace());
    private LineExtractor<String> idExtractor;
    private LineExtractor<String> taxonomyIdExtractor;
    private LineExtractor<String> commonNameExtractor;
    private LineExtractor<String> scientificExtractor;
    private LineExtractor<String> subspeciesExtractor;
    private LineExtractor<String> countryExtractor;
    private LineExtractor<String> stateExtractor;
    private LineExtractor<String> locationExtractor;
    private LineExtractor<String> speciesGroupExtractor;
    private LineExtractor<String> longitudeExtractor;
    private LineExtractor<String> latitudeExtractor;
    private boolean onlyBirds;
    private final CharMatcher SLASH = CharMatcher.is('/');
    private final Splitter SLASH_SPLITTER = Splitter.on(this.SLASH);
    private static final CharMatcher STRIP_FOR_BELGIUM_AND_NETHERLANDS_LOOKUP = CharMatcher.anyOf(" -");
    private static final ImmutableMap<String, CountryAndState> BELGIUM_AND_NETHERLANDS = ImmutableMap.builder().put("antwerp", ObservadoImporter.countryAndState("Belgium", "VLG")).put("antwerpen", ObservadoImporter.countryAndState("Belgium", "VLG")).put("anvers", ObservadoImporter.countryAndState("Belgium", "VLG")).put("eastflanders", ObservadoImporter.countryAndState("Belgium", "VLG")).put("oostvlaanderen", ObservadoImporter.countryAndState("Belgium", "VLG")).put("flandreorientale", ObservadoImporter.countryAndState("Belgium", "VLG")).put("vlaamsbrabant", ObservadoImporter.countryAndState("Belgium", "VLG")).put("flemishbrabant", ObservadoImporter.countryAndState("Belgium", "VLG")).put("brabantflamband", ObservadoImporter.countryAndState("Belgium", "VLG")).put("limburg", ObservadoImporter.countryAndState("Belgium", "VLG")).put("limbourg", ObservadoImporter.countryAndState("Belgium", "VLG")).put("westflanders", ObservadoImporter.countryAndState("Belgium", "VLG")).put("westvlaanderen", ObservadoImporter.countryAndState("Belgium", "VLG")).put("flandreoccidentale", ObservadoImporter.countryAndState("Belgium", "VLG")).put("henegouwen", ObservadoImporter.countryAndState("Belgium", "WAL")).put("hainaut", ObservadoImporter.countryAndState("Belgium", "WAL")).put("luik", ObservadoImporter.countryAndState("Belgium", "WAL")).put("li\u00e8ge", ObservadoImporter.countryAndState("Belgium", "WAL")).put("l\u00fcttich", ObservadoImporter.countryAndState("Belgium", "WAL")).put("luxemburg", ObservadoImporter.countryAndState("Belgium", "WAL")).put("namen", ObservadoImporter.countryAndState("Belgium", "WAL")).put("namur", ObservadoImporter.countryAndState("Belgium", "WAL")).put("walloonbrabant", ObservadoImporter.countryAndState("Belgium", "WAL")).put("waalsbrabant", ObservadoImporter.countryAndState("Belgium", "WAL")).put("brabantwallon", ObservadoImporter.countryAndState("Belgium", "WAL")).put("brussel", ObservadoImporter.countryAndStateNoProvince("Belgium", "BRU")).put("brussels", ObservadoImporter.countryAndStateNoProvince("Belgium", "BRU")).put("bruxelles", ObservadoImporter.countryAndStateNoProvince("Belgium", "BRU")).put("brusselshoofdstedelijkgewest", ObservadoImporter.countryAndStateNoProvince("Belgium", "BRU")).put("r\u00e9giondebruxellescapitale", ObservadoImporter.countryAndStateNoProvince("Belgium", "BRU")).put("drenthe", ObservadoImporter.countryAndStateNoProvince("Netherlands", "DR")).put("flevoland", ObservadoImporter.countryAndStateNoProvince("Netherlands", "FL")).put("frysl\u00e2n", ObservadoImporter.countryAndStateNoProvince("Netherlands", "FR")).put("friesland", ObservadoImporter.countryAndStateNoProvince("Netherlands", "FR")).put("gelderland", ObservadoImporter.countryAndStateNoProvince("Netherlands", "GE")).put("groningen", ObservadoImporter.countryAndStateNoProvince("Netherlands", "GR")).put("gr\u00f6nnen", ObservadoImporter.countryAndStateNoProvince("Netherlands", "GR")).put("grinsl\u00e2n", ObservadoImporter.countryAndStateNoProvince("Netherlands", "GR")).put("noordbrabant", ObservadoImporter.countryAndStateNoProvince("Netherlands", "NB")).put("northbrabant", ObservadoImporter.countryAndStateNoProvince("Netherlands", "NB")).put("noordholland", ObservadoImporter.countryAndStateNoProvince("Netherlands", "NH")).put("northholland", ObservadoImporter.countryAndStateNoProvince("Netherlands", "NH")).put("overijssel", ObservadoImporter.countryAndStateNoProvince("Netherlands", "OV")).put("utrecht", ObservadoImporter.countryAndStateNoProvince("Netherlands", "UT")).put("zeeland", ObservadoImporter.countryAndStateNoProvince("Netherlands", "ZE")).put("zuidholland", ObservadoImporter.countryAndStateNoProvince("Netherlands", "ZH")).put("southholland", ObservadoImporter.countryAndStateNoProvince("Netherlands", "ZH")).build();
    private static final Table<String, String, String> COUNTRY_AND_STATE_TO_COUNTRY_CODE = ImmutableTable.builder().put("Portugal", "Azores", "PT-20").put("Portugal", "Madeira", "PT-30").put("Ecuador", "Gal\u00e1pagos", "EC-W").put("Spain", "Santa Cruz de Tenerife", "ES-CN").put("Spain", "Las Palmas", "ES-CN").build();

    public ObservadoImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        super(reportSet, taxonomy, checklists, predefinedLocations, file, file);
        this.onlyBirds = taxonomy.isBuiltIn();
    }

    protected LineExtractor<? extends Object> taxonomyIdExtractor() {
        return this.taxonomyIdExtractor;
    }

    @Override
    protected TaxonImporter<String[]> newTaxonImporter(Taxonomy taxonomy) {
        return new FieldTaxonImporter<String[]>(taxonomy, this.commonNameExtractor, this.scientificExtractor, this.subspeciesExtractor);
    }

    @Override
    protected void parseLocationIds(LocationSet locations, PredefinedLocations predefinedLocations) throws IOException {
        try (ImportLines lines = this.importLines(this.locationsFile);){
            Object[] line;
            this.computeMappings(lines);
            while ((line = lines.nextLine()) != null) {
                if (this.skipLine((String[])line)) continue;
                try {
                    CountryAndState countryAndState;
                    String id = (String)this.idExtractor.extract((String)line);
                    if (this.locationIds.hasBeenParsed(id)) continue;
                    ImportedLocation imported = new ImportedLocation();
                    imported.defaultRegion = "Europe";
                    imported.longitude = Strings.emptyToNull((String)this.longitudeExtractor.extract((String)line));
                    imported.latitude = Strings.emptyToNull((String)this.latitudeExtractor.extract((String)line));
                    String country = (String)this.countryExtractor.extract((String)line);
                    if (country.endsWith(", The")) {
                        country = country.substring(0, country.length() - 5);
                    }
                    if ((countryAndState = this.getCountryAndState(country)) != null) {
                        String area;
                        String town;
                        imported.country = countryAndState.country;
                        imported.stateCode = countryAndState.state;
                        if (countryAndState.appendCounty) {
                            imported.county = country;
                        }
                        if (!Strings.isNullOrEmpty(town = (String)this.stateExtractor.extract((String)line))) {
                            imported.city = town;
                        }
                        if (!Strings.isNullOrEmpty(area = (String)this.locationExtractor.extract((String)line))) {
                            if (!Strings.isNullOrEmpty(town)) {
                                area = this.stripLocationPrefix(area, town);
                            }
                            imported.locationNames.add(area);
                        }
                    } else {
                        String countryCode;
                        imported.country = country;
                        imported.state = this.stripParentheticalAbbrevation(this.stripLocationPrefix((String)this.stateExtractor.extract((String)line), imported.country));
                        int slashSeparatedIndex = imported.state.indexOf(" / ");
                        if (slashSeparatedIndex > 0) {
                            imported.state = imported.state.substring(slashSeparatedIndex + 3);
                        }
                        if ("Luxembourg".equals(imported.country) && imported.latitude != null && imported.longitude != null) {
                            try {
                                LatLongCoordinates latLong = LatLongCoordinates.withLatAndLong(imported.latitude, imported.longitude);
                                String isoCode = MapData.instance().getISOCode(latLong);
                                if (isoCode != null) {
                                    switch (isoCode) {
                                        case "BE": 
                                        case "BE-WAL": {
                                            imported.countryCode = "BE";
                                            imported.country = null;
                                            if (!Strings.isNullOrEmpty(imported.state)) {
                                                imported.locationNames.add(imported.state);
                                            }
                                            imported.stateCode = "WAL";
                                            imported.state = null;
                                            imported.county = "Luxembourg";
                                            break;
                                        }
                                        case "LU": {
                                            break;
                                        }
                                        default: {
                                            logger.log(Level.WARNING, "Expected one of Belgium or Luxembourg, got {0} at {1}", new Object[]{isoCode, latLong});
                                        }
                                    }
                                }
                            }
                            catch (IllegalArgumentException latLong) {
                                // empty catch block
                            }
                        }
                        if ((countryCode = COUNTRY_AND_STATE_TO_COUNTRY_CODE.get(imported.country, imported.state)) != null) {
                            imported.countryCode = countryCode;
                            imported.country = null;
                            imported.state = null;
                        }
                        String locationNames = this.stripParentheticalAbbrevation(this.stripLocationPrefix(this.stripLocationPrefix((String)this.locationExtractor.extract((String)line), imported.country), imported.state));
                        imported.locationNames.addAll(LOCATION_SPLITTER.splitToList(locationNames));
                    }
                    String locationId = imported.addToLocationSet(this.reportSet, locations, this.locationShortcuts, predefinedLocations);
                    this.locationIds.put((Object)id, locationId);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to import location " + Joiner.on(',').join(line), e);
                }
            }
        }
    }

    private final CountryAndState getCountryAndState(String possibleProvince) {
        CountryAndState countryAndState;
        block1: {
            String split;
            String stripped = STRIP_FOR_BELGIUM_AND_NETHERLANDS_LOOKUP.removeFrom(possibleProvince.toLowerCase());
            countryAndState = BELGIUM_AND_NETHERLANDS.get(stripped);
            if (countryAndState != null || !this.SLASH.matchesAnyOf(possibleProvince)) break block1;
            Iterator<String> iterator = this.SLASH_SPLITTER.split(stripped).iterator();
            while (iterator.hasNext() && (countryAndState = BELGIUM_AND_NETHERLANDS.get(split = iterator.next())) == null) {
            }
        }
        return countryAndState;
    }

    static CountryAndState countryAndState(String country, String state) {
        return new CountryAndState(country, state, true);
    }

    static CountryAndState countryAndStateNoProvince(String country, String state) {
        return new CountryAndState(country, state, false);
    }

    private String stripParentheticalAbbrevation(String extracted) {
        int lastLeftParen;
        if (extracted.endsWith(")") && (lastLeftParen = extracted.lastIndexOf(40)) > 1) {
            if (CharMatcher.whitespace().matches(extracted.charAt(lastLeftParen - 1))) {
                --lastLeftParen;
            }
            extracted = extracted.substring(0, lastLeftParen);
        }
        return extracted;
    }

    private String stripLocationPrefix(String extracted, String country) {
        if (extracted == null) {
            return null;
        }
        if (country == null) {
            return extracted;
        }
        if (extracted.startsWith(country)) {
            extracted = extracted.substring(country.length());
        } else if (extracted.startsWith("BRD")) {
            extracted = extracted.substring(3);
        }
        if (extracted.startsWith(" - ")) {
            extracted = extracted.substring(3);
        } else if (extracted.startsWith(" -") || extracted.startsWith("- ")) {
            extracted = extracted.substring(2);
        } else if (extracted.startsWith("-")) {
            extracted = extracted.substring(1);
        }
        return extracted;
    }

    @Override
    protected ComputedMappings<String[]> computeMappings(ImportLines lines) throws IOException {
        String[] header = lines.nextLine();
        HashMap<String, Integer> headersByIndex = Maps.newHashMap();
        for (int i = 0; i < header.length; ++i) {
            headersByIndex.put(CharMatcher.whitespace().removeFrom(header[i]).toLowerCase(), i);
        }
        ArrayList mappers = Lists.newArrayList();
        Integer commonIndex = this.findIndex(headersByIndex, "name", "naam", "nom");
        Integer sciIndex = this.findIndex(headersByIndex, "scientificname", "wetenschappelijkenaam", "nomscientifique");
        Integer dateIndex = this.findIndex(headersByIndex, "date", "datum");
        Integer numberIndex = this.findIndex(headersByIndex, "number", "aantal", "nombre");
        Integer sexIndex = this.findIndex(headersByIndex, "sex", "geslacht", "sexe");
        Integer plumageIndex = this.findIndex(headersByIndex, "plumage", "kleed");
        Integer descriptionIndex = this.findIndex(headersByIndex, "remarks", "toelichting", "remarques");
        Integer countryIndex = this.findIndex(headersByIndex, "province", "provincie");
        Integer stateIndex = this.findIndex(headersByIndex, "municipal", "gemeente", "commune");
        Integer locationIndex = this.findIndex(headersByIndex, "area", "gebied", "site");
        Integer speciesGroupIndex = this.findIndex(headersByIndex, "speciesgroup", "soortgroep", "groupetaxonomique");
        Integer certainIndex = this.findIndex(headersByIndex, "certain", "zeker");
        Integer exoticIndex = this.findIndex(headersByIndex, "exotic", "escape", "\u00e9chapp\u00e9decaptivit\u00e9");
        Integer activityIndex = this.findIndex(headersByIndex, "activity", "gedrag");
        Integer latitudeIndex = this.findIndex(headersByIndex, "latitude", "lat");
        Integer longitudeIndex = this.findIndex(headersByIndex, "longitude", "lon", "lng");
        Integer photosIndex = this.findIndex(headersByIndex, "photos");
        Integer linkIndex = this.findIndex(headersByIndex, "link");
        this.commonNameExtractor = commonIndex == null ? LineExtractors.alwaysNull() : new DropSspFromCommon(LineExtractors.stringFromIndex(commonIndex));
        this.scientificExtractor = sciIndex == null ? LineExtractors.alwaysNull() : new DropSspFromSci(LineExtractors.stringFromIndex(sciIndex));
        this.subspeciesExtractor = sciIndex == null ? LineExtractors.alwaysNull() : new ExtractSspFromSci(LineExtractors.stringFromIndex(sciIndex));
        this.taxonomyIdExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), ImmutableList.of(this.commonNameExtractor, this.scientificExtractor, this.subspeciesExtractor));
        this.countryExtractor = LineExtractors.stringFromIndex(countryIndex);
        this.stateExtractor = stateIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(stateIndex);
        this.locationExtractor = locationIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(locationIndex);
        this.longitudeExtractor = longitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(longitudeIndex);
        this.latitudeExtractor = latitudeIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(latitudeIndex);
        ArrayList<RowExtractor<String[], String>> allLocationExtractors = Lists.newArrayList();
        allLocationExtractors.add(this.countryExtractor);
        allLocationExtractors.add(this.stateExtractor);
        allLocationExtractors.add(this.locationExtractor);
        this.speciesGroupExtractor = LineExtractors.stringFromIndex(speciesGroupIndex);
        this.idExtractor = LineExtractors.joined(Joiner.on('|').useForNull(""), allLocationExtractors);
        mappers.add(new ScythebillDateMapper(LineExtractors.stringFromIndex(dateIndex)));
        if (numberIndex != null) {
            mappers.add(new CountFieldMapper(LineExtractors.stringFromIndex(numberIndex)));
        }
        StripQuotes commentExtractor = descriptionIndex == null ? LineExtractors.constant("") : new StripQuotes(LineExtractors.stringFromIndex(descriptionIndex));
        mappers.add(new DescriptionFieldMapper(LineExtractors.appendingLatitudeAndLongitude(commentExtractor, this.latitudeExtractor, this.longitudeExtractor)));
        if (sexIndex != null) {
            mappers.add(new SexMapper(LineExtractors.stringFromIndex(sexIndex)));
        }
        if (plumageIndex != null) {
            mappers.add(new PlumageMapper(LineExtractors.stringFromIndex(plumageIndex)));
        }
        if (activityIndex != null) {
            mappers.add(new ActivityMapper(LineExtractors.stringFromIndex(activityIndex)));
        }
        if (photosIndex != null) {
            LineExtractor<String> linkExtractor = linkIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(linkIndex);
            mappers.add(new PhotosMapper(LineExtractors.intFromIndex(photosIndex), linkExtractor));
        }
        LineExtractor<String> exoticExtractor = exoticIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(exoticIndex);
        LineExtractor<String> certainExtractor = certainIndex == null ? LineExtractors.alwaysNull() : LineExtractors.stringFromIndex(certainIndex);
        mappers.add(new StatusMapper(certainExtractor, exoticExtractor));
        return new ComputedMappings<String[]>(new SightingsImporter.TaxonFieldMapper(this.taxonomyIdExtractor), new SightingsImporter.LocationMapper(this.idExtractor), mappers);
    }

    private Integer findIndex(Map<String, Integer> headersByIndex, String ... names) {
        for (String name : names) {
            Integer index = headersByIndex.get(name);
            if (index == null) continue;
            return index;
        }
        return null;
    }

    @Override
    protected ImportLines importLines(File file) throws IOException {
        CSVParser parser = new CSVParserBuilder().withSeparator('\t').withQuoteChar('\"').withStrictQuotes(false).build();
        CSVReader csvReader = new CSVReaderBuilder(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), StandardCharsets.UTF_16LE)).withCSVParser(parser).build();
        return CsvImportLines.fromReader(csvReader);
    }

    @Override
    protected boolean skipLine(String[] line) {
        String extracted;
        return this.onlyBirds && !Strings.isNullOrEmpty(extracted = (String)this.speciesGroupExtractor.extract((String)line)) && !"birds".equalsIgnoreCase(extracted);
    }

    static class CountryAndState {
        final String country;
        final String state;
        final boolean appendCounty;

        CountryAndState(String country, String state, boolean appendCounty) {
            this.country = country;
            this.state = state;
            this.appendCounty = appendCounty;
        }
    }

    static class DropSspFromCommon
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;

        public DropSspFromCommon(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            String name = (String)this.extractor.extract((String)line);
            int indexOf = name.indexOf(" ssp ");
            if (indexOf > 0) {
                name = name.substring(0, indexOf);
            }
            return name;
        }
    }

    static class DropSspFromSci
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;

        public DropSspFromSci(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            int nextSpace;
            String name = (String)this.extractor.extract((String)line);
            if (name == null) {
                return null;
            }
            if (name.indexOf(47) >= 0) {
                return name;
            }
            int firstSpace = name.indexOf(32);
            if (firstSpace >= 0 && (nextSpace = name.indexOf(32, firstSpace + 1)) >= 0) {
                return name.substring(0, nextSpace);
            }
            return name;
        }
    }

    static class ExtractSspFromSci
    implements LineExtractor<String> {
        private final LineExtractor<String> extractor;

        public ExtractSspFromSci(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            int nextSpace;
            String name = (String)this.extractor.extract((String)line);
            if (name == null) {
                return null;
            }
            int firstSpace = name.indexOf(32);
            if (firstSpace >= 0 && (nextSpace = name.indexOf(32, firstSpace + 1)) >= 0) {
                return name.substring(nextSpace + 1);
            }
            return null;
        }
    }

    static class ScythebillDateMapper
    implements FieldMapper<String[]> {
        private LineExtractor<String> extractor;

        ScythebillDateMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String date = Strings.emptyToNull((String)this.extractor.extract((String)line));
            if (date != null) {
                ReadablePartial datePartial = PartialIO.fromString(date);
                sighting.setDate(datePartial);
            }
        }
    }

    static class StripQuotes
    implements LineExtractor<String> {
        private final CharMatcher QUOTE = CharMatcher.is('\"');
        private final LineExtractor<String> extractor;

        public StripQuotes(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public String extract(String[] line) {
            String extracted = (String)this.extractor.extract((String)line);
            if (extracted == null) {
                return extracted;
            }
            return this.QUOTE.trimFrom(extracted);
        }
    }

    static class SexMapper
    implements FieldMapper<String[]> {
        private final LineExtractor<String> extractor;

        public SexMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String extracted = (String)this.extractor.extract((String)line);
            if (extracted != null) {
                if ("male".equals(extracted = extracted.toLowerCase()) || "man".equals(extracted) || "m\u00e2le".equals(extracted)) {
                    sighting.getSightingInfo().setMale(true);
                } else if ("female".equals(extracted) || "vrouw".equals(extracted) || "femelle".equals(extracted)) {
                    sighting.getSightingInfo().setFemale(true);
                } else if ("pair".equalsIgnoreCase(extracted)) {
                    sighting.getSightingInfo().setMale(true);
                    sighting.getSightingInfo().setFemale(true);
                }
            }
        }
    }

    static class PlumageMapper
    implements FieldMapper<String[]> {
        private final LineExtractor<String> extractor;

        public PlumageMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String extracted = (String)this.extractor.extract((String)line);
            if (extracted != null) {
                if ((extracted = extracted.toLowerCase()).contains("adult")) {
                    sighting.getSightingInfo().setAdult(true);
                } else if ("immature".equals(extracted) || "onvolwassen".equals(extracted) || "juvenile".equals(extracted) || "juveniel".equals(extracted)) {
                    sighting.getSightingInfo().setImmature(true);
                }
            }
        }
    }

    static class ActivityMapper
    implements FieldMapper<String[]> {
        private final LineExtractor<String> extractor;

        public ActivityMapper(LineExtractor<String> extractor) {
            this.extractor = extractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String extracted = (String)this.extractor.extract((String)line);
            if (extracted != null) {
                if ("territorial behaviour".equals(extracted = extracted.toLowerCase())) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.TERRITORIAL_DEFENSE);
                } else if ("occupied nest".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.OCCUPIED_NEST);
                } else if ("pair in breeding area".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.PAIR_IN_SUITABLE_HABITAT);
                } else if ("adult in breeding area".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.IN_APPROPRIATE_HABITAT);
                } else if ("occupied nest with eggs".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.NEST_WITH_EGGS);
                } else if ("occupied nest with young".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.NEST_WITH_YOUNG);
                } else if ("probable nesting location".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.VISITING_PROBABLE_NEST_SITE);
                } else if ("pair courtship and or mating".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.COURTSHIP_DISPLAY_OR_COPULATION);
                } else if ("nest building".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.NEST_BUILDING);
                } else if ("recently fletched young".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.RECENTLY_FLEDGED);
                } else if ("bird with brood patch".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.PHYSIOLOGICAL_EVIDENCE);
                } else if ("transport of food or faeces".equals(extracted)) {
                    sighting.getSightingInfo().setBreedingBirdCode(SightingInfo.BreedingBirdCode.CARRYING_FOOD);
                }
            }
        }
    }

    static class PhotosMapper
    implements FieldMapper<String[]> {
        private LineExtractor<Integer> photoCountExtractor;
        private LineExtractor<String> linkExtractor;

        public PhotosMapper(LineExtractor<Integer> photoCountExtractor, LineExtractor<String> linkExtractor) {
            this.photoCountExtractor = photoCountExtractor;
            this.linkExtractor = linkExtractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            Integer photoCount = (Integer)this.photoCountExtractor.extract((Integer)line);
            if (photoCount != null && photoCount > 0) {
                sighting.getSightingInfo().setPhotographed(true);
                String link = (String)this.linkExtractor.extract((String)line);
                if (!Strings.isNullOrEmpty(link)) {
                    try {
                        URI linkUri = new URI(link);
                        Photo photo = new Photo(linkUri);
                        sighting.getSightingInfo().setPhotos(ImmutableList.of(photo));
                    }
                    catch (URISyntaxException e) {
                        logger.warning("Could not parse link " + link);
                    }
                }
            }
        }
    }

    static class StatusMapper
    implements FieldMapper<String[]> {
        private final LineExtractor<String> certainExtractor;
        private final LineExtractor<String> exoticExtractor;

        public StatusMapper(LineExtractor<String> certainExtractor, LineExtractor<String> exoticExtractor) {
            this.certainExtractor = certainExtractor;
            this.exoticExtractor = exoticExtractor;
        }

        @Override
        public void map(String[] line, Sighting.Builder sighting) {
            String certain = (String)this.certainExtractor.extract((String)line);
            if ("N".equals(certain)) {
                sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.ID_UNCERTAIN);
            } else {
                String exotic = (String)this.exoticExtractor.extract((String)line);
                if ("Y".equals(exotic)) {
                    sighting.getSightingInfo().setSightingStatus(SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED);
                }
            }
        }
    }
}

