/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.imports.ObservadoImporter;
import com.scythebill.birdlist.ui.imports.ObservadoNewImporter;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class Observado {
    private Observado() {
    }

    public static SightingsImporter<?> newImporter(ReportSet reportSet, Taxonomy taxonomy, Checklists checklists, PredefinedLocations predefinedLocations, File file) {
        CharSource charSource = Files.asCharSource(file, StandardCharsets.UTF_16LE);
        try {
            String firstLine = charSource.readFirstLine();
            if (firstLine != null && firstLine.startsWith("\ufeff")) {
                return new ObservadoImporter(reportSet, taxonomy, checklists, predefinedLocations, file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ObservadoNewImporter(reportSet, taxonomy, checklists, predefinedLocations, file);
    }
}

