/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Strings;
import com.scythebill.birdlist.ui.imports.DateParseException;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GJChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class MultiFormatDateFromStringLineExtractor
implements LineExtractor<ReadablePartial> {
    private final LineExtractor<String> extractor;
    private final Supplier<List<DateTimeFormatter>> dateTimeFormatters;

    public MultiFormatDateFromStringLineExtractor(LineExtractor<String> extractor, String ... patterns) {
        this(extractor, Locale.getDefault(), patterns);
    }

    public MultiFormatDateFromStringLineExtractor(LineExtractor<String> extractor, Locale locale, String ... patterns) {
        this.extractor = extractor;
        ArrayList<DateTimeFormatter> formatters = new ArrayList<DateTimeFormatter>();
        for (int i = 0; i < patterns.length; ++i) {
            formatters.add(DateTimeFormat.forPattern(patterns[i]).withPivotYear(2000).withLocale(locale).withChronology(GJChronology.getInstance()));
        }
        this.dateTimeFormatters = () -> formatters;
    }

    public MultiFormatDateFromStringLineExtractor(LineExtractor<String> extractor, Supplier<List<DateTimeFormatter>> dateTimeFormatters) {
        this.extractor = extractor;
        this.dateTimeFormatters = dateTimeFormatters;
    }

    @Override
    public ReadablePartial extract(String[] row) {
        String date = Strings.emptyToNull((String)this.extractor.extract((String)row));
        if (date != null) {
            List<DateTimeFormatter> formatters = this.dateTimeFormatters.get();
            for (int i = 0; i < formatters.size(); ++i) {
                try {
                    return formatters.get(i).parseLocalDate(date);
                }
                catch (IllegalArgumentException e) {
                    if (i != formatters.size() - 1) continue;
                    throw new DateParseException(e);
                }
            }
        }
        return null;
    }
}

