/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.util.BKTree;
import com.scythebill.birdlist.model.util.Metrics;
import com.scythebill.birdlist.model.util.Trie;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class LocationShortcuts {
    private final Multimap<String, Location> countriesByCode = TreeMultimap.create(Ordering.natural(), PREFERRED_PARENT_ORDERING);
    private final Multimap<String, Location> allLocations = LinkedHashMultimap.create();
    private final Table<String, String, Location> statesByCode = HashBasedTable.create();
    private final Table<String, String, Location> statesByName = TreeBasedTable.create(Ordering.natural(), String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Location> locationsByCode = Maps.newHashMap();
    private final ImmutableMultimap<String, String> ALTERNATE_NAMES = ImmutableMultimap.builder().putAll("AO-CAB", "Cabinda").putAll("BA", (String[])new String[]{"Bosnia"}).putAll("BQ", (String[])new String[]{"Bonaire, Sint Eustatius and Saba", "Netherlands Antilles"}).putAll("CD", (String[])new String[]{"Democratic Republic of Congo (Zaire)"}).putAll("CG", (String[])new String[]{"Peoples Republic of Congo"}).putAll("CI", (String[])new String[]{"C\u00f4te d'Ivoire"}).putAll("CW", (String[])new String[]{"Cura\u00e7ao"}).putAll("CZ", (String[])new String[]{"Czechia"}).putAll("CY", (String[])new String[]{"Northern Cyprus"}).putAll("GB", (String[])new String[]{"Great Britain"}).putAll("FM", (String[])new String[]{"Federated States of Micronesia"}).putAll("GM", (String[])new String[]{"The Gambia"}).putAll("GS", (String[])new String[]{"South Georgia", "South Sandwich Islands"}).putAll("HM", (String[])new String[]{"Heard Island"}).putAll("IT-88", (String[])new String[]{"Sardinia"}).putAll("IT-82", (String[])new String[]{"Sicily"}).putAll("MF", (String[])new String[]{"Saint-Martin"}).putAll("MK", (String[])new String[]{"Macedonia"}).putAll("MP", (String[])new String[]{"Commonwealth of the Northern Mariana Islands"}).putAll("MV", (String[])new String[]{"Maldive Islands"}).putAll("MY-12", (String[])new String[]{"Borneo"}).putAll("PM", (String[])new String[]{"Saint Pierre and Miquelon"}).putAll("PS", (String[])new String[]{"Palestine"}).putAll("RU", (String[])new String[]{"Russian Federation"}).putAll("SJ", (String[])new String[]{"Spitzbergen"}).putAll("SX", (String[])new String[]{"Sint Maarten"}).putAll("TF", (String[])new String[]{"French Southern Territories"}).putAll("TL", (String[])new String[]{"Timor-Leste"}).putAll("US", (String[])new String[]{"United States of America"}).putAll("VC", (String[])new String[]{"St Vincent & Grenadines"}).putAll("VI", (String[])new String[]{"United States Virgin Islands"}).putAll("WS", (String[])new String[]{"Western Samoa"}).build();
    private final ImmutableSet<String> LOCATION_CODES_SOMETIMES_CALLED_COUNTRIES = ImmutableSet.of("SH-AC", "SH-SH", "SH-TA", "GB-ENG", "GB-NIR", "GB-SCT", new String[]{"GB-WLS", "UM-71", "UM-79", "MY-12", "MY-13"});
    private final ImmutableMap<String, String> KNOWN_LOCATIONS_WITH_PARENT_CODES = ImmutableMap.builder().put("Novaya Zemlya", "RU-ARK").put("Franz Josef Land", "RU-ARK").put("South Shetland Islands", "AQ").put("South Orkney Islands", "AQ").put("Amsterdam Island", "TF").put("Kerguelen Island", "TF").put("Crozet Islands", "TF").put("Aru Islands", "ID-MA").put("Kermadec Islands", "NZ-NTL").build();
    private final ImmutableMap<String, String> KNOWN_LOCATIONS_WITH_PARENT_REGIONS = ImmutableMap.builder().put("Southern Caribbean Islands", "West Indies").put("Lesser Antilles", "West Indies").put("Virgin Islands", "West Indies").put("Anguilla, St Martin & St Barth\u00e9l\u00e9my", "West Indies").put("Channel Islands", "Europe").put("Mascarene Islands", "Indian Ocean").build();
    private static final ImmutableMap<String, String> PREFERRED_PARENTS = ImmutableMap.of("United States", "North America", "Egypt", "Africa", "Turkey", "Asia", "Indonesia", "Asia");
    private static final Ordering<Location> PREFERRED_PARENT_ORDERING = new Ordering<Location>(){

        @Override
        public int compare(Location left, Location right) {
            String preferredParent = PREFERRED_PARENTS.get(left.getModelName());
            if (preferredParent != null) {
                if (preferredParent.equals(left.getParent().getModelName())) {
                    return -1;
                }
                if (preferredParent.equals(right.getParent().getModelName())) {
                    return 1;
                }
            }
            return left.getParent().getModelName().compareTo(right.getParent().getModelName());
        }
    };
    private final Multimap<String, Location> exactCountryNames = TreeMultimap.create(Ordering.natural(), PREFERRED_PARENT_ORDERING);
    private final BKTree<String, Location> countryNames;
    private final BKTree<String, Location> regionNames;
    private final PredefinedLocations predefinedLocations;
    private int maxDistance = 3;
    private LocationSet locations;
    private static final Function<String, String> NORMALIZE_NAMES = s -> s == null ? null : LocationShortcuts.normalizeLocationNames(Trie.normalizeString(s.toLowerCase()));
    private static final ImmutableList<String> TRANSLATED_LOCATION_NAMES = ImmutableList.of("de", "fr", "nl");
    private static final ImmutableMultimap<String, String> CODE_TO_TRANSLATED_COUNTRY_NAMES = LocationShortcuts.buildCodeToTranslatedCountryNames();

    public LocationShortcuts(LocationSet locations, PredefinedLocations predefinedLocations) {
        this.locations = locations;
        this.predefinedLocations = predefinedLocations;
        BKTree.Builder<String, Location> countryNames = BKTree.builder(Metrics.levenshteinDistance()).withTransform(NORMALIZE_NAMES);
        BKTree.Builder<String, Location> regionNames = BKTree.builder(Metrics.levenshteinDistance()).withTransform(NORMALIZE_NAMES);
        this.buildMaps(locations.rootLocations(), countryNames, regionNames);
        for (String key : this.ALTERNATE_NAMES.keySet()) {
            Location location = this.getLocationFromEBirdCode(key);
            if (location == null) continue;
            for (String name : this.ALTERNATE_NAMES.get((Object)key)) {
                countryNames.add(name, location);
            }
        }
        this.countryNames = countryNames.build();
        this.regionNames = regionNames.build();
    }

    private static String normalizeLocationNames(String s) {
        return s.replace("saint", "st").replace("&", "and");
    }

    private static ImmutableMultimap<String, String> buildCodeToTranslatedCountryNames() {
        ImmutableMultimap.Builder<String, String> codeToNamesBuilder = ImmutableMultimap.builder();
        for (String locale : TRANSLATED_LOCATION_NAMES) {
            CharSource source = Resources.asCharSource(Resources.getResource(LocationShortcuts.class, String.format("imported-countries-%s.csv", locale)), StandardCharsets.UTF_8);
            try {
                BufferedReader reader = source.openBufferedStream();
                try {
                    String[] line;
                    ImportLines lines = CsvImportLines.fromReader(reader);
                    while ((line = lines.nextLine()) != null) {
                        if (line.length == 0) continue;
                        if (line.length != 2) {
                            throw new AssertionError((Object)("Unexpected line: " + Arrays.asList(line)));
                        }
                        codeToNamesBuilder.put(line[1].trim(), line[0].trim());
                    }
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return codeToNamesBuilder.build();
    }

    private void buildMaps(Iterable<Location> collection, BKTree.Builder<String, Location> countryNames, BKTree.Builder<String, Location> regionNames) {
        for (Location location : collection) {
            boolean hasDifferentDisplayName = !location.getModelName().equals(location.getDisplayName());
            this.allLocations.put(location.getModelName(), location);
            if (hasDifferentDisplayName) {
                this.allLocations.put(location.getDisplayName(), location);
            }
            String locationCode = Locations.getLocationCode(location);
            if (location.getType() == Location.Type.country || this.LOCATION_CODES_SOMETIMES_CALLED_COUNTRIES.contains(Locations.getLocationCode(location))) {
                countryNames.add(location.getModelName(), location);
                this.exactCountryNames.put(location.getModelName(), location);
                if (hasDifferentDisplayName) {
                    countryNames.add(location.getDisplayName(), location);
                    this.exactCountryNames.put(location.getDisplayName(), location);
                }
                if (locationCode != null) {
                    this.locationsByCode.put(locationCode, location);
                }
                if (location.getEbirdCode() != null) {
                    this.countriesByCode.put(location.getEbirdCode(), location);
                }
                for (String name : CODE_TO_TRANSLATED_COUNTRY_NAMES.get((Object)locationCode)) {
                    this.exactCountryNames.put(name, location);
                    this.allLocations.put(name, location);
                }
            } else if (locationCode != null) {
                this.locationsByCode.put(locationCode, location);
                for (String name : CODE_TO_TRANSLATED_COUNTRY_NAMES.get((Object)locationCode)) {
                    this.allLocations.put(name, location);
                }
            }
            if (this.isStateOrCountryInCountry(location) && location.getEbirdCode() != null && location.getParent().getEbirdCode() != null) {
                this.statesByCode.put(Locations.getLocationCode(location.getParent()), locationCode, location);
                this.statesByName.put(location.getParent().getEbirdCode(), location.getModelName(), location);
                if (hasDifferentDisplayName) {
                    this.statesByName.put(location.getParent().getEbirdCode(), location.getDisplayName(), location);
                }
            }
            if (location.getType() == Location.Type.region && location.isBuiltInLocation()) {
                regionNames.add(location.getModelName(), location);
                if (hasDifferentDisplayName) {
                    regionNames.add(location.getDisplayName(), location);
                }
            }
            ArrayList<Location> extraPredefinedLocations = Lists.newArrayList();
            for (PredefinedLocations.PredefinedLocation predefinedLocation : this.predefinedLocations.getPredefinedLocations(location)) {
                if (this.locations.getLocationByCode(predefinedLocation.getCode()) != null) continue;
                Location notYetAdded = predefinedLocation.create(this.locations, location);
                if (notYetAdded.getId() != null) {
                    this.locationsByCode.put(Locations.getLocationCode(notYetAdded), notYetAdded);
                    continue;
                }
                extraPredefinedLocations.add(notYetAdded);
            }
            this.buildMaps(Iterables.concat(location.contents(), extraPredefinedLocations), countryNames, regionNames);
        }
    }

    private boolean isStateOrCountryInCountry(Location location) {
        if (location.getType() == Location.Type.state) {
            return true;
        }
        return location.getType() == Location.Type.country && location.getParent() != null && location.getParent().getType() == Location.Type.country;
    }

    public Location getCountryFromCodeWithExpectedChild(String countryCode, @Nullable String expectedChild) {
        return this.replaceWithCreated(this.chooseByExpectedChild(this.countriesByCode.get(countryCode), expectedChild));
    }

    public Location getCountryFromCodeWithExpectedParent(String countryCode, @Nullable String expectedParent) {
        return this.replaceWithCreated(this.chooseByExpectedParent(this.countriesByCode.get(countryCode), expectedParent));
    }

    public Location getLocationFromEBirdCode(String code) {
        return this.replaceWithCreated(this.locationsByCode.get(code));
    }

    public Location getStateByCode(String countryCode, String stateCode) {
        return this.replaceWithCreated(this.statesByCode.get(countryCode, stateCode));
    }

    public Location getStateByName(String countryCode, String stateName) {
        return this.replaceWithCreated(this.statesByName.get(countryCode, stateName));
    }

    public Location getRegion(String regionName) {
        return this.replaceWithCreated(this.searchAtGrowingDistances(this.regionNames, regionName));
    }

    public Collection<Location> getAnyLocationFromName(String name) {
        return this.allLocations.get(name);
    }

    public Location getCountryExactMatch(String country, @Nullable Location optionalRegion, @Nullable String expectedChild) {
        Location countryInRegion;
        if (optionalRegion != null && (countryInRegion = optionalRegion.getContent(country)) != null) {
            return countryInRegion;
        }
        return this.chooseByExpectedChild(this.exactCountryNames.get(country), expectedChild);
    }

    public Location getCountryInexactMatch(String country, @Nullable Location optionalRegion, @Nullable String expectedChild) {
        Location exactMatchWithChild;
        Location location = this.searchAtGrowingDistances(this.countryNames, country);
        if (location == null) {
            return null;
        }
        if (optionalRegion != null) {
            Location countryInRegion = optionalRegion.getContent(location.getModelName());
            if (countryInRegion != null) {
                location = countryInRegion;
            }
            return location;
        }
        if (expectedChild != null && !this.hasExpectedChild(location, expectedChild) && (exactMatchWithChild = this.getCountryExactMatch(location.getModelName(), optionalRegion, expectedChild)) != null) {
            location = exactMatchWithChild;
        }
        return location;
    }

    public Location getCountryNotEvenBuiltInState(String name) {
        String code = this.KNOWN_LOCATIONS_WITH_PARENT_CODES.get(name);
        if (code != null) {
            Location location = this.getLocationFromEBirdCode(code);
            Preconditions.checkNotNull(location, "Expected location with code %s for %s", (Object)code, (Object)name);
            Location content = location.getContent(name);
            if (content != null) {
                return content;
            }
            return Location.builder().setName(name).setParent(location).build();
        }
        String regionName = this.KNOWN_LOCATIONS_WITH_PARENT_REGIONS.get(name);
        if (regionName != null) {
            Location region = this.getRegion(regionName);
            Preconditions.checkNotNull(region, "Expected region with name %s for %s", (Object)regionName, (Object)name);
            Location content = region.getContent(name);
            if (content != null) {
                return content;
            }
            return Location.builder().setName(name).setParent(region).build();
        }
        return null;
    }

    private Location searchAtGrowingDistances(BKTree<String, Location> tree, String name) {
        int maxDistanceForName = this.maxDistanceForName(name);
        for (int i = 0; i < maxDistanceForName; ++i) {
            List<Location> list = tree.search(name, i);
            if (list.isEmpty()) continue;
            return list.get(0);
        }
        return null;
    }

    private int maxDistanceForName(String name) {
        return Math.min((name.length() - 1) / 2, this.maxDistance);
    }

    public void setMaxDistance(int maxDistance) {
        this.maxDistance = maxDistance;
    }

    private Location chooseByExpectedChild(Collection<Location> collection, @Nullable String expectedChild) {
        if (collection.isEmpty()) {
            return null;
        }
        if (collection.size() > 1 && expectedChild != null) {
            for (Location location : collection) {
                if (!this.hasExpectedChild(location, expectedChild)) continue;
                return location;
            }
        }
        return collection.iterator().next();
    }

    private Location chooseByExpectedParent(Collection<Location> collection, @Nullable String expectedParent) {
        if (collection.isEmpty()) {
            return null;
        }
        if (collection.size() > 1 && expectedParent != null) {
            for (Location location : collection) {
                if (location.getParent() == null || !location.getParent().getModelName().equals(expectedParent) && !location.getParent().getDisplayName().equals(expectedParent)) continue;
                return location;
            }
        }
        return collection.iterator().next();
    }

    private boolean hasExpectedChild(Location location, String expectedChild) {
        if (location.getContent(expectedChild) != null) {
            return true;
        }
        return this.predefinedLocations.getPredefinedLocationChild(location, expectedChild) != null;
    }

    private Location replaceWithCreated(Location location) {
        Location existingChild;
        Location newParent;
        if (location == null || location.getId() != null || location.getParent() == null) {
            return location;
        }
        Location oldParent = location.getParent();
        if (oldParent != (newParent = this.replaceWithCreated(oldParent))) {
            location = location.asBuilder().setParent(newParent).build();
        }
        return (existingChild = newParent.getContent(location.getModelName())) == null ? location : existingChild;
    }
}

