/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.scythebill.birdlist.ui.imports.LineExtractor;
import com.scythebill.birdlist.ui.imports.RowExtractor;

public class LineExtractors {
    private static final CharMatcher DIGIT_OR_PERIOD = CharMatcher.inRange('0', '9').or(CharMatcher.is('.'));

    public static LineExtractor<String> stringFromIndex(int index) {
        return new DirectStringExtractor(index);
    }

    public static LineExtractor<String> nullIfEmpty(LineExtractor<String> stringExtractor) {
        return line -> Strings.emptyToNull((String)stringExtractor.extract((String)line));
    }

    public static LineExtractor<Integer> intFromIndex(int index) {
        return new DirectIntegerExtractor(index);
    }

    public static LineExtractor<Boolean> booleanFromIndex(int index) {
        return new DirectBooleanExtractor(index);
    }

    public static LineExtractor<Float> floatFromIndex(int index) {
        return new DirectFloatExtractor(index);
    }

    public static <T> LineExtractor<T> alwaysNull() {
        return line -> null;
    }

    public static LineExtractor<String> joined(Joiner joiner, RowExtractor<String[], String> first, RowExtractor<String[], String> second) {
        return line -> joiner.join(first.extract((String[])line), second.extract((String[])line), new Object[0]);
    }

    @SafeVarargs
    public static LineExtractor<String> joined(final Joiner joiner, final RowExtractor<String[], String> ... extractors) {
        return new LineExtractor<String>(){

            @Override
            public String extract(String[] line) {
                Object[] parameters = new Object[extractors.length];
                for (int i = 0; i < extractors.length; ++i) {
                    parameters[i] = extractors[i].extract(line);
                }
                return joiner.join(parameters);
            }
        };
    }

    @SafeVarargs
    public static LineExtractor<String> firstNonEmpty(final RowExtractor<String[], String> ... extractors) {
        return new LineExtractor<String>(){

            @Override
            public String extract(String[] line) {
                for (int i = 0; i < extractors.length; ++i) {
                    String s = (String)extractors[i].extract(line);
                    if (Strings.isNullOrEmpty(s)) continue;
                    return s;
                }
                return null;
            }
        };
    }

    public static LineExtractor<String> joined(final Joiner joiner, Iterable<RowExtractor<String[], String>> extractors) {
        final ImmutableList<RowExtractor<String[], String>> extractorsList = ImmutableList.copyOf(extractors);
        return new LineExtractor<String>(){

            @Override
            public String extract(String[] line) {
                Object[] parameters = new Object[extractorsList.size()];
                int i = 0;
                for (RowExtractor extractor : extractorsList) {
                    parameters[i++] = extractor.extract(line);
                }
                return joiner.join(parameters);
            }
        };
    }

    public static <T> LineExtractor<T> constant(final T value) {
        return new LineExtractor<T>(){

            @Override
            public T extract(String[] line) {
                return value;
            }
        };
    }

    public static LineExtractor<String> appendingLatitudeAndLongitude(final LineExtractor<String> primaryText, final LineExtractor<String> latitudeExtractor, final LineExtractor<String> longitudeExtractor) {
        return new LineExtractor<String>(){

            @Override
            public String extract(String[] line) {
                Object description = (String)primaryText.extract(line);
                if (description == null) {
                    description = "";
                }
                String latitude = (String)latitudeExtractor.extract(line);
                String longitude = (String)longitudeExtractor.extract(line);
                if (!Strings.isNullOrEmpty(latitude) && !Strings.isNullOrEmpty(longitude)) {
                    String latLong = String.format(((String)description).isEmpty() ? "LL:%s,%s" : "\nLL:%s,%s", LineExtractors.trimOverlyPreciseLatOrLong(latitude), LineExtractors.trimOverlyPreciseLatOrLong(longitude));
                    description = (String)description + latLong;
                }
                return description;
            }
        };
    }

    private static String trimOverlyPreciseLatOrLong(String latOrLong) {
        int decimalIndex = latOrLong.indexOf(46);
        if (decimalIndex < 0) {
            return latOrLong;
        }
        if (decimalIndex + 7 >= latOrLong.length()) {
            return latOrLong;
        }
        return latOrLong.substring(0, decimalIndex + 7);
    }

    static class DirectStringExtractor
    implements LineExtractor<String> {
        private final int index;

        DirectStringExtractor(int index) {
            this.index = index;
        }

        @Override
        public String extract(String[] line) {
            if (line.length <= this.index) {
                return null;
            }
            return CharMatcher.whitespace().trimFrom(line[this.index]);
        }
    }

    static class DirectIntegerExtractor
    implements LineExtractor<Integer> {
        private final int index;

        DirectIntegerExtractor(int index) {
            this.index = index;
        }

        @Override
        public Integer extract(String[] line) {
            if (line.length <= this.index) {
                return null;
            }
            String entry = CharMatcher.whitespace().trimFrom(line[this.index]);
            entry = CharMatcher.inRange('0', '9').negate().trimFrom(entry);
            if (entry.isEmpty()) {
                return null;
            }
            if ("X".equalsIgnoreCase(entry)) {
                return null;
            }
            return Ints.tryParse(entry);
        }
    }

    static class DirectBooleanExtractor
    implements LineExtractor<Boolean> {
        private final int index;
        private static final ImmutableSet<String> TRUE_SET = ImmutableSet.of("Y", "y", "T", "t", "TRUE", "True", new String[]{"true", "1"});

        DirectBooleanExtractor(int index) {
            this.index = index;
        }

        @Override
        public Boolean extract(String[] line) {
            if (line.length <= this.index) {
                return false;
            }
            String text = CharMatcher.whitespace().trimFrom(line[this.index]);
            return TRUE_SET.contains(text);
        }
    }

    static class DirectFloatExtractor
    implements LineExtractor<Float> {
        private final int index;

        DirectFloatExtractor(int index) {
            this.index = index;
        }

        @Override
        public Float extract(String[] line) {
            if (line.length <= this.index) {
                return null;
            }
            String entry = DIGIT_OR_PERIOD.retainFrom(line[this.index]);
            if (entry.isEmpty()) {
                return null;
            }
            return Floats.tryParse(entry);
        }
    }
}

