/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.mapdata.MapData;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.ui.imports.LocationShortcuts;
import java.util.List;
import java.util.logging.Logger;

public class ImportedLocation {
    private static final Logger logger = Logger.getLogger(ImportedLocation.class.getName());
    public String countryCode;
    public String country;
    public String stateCode;
    public String state;
    public String county;
    public List<String> locationNames = Lists.newArrayList();
    public String city;
    public String region;
    public String defaultRegion = "North America";
    public String latitude;
    public String longitude;
    public String description;

    public String addToLocationSet(ReportSet reportSet, LocationSet locations, LocationShortcuts locationShortcuts, PredefinedLocations predefinedLocations) {
        LatLongCoordinates latLong;
        Location canaryIslands;
        Location galapagos;
        Location falklands;
        Object current = null;
        if ("usa".equalsIgnoreCase(this.country) || "us".equalsIgnoreCase(this.country)) {
            this.countryCode = "US";
        }
        if ("uk".equalsIgnoreCase(this.country)) {
            this.countryCode = "GB";
            this.country = null;
        }
        if (this.country != null && this.country.length() == 2 && this.countryCode == null) {
            this.countryCode = this.country;
            this.country = null;
        }
        if (this.state != null && this.state.length() >= 1 && this.state.length() <= 3 && this.stateCode == null) {
            this.stateCode = this.state;
        }
        if (Strings.isNullOrEmpty(this.countryCode) && (Strings.isNullOrEmpty(this.country) || locationShortcuts.getCountryExactMatch(this.country, null, null) == null && locationShortcuts.getCountryInexactMatch(this.country, null, null) == null && locationShortcuts.getCountryNotEvenBuiltInState(this.country) == null)) {
            this.setCodesUsingLatLong();
        }
        if (!Strings.isNullOrEmpty(this.countryCode)) {
            String countryCodeIncludingState;
            Location countryIncludingState;
            if (this.state != null) {
                current = locationShortcuts.getCountryFromCodeWithExpectedChild(this.countryCode, this.state);
            } else {
                String regionForCountryCodeLookup = this.region != null ? this.region : this.defaultRegion;
                current = locationShortcuts.getCountryFromCodeWithExpectedParent(this.countryCode, regionForCountryCodeLookup);
            }
            if (!Strings.isNullOrEmpty(this.stateCode) && (countryIncludingState = locationShortcuts.getLocationFromEBirdCode(countryCodeIncludingState = this.countryCode + "-" + this.stateCode)) != null) {
                current = countryIncludingState;
                this.state = null;
                this.stateCode = null;
            }
            if (current == null && this.country == null) {
                this.country = this.countryCode;
            }
        }
        if (current == null) {
            if (!Strings.isNullOrEmpty(this.country)) {
                Location regionLoc = null;
                if (this.region != null) {
                    regionLoc = locationShortcuts.getRegion(this.region);
                }
                if ((current = locationShortcuts.getCountryExactMatch(this.country, regionLoc, this.state)) == null) {
                    current = locationShortcuts.getCountryInexactMatch(this.country, regionLoc, this.state);
                }
                if (current == null) {
                    current = locationShortcuts.getCountryNotEvenBuiltInState(this.country);
                }
                if (current == null) {
                    if (regionLoc == null) {
                        regionLoc = locationShortcuts.getRegion(this.defaultRegion);
                    }
                    current = Location.builder().setName(this.country).setType(Location.Type.country).setParent(regionLoc).build();
                    current = this.addLocationIfNecessary(locations, predefinedLocations, (Location)current);
                } else if (((Location)current).getEbirdCode() != null) {
                    this.countryCode = ((Location)current).getEbirdCode();
                }
            } else if (!Strings.isNullOrEmpty(this.region)) {
                current = locationShortcuts.getRegion(this.region);
                if (current == null) {
                    throw new IllegalStateException("Couldn't find region " + this.region);
                }
            } else {
                return null;
            }
        }
        if (current != null && "GB".equals(((Location)current).getEbirdCode()) && "Falkland Islands".equals(this.state) && (falklands = locations.getLocationByCode("FK")) != null) {
            current = falklands;
            this.state = null;
            this.stateCode = null;
        }
        if (current != null && "EC".equals(((Location)current).getEbirdCode()) && this.state != null && (this.state.contains("Galapagos") || this.state.contains("Gal\u00e1pagos")) && (galapagos = locations.getLocationByCode("EC-W")) != null) {
            current = galapagos;
            this.state = null;
            this.stateCode = null;
        }
        if (current != null && "ES".equals(((Location)current).getEbirdCode()) && this.state != null && (this.state.contains("Canary") || this.state.contains("Canarias")) && (canaryIslands = locations.getLocationByCode("ES-CN")) != null) {
            current = canaryIslands;
            this.state = null;
            this.stateCode = null;
        }
        if (!Strings.isNullOrEmpty(this.stateCode) || !Strings.isNullOrEmpty(this.state)) {
            Location stateLoc = null;
            if (this.stateCode != null && this.countryCode != null && (stateLoc = locationShortcuts.getStateByCode(this.countryCode, this.countryCode + "-" + this.stateCode)) != null) {
                stateLoc = this.addLocationIfNecessary(locations, predefinedLocations, stateLoc);
            }
            if (stateLoc == null) {
                String stateName = MoreObjects.firstNonNull(this.state, this.stateCode);
                if ("ID".equals(((Location)current).getEbirdCode()) && stateName != null) {
                    if (stateName.contains("Papua") || stateName.contains("Geelvink") || stateName.contains("Irian Jaya")) {
                        australasianIndonesia = locationShortcuts.getCountryFromCodeWithExpectedParent("ID", "Australasia");
                        if (australasianIndonesia != null) {
                            current = australasianIndonesia;
                        }
                        if (!stateName.equals("Papua") && !stateName.equals("Irian Jaya")) {
                            this.locationNames.add(0, stateName);
                        }
                        stateName = "Papua";
                    } else if (stateName.contains("Halmahera") || stateName.contains("Timor") || stateName.contains("Seram") || stateName.contains("Molucca")) {
                        australasianIndonesia = locationShortcuts.getCountryFromCodeWithExpectedParent("ID", "Australasia");
                        if (australasianIndonesia != null) {
                            current = australasianIndonesia;
                        }
                        if (!stateName.equals("Moluccas") && !stateName.equals("Molucca")) {
                            this.locationNames.add(0, stateName);
                        }
                        stateName = "Maluku";
                    } else if (stateName.equals("Java")) {
                        stateName = "Jawa";
                    } else if (stateName.equals("Sumatra")) {
                        stateName = "Sumatera";
                    } else if (stateName.equals("Bali")) {
                        stateName = "Nusa Tenggara";
                        this.locationNames.add(0, "Bali");
                    }
                }
                if ((stateLoc = ((Location)current).getContent(stateName)) == null) {
                    Location.Builder stateLocBuilder = Location.builder().setParent((Location)current).setName(stateName).setType(Location.Type.state);
                    stateLoc = this.addLocationIfNecessary(locations, predefinedLocations, stateLocBuilder.build());
                }
            }
            current = stateLoc;
        }
        if (!Strings.isNullOrEmpty(this.county)) {
            if (this.county.endsWith(" Co")) {
                originalCounty = this.county;
                this.county = this.county.substring(0, this.county.length() - 3);
                if (!this.locationNames.isEmpty() && originalCounty.equals(this.locationNames.get(0))) {
                    this.locationNames.remove(0);
                }
            } else if (this.county.endsWith(" County")) {
                originalCounty = this.county;
                this.county = this.county.substring(0, this.county.length() - " County".length());
                if (!this.locationNames.isEmpty() && originalCounty.equals(this.locationNames.get(0))) {
                    this.locationNames.remove(0);
                }
            } else if (this.county.contains(" (County")) {
                originalCounty = this.county;
                int index = this.county.indexOf(" (County");
                this.county = this.county.substring(0, index);
                if (!this.locationNames.isEmpty() && originalCounty.equals(this.locationNames.get(0))) {
                    this.locationNames.remove(0);
                }
            }
            Location countyLoc = ((Location)current).getContent(this.county);
            if (countyLoc == null) {
                countyLoc = Location.builder().setParent((Location)current).setName(this.county).setType(Location.Type.county).build();
                countyLoc = this.addLocationIfNecessary(locations, predefinedLocations, countyLoc);
            }
            current = countyLoc;
        }
        if (!Strings.isNullOrEmpty(this.city)) {
            Object cityLoc = ((Location)current).getContent(this.city);
            if (cityLoc == null) {
                cityLoc = Location.builder().setParent((Location)current).setName(this.city).setType(Location.Type.city).build();
                cityLoc = this.addLocationIfNecessary(locations, predefinedLocations, (Location)cityLoc);
            }
            current = cityLoc;
        }
        for (String locationName : this.locationNames) {
            if (Strings.isNullOrEmpty(locationName) || locationName.equals(((Location)current).getModelName())) continue;
            Location location = ((Location)current).getContent(locationName);
            if (location == null) {
                Location groupedLocationParent = this.getGroupedLocationParent((Location)current, locationName);
                if (groupedLocationParent != null) {
                    current = groupedLocationParent;
                    location = ((Location)current).getContent(locationName);
                }
                if (location == null) {
                    location = Location.builder().setParent((Location)current).setName(locationName).build();
                    location = this.addLocationIfNecessary(locations, predefinedLocations, location);
                }
            }
            current = location;
        }
        locations.ensureAdded((Location)current);
        if (!((Location)current).isBuiltInLocation() && (latLong = this.getLatLong()) != null) {
            Location withLatLong = ((Location)current).asBuilder().setLatLong(latLong).build();
            reportSet.replaceLocation((Location)current, withLatLong);
            current = withLatLong;
        }
        if (!Strings.isNullOrEmpty(this.description) && !((Location)current).isBuiltInLocation()) {
            Location withDescription = ((Location)current).asBuilder().setDescription(this.description).build();
            reportSet.replaceLocation((Location)current, withDescription);
            current = withDescription;
        }
        return ((Location)current).getId();
    }

    private Location getGroupedLocationParent(Location current, String locationName) {
        String groupedLocationPrefix = Locations.getGroupedLocationPrefix(locationName);
        if (groupedLocationPrefix == null) {
            return null;
        }
        return this.findChildMatchingName(current, groupedLocationPrefix);
    }

    public String tryAddToLocationSetWithLatLong(ReportSet reportSet, LocationSet locations, LocationShortcuts locationShortcuts, PredefinedLocations predefinedLocations) {
        if (this.locationNames.isEmpty()) {
            return null;
        }
        if (!this.setCodesUsingLatLong()) {
            return null;
        }
        return this.addToLocationSet(reportSet, locations, locationShortcuts, predefinedLocations);
    }

    private boolean setCodesUsingLatLong() {
        LatLongCoordinates latLong = this.getLatLong();
        if (latLong == null) {
            return false;
        }
        String eBirdCode = MapData.instance().getISOCode(latLong);
        if (eBirdCode == null) {
            return false;
        }
        List<String> codeList = Splitter.on('-').splitToList(eBirdCode);
        if (codeList.isEmpty()) {
            return false;
        }
        this.countryCode = codeList.get(0);
        if (codeList.size() > 1) {
            this.stateCode = codeList.get(1);
        }
        return true;
    }

    public LatLongCoordinates getLatLong() {
        if (Strings.isNullOrEmpty(this.longitude) || Strings.isNullOrEmpty(this.latitude)) {
            return null;
        }
        try {
            LatLongCoordinates latLong = LatLongCoordinates.withLatAndLong(this.latitude, this.longitude);
            if (latLong.latitudeAsDouble() == 0.0 && latLong.longitudeAsDouble() == 0.0) {
                return null;
            }
            return latLong;
        }
        catch (IllegalArgumentException e) {
            logger.warning(String.format("Could not parse lat/long: %s/%s", this.latitude, this.longitude));
            return null;
        }
    }

    private Location addLocationIfNecessary(LocationSet locations, PredefinedLocations predefinedLocations, Location newLocation) {
        locations.ensureAdded(newLocation.getParent());
        Location foundChild = this.findChildMatchingName(newLocation.getParent(), newLocation.getModelName());
        if (foundChild != null) {
            return foundChild;
        }
        PredefinedLocations.PredefinedLocation predefinedLocation = predefinedLocations.getPredefinedLocationChildThatHasNotBeenCreatedYet(locations, newLocation.getParent(), newLocation.getModelName());
        if (predefinedLocation != null) {
            Location fromPredefined = predefinedLocation.create(locations, newLocation.getParent());
            locations.ensureAdded(fromPredefined);
            return fromPredefined;
        }
        locations.addLocation(newLocation);
        return newLocation;
    }

    private Location findChildMatchingName(Location location, String name) {
        for (Location child : location.contents()) {
            if (child.getModelName().equals(name) || child.getDisplayName().equals(name)) {
                return child;
            }
            Location foundChild = this.findChildMatchingName(child, name);
            if (foundChild == null) continue;
            return foundChild;
        }
        return null;
    }
}

