/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.actions.ReturnAction;
import com.scythebill.birdlist.ui.components.SpeciesIndexerPanelConfigurer;
import com.scythebill.birdlist.ui.events.EventBusRegistrar;
import com.scythebill.birdlist.ui.events.TaxonomyChangedEvent;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.imports.SightingsImporter;
import com.scythebill.birdlist.ui.imports.TaxonImporter;
import com.scythebill.birdlist.ui.imports.TaxonPossibilities;
import com.scythebill.birdlist.ui.imports.TaxonResolver;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.SpeciesSpHybridEntryPanel;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

class ImportResolveTaxaPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private JButton cancel;
    private JButton back;
    private JButton dropSpecies;
    private Taxonomy taxonomy;
    private List<TbdNoSsp> keys;
    private int index;
    private JLabel commonName;
    private JLabel scientificName;
    private JScrollPane descriptionScrollPane;
    private JTextArea description;
    private Map<Object, TaxonImporter.ToBeDecided> toBeDecidedMap;
    private TbdNoSsp toBeDecided;
    private SightingsImporter<?> importer;
    private Runnable onFinished;
    private Multimap<TbdNoSsp, Object> tbdNoSspToKeys;
    private SpeciesSpHybridEntryPanel speciesEntry;
    private JButton ok;
    private JLabel commonLabel;
    private JLabel scientificLabel;
    private JLabel descriptionLabel;
    private JSeparator separator;
    private JLabel topLabel;
    private TaxonResolver taxonResolver;

    @Inject
    public ImportResolveTaxaPanel(TaxonomyStore taxonomyStore, SpeciesIndexerPanelConfigurer speciesIndexerPanelConfigurer, EventBusRegistrar eventBusRegistrar, ReturnAction returnAction, SpeciesSpHybridEntryPanel speciesEntry, FontManager fontManager) {
        this.speciesEntry = speciesEntry;
        this.initGUI();
        fontManager.applyTo(this);
        eventBusRegistrar.registerWhenInHierarchy(this);
        this.setTaxonomy(taxonomyStore.getTaxonomy());
        this.cancel.addActionListener(returnAction);
        speciesEntry.setInPanelAddButtonVisibility(false);
        this.ok.setAction(speciesEntry.getAddAction());
        this.ok.setText(Messages.getMessage(Messages.Name.OK_BUTTON));
        speciesEntry.addSpeciesEntryListener(new SpeciesSpHybridEntryPanel.SpeciesEntryListener(){

            @Override
            public void addSpecies(SpeciesSpHybridEntryPanel.SpeciesEntryEvent event) {
                SightingTaxon species = event.getResolved().getSightingTaxon();
                Collection<Object> taxonKeys = ImportResolveTaxaPanel.this.tbdNoSspToKeys.get(ImportResolveTaxaPanel.this.keys.get(ImportResolveTaxaPanel.this.index));
                for (Object taxonKey : taxonKeys) {
                    SightingTaxon withSubspecies = ImportResolveTaxaPanel.this.resolveSubspecies(ImportResolveTaxaPanel.this.toBeDecidedMap.get(taxonKey), species);
                    SightingTaxon mappedToBase = ImportResolveTaxaPanel.this.mapToBase(withSubspecies);
                    ImportResolveTaxaPanel.this.importer.registerTaxon(taxonKey, new TaxonPossibilities(mappedToBase));
                }
                ImportResolveTaxaPanel.this.nextSpecies();
            }
        });
        this.back.setEnabled(false);
        this.back.addActionListener(e -> this.previousSpecies());
        this.dropSpecies.addActionListener(e -> this.nextSpecies());
    }

    public void start(Map<Object, TaxonImporter.ToBeDecided> toBeDecided, SightingsImporter<?> importer, Runnable onFinished) {
        this.onFinished = onFinished;
        Preconditions.checkState(!toBeDecided.isEmpty());
        this.tbdNoSspToKeys = LinkedHashMultimap.create();
        for (Map.Entry<Object, TaxonImporter.ToBeDecided> tbdEntry : toBeDecided.entrySet()) {
            this.tbdNoSspToKeys.put(new TbdNoSsp(tbdEntry.getValue()), tbdEntry.getKey());
        }
        this.toBeDecidedMap = toBeDecided;
        this.importer = importer;
        this.keys = Lists.newArrayList(this.tbdNoSspToKeys.keySet());
        this.setIndex(0);
    }

    private void setIndex(int index) {
        this.index = index;
        this.toBeDecided = this.keys.get(index);
        this.commonName.setText(this.toBeDecided.commonName == null ? Messages.getMessage(Messages.Name.NO_COMMON_NAME) : this.toBeDecided.commonName);
        this.scientificName.setText(this.toBeDecided.sciName == null ? Messages.getMessage(Messages.Name.NO_SCIENTIFIC_NAME) : this.toBeDecided.sciName);
        this.description.setText(this.toBeDecided.longText == null ? "" : this.toBeDecided.longText);
        if (this.toBeDecided.longText == null) {
            this.commonLabel.setVisible(true);
            this.commonName.setVisible(true);
            this.scientificLabel.setVisible(true);
            this.scientificName.setVisible(true);
            this.descriptionLabel.setVisible(false);
            this.descriptionScrollPane.setVisible(false);
        } else {
            this.commonLabel.setVisible(this.toBeDecided.commonName != null || this.toBeDecided.sciName != null);
            this.commonName.setVisible(this.toBeDecided.commonName != null || this.toBeDecided.sciName != null);
            this.scientificLabel.setVisible(this.toBeDecided.commonName != null || this.toBeDecided.sciName != null);
            this.scientificName.setVisible(this.toBeDecided.commonName != null || this.toBeDecided.sciName != null);
            this.descriptionLabel.setVisible(true);
            this.descriptionScrollPane.setVisible(true);
        }
        this.speciesEntry.setIndexerLabel(Messages.getFormattedMessage(Messages.Name.RESOLVE_SPECIES_OF_FORMAT, index + 1, this.keys.size()));
        this.speciesEntry.getIndexer().setValue(null);
        this.back.setEnabled(index > 0);
    }

    @Subscribe
    public void taxonomyChanged(TaxonomyChangedEvent event) {
        this.setTaxonomy(event.getTaxonomy());
    }

    private void setTaxonomy(Taxonomy newTaxonomy) {
        if (newTaxonomy == this.taxonomy) {
            return;
        }
        this.taxonomy = newTaxonomy;
        this.speciesEntry.setTaxonomy(newTaxonomy);
        this.taxonResolver = new TaxonResolver(newTaxonomy);
    }

    private void initGUI() {
        this.topLabel = new JLabel(Messages.getMessage(Messages.Name.COULD_NOT_LOCATE_SOME_SPECIES));
        this.topLabel.putClientProperty("birdlist.plainLabel", true);
        this.commonLabel = new JLabel(Messages.getMessage(Messages.Name.IMPORTED_COMMON_NAME_LABEL));
        this.commonName = new JLabel();
        this.commonName.putClientProperty("birdlist.plainLabel", true);
        this.scientificLabel = new JLabel(Messages.getMessage(Messages.Name.IMPORTED_SCIENTIFIC_NAME_LABEL));
        this.scientificName = new JLabel();
        this.scientificName.putClientProperty("birdlist.plainLabel", true);
        this.descriptionLabel = new JLabel(Messages.getMessage(Messages.Name.IMPORTED_DESCRIPTION_LABEL));
        this.description = new JTextArea(5, 60);
        this.description.setWrapStyleWord(true);
        this.description.setLineWrap(true);
        this.description.setEditable(false);
        this.descriptionScrollPane = new JScrollPane(this.description, 20, 31);
        this.separator = new JSeparator();
        this.cancel = new JButton();
        this.cancel.setText(Messages.getMessage(Messages.Name.CANCEL_IMPORT));
        this.dropSpecies = new JButton();
        this.dropSpecies.setText(Messages.getMessage(Messages.Name.DROP_SPECIES));
        this.back = new JButton();
        this.back.setText(Messages.getMessage(Messages.Name.PREVIOUS_BUTTON));
        this.ok = new JButton();
        this.ok.setText(Messages.getMessage(Messages.Name.OK_BUTTON));
    }

    private void nextSpecies() {
        if (this.index + 1 == this.keys.size()) {
            this.onFinished.run();
        } else {
            this.setIndex(this.index + 1);
        }
    }

    private void previousSpecies() {
        if (this.index > 0) {
            this.setIndex(this.index - 1);
        }
    }

    private SightingTaxon resolveSubspecies(TaxonImporter.ToBeDecided toBeDecided, SightingTaxon species) {
        if (Strings.isNullOrEmpty(toBeDecided.subspecies)) {
            return species;
        }
        if (species.getType() != SightingTaxon.Type.SINGLE) {
            return species;
        }
        Taxon speciesTaxon = this.taxonomy.getTaxon(species.getId());
        Taxon subspecies = this.taxonResolver.findMatchWithin(speciesTaxon, toBeDecided.subspecies, false);
        if (subspecies != null) {
            return SightingTaxons.newSightingTaxon(subspecies.getId());
        }
        return species;
    }

    private SightingTaxon mapToBase(SightingTaxon taxon) {
        if (this.taxonomy instanceof MappedTaxonomy) {
            MappedTaxonomy mappedTaxonomy = (MappedTaxonomy)this.taxonomy;
            SightingTaxon mapping = mappedTaxonomy.getMapping(taxon);
            if (mapping == null) {
                taxon = taxon.resolveInternal(this.taxonomy).getParent();
                mapping = mappedTaxonomy.getMapping(taxon);
            }
            return mapping;
        }
        return taxon;
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.setPreferredSize(fontManager.scale(new Dimension(700, 440)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.topLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.commonLabel).addComponent(this.scientificLabel).addComponent(this.descriptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.commonName).addComponent(this.scientificName).addComponent(this.descriptionScrollPane, -2, -2, -2))).addComponent(this.speciesEntry).addComponent(this.separator).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.cancel).addGap(0, fontManager.scale(75), Short.MAX_VALUE).addComponent(this.dropSpecies).addGap(fontManager.scale(20)).addComponent(this.back).addGap(fontManager.scale(20)).addComponent(this.ok)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.topLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.commonLabel).addComponent(this.commonName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.scientificLabel).addComponent(this.scientificName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createBaselineGroup(false, false).addComponent(this.descriptionLabel).addComponent(this.descriptionScrollPane, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.speciesEntry).addGap(18).addComponent(this.separator).addGroup(layout.createBaselineGroup(false, false).addComponent(this.cancel).addComponent(this.dropSpecies).addComponent(this.back).addComponent(this.ok)));
        layout.linkSize(this.commonLabel, this.scientificLabel, this.descriptionLabel);
        layout.linkSize(this.cancel, this.dropSpecies, this.back, this.ok);
    }

    static final class TbdNoSsp {
        final String commonName;
        final String sciName;
        final String longText;

        TbdNoSsp(TaxonImporter.ToBeDecided tbd) {
            this.commonName = tbd.commonName == null ? null : CharMatcher.whitespace().trimFrom(tbd.commonName);
            this.sciName = tbd.scientificName == null ? null : CharMatcher.whitespace().trimFrom(tbd.scientificName);
            this.longText = tbd.longText == null ? null : CharMatcher.whitespace().trimFrom(tbd.longText);
        }

        public int hashCode() {
            return Objects.hashCode(this.commonName, this.sciName, this.longText);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TbdNoSsp)) {
                return false;
            }
            TbdNoSsp that = (TbdNoSsp)obj;
            return Objects.equal(this.commonName, that.commonName) && Objects.equal(this.sciName, that.sciName) && Objects.equal(this.longText, that.longText);
        }
    }
}

