/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.mapdata.MapData;
import com.scythebill.birdlist.model.sighting.ClosestLocations;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.ui.actions.ReturnAction;
import com.scythebill.birdlist.ui.components.IndexerPanel;
import com.scythebill.birdlist.ui.components.NewLocationPanel;
import com.scythebill.birdlist.ui.components.WherePanelIndexers;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.imports.LocationShortcuts;
import com.scythebill.birdlist.ui.imports.ParsedLocationIds;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.LocationIdToString;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;

class ImportResolveLocationsPanel
extends JPanel
implements FontManager.FontsUpdatedListener {
    private static final int MAX_CLOSE_LOCATIONS = 10;
    private static final double MAX_CLOSE_DISTANCE_KM = 50.0;
    private static final double SHORTCUT_CLOSE_DISTANCE_KM = 5.0;
    private final Alerts alerts;
    private JButton cancel;
    private JButton back;
    private JButton ok;
    private List<Object> keys;
    private int index;
    private Object toBeDecidedKey;
    private Runnable onFinished;
    private JSeparator separator;
    private JLabel topLabel;
    private ParsedLocationIds parsedLocationIds;
    private Map<Object, ParsedLocationIds.ToBeDecided> toBeResolvedNames;
    private Map<Object, Location> resolvedLocations;
    private Map<String, Location> resolvedLocationsByName = new LinkedHashMap<String, Location>();
    private Set<String> askedHints = new LinkedHashSet<String>();
    private ReportSet reportSet;
    private final NewLocationPanel newLocationPanel;
    private JRadioButton existingRadio;
    private JRadioButton newRadio;
    private JComboBox<ExistingLocation> existingCombobox;
    private IndexerPanel<Object> existingIndexer;
    private WherePanelIndexers wherePanelIndexers;
    private Multimap<String, String> locationsByExactName;
    private PredefinedLocations predefinedLocations;
    private JLabel countLabel;

    @Inject
    public ImportResolveLocationsPanel(ReturnAction returnAction, FontManager fontManager, final NewLocationPanel newLocationPanel, PredefinedLocations predefinedLocations, Alerts alerts) {
        this.newLocationPanel = newLocationPanel;
        this.predefinedLocations = predefinedLocations;
        this.alerts = alerts;
        this.initGUI();
        fontManager.applyTo(this);
        this.cancel.addActionListener(returnAction);
        this.back.setEnabled(false);
        this.back.addActionListener(e -> this.previousLocation());
        this.ok.setEnabled(false);
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Location value = null;
                int advanceTo = ImportResolveLocationsPanel.this.index + 1;
                if (ImportResolveLocationsPanel.this.newRadio.isSelected()) {
                    ParsedLocationIds.ToBeDecided toBeDecided;
                    if (newLocationPanel.isComplete()) {
                        value = newLocationPanel.getValuePossiblyReusing();
                    }
                    Preconditions.checkState((toBeDecided = ImportResolveLocationsPanel.this.toBeResolvedNames.get(ImportResolveLocationsPanel.this.toBeDecidedKey)) != null);
                    if (!Strings.isNullOrEmpty(toBeDecided.hint)) {
                        advanceTo = ImportResolveLocationsPanel.this.useHintToSkipPastEntries(advanceTo, toBeDecided.hint, value);
                    }
                } else {
                    value = WherePanelIndexers.toLocation(ImportResolveLocationsPanel.this.reportSet.getLocations(), ImportResolveLocationsPanel.this.existingIndexer.getValue());
                }
                if (value != null) {
                    ImportResolveLocationsPanel.this.markLocationResolved(ImportResolveLocationsPanel.this.toBeDecidedKey, value);
                    ImportResolveLocationsPanel.this.advanceTo(advanceTo);
                }
            }
        });
        PropertyChangeListener updateButtonsListener = e -> this.updateButtons();
        newLocationPanel.addPropertyChangeListener("complete", updateButtonsListener);
        this.existingIndexer.addPropertyChangeListener("value", updateButtonsListener);
        this.existingCombobox.addActionListener(e -> {
            Object selectedItem = this.existingCombobox.getSelectedItem();
            if (selectedItem instanceof ExistingLocation) {
                this.existingIndexer.setValue(((ExistingLocation)selectedItem).locationId);
            }
        });
        ActionListener buttonListener = e -> this.updateButtons();
        this.existingRadio.addActionListener(buttonListener);
        this.newRadio.addActionListener(buttonListener);
    }

    private void updateButtons() {
        if (this.newRadio.isSelected()) {
            this.newLocationPanel.setEnabled(true);
            this.existingCombobox.setEnabled(false);
            this.existingIndexer.setEnabled(false);
            this.ok.setEnabled(this.newLocationPanel.isComplete());
        } else {
            this.newLocationPanel.setEnabled(false);
            this.existingCombobox.setEnabled(true);
            this.existingIndexer.setEnabled(true);
            Object comboboxItem = this.existingCombobox.getSelectedItem();
            Object indexerItem = this.existingIndexer.getValue();
            if (comboboxItem != null && comboboxItem instanceof ExistingLocation && indexerItem != null && !indexerItem.equals(((ExistingLocation)comboboxItem).locationId)) {
                this.existingCombobox.setSelectedItem(null);
            }
            this.ok.setEnabled(this.existingIndexer.getValue() != null);
        }
    }

    public void start(ReportSet reportSet, ImmutableMap<Object, ParsedLocationIds.ToBeDecided> toBeResolvedNames, ParsedLocationIds parsedLocationIds, Runnable onFinished) {
        String code;
        this.reportSet = reportSet;
        this.toBeResolvedNames = toBeResolvedNames;
        this.parsedLocationIds = parsedLocationIds;
        this.onFinished = onFinished;
        this.wherePanelIndexers = new WherePanelIndexers(reportSet.getLocations(), this.predefinedLocations, false, null, Predicates.alwaysTrue(), null);
        Preconditions.checkState(!toBeResolvedNames.isEmpty());
        this.locationsByExactName = LinkedHashMultimap.create();
        for (Location location : reportSet.getLocations().rootLocations()) {
            this.populateLocationsByExactNameMap(location);
        }
        this.keys = Lists.newArrayList(toBeResolvedNames.keySet());
        LinkedHashMap<String, Integer> hintFirstPositions = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < this.keys.size(); ++i) {
            Object key2 = this.keys.get(i);
            ParsedLocationIds.ToBeDecided tbd = toBeResolvedNames.get(key2);
            String hint = Strings.nullToEmpty(tbd.hint);
            if (hintFirstPositions.containsKey(hint)) continue;
            hintFirstPositions.put(hint, i);
        }
        if (hintFirstPositions.size() > 1) {
            Collections.sort(this.keys, Comparator.comparing(key -> {
                String hint = Strings.nullToEmpty(((ParsedLocationIds.ToBeDecided)toBeResolvedNames.get((Object)key)).hint);
                return (Integer)hintFirstPositions.get(hint);
            }, Comparator.naturalOrder()));
        }
        ParsedLocationIds.ToBeDecided firstTbd = toBeResolvedNames.get(this.keys.get(0));
        if (firstTbd.preferredParent == null && firstTbd.latLong != null && (code = MapData.instance().getISOCode(firstTbd.latLong)) != null) {
            LocationShortcuts locationShortcuts = new LocationShortcuts(reportSet.getLocations(), this.predefinedLocations);
            firstTbd.preferredParent = locationShortcuts.getLocationFromEBirdCode(code);
        }
        this.resolvedLocations = Maps.newHashMap();
        this.setIndex(0);
    }

    private void populateLocationsByExactNameMap(Location location) {
        this.locationsByExactName.put(location.getDisplayName(), location.getId());
        if (!location.getModelName().equals(location.getDisplayName())) {
            this.locationsByExactName.put(location.getModelName(), location.getId());
        }
        for (Location child : location.contents()) {
            this.populateLocationsByExactNameMap(child);
        }
    }

    private void setIndex(int index) {
        Collection<Object> matches;
        this.index = index;
        this.toBeDecidedKey = this.keys.get(index);
        ParsedLocationIds.ToBeDecided toBeDecided = this.toBeResolvedNames.get(this.toBeDecidedKey);
        String name = toBeDecided.name;
        this.newLocationPanel.cancelAsyncOperations();
        this.newLocationPanel.setLocationName(name);
        this.newLocationPanel.setGeocodedParentLocation(toBeDecided.preferredParent);
        this.newLocationPanel.setLocationLatLong(toBeDecided.latLong);
        this.newLocationPanel.reindexLocations();
        this.wherePanelIndexers.configureIndexer(this.existingIndexer);
        if (this.keys.size() != 1) {
            String countText = Strings.isNullOrEmpty(name) ? Messages.getFormattedMessage(Messages.Name.LOCATION_OF_FORMAT, index + 1, this.keys.size()) : Messages.getFormattedMessage(Messages.Name.LOCATION_OF_FORMAT_WITH_HINT, index + 1, this.keys.size(), name);
            if (toBeDecided.hint != null) {
                countText = String.format("%s - %s", countText, toBeDecided.hint);
            }
            this.countLabel.setText(countText);
        }
        if (Strings.isNullOrEmpty(name)) {
            if (toBeDecided.latLong != null) {
                ClosestLocations closestLocations = new ClosestLocations(toBeDecided.latLong, this.reportSet.getLocations());
                matches = closestLocations.getNearestLocations(10, 50.0);
            } else {
                matches = ImmutableList.of();
            }
        } else {
            matches = this.wherePanelIndexers.getMatches(name);
            if (matches.isEmpty()) {
                Collection<String> exactIds = this.locationsByExactName.get(name);
                ArrayList<Object> indexerMatchers = Lists.newArrayList();
                for (String exactId : exactIds) {
                    indexerMatchers.add(this.wherePanelIndexers.toIndexerObject(exactId));
                }
                matches = indexerMatchers;
            }
            if (this.resolvedLocationsByName.containsKey(name)) {
                Location location = this.resolvedLocationsByName.get(name);
                Object resolved = this.wherePanelIndexers.toIndexerObject(location.getId());
                ArrayList<Object> matchesWithResolved = new ArrayList<Object>(1 + matches.size());
                matchesWithResolved.addAll(matches);
                matchesWithResolved.remove(resolved);
                matchesWithResolved.add(0, resolved);
                matches = matchesWithResolved;
            }
        }
        if (matches.isEmpty()) {
            this.existingCombobox.setVisible(false);
            this.existingCombobox.setModel(new DefaultComboBoxModel());
            this.existingIndexer.setVisible(true);
            this.newRadio.setSelected(true);
            this.newLocationPanel.setEnabled(true);
        } else {
            this.existingCombobox.setVisible(true);
            this.existingIndexer.setVisible(true);
            List list = matches.stream().map(o -> new ExistingLocation(o, toBeDecided.latLong)).collect(Collectors.toCollection(ArrayList::new));
            list.add(0, null);
            this.existingCombobox.setModel(new DefaultComboBoxModel<ExistingLocation>(list.toArray(new ExistingLocation[0])));
            if (Strings.isNullOrEmpty(name)) {
                ExistingLocation closestExistingLocation = (ExistingLocation)list.get(1);
                if (closestExistingLocation.distanceToCenter() < 5.0) {
                    this.newLocationPanel.setEnabled(false);
                    this.existingRadio.setSelected(true);
                    this.existingCombobox.setSelectedIndex(1);
                } else {
                    this.newLocationPanel.setEnabled(false);
                    this.newRadio.setSelected(true);
                }
            } else {
                this.newLocationPanel.setEnabled(false);
                this.existingRadio.setSelected(true);
                ImmutableList nameMatches = list.stream().filter(el -> el != null && el.nameMatches(name)).collect(ImmutableList.toImmutableList());
                if (nameMatches.size() == 1) {
                    this.existingCombobox.setSelectedIndex(list.indexOf(nameMatches.get(0)));
                    if (matches.size() == 1) {
                        this.existingCombobox.setVisible(false);
                    }
                }
            }
        }
        this.back.setEnabled(index > 0);
        this.ok.setText(index < this.keys.size() - 1 ? Messages.getMessage(Messages.Name.NEXT_BUTTON) : Messages.getMessage(Messages.Name.OK_BUTTON));
        this.updateButtons();
    }

    private void initGUI() {
        this.topLabel = new JLabel("<html>" + Messages.getMessage(Messages.Name.IDENTIFY_WHERE_THE_SIGHTINGS_TOOK_PLACE));
        this.topLabel.putClientProperty("birdlist.plainLabel", true);
        this.countLabel = new JLabel();
        this.separator = new JSeparator();
        this.cancel = new JButton();
        this.cancel.setText(Messages.getMessage(Messages.Name.CANCEL_IMPORT));
        this.back = new JButton();
        this.back.setText(Messages.getMessage(Messages.Name.PREVIOUS_BUTTON));
        this.ok = new JButton();
        this.ok.setText(Messages.getMessage(Messages.Name.OK_BUTTON));
        this.existingRadio = new JRadioButton(Messages.getMessage(Messages.Name.EXISTING_LOCATION));
        this.newRadio = new JRadioButton(Messages.getMessage(Messages.Name.NEW_LOCATION));
        ButtonGroup group = new ButtonGroup();
        group.add(this.existingRadio);
        group.add(this.newRadio);
        this.existingCombobox = new JComboBox();
        this.existingCombobox.setEditable(false);
        this.existingIndexer = new IndexerPanel();
        this.existingIndexer.setPreviewText(Messages.Name.START_TYPING_A_LOCATION);
    }

    private void advanceTo(int toIndex) {
        if (toIndex >= this.keys.size()) {
            for (Map.Entry<Object, Location> entry : this.resolvedLocations.entrySet()) {
                Location location = entry.getValue();
                this.reportSet.getLocations().ensureAdded(location);
                Preconditions.checkState(location.getId() != null);
                this.parsedLocationIds.put(entry.getKey(), location.getId());
            }
            this.onFinished.run();
        } else {
            ParsedLocationIds.ToBeDecided previousTbd = this.toBeResolvedNames.get(this.toBeDecidedKey);
            String previousHint = previousTbd.hint;
            if (!Strings.isNullOrEmpty(previousHint)) {
                ParsedLocationIds.ToBeDecided nextTbd = this.toBeResolvedNames.get(this.keys.get(toIndex));
                if (previousTbd.hintType == ParsedLocationIds.ToBeDecided.HintType.location) {
                    Location previous;
                    Location country;
                    if (previousHint.equals(nextTbd.hint) && nextTbd.preferredParent == null && (country = Locations.getAncestorOfType(previous = Preconditions.checkNotNull(this.resolvedLocations.get(this.toBeDecidedKey)), Location.Type.country)) != null) {
                        nextTbd.preferredParent = country;
                    }
                } else if (nextTbd.preferredParent == null) {
                    Location previous = Preconditions.checkNotNull(this.resolvedLocations.get(this.toBeDecidedKey));
                    Location state = Locations.getAncestorOfType(previous, Location.Type.state);
                    if (state != null) {
                        nextTbd.preferredParent = state;
                    } else {
                        Location country = Locations.getAncestorOfType(previous, Location.Type.country);
                        if (country != null) {
                            nextTbd.preferredParent = country;
                        }
                    }
                }
            }
            this.setIndex(toIndex);
        }
    }

    private void previousLocation() {
        if (this.index > 0) {
            this.setIndex(this.index - 1);
        }
    }

    private int useHintToSkipPastEntries(int advanceTo, String hint, Location value) {
        if (!this.askedHints.contains(hint)) {
            int yesNo;
            Location country;
            ArrayList<ParsedLocationIds.ToBeDecided> toBeDecidedWithSameHint = new ArrayList<ParsedLocationIds.ToBeDecided>();
            for (int i = advanceTo; i < this.keys.size(); ++i) {
                ParsedLocationIds.ToBeDecided toBeDecided = this.toBeResolvedNames.get(this.keys.get(i));
                if (toBeDecided.preferredParent != null) {
                    return advanceTo;
                }
                if (Strings.isNullOrEmpty(toBeDecided.name) || !Objects.equals(toBeDecided.hint, hint) || toBeDecided.hintType != ParsedLocationIds.ToBeDecided.HintType.location) break;
                toBeDecidedWithSameHint.add(toBeDecided);
            }
            if (!toBeDecidedWithSameHint.isEmpty() && (country = Locations.getAncestorOfType(value, Location.Type.country)) != null && (yesNo = this.alerts.showYesNo((Object)this, Messages.getFormattedMessage(Messages.Name.ASSIGN_ALL_TO_COUNTRY_TITLE_FORMAT, toBeDecidedWithSameHint.size(), country.getDisplayName()), Messages.getFormattedMessage(Messages.Name.ASSIGN_ALL_TO_COUNTRY_MESSAGE_FORMAT, toBeDecidedWithSameHint.size(), hint, country.getDisplayName()), new Object[0])) == 0) {
                for (int i = advanceTo; i < advanceTo + toBeDecidedWithSameHint.size(); ++i) {
                    Object key = this.keys.get(i);
                    ParsedLocationIds.ToBeDecided toBeDecided = this.toBeResolvedNames.get(key);
                    Location location = country.getContent(toBeDecided.name);
                    if (location == null) {
                        Location.Builder builder = Location.builder().setName(toBeDecided.name).setParent(country);
                        if (toBeDecided.latLong != null) {
                            builder.setLatLong(toBeDecided.latLong);
                        }
                        location = builder.build();
                    }
                    this.markLocationResolved(key, location);
                }
                advanceTo += toBeDecidedWithSameHint.size();
            }
            this.askedHints.add(hint);
        }
        return advanceTo;
    }

    private void markLocationResolved(Object key, Location location) {
        this.reportSet.getLocations().ensureAdded(location);
        this.resolvedLocations.put(key, location);
        this.resolvedLocationsByName.put(location.getModelName(), location);
        this.resolvedLocationsByName.put(location.getDisplayName(), location);
        ParsedLocationIds.ToBeDecided toBeDecided = this.toBeResolvedNames.get(key);
        if (!Strings.isNullOrEmpty(toBeDecided.name)) {
            this.resolvedLocationsByName.put(toBeDecided.name, location);
        }
    }

    @Override
    public void fontsUpdated(FontManager fontManager) {
        this.setPreferredSize(fontManager.scale(new Dimension(900, 600)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.topLabel).addComponent(this.countLabel).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.existingRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.existingCombobox, -2, -2, -2).addComponent(this.existingIndexer, -2, -2, -2))).addComponent(this.newRadio).addComponent(this.newLocationPanel).addComponent(this.separator).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.cancel).addGap(0, fontManager.scale(75), Short.MAX_VALUE).addComponent(this.back).addGap(fontManager.scale(20)).addComponent(this.ok)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.topLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.countLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createBaselineGroup(false, true).addComponent(this.existingRadio).addGroup(layout.createSequentialGroup().addComponent(this.existingIndexer).addComponent(this.existingCombobox))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.newRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newLocationPanel).addGap(18, 18, Short.MAX_VALUE).addComponent(this.separator, -2, -2, -2).addGroup(layout.createBaselineGroup(false, false).addComponent(this.cancel).addComponent(this.back).addComponent(this.ok)));
        layout.linkSize(this.cancel, this.back, this.ok);
    }

    class ExistingLocation {
        final Object locationId;
        private final LatLongCoordinates center;

        ExistingLocation(Object locationId, LatLongCoordinates center) {
            this.locationId = locationId;
            this.center = center;
        }

        public String toString() {
            Location location = WherePanelIndexers.toLocation(ImportResolveLocationsPanel.this.reportSet.getLocations(), this.locationId);
            if (location == null) {
                return "";
            }
            String locationName = LocationIdToString.getStringWithType(location);
            if (this.center != null && location.getLatLong().isPresent()) {
                locationName = String.format("%s (%.1f km)", locationName, this.center.kmDistance(location.getLatLong().get()));
            }
            return locationName;
        }

        public double distanceToCenter() {
            if (this.center == null) {
                return Double.MAX_VALUE;
            }
            Location location = WherePanelIndexers.toLocation(ImportResolveLocationsPanel.this.reportSet.getLocations(), this.locationId);
            if (location == null || !location.getLatLong().isPresent()) {
                return Double.MAX_VALUE;
            }
            return this.center.kmDistance(location.getLatLong().get());
        }

        public boolean nameMatches(String name) {
            Location location = WherePanelIndexers.toLocation(ImportResolveLocationsPanel.this.reportSet.getLocations(), this.locationId);
            if (location == null) {
                return false;
            }
            return name.equals(location.getDisplayName()) || name.equals(location.getModelName());
        }
    }
}

