/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.imports;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.scythebill.birdlist.model.annotations.Preference;
import com.scythebill.birdlist.model.annotations.SerializeAsJson;
import com.scythebill.birdlist.ui.messages.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Singleton
public class ImportPreferences {
    public static final long MAX_IMPORT_TYPES = 4L;
    private static ImmutableMap<String, ImportType> STRING_TO_TYPE = Arrays.stream(ImportType.values()).collect(ImmutableMap.toImmutableMap(type -> type.name(), type -> type));
    @Preference
    @SerializeAsJson
    List<String> recentlyUsedImports = new ArrayList<String>();
    @Preference
    public boolean excelCompatibleCsv = false;

    @Inject
    ImportPreferences() {
    }

    public ImmutableSet<ImportType> recentlyUsedImports() {
        return this.recentlyUsedImports.stream().filter(STRING_TO_TYPE::containsKey).map(STRING_TO_TYPE::get).collect(ImmutableSet.toImmutableSet());
    }

    public void addRecentlyUsedImport(ImportType importType) {
        if (this.recentlyUsedImports.contains(importType.name()) && (long)this.recentlyUsedImports.indexOf(importType.name()) < 4L) {
            return;
        }
        this.recentlyUsedImports.add(0, importType.name());
        while ((long)this.recentlyUsedImports.size() > 4L) {
            this.recentlyUsedImports.remove(this.recentlyUsedImports.size() - 1);
        }
    }

    public static enum ImportType {
        EBIRD("eBird", Messages.Name.CSV_EXPORT_FROM_FORMAT, true),
        SCYTHEBILL("Scythebill", Messages.Name.CSV_EXPORT_FROM_FORMAT, true),
        AVISYS("Avisys", Messages.Name.CSV_EXPORT_FROM_FORMAT, true),
        BIRDBASE("Birdbase", Messages.Name.CSV_EXPORT_FROM_FORMAT, true),
        BIRD_BRAIN("Bird Brain", Messages.Name.CSV_EXPORT_FROM_FORMAT),
        BIRD_TRACK("BirdTrack", Messages.Name.XLSX_EXPORT_FROM_FORMAT, true),
        BIRDERS_DIARY("Birder's Diary", Messages.Name.CSV_EXPORT_FROM_FORMAT, true),
        BIRDLASSER("BirdLasser", Messages.Name.CSV_EXPORT_FROM_FORMAT),
        BIRDA("Birda", Messages.Name.CSV_EXPORT_FROM_FORMAT, false),
        FLICKR("Flickr Albums", Messages.Name.FLICKR_ALBUM, true),
        HBW_ALIVE("HBW Alive", Messages.Name.XLS_EXPORT_FROM_FORMAT),
        INATURALIST("iNaturalist", Messages.Name.CSV_EXPORT_FROM_FORMAT, true),
        OBSERVADO("Observado/Waarnemingen", Messages.Name.CSV_EXPORT_FROM_FORMAT, true),
        ORNITHO("Ornitho", Messages.Name.TXT_EXPORT_FROM_FORMAT),
        WILDLIFE_RECORDER("Wildlife Recorder", Messages.Name.MDB_OR_CSV_EXPORT_FROM_FORMAT, true),
        WINGS("Wings", Messages.Name.XML_EXPORTS_FROM_FORMAT);

        private final String importName;
        private final Messages.Name documentationFormat;
        private final boolean supportsNonAvianTaxa;

        private ImportType(String importName, Messages.Name documentationFormat) {
            this(importName, documentationFormat, false);
        }

        private ImportType(String importName, Messages.Name documentationFormat, boolean supportsNonAvianTaxa) {
            this.importName = importName;
            this.documentationFormat = documentationFormat;
            this.supportsNonAvianTaxa = supportsNonAvianTaxa;
        }

        public String importName() {
            return this.importName;
        }

        public String documentation() {
            return Messages.getFormattedMessage(this.documentationFormat, this.importName);
        }

        public boolean supportsNonAvianTaxa() {
            return this.supportsNonAvianTaxa;
        }

        public String toString() {
            return this.importName();
        }
    }
}

